// FaultsReport.h
#pragma once

#ifdef  APL_FAULTSREPORT_DLL
	#define  APL_FAULTSREPORT_CLASS_EXPORT	__declspec(dllexport)
#else
	#define  APL_FAULTSREPORT_CLASS_EXPORT	__declspec(dllimport)

	#ifdef _DEBUG
		#ifdef UNICODE
			#pragma comment (lib,"FaultsReport_ud.lib")
		#else
			#pragma comment (lib,"FaultsReportD.lib")
		#endif
	#else
		#ifdef UNICODE
			#pragma comment (lib,"FaultsReport_u.lib")
		#else
			#pragma comment (lib,"FaultsReport.lib")
		#endif
	#endif
#endif

#ifdef APL_FAULTSREPORT_DLL
DLL_EXPORT bool GetQueryList(CArray<CaplQuery, CaplQuery> *pQueriesArray);
DLL_EXPORT bool GetFaultReport(CaplQuery *pQuery, CRParamsArray &arrParams, UINT uiMode);
DLL_EXPORT bool GetPdfAndStagesReportHeader(CaplQuery *pQuery, CRParamsArray &arrParams, UINT uiMode);
DLL_EXPORT bool GetGRPZReportHeader(CaplQuery *pQuery, CRParamsArray &arrParams, UINT uiMode);
DLL_EXPORT bool GetProductionReturnHeader(CaplQuery *pQuery, CRParamsArray &arrParams, UINT uiMode);

DLL_EXPORT bool GenPdfAndStagesReport(CaplAPI *pAPI, aplExtent &aeRefusal, CString strPath = _T(""), BOOL bShowReport = TRUE);
DLL_EXPORT bool GenGRPZReport(CaplAPI *pAPI, aplExtent &aeRefusal, CString strPath = _T(""), BOOL bShowReport = TRUE);
#endif


bool APL_FAULTSREPORT_CLASS_EXPORT GenProductReturnReport(CaplAPI *pAPI, CaplInstance *pRefusalInstance, CString strPath = _T(""), BOOL bShowReport = TRUE);
bool APL_FAULTSREPORT_CLASS_EXPORT GenFaultReportSheet(CaplAPI *pAPI, CaplInstance *pRefusalInstance, CString strPath = _T(""), BOOL bShowReport = TRUE);
//////////////////////////////////////////////////////////////////////////

