// RefApprovalChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefApprovalChildDlg.h"


// CRefApprovalChildDlg dialog

IMPLEMENT_DYNAMIC(CRefApprovalChildDlg, CaplTranslateDialog)

CRefApprovalChildDlg::CRefApprovalChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefApprovalChildDlg::IDD, pParent)
{
	m_api = api;

	m_ciRef = 0;
	m_ciTmpRef = 0;
}

CRefApprovalChildDlg::~CRefApprovalChildDlg()
{
}

void CRefApprovalChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDC_NEW, m_new);
	DDX_Control(pDX, IDC_SHOW, m_show);
	DDX_Control(pDX, IDC_DEL, m_del);
}

BEGIN_MESSAGE_MAP(CRefApprovalChildDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_NEW, &CRefApprovalChildDlg::OnBnClickedNew)
	ON_BN_CLICKED(IDC_SHOW, &CRefApprovalChildDlg::OnBnClickedShow)
	ON_BN_CLICKED(IDC_DEL, &CRefApprovalChildDlg::OnBnClickedDel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, &CRefApprovalChildDlg::OnNMDblclkList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &CRefApprovalChildDlg::OnLvnItemchangedList)
END_MESSAGE_MAP()

BOOL CRefApprovalChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	InitList();
	FillList();

	return TRUE;
}

void CRefApprovalChildDlg::OnCancel()
{

}

void CRefApprovalChildDlg::OnOK()
{

}

// CRefApprovalChildDlg message handlers

void CRefApprovalChildDlg::OnBnClickedNew()
{
	if(0==m_ciTmpRef)
	{
		CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
		m_ciTmpRef = m_api->m_data.CreateInstance(mgr->e_apl_refusal);
		m_api->m_data.NET_SaveExtent(m_ciTmpRef);
	}

	CaplInstance *cit = m_api->m_appr_mgr.CreateApproval(m_ciTmpRef);
	if(cit)
	{
		AddString(cit);
		m_aeNewAppr.Add(cit);
	}
}

void CRefApprovalChildDlg::OnBnClickedShow()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_appr_mgr.ShowApproval(ciObj))
	{
		//m_list.DeleteItem(nIndex);
		AddString(ciObj, nIndex);
	}
}

void CRefApprovalChildDlg::OnBnClickedDel()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciItem = 0;
	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(MessageBox(APL_T("    ?"), APL_T(""), MB_ICONSTOP|MB_YESNO|MB_DEFBUTTON2) == IDYES)
	{
		m_api->m_data.GetAttr(ciObj, m_api->m_appr_mgr.a_appr_item, ciItem);

		if(ciItem == m_ciTmpRef) 
		{
			m_api->m_data.DeleteInstance(ciObj);
			m_api->SaveChanges();
		}
		else 
		{
			m_aeDelAppr.Add(ciObj);
		}

		m_list.DeleteItem(nIndex);
	}
}

void CRefApprovalChildDlg::InitBtns()
{
	CBitmap bmp;

	// 
	bmp.LoadBitmap(IDB_APPR_ICONS);
	imageList.Create(32,32,ILC_COLOR16|ILC_MASK,20,20);
	imageList.Add(&bmp,RGB(192,192,192));

	// 
	m_new.SetFlat(TRUE);
	m_new.SetIcon(imageList.ExtractIcon(0));
	m_new.SetTooltipText(APL_T(" "));

	m_show.SetFlat(TRUE);
	m_show.SetIcon(imageList.ExtractIcon(1));
	m_show.SetTooltipText(APL_T(" "));
	
	m_del.SetFlat(TRUE);
	m_del.SetIcon(imageList.ExtractIcon(2));
	m_del.SetTooltipText(APL_T(" "));	


	if(m_api->m_data.IsReadOnly())
	{
		m_new.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
}

void CRefApprovalChildDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_list.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_list.InsertColumn(2, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));	
	m_list.InsertColumn(3, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.1));		
}

void CRefApprovalChildDlg::FillList()
{
	if(!m_ciRef) return;

	aplExtent aeAppr;

	m_api->m_appr_mgr.LoadItemApproval(m_ciRef, aeAppr);
	for(int i=0; i<aeAppr.Size; i++) AddString(aeAppr[i]);	
}

void CRefApprovalChildDlg::AddString(CaplInstance *ciAppr, int nIndex)
{
	if(!ciAppr) return;

	CString t_str;
	COleDateTime time;
	CaplInstance *cit = 0;

	if( nIndex == -1)
		nIndex = m_list.InsertItem( m_list.GetItemCount(), _T(""));
	
	// 
	t_str.Empty();
	m_api->m_data.GetAttr(ciAppr, m_api->m_appr_mgr.a_appr_status, cit);
	if(cit) m_api->m_data.GetAttr(cit, m_api->m_appr_mgr.a_appr_status_name, t_str);
	m_list.SetItemText(nIndex, 0, t_str);

	// 
	t_str.Empty();
	m_api->m_data.GetAttr(ciAppr, m_api->m_appr_mgr.a_appr_role, t_str);
	m_list.SetItemText(nIndex, 1, t_str);

	// 
	t_str.Empty();
	m_api->m_data.GetAttr(ciAppr, m_api->m_appr_mgr.a_appr_pers_org, cit);
	if(m_api->m_data.IsKindOf(cit, m_api->m_appr_mgr.e_pers_org)) m_api->m_data.GetAttr(cit, m_api->m_appr_mgr.a_po_the_pers, cit);
	if(cit) m_api->GetItemName(cit, t_str);
	m_list.SetItemText(nIndex, 2, t_str);

	// 
	m_api->m_data.GetAttr(ciAppr, m_api->m_appr_mgr.a_appr_appr_date_time_s, t_str);
	aplString2Date(t_str, time);
	t_str.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
	m_list.SetItemText(nIndex, 3, t_str);

	m_list.SetItemData(nIndex, (DWORD)ciAppr);
}

void CRefApprovalChildDlg::DiscardChanges()
{
	for(int i=0; i<m_aeNewAppr.Size; i++)
	{
		if(m_aeNewAppr[i]->GetId() == 0) continue;
		if(m_aeNewAppr[i]->GetType() == 0) continue;

		m_api->m_data.DeleteInstance(m_aeNewAppr[i]);
	}

	if(m_ciTmpRef) m_api->m_data.DeleteInstance(m_ciTmpRef, false);
}

void CRefApprovalChildDlg::SaveRefData( CaplInstance *ciRef, bool bExitDlg )
{
	if(!ciRef) return;
	if(!bExitDlg) return;

	//  
	for(int i=0; i<m_list.GetItemCount(); i++)
	{
		CaplInstance *cit = (CaplInstance*)m_list.GetItemData(i);
		if(cit) m_api->m_data.PutAttr(cit, m_api->m_appr_mgr.a_appr_item, ciRef);		
	}

	for(int j=0; j<m_aeDelAppr.Size; j++)
	{
		if(m_aeDelAppr[j]->GetId() == 0) continue;
		m_api->m_data.DeleteInstance(m_aeDelAppr[j]);
	}

	if(m_ciTmpRef) m_api->m_data.DeleteInstance(m_ciTmpRef, false);
}

void CRefApprovalChildDlg::OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedShow();
	*pResult = 0;
}

void CRefApprovalChildDlg::UpdateToolBar()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex == -1)
	{
		m_show.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
	else
	{
		m_show.EnableWindow(TRUE);
		m_del.EnableWindow(TRUE);
	}
}

void CRefApprovalChildDlg::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	UpdateToolBar();
	*pResult = 0;
}
