// RefCharactChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefCharactChildDlg.h"


// CRefCharactChildDlg dialog

IMPLEMENT_DYNAMIC(CRefCharactChildDlg, CaplTranslateDialog)

CRefCharactChildDlg::CRefCharactChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefCharactChildDlg::IDD, pParent)
{
	m_api = api;

	m_ciRef = 0;
	m_ciTmpRef = 0;
}

CRefCharactChildDlg::~CRefCharactChildDlg()
{
}

void CRefCharactChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDC_NEW, m_new);
	DDX_Control(pDX, IDC_SHOW, m_show);
	DDX_Control(pDX, IDC_DEL, m_del);
}


BEGIN_MESSAGE_MAP(CRefCharactChildDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_NEW, &CRefCharactChildDlg::OnBnClickedNew)
	ON_BN_CLICKED(IDC_SHOW, &CRefCharactChildDlg::OnBnClickedShow)
	ON_BN_CLICKED(IDC_DEL, &CRefCharactChildDlg::OnBnClickedDel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, &CRefCharactChildDlg::OnNMDblclkList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &CRefCharactChildDlg::OnLvnItemchangedList)
END_MESSAGE_MAP()

BOOL CRefCharactChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	InitList();
	FillList();

	return TRUE;
}

void CRefCharactChildDlg::OnCancel()
{

}

void CRefCharactChildDlg::OnOK()
{

}

void CRefCharactChildDlg::OnBnClickedNew()
{
	if(0==m_ciTmpRef)
	{
		CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
		m_ciTmpRef = m_api->m_data.CreateInstance(mgr->e_apl_refusal);
		m_api->m_data.NET_SaveExtent(m_ciTmpRef);
	}

	CaplInstance *cit = 0;
	m_api->m_charact_mgr.CreateCharacteristic(m_ciTmpRef, 0, &cit);
	
	if(cit)
	{
		AddString(cit);
		m_aeNewCharact.Add(cit);
	}
}

void CRefCharactChildDlg::OnBnClickedShow()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_charact_mgr.ShowProperties(ciObj))	
	{
		//m_list.DeleteItem(nIndex);
		AddString(ciObj, nIndex);
	}
}

void CRefCharactChildDlg::OnBnClickedDel()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciItem = 0;
	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(MessageBox(APL_T("    ?"), APL_T(""), MB_ICONSTOP|MB_YESNO|MB_DEFBUTTON2) == IDYES)
	{
		m_api->m_data.GetAttr(ciObj, m_api->m_charact_mgr.a_apl_charact_val_item, ciItem);

		if(ciItem == m_ciTmpRef) 
		{
			m_api->m_data.DeleteInstance(ciObj);
			m_api->SaveChanges();
		}
		else 
		{
			m_aeDelCharact.Add(ciObj);
		}

		m_list.DeleteItem(nIndex);
	}
}

void CRefCharactChildDlg::InitBtns()
{
	CBitmap bmp;

	// 
	bmp.LoadBitmap(IDB_CHARACT_BTNS);
	imageList.Create(32,32,ILC_COLOR16|ILC_MASK,20,20);
	imageList.Add(&bmp,RGB(192,192,192));

	// 
	m_new.SetFlat(TRUE);
	m_new.SetIcon(imageList.ExtractIcon(0));
	m_new.SetTooltipText(APL_T(" "));

	m_show.SetFlat(TRUE);
	m_show.SetIcon(imageList.ExtractIcon(1));
	m_show.SetTooltipText(APL_T(" "));

	m_del.SetFlat(TRUE);
	m_del.SetIcon(imageList.ExtractIcon(2));
	m_del.SetTooltipText(APL_T(" "));	

	if(m_api->m_data.IsReadOnly())
	{
		m_new.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
}

void CRefCharactChildDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0, APL_T(""),		LVCFMT_LEFT, (int)(rect.Width()*0.2));
	m_list.InsertColumn(1, APL_T(""),		LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_list.InsertColumn(2, APL_T(""),				LVCFMT_LEFT, (int)(rect.Width()*0.3));	
	m_list.InsertColumn(3, APL_T(""),			LVCFMT_LEFT, (int)(rect.Width()*0.2));		
}

void CRefCharactChildDlg::FillList()
{
	if(!m_ciRef) return;
	aplExtent aeCharVal;

	m_api->m_charact_mgr.FindAssociatedCharacteristic(m_ciRef, aeCharVal);
	for(int i=0; i<aeCharVal.Size; i++) AddString(aeCharVal[i]);	
}

void CRefCharactChildDlg::AddString(CaplInstance *ciCharVal, int nIndex)
{
	if(!ciCharVal) return;

	CString t_str;
	COleDateTime time;
	CaplInstance *ciCharact = 0, *ciType = 0;

	m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_charact, ciCharact);
	m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_name, t_str);

	t_str.MakeLower();
	if(t_str.CompareNoCase(APL_T("  ")) == 0) return;

	if( nIndex == -1) nIndex = m_list.InsertItem( m_list.GetItemCount(), _T(""));

	if(ciCharact)
	{
		// 
		t_str.Empty();
		m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_id, t_str);
		m_list.SetItemText(nIndex, 0, t_str);

		// 
		t_str.Empty();
		m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_name, t_str);
		m_list.SetItemText(nIndex, 1, t_str);		
	}

	// 
	t_str.Empty();
	m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_type, ciType);
	if(ciType) m_api->m_data.GetAttr(ciType, m_api->m_charact_mgr.a_apl_charact_type_name, t_str);
	m_list.SetItemText(nIndex, 2, t_str);

	// 
	t_str.Empty();
	if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_meas_value))
	{
		double val;
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_meas_val, val);
		t_str.Format(_T("%g"), val);
	}
	else if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_descr_value))
	{
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_descr_val, t_str);
	}
	else if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_apl_reference_value))
	{
		CaplInstance *ciOrg = 0;
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_reference_val, ciOrg);
		if(ciOrg) m_api->GetItemName(ciOrg, t_str);
	}
	else if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_time_val))
	{	
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_time_val_s, t_str);
		aplString2Date(t_str, time);
		t_str.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
	}
	else if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_enum_value))
	{
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_enum_val, t_str);
	}
	else if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_monet_value))
	{
		double val;
		m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_monet_val, val);
		t_str.Format(_T("%g"), val);
	}
	m_list.SetItemText(nIndex, 3, t_str);

	m_list.SetItemData(nIndex, (DWORD)ciCharVal);
}

void CRefCharactChildDlg::DiscardChanges()
{
	for(int i=0; i<m_aeNewCharact.Size; i++)
	{
		if(m_aeNewCharact[i]->GetId() == 0) continue;
		if(m_aeNewCharact[i]->GetType() == 0) continue;		

		m_api->m_data.DeleteInstance(m_aeNewCharact[i], false);
	}

	if(m_ciTmpRef) m_api->m_data.DeleteInstance(m_ciTmpRef, false);
}

void CRefCharactChildDlg::SaveRefData( CaplInstance *ciRef, bool bExitDlg )
{
	if(!ciRef) return;
	if(!bExitDlg) return;

	//  
	for(int i=0; i<m_list.GetItemCount(); i++)
	{
		CaplInstance *cit = (CaplInstance*)m_list.GetItemData(i);
		if(cit) m_api->m_data.PutAttr(cit, m_api->m_charact_mgr.a_apl_charact_val_item, ciRef);		
	}

	for(int j=0; j<m_aeDelCharact.Size; j++)
	{
		if(m_aeDelCharact[j]->GetId() == 0) continue;
		m_api->m_data.DeleteInstance(m_aeDelCharact[j]);
	}

	if(m_ciTmpRef) m_api->m_data.DeleteInstance(m_ciTmpRef);
}

void CRefCharactChildDlg::OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedShow();
	*pResult = 0;
}

void CRefCharactChildDlg::UpdateToolBar()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex == -1)
	{
		m_show.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
	else
	{
		m_show.EnableWindow(TRUE);
		m_del.EnableWindow(TRUE);
	}
}

void CRefCharactChildDlg::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	UpdateToolBar();
	*pResult = 0;
}