// RefResultsChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefResultsChildDlg.h"


// CRefResultsChildDlg dialog

IMPLEMENT_DYNAMIC(CRefResultsChildDlg, CaplTranslateDialog)

CRefResultsChildDlg::CRefResultsChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefResultsChildDlg::IDD, pParent)
{
	m_api = api;
	m_ciRef = 0;
	m_ciReklDoc = 0;
	m_pDocDlg = 0;
}

CRefResultsChildDlg::~CRefResultsChildDlg()
{
}

void CRefResultsChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_ARRANGM, m_sArrangm);
	DDX_Text(pDX, IDC_DISPOSE, m_sDispose);
	DDX_Text(pDX, IDC_RESULTS, m_sResult);
	DDX_Text(pDX, IDC_REKL_DOC, m_sReklDoc);
	DDX_Text(pDX, IDC_REKL_NUM, m_sReklNum);

	DDX_Control(pDX, IDC_CHOOSE_REKL, m_choose_rekl_doc);
	DDX_Control(pDX, IDC_CLEAR_REKL, m_clear_rekl_doc);
	DDX_Control(pDX, IDC_CREATE_REKL, m_create_rekl);
	DDX_Control(pDX, IDC_SHOW_REKL, m_show_rekl);
}


BEGIN_MESSAGE_MAP(CRefResultsChildDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_CHOOSE_REKL, &CRefResultsChildDlg::OnBnClickedChooseRekl)
	ON_BN_CLICKED(IDC_CLEAR_REKL, &CRefResultsChildDlg::OnBnClickedClearRekl)
	ON_BN_CLICKED(IDC_CREATE_REKL, &CRefResultsChildDlg::OnBnClickedCreateRekl)
	ON_BN_CLICKED(IDC_SHOW_REKL, &CRefResultsChildDlg::OnBnClickedShowRekl)
END_MESSAGE_MAP()

BOOL CRefResultsChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	FillDataBase();

	return TRUE;
}

void CRefResultsChildDlg::OnCancel()
{

}

void CRefResultsChildDlg::OnOK()
{

}

void CRefResultsChildDlg::FillDataBase()
{
	if(!m_ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();

	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_accepted_arrangements_str, m_sArrangm);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_dispose_data, m_sDispose);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_document_str, m_sReklNum);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_result_decision, m_sResult);

	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_document_obj, m_ciReklDoc);
	if(m_ciReklDoc) m_api->GetItemName(m_ciReklDoc, m_sReklDoc);

	UpdateData(FALSE);
}

void CRefResultsChildDlg::SaveRefData(CaplInstance *ciRef)
{
	if(!ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_accepted_arrangements_str, m_sArrangm);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_dispose_data, m_sDispose);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_result_decision, m_sResult);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_document_str, m_sReklNum);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_document_obj, m_ciReklDoc);
}
void CRefResultsChildDlg::SetReadOnly()
{
	m_choose_rekl_doc.EnableWindow(FALSE);
	m_clear_rekl_doc.EnableWindow(FALSE);
	m_create_rekl.EnableWindow(FALSE);
	m_show_rekl.EnableWindow(FALSE);

	CWnd *wnd;
	wnd=GetDlgItem(IDC_REKL_NUM);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_ARRANGM);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_DISPOSE);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_RESULTS);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
}

void CRefResultsChildDlg::InitBtns()
{
	m_choose_rekl_doc.SetFlat(TRUE);	
	m_choose_rekl_doc.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_rekl_doc.SetTooltipText(APL_T("  "));

	m_clear_rekl_doc.SetFlat(TRUE);	
	m_clear_rekl_doc.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_rekl_doc.SetTooltipText(APL_T(" "));

	m_show_rekl.SetFlat(TRUE);	
	m_show_rekl.SetIcon(aplGetButtonIco(APL_24_VIEW));
	m_show_rekl.SetTooltipText(APL_T("  "));

	m_create_rekl.SetFlat(TRUE);	
	m_create_rekl.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_create_rekl.SetTooltipText(APL_T("  "));
}

void CRefResultsChildDlg::OnBnClickedChooseRekl()
{
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	CaplInstance* inst = mgr->SelectInstance(APL_MODE_SELECT_DOC, APL_T("  \" \""));

	if(inst)
	{
		if(m_ciReklDoc) m_pDocDlg->DelDocumentAsAttr(m_ciReklDoc);
		SetDoc(inst);
	}
}

void CRefResultsChildDlg::SetDoc(CaplInstance *inst)
{
	if(!inst) return;
	if(!UpdateData()) return;
	if(!m_pDocDlg->Check(inst)) return;

	m_ciReklDoc = inst;
	m_api->GetItemName(m_ciReklDoc, m_sReklDoc);
	m_pDocDlg->AddDocument(m_ciReklDoc, true);

	UpdateData(FALSE);
}

void CRefResultsChildDlg::OnBnClickedClearRekl()
{
	if(MessageBox(APL_T(" ?\n(    )"), APL_T(""), MB_ICONQUESTION|MB_YESNO) == IDNO) return;

	if(m_ciReklDoc) m_pDocDlg->DelDocumentAsAttr(m_ciReklDoc);
	ClearRekl();	
}

void CRefResultsChildDlg::OnBnClickedCreateRekl()
{
	CaplInstance *ciDoc = m_api->m_doc_mgr.CreateDocument(_T(""), _T(""), _T(""), 0, _T(""));
	if(ciDoc) 
	{
		if(m_ciReklDoc) m_pDocDlg->DelDocumentAsAttr(m_ciReklDoc);
		SetDoc(ciDoc);
	}
}

void CRefResultsChildDlg::OnBnClickedShowRekl()
{
	if(!m_ciReklDoc) return;	
	m_api->m_doc_mgr.View(m_ciReklDoc);
}

void CRefResultsChildDlg::ClearRekl()
{
	UpdateData();

	m_ciReklDoc = NULL;
	m_sReklDoc = _T("");

	UpdateData(FALSE);
}