#pragma once
#include "resource.h"
#include "EditValueCtrl.h"
#include "Condition.h"
#include "CaplFaultMgr.h"
#include "afxwin.h"

// CRefusalFilterDlg dialog

class CRefusalFilterDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefusalFilterDlg)

public:
	CRefusalFilterDlg(CaplFaultMgr *FaultMgr, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefusalFilterDlg();

	//  
	void AddNewCondition();
	void AddConditionOperation();
	void AddConditionType();

	//  
	void DelCondition();

	//      
	void PrepareCondition(CCondition *pCond, int nIndex);

	// / 
	void ResizeDialog(bool bIncrease = true);
	void MoveWnd(CWnd *Wnd, bool bIncrease, bool bMoveOnly = true);

	//      
	void ShowValueEditCtrl(CComboBox *pBox, CCondition *pCond, int nIndex);

	//      
	void IncreaseComboBoxDroppedList(CComboBox *pBox);

	//    
	CString GetConditionValue(CCondition *pCond, int nIndex);

	//   
	void CreateComboBox(CComboBox **pBox, CRect rect);

	//    
	void CreateEdit(CEdit **pBox, CRect rect, bool bReadOnly = false);

	//   
	void CreateButton(CaplButton **pBtn, CRect rect, int nIco);

	//   CDateTimeCtrl
	void CreateDateTimeCtrl(CDateTimeCtrl **pBox, CRect rect);

	//  
	void DisableBtns();

	//     
	void CreateFont();

	// 
	void ClearMemory();

	//    
	void ComboBoxNotify(int nID);

	//   SQL   
	void BuildSQLbyDialog();

	//       SQL
	void BuildDialogBySQL();

	//    
	CCondition* GetConditionByAttr(CString sAttr);

	//   
	CConditionOperation* GetOperation(CString sOp);

	//  
	void SetValue(CEditValueCtrl *pEditValueCtrl, EConditionType type, CString sValue);

// Dialog Data
	enum { IDD = IDD_FILTER };

	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	CaplButton m_add;
	CaplButton m_minus;
	CaplButton m_restore;

	CStringArray *m_pSQLparts;
	CArray<CEditValueCtrl*, CEditValueCtrl*> m_caEditCtrl;		//  ,    
	CArray<CComboBox*, CComboBox*> m_caField;					//  ,      
	CArray<CComboBox*, CComboBox*> m_caOperation;				//  ,    	

protected:

	int m_nID;
	int m_nTop;
	int m_nSpacesHor;
	int m_nSpacesVert;
	int m_nDefHeight;
	int m_nLeftStart;

	int m_nComboLeftWidth;	
	int m_nComboCenterWidth;
	int m_nValueEditCtrlWidth;

	CFont  m_font;
	LOGFONT m_lf;

	CaplFaultMgr *m_FaultMgr;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	inline UINT GetNewId() { return ++m_nID; };

	DECLARE_MESSAGE_MAP()

	afx_msg void OnAdd();
	afx_msg void OnMinus();	
	afx_msg void OnCBN(UINT id);
	afx_msg void OnBtnClick(UINT id);
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedRestore();		
public:
	bool m_add_to_last_found;
	bool m_bUseOrCondition;
	CButton m_add_to_last_found_ctrl;
	CComboBox m_condition_type_combo;
	afx_msg void OnBnClickedOk();
};
