// AplStringMap.cpp : Implementation of CAplStringMap
#include "stdafx.h"
#include "APL_PSS_API.h"
#include "AplStringMap.h"

/////////////////////////////////////////////////////////////////////////////
// CAplStringMap

STDMETHODIMP CAplStringMap::Add(BSTR key, long value, long *result)
{
	CString sKey(key);
	*result= m_map.Add(sKey, value);
	return S_OK;
}

STDMETHODIMP CAplStringMap::Remove(long index, BOOL *result)
{
	*result= FALSE;
	if(m_map.Remove(index))	*result= TRUE;
	return S_OK;
}

STDMETHODIMP CAplStringMap::Clear()
{
	m_map.Clear();
	return S_OK;
}

STDMETHODIMP CAplStringMap::GetByIndex(long index, BSTR* key, long* value, BOOL* result)
{
	if(index<0 || index>=m_map.GetSize())
	{
		*key= NULL;
		*value= -1;
		*result= FALSE;
	}
	else
	{
		*key= m_map.GetAt(index)->str.AllocSysString();
		*value= m_map.GetAt(index)->val;
		*result= TRUE;
	}

	return S_OK;
}
STDMETHODIMP CAplStringMap::SetByIndex(long index, long value, BOOL* result)
{
	if(index<0 || index>=m_map.GetSize())
	{
		*result= FALSE;
	}
	else
	{
		if(m_map.SetAt(index, value))
			*result= TRUE;
	}

	return S_OK;
}

STDMETHODIMP CAplStringMap::FindIndexByKey(BSTR key, long *result)
{
	CString sKey(key);
	*result= m_map.Find(sKey);
	return S_OK;
}

STDMETHODIMP CAplStringMap::GetByKey(BSTR key, long *result)
{
	CString sKey(key);
	*result= m_map.Get(sKey);
	return S_OK;
}

STDMETHODIMP CAplStringMap::GetByKeyP(BSTR key, long *result)
{
	CString sKey(key);
	*result= (long)m_map.GetP(sKey);
	return S_OK;
}

STDMETHODIMP CAplStringMap::Sort()
{
	m_map.Sort();
	return S_OK;
}

STDMETHODIMP CAplStringMap::get_Size(long *pVal)
{
	*pVal= m_map.GetSize();
	return S_OK;
}

