#include "stdafx.h"
#include "CaplPreExploitationMgr.h"
#include "CaplRefusalTreeItem.h"
#include "aplDocTreeItem.h"


#define _APL_TREE_ITEM_CHEK_PARAM \
	if(m_tree==0) return false;\
	if(m_doc==0) return false;


CaplRefusalTreeItem::CaplRefusalTreeItem(CTreeCtrl *tree, CPSMDoc *doc,	 CaplInstance *val, CaplInstance *folder)
{
	m_type=APL_TREE_ITEM_REFUSAL;
	m_refusal=val;
	m_folder=folder;
	m_doc=doc;
	m_tree=tree;
	if(doc!=0) doc->m_items.Add(this);
}

CaplRefusalTreeItem::~CaplRefusalTreeItem(void)
{
}
//****************************************************************

void CaplRefusalTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(0!=m_refusal) ext.Add(m_refusal);
}

void CaplRefusalTreeItem::GetMainInstances(aplExtent &ext)
{
	ext.Clear();
	if(0!=m_refusal) ext.Add(m_refusal);
}

//****************************************************************
bool CaplRefusalTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	_APL_TREE_ITEM_CHEK_PARAM
	if(action==TVE_EXPAND)
	{
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		ShowAllDocs(false,false);
	}
	else if(action==TVE_COLLAPSE)
	{
		CollapseItem(true);
	}
	return true;
}

//****************************************************************
bool CaplRefusalTreeItem::GetName(CString &name)
{
	name=_T("Fault");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	return m_doc->m_api.GetItemName(m_refusal, name);
}


//****************************************************************
bool CaplRefusalTreeItem::RefreshItem()
{
	CString name,buf,buf1;
	UINT ico=0;
	ico=ICON_CHARACTERISTIC;
	if(m_tree==0) return false;
	if(m_refusal==0) return false;
	if(m_refusal->GetType()==0)
	{
		GetName(name);
		m_tree->SetItemText(m_item,name);
		m_tree->RedrawWindow();
		return false;
	}

	ico = m_doc->m_api.GetInstIco(m_refusal);
	GetName(name);
	SetItemImage(ico, IDX_IL_TREE_ITEM);

	if(m_bWOForNote)
		SetItemImage(ICO_REL_WO_4NOTE, IDX_IL_TREE_REL_TYPE);

	m_tree->SetItemText(m_item,name);
	
	Sort();
	m_tree->RedrawWindow();

	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}
//****************************************************************
bool CaplRefusalTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	InsetItem(buf,ICON_ACTIVITY,parent_item);
	RefreshItem();
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}

//****************************************************************
void CaplRefusalTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(0==m_refusal) return;
	if(m_refusal->IsDeleted()) return;

	//m_doc->m_api.m_expl_mgr->ShowRefusalProperies(m_refusal);
	aplExtent ext;
	ext.Add(m_refusal);
	m_doc->m_fault_mgr.LoadRefusalInfo(ext);
	ext.Clear();
	m_doc->m_fault_mgr.ShowRefusalProperty(m_refusal,ext);
	RefreshItem();
}

//****************************************************************
void CaplRefusalTreeItem::ShowCmd(long cmd)
{
	switch(cmd)
	{
		case ID_ITEM_VIEW: ShowProperties();break;
		default: PrepareContextMenu(cmd);break;
	}
}
//****************************************************************
BOOL CaplRefusalTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	CaplInstance *item=0;
	if(m_refusal==0) return FALSE;
	if(m_refusal->GetType()==0) return FALSE;

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		if(m_refusal->GetAccessmode()==aplOWN) return TRUE;
		return FALSE;
	}

	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
	//case ID_SHOW_ALL_VERSION:
	case ID_SHOW_ALL_DOCS:
	//case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
		//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
		//	case ID_SHOW_ALL_LOT:
		//	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
		//	case ID_SHOW_ALL_VERSION:
		//	case ID_CREATE_PRODUCT:
	//case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_ITEM_VIEW:
	//case ID_ITEM_CHECK_OUT:
	//case ID_ITEM_CHECK_IN:
	//case ID_ITEM_UNDO_CHECK_OUT:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplRefusalTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU1));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_REFUSAL_ITEM_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	if(0==m_folder)	pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);

	//pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
	//pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	switch(res)
	{
		case ID_SHOW_PROPERTIES:  ShowProperties(); break;
		case ID_SHOW_CONTAINED_PROCCESS:
			ShowContainedProccess(m_refusal);
			break;
		case ID_SHOW_CONTAINED_FOLDER:
			ShowContainedFolder(m_refusal);
			break;
		case ID_SHOW_CONTAINED_MESSAGE: ShowContainedMessage(m_refusal); break;
		case ID_SHOW_CONTAINED_TASKS: ShowContainedTasks(m_refusal); break;
		case ID_SHOW_CONTAINED_ALERT: ShowContainedAlert(m_refusal); break;

		case ID_CREATE_DOC: 
			CreateDoc();
			break;
		case ID_REMOVE_FROM_FOLDER:
			if(m_folder!=0)
			{
				if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_refusal))
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
			break;
		case ID_DELETE :
		{
			if(!m_refusal) return false;
			if(m_refusal->GetAccessmode()>aplOWN)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return false;
			}
			if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDNO) return false;			 

			if(!m_doc->m_api.m_expl_mgr->DeleteRefusal(m_refusal)) return false;
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
			return true;
		}
		break;

		default: PrepareContextMenu(res); break;
	}
	return true;
}

//****************************************************************
bool CaplRefusalTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	if (item->m_type != APL_TREE_ITEM_DOCUMENT)	return false;

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup=0;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	if(item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		CString state;
		m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
		if(state==_T("canceled")) return false;
		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
	}

	if(0==pPopup) return false;

	pPopup->RemoveMenu(ID_DOCUMENT_INITIAL, MF_BYCOMMAND);

	POINT pnt;
	if(point==0)
	{
		RECT rect;
		m_tree->GetItemRect(m_item,&rect,TRUE);
		m_tree->ClientToScreen(&rect);
		pnt.x=rect.right;
		pnt.y=rect.bottom;
	}
	else
	{
		pnt.x=point->x;
		pnt.y=point->y;
	}

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

	//  
	if (res == ID_DOCUMENT_COPY)
	{
		CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
		
		HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
		aplAccessModeType access =aplOWN;
		if(Item)
		{
			aplExtent instances;
			Item->GetAccessedInstances(instances);
			if(instances.GetSize()>0)
				access = instances.GetAt(0)->GetAccessmode();
		}
		
		if(m_refusal->GetAccessmode()>aplRW || access>aplRO)
		{
			AfxMessageBox( APL_T("   "));
			return false;
		}
		if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_refusal, false))
			ShowCmd(ID_SHOW_ALL_DOCS);
	}
	//  
	else if(res == ID_DOCUMENT_BYDOT)
	{
		CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
		
		aplExtent instances;
		GetAccessedInstances(instances);
		if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
			ShowCmd(ID_SHOW_ALL_DOCS);
	}
	// 
	else if(res == ID_DOCUMENT_MOVE)
	{
		CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
		HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
		
		CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
	}
	m_tree->RedrawWindow();
	return true;
}

//****************************************************************
bool CaplRefusalTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	CHECK_SHOW_LIST_CTRL(m_refusal);
	if(m_doc==0)return false;

	int i;
	CString buf,buf1,buf2;

	i=list->InsertItem(0, APL_T(":"));

	CaplInstance *ref_type;
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_type, ref_type);
	if(0!=ref_type) m_doc->m_api.m_data.GetAttr(ref_type,m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_name,buf1);
	else buf1=_T("");
	list->SetItemText(i,1,buf1);

	i=list->InsertItem(1, APL_T(":"));
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_state, buf1);
	list->SetItemText(i,1,buf1);


	i=list->InsertItem(2, APL_T(" :"));
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_doc_type, buf1);
	list->SetItemText(i,1,buf1);

	i=list->InsertItem(3, APL_T(" :"));
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_doc_num, buf1);
	list->SetItemText(i,1,buf1);

	i=list->InsertItem(4, APL_T(" :"));
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_doc_date, buf1);
	if(buf1!=_T(""))
	{
		COleDateTime odt;
		aplString2Date(buf1,odt);
		buf1=odt.Format(_T("%d.%m.%Y"));// %H:%M:%S");
	}
	list->SetItemText(i,1,buf1);

	i=list->InsertItem(5, APL_T(":"));
	m_doc->m_api.m_data.GetAttr(m_refusal, m_doc->m_api.m_expl_mgr->a_apl_refusal_description, buf1);
	list->SetItemText(i,1,buf1);



	list->InsertItem(6,_T(""));
	i=list->InsertItem(7, APL_T(":"));
	GetAccessName(m_refusal,buf);
	list->SetItemText(i,1,buf);

	
	aplExtent ext;
	CStringArray comment;
	ext.Add(m_refusal);
	comment.Add(APL_T(""));
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}