// ChooseStatusDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "ChooseStatusDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChooseStatusDlg dialog


CChooseStatusDlg::CChooseStatusDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CChooseStatusDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChooseStatusDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=0;
	m_chosen_status=0;
}


void CChooseStatusDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChooseStatusDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_STATUS_LIST, m_status_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChooseStatusDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CChooseStatusDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChooseStatusDlg message handlers

BOOL CChooseStatusDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}
	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	aplExtent ext_status;
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_appr_status,ext_status);
	CString buf;
	int itemIndex;
	for(int i=0;i<ext_status.GetSize();i++)
	{
		if(!ext_status[i]) continue;
		m_api->m_data.GetAttr(ext_status[i],m_api->m_appr_mgr.a_appr_status_name,buf);
		itemIndex=m_status_ctrl.AddString(buf);
		m_status_ctrl.SetItemData(itemIndex,(DWORD)ext_status[i]);
	}
	itemIndex=m_status_ctrl.AddString( APL_T("<   >"));
	m_status_ctrl.SetItemData(itemIndex,(DWORD)0);
	m_status_ctrl.SetCurSel(itemIndex);

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChooseStatusDlg::OnOK() 
{
	// TODO: Add extra validation here
	int itemIndex=m_status_ctrl.GetCurSel();
	m_chosen_status=(CaplInstance*)m_status_ctrl.GetItemData(itemIndex);
	CaplResizableDialog::OnOK();
}
