// DocsListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "DocsListView.h"

#include "PSMDoc.h"
#include "aplTopLevelItem.h"
#include "TreeProductItem.h"
#include "aplDocTreeItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "act_res_treeitem.h"
#include "aplProjectTreeItem.h"
#include "aplOrganizationTreeItem.h"
#include "aplFolderTreeItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDocsListView

IMPLEMENT_DYNCREATE(CDocsListView, CaplListView)

CDocsListView::CDocsListView()
{
	SetUniqueName(_T("CDocsListView"));
}

CDocsListView::~CDocsListView()
{
}


BEGIN_MESSAGE_MAP(CDocsListView, CaplListView)
	//{{AFX_MSG_MAP(CDocsListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDocsListView drawing

void CDocsListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CDocsListView diagnostics

#ifdef _DEBUG
void CDocsListView::AssertValid() const
{
	CListView::AssertValid();
}

void CDocsListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDocsListView message handlers

int CDocsListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
	m_ImageList.Create(aplGetInstImageList());
	LIST.SetImageList(&m_ImageList,LVSIL_SMALL);

    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,150);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,50);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(4, APL_T(""),LVCFMT_LEFT,200);
	LIST.InsertColumn(5, APL_T(""),LVCFMT_LEFT,100);
	LIST.InsertColumn(6, APL_T("  "),LVCFMT_LEFT,400);

	LoadColumnWidths();
	return 0;
}


void CDocsListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	UpdateHeaders();

	aplExtent ext;
	item->GetAccessedInstances(ext);

	CaplInstance *m_prd=0, *m_pdf=0,*m_val=0; 
	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{ 
		m_prd=((CaplProductTreeItem*)item)->m_prd;
		m_pdf=((CaplProductTreeItem*)item)->m_pdf;
	}
/*	else if(item->m_type==APL_TREE_ITEM_LOT)
	{
		m_prd=((CaplLotTreeItem*)item)->m_lot;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_PRDINST)
	{
		m_prd=((CaplPrdInstTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_BP)
	{
		m_prd=((CaplBPTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_BPINST)
	{
		m_prd=((CaplBPInstTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_PROJECT)
	{
		m_prd=((CaplProjectTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_BPRES)
	{
		m_prd=((CaplBPResourceTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_CHARACTERISTIC)
	{
		m_prd=((CaplCharacteristicTreeItem*)item)->m_val;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
	{
		m_prd=((CaplDocTreeItem*)item)->m_inst;
		m_pdf=((CaplDocTreeItem*)item)->m_rev;
	}
	else if(item->m_type==APL_TREE_ITEM_CATEGORIES)
	{
		m_prd=((CaplCategoryTreeItem*)item)->m_inst;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
	{
		m_prd=((CaplCharacteristicGroupTreeItem*)item)->m_group;
		m_pdf=0;
	}
	else if(item->m_type==APL_TREE_ITEM_ORGANIZATION)
	{
		m_prd = ((CaplOrganizationTreeItem*)item)->m_inst;
		m_pdf = 0;
	}*/
	else if(ext.Size>0)
	{
		m_prd = ext[0];
		m_pdf = 0;
	}
	else return;
	ext.Clear();

	if(m_prd==0) return;

	int i,k;
	CString buf;
	aplExtent aDocuments, ext_rel;
	CaplInstance * pInstance;
	
	StartBusy();
	if(item->m_type==APL_TREE_ITEM_FOLDER)
	{
		aplExtent ext, docs;
		item->GetAccessedInstances(ext);
		item->m_doc->m_api.m_folder_mgr.GetFolderContents(ext[0],docs);
		if(CaplFolderManager::m_create_assoc_folder_doc==TRUE)
		{
			aplExtent tmp, tmp_rel;
			item->m_doc->m_api.m_doc_mgr.FindAssociatedDocuments(ext[0], tmp,tmp_rel);
			docs.Append(tmp);
		}

		for(int i=0;i<docs.Size;i++)
			if(!item->m_doc->m_api.m_data.IsKindOf(docs[i],item->m_doc->m_api.m_doc_mgr.e_doc))
			{
				docs.Remove(i);
				i--;
			}
		aDocuments.Clear();
		aDocuments.Append(docs);
	}
	else
	{
		item->m_doc->m_api.m_doc_mgr.FindAssociatedDocuments(m_prd,aDocuments,ext_rel);
		if(m_pdf!=0) item->m_doc->m_api.m_doc_mgr.FindAssociatedDocuments(m_pdf,ext,ext_rel);
		aDocuments.Append(ext);
	}
	StopBusy();
/*	SetStatusString(_T(""));
	item->m_doc_data.GetEntityExtentBN(S::apl_document_lock, aLockInfo);
	for (i = 0; i < aLockInfo.GetSize(); i++)
	{
		item->m_doc_data.GetAttrBN(aLockInfo[i], S::document, pInstance);
		aLockedDocuments.Add(pInstance);
	}*/

	SetRedraw(FALSE);
	aplExtent ch_ext, group;
	item->m_doc->m_api.m_charact_mgr.FindAssociatedCharacteristic(aDocuments,ch_ext,group);
	item->m_doc->m_api.m_charact_mgr.LoadCharacteristic(ch_ext);

	for (i = 0; i < aDocuments.GetSize(); i++)
	{
		int icon = ICON_DOCUMENT;
		item->m_doc_data.GetAttr(aDocuments[i],item->m_doc->m_api.m_doc_mgr.a_apl_doc_lock, pInstance);
		if(pInstance)
			icon = ICON_DOCUMENT+1;
		item->m_doc_data.GetAttrBN(aDocuments[i], S::id, buf);
		k=LIST.InsertItem(0,buf,icon);
		LIST.SetItemData(k,(long)aDocuments[i]);
		item->m_doc_data.GetAttrBN(aDocuments[i], S::name, buf);
		LIST.SetItemText(k,1,buf);
		item->m_doc_data.GetAttrBN(aDocuments[i], S::kind, pInstance);
		if(pInstance) item->m_doc_data.GetAttrBN(pInstance, _T("product_data_type"), buf);
		else buf=_T("");
		LIST.SetItemText(k,3,buf);
		 
		item->m_doc_data.GetAttrBN(aDocuments[i], S::active, pInstance);
		if (pInstance != NULL)
			if (item->m_doc_data.IsKindOfBN(pInstance, S::apl_digital_document))
			{
				item->m_doc_data.GetAttrBN(pInstance, _T("revision_id"), buf);
				LIST.SetItemText(k,2,buf);
			}
		CaplInstance *pLock;
		item->m_doc_data.GetAttr(aDocuments[i],item->m_doc->m_api.m_doc_mgr.a_apl_doc_lock, pLock);
		if(pLock)
			pInstance=pLock;
	
		if(pInstance)
		{
			item->m_doc_data.GetAttr(pInstance,item->m_doc->m_api.m_doc_mgr.a_apl_doc_rev_user, buf);
			LIST.SetItemText(k,4,buf);

			CString sdate;
			if(pLock)
			{
				item->m_doc_data.GetAttr(pLock,item->m_doc->m_api.m_doc_mgr.a_apl_doc_rev_edit_path, buf);
				LIST.SetItemText(k,6,buf);
				item->m_doc_data.GetAttr(pLock,item->m_doc->m_api.m_doc_mgr.a_apl_doc_rev_start_s, sdate);
			}
			else item->m_doc_data.GetAttr(pInstance,item->m_doc->m_api.m_doc_mgr.a_apl_doc_rev_end_s, sdate);

			COleDateTime time;
			aplString2Date(sdate,time);
			buf = time.Format(_T("%d.%m.%Y %H:%M"));
			LIST.SetItemText(k,5,buf);
		}
		// 
		CaplInstance *charact;
		CaplInstance *base;
		for(int ch = 0; ch<ch_ext.Size;ch++)
		{
			item->m_doc->m_api.m_data.GetAttr(ch_ext[ch],item->m_doc->m_api.m_charact_mgr.a_apl_charact_val_item,base);
			if(base != aDocuments[i]) continue;
			charact=0;
			item->m_doc->m_api.m_data.GetAttr(ch_ext[ch],item->m_doc->m_api.m_charact_mgr.a_apl_charact_val_charact,charact);
			ASSERT(charact);
			aplExtent docs;
			int ind=-1;
			if((ind=item->m_doc->m_characteristics_show.Find(charact))>-1)
			{
				CString buf;
				CaplInstance *unit=0;
				item->m_doc->m_api.m_data.GetAttr(charact,item->m_doc->m_api.m_charact_mgr.a_apl_charact_unit,unit);
				item->m_doc->m_api.m_charact_mgr.PrintCharacteristicValue(ch_ext[ch],unit,buf);
				LIST.SetItemText(k,7+ind,buf);
			}
		}
	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
}

void CDocsListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplInstance *inst=(CaplInstance *)LIST.GetItemData(i);
			if(inst!=0)
			{
				CaplDocTreeItem *doc_item = new CaplDocTreeItem(0,m_cur_item->m_doc,inst);
				if(doc_item!=0) 
				{
					doc_item->View(false);
					m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(doc_item));
				}
			}
		}
	}
	CListView::OnLButtonDblClk(nFlags, point);
}

bool CDocsListView::UpdateHeaders()
{
	CPSMDoc *doc = (CPSMDoc*)GetDocument();
	ASSERT(doc);
	CListCtrl &list  =GetListCtrl();
	while(list.GetHeaderCtrl()->GetItemCount()>7)
		list.DeleteColumn(list.GetHeaderCtrl()->GetItemCount()-1);
	
	CString name;
	for(int i=0; i<doc->m_characteristics_show.Size;i++)
	{
		CaplInstance *inst = doc->m_characteristics_show.GetAt(i);
		if(inst==0) continue;
		doc->m_api.m_data.GetAttr(inst,doc->m_api.m_charact_mgr.a_apl_charact_name,name);
		list.InsertColumn(list.GetHeaderCtrl()->GetItemCount(),name,LVCFMT_LEFT,150);
	}
	return true;
}

LRESULT CDocsListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
