// EffectivitySetDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "EffectivitySetDlg.h"
#include  <aplStepManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEffectivitySetDlg dialog


CEffectivitySetDlg::CEffectivitySetDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CEffectivitySetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEffectivitySetDlg)
	//}}AFX_DATA_INIT
	m_eff=0;
	m_data=0;
	m_prd_mgr=0;
}


void CEffectivitySetDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEffectivitySetDlg)
	DDX_Control(pDX, IDC_END_STATUS, m_end_status);
	DDX_Control(pDX, IDC_EFF_ID, m_eff_id_ctrl);
	DDX_Control(pDX, IDC_START_TIME, m_start_time_ctrl);
	DDX_Control(pDX, IDC_STOP_TIME, m_stop_time_ctrl);
	DDX_Control(pDX, IDC_STOP_SN, m_stop_sn_ctrl);
	DDX_Control(pDX, IDC_STOP_DATE, m_stop_date_ctrl);
	DDX_Control(pDX, IDC_START_SN, m_start_sn_ctrl);
	DDX_Control(pDX, IDC_START_DATE, m_start_date_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEffectivitySetDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CEffectivitySetDlg)
	ON_BN_CLICKED(IDC_SN_MODE, OnSnMode)
	ON_BN_CLICKED(IDC_DATE_MODE, OnDateMode)
	ON_BN_CLICKED(IDC_END_STATUS, OnEndStatus)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEffectivitySetDlg message handlers

void CEffectivitySetDlg::OnSnMode() 
{
	// TODO: Add your control notification handler code here
	m_start_date_ctrl.ShowWindow(SW_HIDE);
	m_start_time_ctrl.ShowWindow(SW_HIDE);
	m_stop_date_ctrl.ShowWindow(SW_HIDE);
	m_stop_time_ctrl.ShowWindow(SW_HIDE);
	
	m_start_sn_ctrl.ShowWindow(SW_SHOW);
	m_stop_sn_ctrl.ShowWindow(SW_SHOW);

	m_cur_type=_T("sn");
	
}

void CEffectivitySetDlg::OnDateMode() 
{
	// TODO: Add your control notification handler code here
	m_start_date_ctrl.ShowWindow(SW_SHOW);
	m_start_time_ctrl.ShowWindow(SW_SHOW);
	m_stop_date_ctrl.ShowWindow(SW_SHOW);
	m_stop_time_ctrl.ShowWindow(SW_SHOW);
	
	m_start_sn_ctrl.ShowWindow(SW_HIDE);
	m_stop_sn_ctrl.ShowWindow(SW_HIDE);
	m_cur_type=S::date;
}

BOOL CEffectivitySetDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	COleDateTime start_t, end_t;
	start_t.GetCurrentTime();
	start_t.SetTime(0,0,0);
	m_start_time_ctrl.SetTime(start_t);
	
	end_t.GetCurrentTime();
	end_t.SetTime(23,59,59);
	m_stop_time_ctrl.SetTime(end_t);
	m_end_status.SetCheck(0);
	m_stop_date_ctrl.EnableWindow(FALSE);
	m_stop_time_ctrl.EnableWindow(FALSE);
	m_stop_sn_ctrl.EnableWindow(FALSE);
	
	RECT rect1,rect2;

	m_start_date_ctrl.GetWindowRect(&rect1);
	m_start_time_ctrl.GetWindowRect(&rect2);
	rect1.right=rect2.right;
	ScreenToClient(&rect1);
	m_start_sn_ctrl.MoveWindow(&rect1);

	m_stop_date_ctrl.GetWindowRect(&rect1);
	m_stop_time_ctrl.GetWindowRect(&rect2);
	rect1.right=rect2.right;
	ScreenToClient(&rect1);
	m_stop_sn_ctrl.MoveWindow(&rect1);

	m_start_date_ctrl.ShowWindow(SW_HIDE);
	m_start_time_ctrl.ShowWindow(SW_HIDE);
	m_stop_date_ctrl.ShowWindow(SW_HIDE);
	m_stop_time_ctrl.ShowWindow(SW_HIDE);
	
	m_start_sn_ctrl.ShowWindow(SW_HIDE);
	m_stop_sn_ctrl.ShowWindow(SW_HIDE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEffectivitySetDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(m_data==0) return;

	CString buf,buf1;
	m_eff_id_ctrl.GetWindowText(buf);
	if(buf==_T(""))
	{
		AfxMessageBox( APL_T("  "),MB_OK|MB_ICONSTOP);
		return;
	}

	CaplAttrValue tst_values[1];
	tst_values[0].value.Set(LPCTSTR(buf));
	tst_values[0].attr=m_prd_mgr->a_pde_id;
	if(!m_data->TestUniqueAttrValues(m_prd_mgr->e_pd_eff,0,1,&tst_values[0]))
	{
		AfxMessageBox( APL_T("        !!!"),MB_OK|MB_ICONSTOP);return;
	}
	if(m_cur_type==_T("sn"))
	{
		if(m_eff==0) m_eff=m_data->CreateInstance(m_prd_mgr->e_sn_eff);
		
		m_start_sn_ctrl.GetWindowText(buf);
		m_data->GetAttr(m_eff,m_prd_mgr->a_sn_eff_start,buf1);
		if(buf1!=buf) m_data->PutAttr(m_eff,m_prd_mgr->a_sn_eff_start,buf);
		
		if(m_end_status.GetCheck()==1)	
		{
			m_stop_sn_ctrl.GetWindowText(buf);
			m_data->GetAttr(m_eff,m_prd_mgr->a_sn_eff_end,buf1);
			if(buf1!=buf) m_data->PutAttr(m_eff,m_prd_mgr->a_sn_eff_end,buf);
		}
	}
	else
	{
		if(m_eff==0) m_eff=m_data->CreateInstance(m_prd_mgr->e_dat_eff);
		
		CString s_dt,s_dt_new;
		COleDateTime d_time,t_time, odt,tim;
		m_start_date_ctrl.GetTime(d_time);	
		m_start_time_ctrl.GetTime(t_time);	
		odt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
		aplDate2String(odt,s_dt_new);

		m_data->GetAttr(m_eff,m_prd_mgr->a_dat_eff_start_s,s_dt);
		if(s_dt_new!=s_dt) 
			m_data->PutAttr(m_eff,m_prd_mgr->a_dat_eff_start_s,s_dt_new);

		if(m_end_status.GetCheck()==1)
		{
			m_stop_date_ctrl.GetTime(d_time);	
			m_stop_time_ctrl.GetTime(t_time);	
			odt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
				t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
			aplDate2String(odt,s_dt_new);

			m_data->GetAttr(m_eff,m_prd_mgr->a_dat_eff_end_s,s_dt);
			if(s_dt_new!=s_dt) 
				m_data->PutAttr(m_eff,m_prd_mgr->a_dat_eff_end_s,s_dt_new);
		}
	}
	m_eff_id_ctrl.GetWindowText(buf);
	m_data->GetAttrBN(m_eff,S::id,buf1);
	if(buf1!=buf) m_data->PutAttrBN(m_eff,S::id,buf);
	
	CaplTranslateDialog::OnOK();
}

void CEffectivitySetDlg::OnEndStatus() 
{
	if(m_end_status.GetCheck()==1)
	{
		m_stop_date_ctrl.EnableWindow(TRUE);
		m_stop_time_ctrl.EnableWindow(TRUE);
		m_stop_sn_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_stop_date_ctrl.EnableWindow(FALSE);
		m_stop_time_ctrl.EnableWindow(FALSE);
		m_stop_sn_ctrl.EnableWindow(FALSE);
	}
}
