// PSMDoc.h : interface of the CPSMDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_PSMDOC_H__8F085ADA_94FE_11D3_BEF1_DCACE325AC16__INCLUDED_)
#define AFX_PSMDOC_H__8F085ADA_94FE_11D3_BEF1_DCACE325AC16__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//#include <stepdata.h>
#include <apl_api.h>
#include <aplPss.h>
#include <aplWorkFlowManager.h>
//#include <aplFormManager.h>
//#include <aplFormManagerDlg.h>
#include <aplProjectMgr.h>
#include <CaplFaultMgr.h>
#include <CommonClasses.h>
//#include <aplTechnicalGuideMgr.h>
#include "aplTreeItem.h"
#include "InfoBar.h"
#include "AutoExpandItems.h"


#define INDEX_CAGEGORY_MENU 0
#define INDEX_PRODUCT_MENU 1
#define INDEX_DOCUMENT_MENU 2
#define INDEX_CHARACTERISTIC_MENU 3
#define INDEX_APPROVAL_MENU 4
#define INDEX_FOLDER_MENU 5
#define INDEX_QUERY_MENU 7
#define INDEX_BP_MENU 9
#define INDEX_BP_INST_PASTE_MENU 10
#define INDEX_PROJECT_PASTE_MENU 11
#define INDEX_PROJECT_MOVE_MENU 13
#define INDEX_REG_CHANGE_MENU 14
#define INDEX_REQ_PASTE_MENU 15
#define INDEX_REQ_PDF_PASTE_MENU 16

#define INDEX_COMBINED_TABLE_MENU 27
#define INDEX_CLASSIFIER_SYSTEM_MENU 28
#define INDEX_REQUIREMENT 29

#define INDEX_DROPPED_FILE 8
#define INDEX_LOT_MENU 9
#define INDEX_PRD_INST_MENU 10
#define INDEX_PERS_FOLDER_MENU 11
#define INDEX_MESSAGE_MENU 12
#define INDEX_MESSAGE_FOLDER_MENU 13
#define INDEX_WF_FOLDER_MENU 14
#define INDEX_PROCESS_MENU 15
#define INDEX_TASK_MENU 16
#define INDEX_PROCESS_TMPL_MENU 17
#define INDEX_ACTIVITY_MENU 18
#define INDEX_ACTION_MENU 19
#define INDEX_CHARACTERISTIC_GROUP_MENU 20
#define INDEX_CHANGE_MENU 21
#define INDEX_ACTION_RES_MENU 22
#define INDEX_BP_INST_MENU 23
#define INDEX_SELECT_QUERY_TYPE_MENU 24

#define INDEX_PASTE_FILE_MENU 4
#define INDEX_PASTE_FOLDER_MENU 5
#define INDEX_PASTE_CHANGE_MENU 6
#define INDEX_PASTE_PRD_INST_MENU 7
#define INDEX_PASTE_QUERY_MENU 8
#define INDEX_PASTE_CHANGE_MENU_1 17
#define INDEX_PASTE_PRECESS_MENU 18

#define INDEX_PROJECT_MENU 0
#define INDEX_ALERT_MENU   1
#define INDEX_DOC_HARD_COPY_MENU 2
#define INDEX_CHANGE_ITEM_MENU	3
#define INDEX_REFUSAL_ITEM_MENU	4

#define m_doc_data  m_doc->m_api.m_data
#define doc_data  doc->m_api.m_data

void SetStatusString(LPCTSTR str, long wait_dlg=0);
void GetAccessName(CaplInstance *inst,CString &buf);

void GetExePath(CString &path);

class CMainFrame;
class CTabView;
class CNavigatorView;
class CaplDocTreeItem;
class CaplAlertTreeItem;

class CMyOleDataSource:public COleDataSource
{
public:
	static bool m_exit;
	CMyOleDataSource();
	CPSMDoc *m_doc;
	CaplInstance *m_inst;
	CaplDocTreeItem *m_item;
	CString m_FileName;
	bool m_bNoEdit;

	virtual BOOL OnRenderData( LPFORMATETC lpFormatEtc, LPSTGMEDIUM lpStgMedium );
};

//    
typedef bool (*LPADDINFUNCTION)(CaplAPI*, aplExtent&, bool);
typedef bool (*LPADDINFUNCTION_v1)(CaplAPI*, aplExtent&, bool, aplExtent&, int&);
typedef bool (*LPADDINFUNCTION_v2)(CaplAPI*, aplExtent&, bool, aplExtent&, int&, CString &);
//     add-in'
class CaplAddInMenuItem
{
public:
	int m_id;					// 
	CString m_itemType;			//m_type CaplTreeItem
	CString m_menuName;			//  
	HICON m_ico;					// 
	CString m_sFuncName;		// 
	LPADDINFUNCTION m_pFunc;	//  
	int m_iFuncParamType;		//  
	CString m_AddInFile;		// dll
	CString m_AddInName;		// add-in'
	bool m_mEnable;				//  
	HMODULE m_hModule;			//handle 

	CaplAddInMenuItem(int id= -1, CString itemType= _T(""), CString menuName= _T(""),
		HICON ico= 0,CString eAddInFile = _T(""),CString eAddInName = _T(""), CString sFuncName= _T(""), LPADDINFUNCTION func= NULL,
		HMODULE Module = NULL, bool Enable = true, int iFuncParamType=0)
	{
		m_id= id;
		m_itemType= itemType;
		m_menuName= menuName;
		m_ico= ico;
		m_sFuncName= sFuncName;
		m_pFunc= func;
		m_AddInFile = eAddInFile;
		m_AddInName = eAddInName;
		m_hModule = Module;
		m_mEnable = Enable;
		m_iFuncParamType = iFuncParamType;
	}
};
/*
class FormMenuItem
{
public:
	int				m_iID;
	CaplInstance*	m_ciForm;
	CString			m_csFormName;
	CString			m_csBaseInstEntName;
};
*/
class CPSMDoc : public CDocument 
{
protected: // create from serialization only
	CPSMDoc();
	DECLARE_DYNCREATE(CPSMDoc)

// Attributes
public:
	CNavigatorView *GetMyActiveView();

	bool m_bMainMenuInit;
	bool m_BShowInListCtrl;
	bool m_bIsAdmin;
	bool m_bCheckingAlerts; //true,   
	UINT m_iTimerTick;

	BOOL m_b_show_categ;

	bool m_bUseProject;

	HINSTANCE m_hMonitorDll;
	bool (*m_fShowMonitor)(CaplAPI*,CaplInstance*&,CString);

	CaplAPI m_api;
	CaplPSSApp m_app;
	
	CaplWorkFlowManager		m_wf_mgr;
	CaplProjectManager*		m_project_mgr;
	CaplExchangeManager		m_exchng_mgr;
	//CaplTechnicalGuideMgr	m_tg_mgr;
	//CaplFormManagerDlg		m_form_mgr_dlg;
	//CaplFormManager		m_form_mgr;     . 
	CaplPreExploitationMgr m_expl_mgr;
	CaplFaultMgr  m_fault_mgr;

	CNavigatorView *m_navigator; //   ( ,    ..)
	CTabView *m_tab_view;
    CaplTAggr <CaplTreeItem*,CaplTreeItem*,APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_items;

	CaplInstance *m_cur_context;
	aplExtent m_inserted_instances_in_new_window;
	CaplInstance* m_next_alert;
	aplExtent m_alerts;

	CString m_show_prd, m_show_doc;

	CStringArray m_charact_names;
	CStringArray m_doc_types_names;
	CStringArray m_sel_doc_types_names;
	
	CaplTreeItem* m_user_incoming_folder;// ""
	CaplTreeItem* m_user_sended_folder;  // ""
	CaplTreeItem* m_user_drafted_folder; // ""

	aplExtent m_incoming_messages;  //   
	aplExtent m_send_or_dr_messages;//   

	CaplMap m_map_dt_dg; //        

	// 
	static BOOL	m_dbl_click_prd_struct_expand_tree;
	static BOOL	m_dbl_click_whereused_expand_tree;
	static BOOL	m_show_inst_info;
	static BOOL	m_bSortPrjByNumzak;
	static BOOL	m_show_subst_in_nauo;
	static BOOL	m_show_zagotov_in_nauo;
	static BOOL	m_auto_show_sign_in_doc_ver;
	static BOOL	m_show_revocated_approval;
	static BOOL	m_show_saved_query_in_tree;
	static DWORD	m_show_old_query_dlg;

	
	//     
	CAutoExpandItems	m_auto_expand_items;

	CFrameWnd			*m_pMainChildFrame;
	CArray <CFrameWnd*, CFrameWnd*> m_additional_frames;
	CArray <CNavigatorView*, CNavigatorView*> m_additional_views;

	CArray <CaplAddInBar*, CaplAddInBar*> m_additional_ctrlbars;
	CaplAddinViews m_addin_tab_views;
	
	CMap<DWORD, DWORD, CString, CString> m_folders_map;

	aplExtent m_characteristics_show;

	//			
	CaplAlertTreeItem* m_RecAlert;// 
	CaplAlertTreeItem* m_DisAlert;//
	
	//Add-in
		
	//      CNavigatorView::OnInitialUpdate()
	//  OnDbConnect   , .. m_navigator  NULL
	bool	m_bShowMonitor;
	CString m_sMonitorText;
	int	m_hMonitorFlag;

public:
	// .    CaplTreeItens 
	//   PSM
	long m_nIndex;
	CArray <CaplAddInMenuItem, CaplAddInMenuItem>	m_addin_menu_items;
	//CArray <FormMenuItem,FormMenuItem>				m_caFormMenuItems;    . 
	aplExtent m_AccessPatterns;

	HINSTANCE m_hConfigMgrLib;
	//   
	void	LoadPSMAddIns();
	//void	LoadFormsData(void);    . 

	DWORD m_tick_connect;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPSMDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual BOOL CanCloseFrame(CFrameWnd* pFrame);
	protected:
	virtual BOOL SaveModified();
	//}}AFX_VIRTUAL

// Implementation
public:
	bool InitialLoad();
	void ShowItem(LPCTSTR type, LPCTSTR show_id);
	void OpenInstanceInNewWindow(CaplInstance *inst);
	void OpenExtentInNewWindow(aplExtent &ext, LPCTSTR sWndHeader);
	CFrameWnd* InitTechToolsPanel(CaplInstance *pFolder);
	CFrameWnd* InitLifeCycleManagmentPanel(CaplInstance *pFolder);
	CFrameWnd* InitModuleContentEditorFrame(CaplInstance *pModuleProduct);

	CaplTreeItem *GetSelItem();

	virtual ~CPSMDoc();
	virtual void SetTitle( LPCTSTR lpszPathName);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

	bool m_AllCategLoaded;
	CaplInstance *m_pCurrentConfiguration;

	BOOL DoSave(LPCTSTR lpszPathName, BOOL bReplace);
	void LoadLocalOptonss();
	void LoadGlobalOptonss();

// Generated message map functions
protected:
public:
	
	CaplInstance* GetCurrentConfiguration() const { return m_pCurrentConfiguration; };
	void SetCurrentConfiguration(CaplInstance *pConfiguration) { m_pCurrentConfiguration = pConfiguration; };

	void CheckAllNewAlerts(int &iRes);
	void CheckAllNewTask(int &iRes);
	void CheckAllNewProcessController(int& iRes);
	void CheckAllNewMessages(int& iRes);
	//void CheckAllNewMonitorEvents(void);
	void UpdateAddinPanels();
	void LoadCharacteristicShow();
	bool SaveFolders();
	bool LoadFoldersMap();
	bool LoadCompositionRequirements();
	void CheckNewMessages(int& iRes);
	void CheckNewMonitorEvents(int& iRes, CString sText);
	void CheckNewTask(int& iRes);
	void CheckNewProcessController(int& iRes);
	bool SortUserAlerts();
	bool ShowUserAlerts(CMainFrame* mFrm= NULL);
	void ChangeItem(CaplTreeItem *item);
	void RefreshAllItemsByType(LPCTSTR type);
	bool DbConnect();
	bool ExportItem(CaplInstance *item);
	
	//{{AFX_MSG(CPSMDoc)
	afx_msg void OnRefreshAllTreeItem();
	afx_msg void OnFileSave();
	afx_msg void OnFileApploadFromFile();
	afx_msg void OnDbConnect();
	afx_msg void OnDbFind();
	afx_msg void OnTest();
	afx_msg void OnConfigure();
	afx_msg void OnShowVariantRule();
	afx_msg void OnShowAllApproval();
	afx_msg void OnShowAllCharacteristic();
	afx_msg void OnShowAllDocs();
	afx_msg void OnShowProperties();
	afx_msg void OnShowAllLot();
	afx_msg void OnShowAllPrdInst();
	afx_msg void OnRunImportef();
	afx_msg void OnProductShowExplosion();
	afx_msg void OnProductShowAllZagotov();
	afx_msg void OnCreateProduct();
	afx_msg void OnProductCreateCharacteristic();
	afx_msg void OnCreateApproval();
	afx_msg void OnCreateDoc();
	afx_msg void OnDigSugnSysSetup();
	afx_msg void OnOptionSelectDefCharacterystic();
	afx_msg void OnUpdateOptionSelectDefCharacterystic(CCmdUI* pCmdUI);
	afx_msg void OnOptionSelectDefDocType();
	afx_msg void OnDbQuery();
	afx_msg void OnDbQueryOld();
	afx_msg void OnDbQueryPdfPiBp();
	afx_msg void OnPdfPiBpAnalize();
	afx_msg void OnProductCompare();
	afx_msg void OnMessageDeliver();
	afx_msg void OnNewMessageCreate();
	afx_msg void OnShowAllVersion();
	afx_msg void OnExpandAll();
	afx_msg void OnFileApploadFromPssFile();
	afx_msg void OnExportItem();
	afx_msg void OnChangePassword();
	afx_msg void OnShowSubscription();
	afx_msg void OnShowPersonAlerts();
	afx_msg void OnImpGloss();
	afx_msg void OnUpdateShowAllDocs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowAllApproval(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowAllCharacteristic(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowAllLot(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowAllPrdInst(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowAllVersion(CCmdUI* pCmdUI);
	afx_msg void OnUpdateProductShowAllZagotov(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCreateDoc(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCreateApproval(CCmdUI* pCmdUI);
	afx_msg void OnUpdateProductCreateSubpart(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCreateCharacteristic(CCmdUI* pCmdUI);
	afx_msg void OnGetDocumentLastVersion();
	afx_msg void OnUpdateGetDocumentLastVersion(CCmdUI *pCmdUI);
	afx_msg void OnShowDocumentChanges();
	afx_msg void OnUpdateShowDocumentChanges(CCmdUI *pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnEditPaste();
	afx_msg void OnEditCut();
	afx_msg void OnCreateBP();
	afx_msg void OnUpdateCreateBP(CCmdUI* pCmdUI);
	afx_msg void OnShowAllBP();
	afx_msg void OnUpdateShowAllBP(CCmdUI* pCmdUI);
	afx_msg void OnShowAllBPResource();
	afx_msg void OnUpdateShowAllBPResource(CCmdUI* pCmdUI);
	afx_msg void OnDbDisconnect();
	afx_msg void OnCreateWindow();
	afx_msg void OnRefreshAll();
	afx_msg void OnActivateMainView();
	afx_msg void OnItemCheckIn();
	afx_msg void OnUpdateItemCheckIn(CCmdUI* pCmdUI);
	afx_msg void OnItemCheckOut();
	afx_msg void OnUpdateItemCheckOut(CCmdUI* pCmdUI);
	afx_msg void OnItemUndoCheckOut();
	afx_msg void OnUpdateItemUndoCheckOut(CCmdUI* pCmdUI);
	afx_msg void OnItemView();
	afx_msg void OnUpdateItemView(CCmdUI* pCmdUI);
	afx_msg void OnOpenItemInNewWindow();
	afx_msg void OnUpdateExpandAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDbFind(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDbQuery(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDbQueryPdfPiBp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNewMessageCreate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateProductCompare(CCmdUI* pCmdUI);
	afx_msg void OnUpdateConfigure(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowVariantRule(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCreateWindow(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOpenItemInNewWindow(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnUpdateActivateMainView(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowProperties(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRefreshAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateRefreshAllTreeItem(CCmdUI* pCmdUI);
	afx_msg void OnUpdateChangePassword(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowSubscription(CCmdUI* pCmdUI);
	afx_msg void OnUpdateShowPersonAlerts(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMessageDeliver(CCmdUI* pCmdUI);
	afx_msg void OnTaskDeliver();
	afx_msg void OnUpdateTaskDeliver(CCmdUI* pCmdUI);
	afx_msg void OnMyOfficial();
	afx_msg void OnCreateBpInst();
	afx_msg void OnUpdateCreateBpInst(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionSelectDefDocType(CCmdUI* pCmdUI);
	afx_msg void OnShowAllBpInst();
	afx_msg void OnUpdateShowAllBpInst(CCmdUI* pCmdUI);
	afx_msg void OnSetupAddin();
	afx_msg void OnSetupCharactiristic();
	afx_msg void OnReportTableSetup();
	afx_msg void OnShowNameOption();
	afx_msg void OnOptionsShow();
	afx_msg void OnOptionsWork();
	afx_msg void OnShowNotes();
	afx_msg void OnUpdateShowNotes(CCmdUI* pCmdUI);
	afx_msg void OnCreateNote();
	afx_msg void OnUpdateCreateNote(CCmdUI* pCmdUI);
	afx_msg void OnOptionsShowintree();
	afx_msg void OnExpand();
	afx_msg void OnUpdateExpand(CCmdUI* pCmdUI);
	afx_msg void OnShowAllDocCopyes();
	afx_msg void OnUpdateShowAllDocCopyes(CCmdUI* pCmdUI);
	afx_msg void OnShowMyDocCopyes(); 
	afx_msg void OnUpdateShowMyDocCopyes(CCmdUI* pCmdUI);
	afx_msg void OnShowMyOutOfOrderDocCopyes();
	afx_msg void OnUpdateShowMyOutOfOrderDocCopyes(CCmdUI* pCmdUI);
	afx_msg void OnShowOutOfOrderCopyes();
	afx_msg void OnUpdateShowOutOfOrderCopyes(CCmdUI* pCmdUI);
	afx_msg void OnCreateHardCopy(); 
	afx_msg void OnUpdateCreateHardCopy(CCmdUI* pCmdUI);
	afx_msg void OnPersonalMonitor();
	afx_msg void OnUpdatePersonalMonitor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSetupCharactiristic(CCmdUI* pCmdUI);
	afx_msg void OnUpdateOptionsWork(CCmdUI* pCmdUI);
	afx_msg void OnSetAccess();
	afx_msg void OnUpdateSetAccess(CCmdUI* pCmdUI);

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	afx_msg void OnPersonalOptions();
	afx_msg void OnAshMoImp();
	afx_msg void OnAshMoVerify();
};

CPSMDoc *GetActiveDocument();
/////////////////////////////////////////////////////////////////////////////



//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PSMDOC_H__8F085ADA_94FE_11D3_BEF1_DCACE325AC16__INCLUDED_)
