// PersonalFolderItem.cpp

#include "stdafx.h"
#include "aplTreeItem.h"

#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"

#include "aplTopLevelItem.h"
#include "TreeProductItem.h"
#include "PersonalFolderItem.h"

#include "ProductCategoryDlg.h"
#include "aplDocTreeItem.h"
#include "aplFolderTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "Defence.h"

#define _APL_TREE_ITEM_CHEK_PARAM \
        if(m_tree==0) return false;\
        if(m_doc==0) return false;

//****************************************************************
//****************************************************************
//****************************************************************
CaplPersonalFolderTreeItem::CaplPersonalFolderTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
				CaplFolderTreeItem *parent, CaplInstance *instance)
{ 
	m_type=_T("PersonalFolder");
	m_tree=tree;
	m_doc=doc;
	m_parent=0;
	m_inst=0;
	if(doc!=0) m_inst=m_doc_data.GetCurrUser();
	if(doc!=0) doc->m_items.Add(this);
}

//****************************************************************
bool CaplPersonalFolderTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_doc==0 || !m_doc->m_api.m_data.IsConnected()) return false;

	CaplInstance * inst;
	CaplTreeItem *par=0;

	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
//	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); //	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_PERS_FOLDER_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;
	
	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	BOOL res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
						point.x, point.y, wnd);
	switch (res)
	{
	case ID_FOLDER_CREATE:

		inst=m_doc->m_api.m_folder_mgr.CreateFolder(m_inst,0,0);
		if(inst!=0)
		{
			CaplFolderTreeItem *fi=new CaplFolderTreeItem(m_tree,m_doc,this,inst);
			fi->CreateTreeItem(m_item);
			m_sub_folders.Add(inst);
			MyExpand();
		}
		break;
	//default: PrepareContextMenu(res); break;
	}
	return true;
}
//****************************************************************
bool CaplPersonalFolderTreeItem::GetName(CString &name)
{
	name= APL_T(" ");
//	name=m_name;
	return true;
}
//****************************************************************
BOOL CaplPersonalFolderTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
/*	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
	case ID_SHOW_ALL_LOT:
	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
	case ID_SHOW_ALL_VERSION:
	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}*/
	return FALSE;
}
//****************************************************************
bool CaplPersonalFolderTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	InsetItem(buf,ICON_PERS_FOLDER,parent_item);
	SetItemImage(ICON_PERS_FOLDER, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	m_expanded=false;
	return true;
}
//****************************************************************
bool CaplPersonalFolderTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	if(item->m_type!=APL_TREE_ITEM_FOLDER) return false;
//	if((m_inst->GetAccessmode()>aplRW)&&(item->m_type!=APL_TREE_ITEM_FOLDER))
//		{ AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}

	CaplInstance *inst=((CaplFolderTreeItem*)item)->m_inst;
	if(inst==0) return false;
	//  
	
	CaplInstance *inst0=m_inst,*inst1;
	bool found=false;
	
	while (1)
	{
		if(inst0==0) break;
		m_doc_data.GetAttr(inst0,m_doc->m_api.m_folder_mgr.a_folder_parent,inst1);
		if(inst1==inst){found=true; break;}
		inst0=inst1;
	}
	if(found) return false;
	//
	if(m_doc->m_api.m_folder_mgr.MoveFolder(inst,m_inst))
	{
		m_doc->m_items.Remove(m_doc->m_items.Find(item));
		CaplFolderTreeItem *fi=new CaplFolderTreeItem(m_tree,m_doc,this,inst);
		fi->CreateTreeItem(m_item);
		m_sub_folders.Add(inst);
		ShowContents();
		MyExpand();
		return true;
	}
	return false;
}