// PrdInstContentsListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PrdInstContentsLV.h"
#include "PrdInstContentsLV.h"
#include "PSMDoc.h"
#include "apl_prd_inst_item.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrdInstContentsListView

IMPLEMENT_DYNCREATE(CPrdInstContentsListView, CListView)

CPrdInstContentsListView::CPrdInstContentsListView()
{
	SetUniqueName(_T("CPrdInstContentsListView"));
}

CPrdInstContentsListView::~CPrdInstContentsListView()
{
}


BEGIN_MESSAGE_MAP(CPrdInstContentsListView, CaplListView)
	//{{AFX_MSG_MAP(CPrdInstContentsListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrdInstContentsListView drawing

void CPrdInstContentsListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CPrdInstContentsListView diagnostics

#ifdef _DEBUG
void CPrdInstContentsListView::AssertValid() const
{
	CaplListView::AssertValid();
}

void CPrdInstContentsListView::Dump(CDumpContext& dc) const
{
	CaplListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPrdInstContentsListView message handlers

int CPrdInstContentsListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,80);
	LIST.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,80);
	LIST.InsertColumn(2, APL_T(" "),LVCFMT_LEFT,120);
	LIST.InsertColumn(3, APL_T(" "),LVCFMT_LEFT,140);
	LIST.InsertColumn(4, APL_T(" "),LVCFMT_LEFT,100);
	LIST.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,100);
	LIST.InsertColumn(6, APL_T(""),LVCFMT_LEFT,200);
	LoadColumnWidths();

	SetColumnDate(4);
	SetColumnDate(5);	

	static CImageList imagelist;
    imagelist.Create(aplGetInstImageList());
	/*CImageList tmp_il;
	int i;
	
	imagelist.Create(IDR_NAVIGATOR_ICON,20,2,RGB(255,0,255));
	imagelist.SetImageCount(300);

	tmp_il.Create(IDR_NAVIGATOR_PRD_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_PRODUCT_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();

	tmp_il.Create(IDR_NAVIGATOR_WF_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_WF_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();*/

	LIST.SetImageList(&imagelist,LVSIL_SMALL);//   TVSIL_STATE);

	return 0;
}

//******************************************************************
void CPrdInstContentsListView::UpdateTreeItem(CaplTreeItem *item)
{
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	
	if(item->m_type!=APL_TREE_ITEM_PRDINST) return;
	CaplInstance *prd_inst=((CaplPrdInstTreeItem*)item)->m_inst; 
	if(prd_inst==0) return;

	CaplInstance *prd=0, *pdf=0, *inst, *rel;
	CString buf,ver;

	CaplAPI &m_api=item->m_doc->m_api;

	aplExtent ext,ext_rel;
	aplExtent rel_contexts;

	StartBusy();	
	m_api.m_prd_inst_mgr.LoadInsertedInstances(prd_inst,ext_rel,ext);
	SetRedraw(FALSE);

	for(int i=0;i<ext_rel.Size;i++)
	{
		rel=ext_rel[i];
		if(rel==0) continue;
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_related,inst);
		if(inst==0) continue;
		if(!m_api.m_data.IsKindOf(inst,m_api.m_prd_inst_mgr.e_prd_inst)) continue;

		int ico=ICON_PRD_INST+3;
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
		if(buf!=_T("")) ico++;

		m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_id,buf);

		int k=LIST.InsertItem(-1,buf,ico);
		LIST.SetItemData(k,(long)rel);

		m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_sn,buf);
		LIST.SetItemText(k,1,buf);
		
		m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_pdf,pdf);
		if(pdf!=0)
		{
			m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_id,ver);
			m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_prd,prd);
			m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_id,buf);
			if(ver!=_T("")) {buf+=_T(" - "); buf+=ver;}
			LIST.SetItemText(k,2,buf);
			m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_name,buf);
			LIST.SetItemText(k,3,buf);
		}

		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
		if(buf!=_T(""))
		{
			COleDateTime odt;
			aplString2Date(buf,odt);
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			LIST.SetItemText(k,4,buf);
			
			m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
			if(buf!=_T(""))
			{
				aplString2Date(buf,odt);
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
				LIST.SetItemText(k,5,buf);
			}
		}
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,rel_contexts);
		m_api.m_prd_inst_mgr.PrintItemContextInString(rel_contexts,buf);
		if(buf!=_T(""))
			LIST.SetItemText(k,6,buf);

	}
	
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CPrdInstContentsListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplInstance *inst,*rel=(CaplInstance *)LIST.GetItemData(i);
			if(rel!=0)
			{
				CaplAPI &m_api=m_cur_item->m_doc->m_api;
				m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_related,inst);
				if(m_api.m_prd_inst_mgr.ShowPrdInstProperties(inst,rel))
				{
					UpdateTreeItem(m_cur_item);
					return;
				}
			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);}

LRESULT CPrdInstContentsListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
