// PrdRelationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PrdRelationDlg.h"
#include "PSMDoc.h"
#include "aplTreeCharacteristicItem.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrdRelationDlg dialog
CPrdRelationDlg::CPrdRelationDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPrdRelationDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrdRelationDlg)
	m_count = 1.0;
	m_in_pdf_id = _T("");
	m_in_prd_id = _T("");
	m_out_pdf_id = _T("");
	m_out_prd_name = _T("");
	m_pdr_descr = _T("");
	m_pdr_id = _T("");
	m_pdr_name = _T("");
	m_out_prd_id = _T("");
	m_in_prd_name = _T("");
	m_ranking = 1;
	m_ranking_rationale = _T("");
	m_count_2 = 1.0;
	m_ref_des = _T("");
	//}}AFX_DATA_INIT

	m_in_pdf=0;
	m_in_prd=0;

	m_out_pdf=0;
	m_out_prd=0;

	m_pdr=0;
	m_data=0;
	m_prd_mgr=0;
	m_charact_mgr=0;
	CString m_mode;

	m_pd_i=0; m_pd=0;
	m_prd_r=0;
	
	m_nauo=0;
	m_subst=0;
}


void CPrdRelationDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrdRelationDlg)
	DDX_Control(pDX, IDC_ST_REF_DES, m_st_ref_des_ctrl);
	DDX_Control(pDX, IDC_REF_DES, m_ref_des_ctrl);
	DDX_Control(pDX, IDC_PDR_ID, m_pdr_id_ctrl);
	DDX_Control(pDX, IDC_PDR_DESCR, m_prd_descr_ctrl);
	DDX_Control(pDX, IDC_PDR_NAME, m_pdr_name_ctrl);
	DDX_Control(pDX, IDC_ST_CONTEXT2, m_st_context);
	DDX_Control(pDX, IDC_CONTEXT_SEL2, m_context_sel);
	DDX_Control(pDX, IDC_CONTEXTS_NAMES2, m_context_names);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	//DDX_Control(pDX, IDC_ST_SORT, m_st_sort);
	DDX_Control(pDX, IDC_STATIC_COUNT_NAME2, m_st_count2);
	DDX_Control(pDX, IDC_COUNT2, m_count_2_ctrl);
	DDX_Control(pDX, IDC_PDR_UNIT2, m_prd_unit_2);
	//DDX_Control(pDX, IDC_SORTAMENT, m_sortament);
	DDX_Control(pDX, IDC_ST_RANK_RAT, m_st_rank_rat);
	DDX_Control(pDX, IDC_ST_NAME, m_st_name);
	DDX_Control(pDX, IDC_ST_DESCR, m_st_descr);
	DDX_Control(pDX, IDC_RANKING_RATIONALE, m_ranking_rationale_ctrl);
	DDX_Control(pDX, IDC_RANKING, m_ranking_ctrl);
	DDX_Control(pDX, IDC_STATIC_RANKING, m_st_ranking);
	DDX_Control(pDX, IDC_COUNT, m_count_ctrl);
	DDX_Control(pDX, IDC_STATIC_COUNT_NAME, m_static_count_name);
	DDX_Control(pDX, IDC_PDR_UNIT, m_pdr_unit);
	DDX_Control(pDX, IDC_STATIC_ID, m_pdr_id_name);
	DDX_Text(pDX, IDC_COUNT, m_count);
	DDX_Text(pDX, IDC_IN_PDF_ID, m_in_pdf_id);
	DDX_Text(pDX, IDC_IN_PRD_ID, m_in_prd_id);
	DDX_Text(pDX, IDC_OUT_PDF_ID, m_out_pdf_id);
	DDX_Text(pDX, IDC_OUT_PRD_NAME, m_out_prd_name);
	DDX_Text(pDX, IDC_PDR_DESCR, m_pdr_descr);
	DDX_Text(pDX, IDC_PDR_ID, m_pdr_id);
	DDX_Text(pDX, IDC_PDR_NAME, m_pdr_name);
	DDX_Text(pDX, IDC_OUT_PRD_ID, m_out_prd_id);
	DDX_Text(pDX, IDC_IN_PRD_NAME, m_in_prd_name);
	DDX_Text(pDX, IDC_RANKING, m_ranking);
	DDV_MinMaxInt(pDX, m_ranking, 0, 999999);
	DDX_Text(pDX, IDC_RANKING_RATIONALE, m_ranking_rationale);
	DDX_Text(pDX, IDC_COUNT2, m_count_2);
	DDX_Text(pDX, IDC_REF_DES, m_ref_des);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPrdRelationDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CPrdRelationDlg)
	ON_BN_CLICKED(IDC_CONTEXT_SEL2, OnContextSel2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrdRelationDlg message handlers

BOOL CPrdRelationDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	if(m_data==0) return FALSE;
	if(m_prd_mgr==0) return FALSE;

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	if((m_mode==_T("Create Assembly"))||(m_mode==_T("Create Supplied"))||
		(m_mode==_T("Create Zagotov"))||(m_mode==_T("Create MakeFrom")))
	{
		m_pd=m_in_pdf;
		m_pd_i=m_out_pdf;
	} 
	else if(m_mode==_T("Create Alternate"))
	{
		if((m_in_prd==0)||(m_out_prd==0))
		{
			AfxMessageBox( APL_T("  !!! (PRD not found)"));
			SendMessage(WM_CLOSE);
			return FALSE;
		}
		if(0!=m_prd_r)
		{
			if(m_data->IsKindOf(m_prd_r,m_prd_mgr->e_alt)) //  
			{
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_basis,m_pdr_id);
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_name,m_pdr_name);
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_descr,m_pdr_descr);

				if(m_in_prd->GetAccessmode()>aplRW)
				{
					m_pdr_id_ctrl.SetReadOnly(TRUE);
					m_pdr_name_ctrl.SetReadOnly(TRUE);
					m_prd_descr_ctrl.SetReadOnly(TRUE);
					m_ok_btn.EnableWindow(FALSE);
				}
			}
			else if(m_data->IsKindOf(m_prd_r,m_prd_mgr->e_alt_pdf))  //   
			{
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_pdf_basis,m_pdr_id);
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_pdf_id,m_pdr_name);
				m_data->GetAttr(m_prd_r,m_prd_mgr->a_alt_pdf_descr,m_pdr_descr);

				if(m_in_pdf->GetAccessmode()>aplRW)
				{
					m_pdr_id_ctrl.SetReadOnly(TRUE);
					m_pdr_name_ctrl.SetReadOnly(TRUE);
					m_prd_descr_ctrl.SetReadOnly(TRUE);
					m_ok_btn.EnableWindow(FALSE);
				}
			}

			if(!m_prd_mgr->m_api->m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T("\\   "),false))
			{
				m_pdr_id_ctrl.SetReadOnly(TRUE);
				m_pdr_name_ctrl.SetReadOnly(TRUE);
				m_prd_descr_ctrl.SetReadOnly(TRUE);
				m_ok_btn.EnableWindow(FALSE);
			}

		}
	}

	if((m_mode==_T("Create Assembly"))||(m_mode==_T("Create MakeFrom"))||(m_mode==_T("Create Substitute")))
	{
		aplExtent ext_unit;

		int option=0;
		m_charact_mgr->m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "),option,1);
		if(1==option) m_charact_mgr->GetPossiblePdfUnits(m_out_pdf,ext_unit);
		if(ext_unit.Size<=0)m_charact_mgr->m_api->m_unit_exch_mgr.GetPrdUnits(ext_unit);

		CString buf,buf1;
		if(ext_unit.Size<=0) m_data->GetEntityExtentBN(_T("step_unit"),ext_unit);
		CString scht;
		for(int i=0;i<ext_unit.Size;i++)
		{
			m_charact_mgr->GetUnitName(ext_unit[i],buf);
			int k=m_pdr_unit.AddString(buf);
			m_pdr_unit.SetItemData(k,(UINT)ext_unit[i]);
			buf1=buf;
			buf1.MakeLower();
			if(buf1==APL_NO_T(""))scht=buf;
			else if(scht==_T(""))
			{
				if(buf1.GetLength()>=2)	{if((buf1[0]==_T(''))&&(buf1[1]==_T('')))scht=buf;}
			}
		}
		if(scht!=_T("")) m_pdr_unit.SelectString(-1,scht);

		CaplInstance *pdf_unit=0;
		m_data->GetAttrBN(m_out_pdf,_T("unit"),pdf_unit);
		if(pdf_unit!=0)
		{
			m_charact_mgr->GetUnitName(pdf_unit,buf);
			m_pdr_unit.SelectString(-1,buf);
		}

		if(m_mode==_T("Create Assembly"))
		{
			MoveRefDes();
			SetWindowText( APL_T("  "));
			m_pdr_id_name.SetWindowText( APL_T(":"));
			m_st_ranking.ShowWindow(SW_HIDE);
			m_ranking_ctrl.ShowWindow(SW_HIDE);
			m_ranking_rationale_ctrl.ShowWindow(SW_HIDE);
			m_st_rank_rat.ShowWindow(SW_HIDE);
			m_st_count2.ShowWindow(SW_HIDE);
			m_count_2_ctrl.ShowWindow(SW_HIDE);
			m_prd_unit_2.ShowWindow(SW_HIDE);
			//m_st_sort.ShowWindow(SW_HIDE);
			//m_sortament.ShowWindow(SW_HIDE);

			m_pdr_id_name.SetWindowText( APL_T(":"));
			m_st_count2.SetWindowText( APL_T(":"));

			if(0!=m_pdr)
			{
				m_data->GetAttr(m_pdr,m_prd_mgr->a_pdr_id,m_pdr_id);
				m_data->GetAttr(m_pdr,m_prd_mgr->a_pdr_name,m_pdr_name);
				m_data->GetAttr(m_pdr,m_prd_mgr->a_pdr_descr,m_pdr_descr);
				m_data->GetAttr(m_pdr,m_prd_mgr->a_acu_ref_des,m_ref_des);

				m_data->GetAttrBN(m_pdr,S::value_component,m_count);
				m_data->GetAttrBN(m_pdr,S::unit_component,pdf_unit);
				if(pdf_unit!=0)
				{
					m_charact_mgr->GetUnitName(pdf_unit,buf);
					m_pdr_unit.SelectString(-1,buf);
				}

				m_data->GetAttr(m_pdr,m_prd_mgr->a_pdr_frames_of_reference,m_nauo_contexts);
				if(m_nauo_contexts.GetSize()>0)
					m_prd_mgr->PrintItemContextInString(m_nauo_contexts,buf);
				else buf=S::all_context();
				m_context_names.SetWindowText(buf);
			}
		}
		else if(m_mode==_T("Create Substitute"))
		{
			SetWindowText( APL_T("    "));
			m_pdr_id_name.SetWindowText( APL_T(":"));
			m_st_name.SetWindowText( APL_T(" :"));
			m_st_descr.SetWindowText( APL_T(" :"));
			m_static_count_name.SetWindowText( APL_T(":"));

			m_context_sel.ShowWindow(SW_HIDE);
			m_st_context.SetWindowText( APL_T(" (.):"));

			// ,   
			RECT r1,r2;
			m_pdr_name_ctrl.GetWindowRect(&r2);
			ScreenToClient(&r2);

			m_context_names.GetWindowRect(&r1);
			ScreenToClient(&r1);
			r1.left=r2.left;
			m_prd_descr_ctrl.GetWindowRect(&r2);
			ScreenToClient(&r2);
			r1.right=r2.right;
			m_context_names.MoveWindow(&r1);

			m_pdr_id_ctrl.GetWindowRect(&r2);
			ScreenToClient(&r2);
			m_st_context.GetWindowRect(&r1);
			ScreenToClient(&r1);
			r1.right=r2.right;
			m_st_context.MoveWindow(&r1);
			
			// 
			m_st_ranking.ShowWindow(SW_HIDE);
			m_ranking_ctrl.ShowWindow(SW_HIDE);
			m_ranking_rationale_ctrl.ShowWindow(SW_HIDE);
			m_st_rank_rat.ShowWindow(SW_HIDE);
			m_st_count2.ShowWindow(SW_HIDE);
			m_count_2_ctrl.ShowWindow(SW_HIDE);
			m_prd_unit_2.ShowWindow(SW_HIDE);
			//m_st_sort.ShowWindow(SW_HIDE);
			//m_sortament.ShowWindow(SW_HIDE);
			m_ref_des_ctrl.ShowWindow(SW_HIDE);
			m_st_ref_des_ctrl.ShowWindow(SW_HIDE);

			// 
			if(m_nauo)
			{
				m_data->GetAttr(m_nauo,m_prd_mgr->a_pdr_r_ting,m_pd);
				if(m_pd) 
				{
					CString buf;
					m_prd_mgr->m_api->GetItemName(m_pd,buf);
					m_context_names.SetWindowText(buf);
				}
			}
			
		}
		else
		{
			SetWindowText( APL_T("   "));
//#ifdef _STUPINO
			m_pdr_id_name.SetWindowText( APL_T(" "));
			m_st_name.SetWindowText( APL_T(".."));
			m_ref_des_ctrl.ShowWindow(SW_HIDE);
			m_st_ref_des_ctrl.ShowWindow(SW_HIDE);
//			m_st_descr.SetWindowText(APL_T("  "));
//			m_st_rank_rat.SetWindowText(APL_T("- .  1 ."));
//#endif

		}
		if(m_mode!=_T("Create Substitute"))
		{
			//  
			if(!m_data->TestCycleInRelationBN(S::assembly_component_usage,S::relating_pd,
				S::related_pd,m_pd,m_pd_i))
			{
				AfxMessageBox( APL_T("  "));
				SendMessage(WM_CLOSE);
				return FALSE;
			}
		}

		if(m_mode==_T("Create MakeFrom"))
		{
			m_ref_des_ctrl.ShowWindow(SW_HIDE);
			m_st_ref_des_ctrl.ShowWindow(SW_HIDE);
			//int i,k=m_sortament.AddString(_T(" "));
			//m_sortament.SetItemData(k,0);

			int i;
			aplExtent ext_unit;
			int option=0;
			m_charact_mgr->m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "),option,1);
			if(1==option) m_charact_mgr->GetPossiblePdfUnits(m_in_pdf,ext_unit);
			if(ext_unit.Size<=0)m_charact_mgr->m_api->m_unit_exch_mgr.GetPrdUnits(ext_unit);

			for(i=0;i<ext_unit.Size;i++)
			{
				m_charact_mgr->GetUnitName(ext_unit[i],buf);
				int k=m_prd_unit_2.AddString(buf);
				m_prd_unit_2.SetItemData(k,(UINT)ext_unit[i]);
			}
			if(scht!=_T("")) m_prd_unit_2.SelectString(-1,scht);

			CaplInstance *pdf_unit=0;
			m_data->GetAttrBN(m_in_pdf,_T("unit"),pdf_unit);
			if(pdf_unit!=0)
			{
				m_charact_mgr->GetUnitName(pdf_unit,buf);
				m_prd_unit_2.SelectString(-1,buf);
			}

			/*aplExtent ext0;
			m_data->GetEntityExtent(m_prd_mgr->e_assortment,ext0);
			for(i=0;i<ext0.Size;i++)
			{
				m_data->GetAttr(ext0[i],m_prd_mgr->a_assortment_name,buf);
				if(buf==_T("")) m_data->GetAttr(ext0[i],m_prd_mgr->a_assortment_id,buf);
				buf+=_T(" ");
				m_data->GetAttrBN(ext0[i],_T("standard"),buf1);
				buf+=buf1;
				int k=m_sortament.AddString(buf);
				m_sortament.SetItemData(k,(UINT)ext0[i]);
			}*/
		}
	}
	else
	{
		if(m_mode==_T("Create Supplied"))SetWindowText( APL_T(" "));
		else if(m_mode==_T("Create Alternate"))
		{
			SetWindowText( APL_T(""));
			m_pdr_id_name.SetWindowText( APL_T(":"));
		}
		else if(m_mode==_T("Create Zagotov"))
		{
			//  
			if(!m_data->TestCycleInRelationBN(_T("design_make_from_relationship"),S::relating_pd,
				S::related_pd,m_pd,m_pd_i))
			{
				AfxMessageBox( APL_T("    \" \""));
				SendMessage(WM_CLOSE);
				return FALSE;
			}
			SetWindowText( APL_T(" "));
//#ifdef _STUPINO
			m_pdr_id_name.SetWindowText( APL_T(". ."));
//#endif

		}
		m_pdr_unit.ShowWindow(SW_HIDE);
		m_static_count_name.ShowWindow(SW_HIDE);
		m_count_ctrl.ShowWindow(SW_HIDE);
		m_st_ranking.ShowWindow(SW_HIDE);
		m_ranking_ctrl.ShowWindow(SW_HIDE);
		m_ranking_rationale_ctrl.ShowWindow(SW_HIDE);
		m_st_rank_rat.ShowWindow(SW_HIDE);
		m_st_count2.ShowWindow(SW_HIDE);
		m_count_2_ctrl.ShowWindow(SW_HIDE);
		m_prd_unit_2.ShowWindow(SW_HIDE);
		//m_st_sort.ShowWindow(SW_HIDE);
		//m_sortament.ShowWindow(SW_HIDE);
		m_context_names.ShowWindow(SW_HIDE);
		m_context_sel.ShowWindow(SW_HIDE);
		m_st_context.ShowWindow(SW_HIDE);
		m_ref_des_ctrl.ShowWindow(SW_HIDE);
		m_st_ref_des_ctrl.ShowWindow(SW_HIDE);
	}

	m_data->GetAttrBN(m_in_prd,S::id,m_in_prd_id);
	m_data->GetAttrBN(m_in_prd,S::name,m_in_prd_name);
	if(m_in_pdf!=0)m_data->GetAttrBN(m_in_pdf,S::id,m_in_pdf_id);
	
	m_data->GetAttrBN(m_out_prd,S::id,m_out_prd_id);
	m_data->GetAttrBN(m_out_prd,S::name,m_out_prd_name);
	if(m_out_pdf!=0)m_data->GetAttrBN(m_out_pdf,S::id,m_out_pdf_id);

	
	UpdateData(FALSE);
	return TRUE;  
	// return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPrdRelationDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(!UpdateData(TRUE)) return;

	CString buf;

	//  ,  .   
	m_count_ctrl.GetWindowText(buf);
	buf.Replace(_T(','),_T('.'));
	m_count=__atof(LPCTSTR(buf));

	m_count_2_ctrl.GetWindowText(buf);
	buf.Replace(_T(','),_T('.'));
	m_count_2=__atof(LPCTSTR(buf));

	UpdateData(FALSE);


	CaplAttrValue tst_values[5];

	if(   (m_mode==_T("Create Assembly"))
		||(m_mode==_T("Create MakeFrom"))
		||(m_mode==_T("Create Supplied"))
		||(m_mode==_T("Create Zagotov")))
	{
		if((m_pd==0)||(m_pd_i==0))
		{
			AfxMessageBox( APL_T(" "));
			return ;
		}

		int NoMultipleIns=0;
		m_prd_mgr->m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "),NoMultipleIns,0);


		if(m_pdr_id.Find(_T("*"))<0 && m_pdr_id.Find(_T("-"))<0) //    -   
		{
			tst_values[0].value.Set(m_pd);
			tst_values[0].attr=m_prd_mgr->a_pdr_r_ting;
			tst_values[1].value.Set(m_pd_i);
			tst_values[1].attr=m_prd_mgr->a_pdr_r_ted;
			int rule_count=2;
			
			if(0==NoMultipleIns)
			{
				tst_values[2].value.Set(m_pdr_id);
				tst_values[2].attr=m_prd_mgr->a_pdr_id;
				rule_count=3;
			}

			if(!m_data->TestUniqueAttrValues(m_prd_mgr->e_pdr,m_pdr,rule_count,&tst_values[0]))
			{
				AfxMessageBox( APL_T("          !!!"),MB_OK|MB_ICONSTOP);return;
			}	
		}
		
		if(m_mode==_T("Create Assembly"))
		{
			if(0==m_pdr) m_pdr=m_data->CreateInstance(m_prd_mgr->e_qacu_nauo);

			m_data->PutAttrBN(m_pdr,S::value_component,m_count);

			CaplInstance *inst2=(CaplInstance*)m_pdr_unit.GetItemData(m_pdr_unit.GetCurSel());
			if(inst2==(CaplInstance*)-1)inst2=0;
			m_data->PutAttrBN(m_pdr,S::unit_component,inst2);
			m_data->PutAttr(m_pdr,m_prd_mgr->a_acu_ref_des,m_ref_des);

			if(m_pd_i->GetAccessmode()<aplRO)
			{
				CaplInstance *first_usage=0;
				m_data->GetAttr(m_pd_i,m_prd_mgr->a_apl_pdf_first_usage,first_usage);
				if(first_usage==0)
				{
					m_data->PutAttr(m_pd_i,m_prd_mgr->a_apl_pdf_first_usage,m_pd);
				}
			}
		}
		else if (m_mode==_T("Create MakeFrom"))
		{
			tst_values[0].value.Set(m_pd);
			tst_values[0].attr=m_prd_mgr->a_pdr_r_ting;
			tst_values[1].value.Set(m_ranking);
			tst_values[1].attr=m_prd_mgr->a_make_from_ranking;
			if(!m_data->TestUniqueAttrValues(m_prd_mgr->e_make_from,0,2,&tst_values[0]))
			{
				AfxMessageBox( APL_T("        !!!"),MB_OK|MB_ICONSTOP);return;
			}

			m_pdr=m_data->CreateInstance(m_prd_mgr->e_make_from);
			m_data->PutAttr(m_pdr,m_prd_mgr->a_make_from_ranking,m_ranking);
			m_data->PutAttr(m_pdr,m_prd_mgr->a_make_from_ranking_rationale,m_ranking_rationale);

			m_data->PutAttrBN(m_pdr,S::value_component,m_count);

			CaplInstance *inst2=(CaplInstance*)m_pdr_unit.GetItemData(m_pdr_unit.GetCurSel());
			if(inst2==(CaplInstance*)-1)inst2=0;
			m_data->PutAttrBN(m_pdr,S::unit_component,inst2);

			inst2=(CaplInstance*)m_prd_unit_2.GetItemData(m_prd_unit_2.GetCurSel());
			if(inst2==(CaplInstance*)-1)inst2=0;
			m_data->PutAttrBN(m_pdr,_T("derive_unit_component"),inst2);
			
			m_data->PutAttrBN(m_pdr,_T("derive_value_component"),m_count_2);

			//inst2=(CaplInstance*)m_sortament.GetItemData(m_sortament.GetCurSel());
			//if(inst2==(CaplInstance*)-1)inst2=0;
			//m_data->PutAttrBN(m_pdr,_T("apl_assortment"),inst2);
		}
		else if(m_mode==_T("Create Supplied"))
		{
			if((m_pd==0)||(m_pd_i==0)){AfxMessageBox( APL_T(" "));return ;}
			m_pdr=m_data->CreateInstanceBN(_T("supplied_part_relationship"));
		}
		else if(m_mode==_T("Create Zagotov"))
		{
			m_pdr=m_data->CreateInstanceBN(_T("design_make_from_relationship"));
		}
		else {AfxMessageBox (_T("Err")); return;}

		m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_id,m_pdr_id);
		m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_name,m_pdr_name);
		m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_descr,m_pdr_descr);
		m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_r_ting,m_pd);
		m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_r_ted,m_pd_i);


		//if(m_nauo_contexts.GetSize()>0) // ..   
			m_data->PutAttr(m_pdr,m_prd_mgr->a_pdr_frames_of_reference,m_nauo_contexts);

	}
	else if(m_mode==_T("Create Alternate"))
	{
		if(0==m_prd_r)
		{
			/*m_prd_r=m_data->CreateInstance(m_prd_mgr->e_alt);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_base,m_in_prd);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_alt,m_out_prd);*/

			m_prd_r=m_data->CreateInstance(m_prd_mgr->e_alt_pdf);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_pdf_base,m_in_pdf);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_pdf_alt,m_out_pdf);
		}
		if(m_data->IsKindOf(m_prd_r,m_prd_mgr->e_alt))
		{
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_basis,m_pdr_id);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_name,m_pdr_name);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_descr,m_pdr_descr);
		}
		else if(m_data->IsKindOf(m_prd_r,m_prd_mgr->e_alt_pdf))  //   
		{
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_pdf_basis,m_pdr_id);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_pdf_id,m_pdr_name);
			m_data->PutAttr(m_prd_r,m_prd_mgr->a_alt_pdf_descr,m_pdr_descr);
		}
	}
	else if(m_mode==_T("Create Substitute"))
	{
		CaplInstance *unit=(CaplInstance*)m_pdr_unit.GetItemData(m_pdr_unit.GetCurSel());
		if(unit==(CaplInstance*)-1)unit=0;
		m_subst=m_prd_mgr->CreateSubstitute(m_nauo,m_out_pdf,m_pdr_id,m_pdr_name,m_pdr_descr,m_count,unit);
		if(!m_subst) return;
	}
	m_data->NET_SaveChanges();
	CaplTranslateDialog::OnOK();
}

void CPrdRelationDlg::OnContextSel2() 
{
	if(m_prd_mgr->ChangeItemContext(m_nauo_contexts))
	{
		CString buf;
		if(m_nauo_contexts.GetSize()>0)
			m_prd_mgr->PrintItemContextInString(m_nauo_contexts,buf);
		else buf=S::all_context();
		m_context_names.SetWindowText(buf);
	}
}

void CPrdRelationDlg::MoveRefDes()
{
	CRect rect,ref_des_rect,st_ref_des_rect;
	m_st_count2.GetWindowRect(&rect);
	ScreenToClient(&rect);
	
	m_ref_des_ctrl.GetWindowRect(&ref_des_rect);
	ScreenToClient(&ref_des_rect);
	int heigth=ref_des_rect.Height();
	ref_des_rect.top=rect.top;
	ref_des_rect.bottom=rect.top+heigth;
	m_ref_des_ctrl.MoveWindow(&ref_des_rect);
	
	m_st_ref_des_ctrl.GetWindowRect(&st_ref_des_rect);
	ScreenToClient(&st_ref_des_rect);
	heigth=st_ref_des_rect.Height();
	st_ref_des_rect.top=rect.top;
	st_ref_des_rect.bottom=rect.top+heigth;
	m_st_ref_des_ctrl.MoveWindow(&st_ref_des_rect);
	
}
