// ProductStructureListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PSMDoc.h"
#include "ProductStructureListView.h"
#include "TreeProductItem.h"
#include "aplTreeCharacteristicItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProductStructureListView

IMPLEMENT_DYNCREATE(CProductStructureListView, CaplListView)

CProductStructureListView::CProductStructureListView()
{
	SetUniqueName(_T("CProductStructureListView"));
}

CProductStructureListView::~CProductStructureListView()
{
}


BEGIN_MESSAGE_MAP(CProductStructureListView, CaplListView)
	//{{AFX_MSG_MAP(CProductStructureListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProductStructureListView drawing

void CProductStructureListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CProductStructureListView diagnostics

#ifdef _DEBUG
void CProductStructureListView::AssertValid() const
{
	CListView::AssertValid();
}

void CProductStructureListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CProductStructureListView message handlers

int CProductStructureListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,40);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,50);
	LIST.InsertColumn(4, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(5, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(6,_T("*"),LVCFMT_LEFT,27);
	LIST.InsertColumn(7, APL_T(""),LVCFMT_LEFT,100);
	LIST.InsertColumn(8, APL_T(""),LVCFMT_LEFT,100);
	LoadColumnWidths();

	SetColumnNumeric(0);
	SetColumnNumeric(4);

	static CImageList imagelist;
	imagelist.Create(aplGetInstImageList());
	/*CImageList tmp_il;
	int i;
	
	imagelist.Create(IDR_NAVIGATOR_ICON,20,2,RGB(255,0,255));
	imagelist.SetImageCount(300);

	tmp_il.Create(IDR_NAVIGATOR_PRD_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_PRODUCT_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();

	tmp_il.Create(IDR_NAVIGATOR_WF_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_WF_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();*/

	LIST.SetImageList(&imagelist,LVSIL_SMALL);//   TVSIL_STATE);

	return 0;
}

void CProductStructureListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	
	if(item->m_type!=APL_TREE_ITEM_PRODUCT) return;
	CaplInstance *m_prd=0, *m_pdf=0,*m_val=0; 
	m_prd=((CaplProductTreeItem*)item)->m_prd;
	m_pdf=((CaplProductTreeItem*)item)->m_pdf;
	
	if(m_prd==0) return;
	if(m_pdf==0) return;
	aplExtent ext0,ext1;
	int i,k;
	CaplInstance *inst1, *i_pdf, *i_prd;
	CString id,name,ver,buf,buf1,subst_descr, code;
	CaplProductManager *prd_mgr=&(item->m_doc->m_api.m_prd_mgr);
	aplExtent ext_subst_rel,ext_subst_pdf;
	CaplInstance *subst_pdf=0,*subst_prd=0;

	StartBusy();	
	prd_mgr->LoadAllSubProduct(0,0,m_pdf,ext0,ext1,true);
	if(CPSMDoc::m_show_subst_in_nauo && ext0.GetSize())
	{
		CaplLoadData ld(&item->m_doc_data,DEF_SOURCE);
		for(i=0;i<ext0.Size;i++)
		{
			if(!ext0[i]) continue;
			if(ext0[i]->GetAccessmode()>aplRO) continue;
			ld.AddQuery(0,ext0[i],true);
		}
		int i1,i8,i12;
		i1=	ld.AddQuery(_T('r'), 0, prd_mgr->e_pdf_subst, prd_mgr->a_pdf_subst_pdr, true,true);
		i8=	ld.AddQuery(_T('d'), i1, 0, prd_mgr->a_pdf_subst_pdr, true,true);
		i12=ld.AddQuery(_T('d'), i8, 0, prd_mgr->a_pdr_r_ted, true,true);//  
			ld.AddQuery(_T('d'), i12,0, prd_mgr->a_pdf_prd, true,true);
		i8=	ld.AddQuery(_T('d'), i1, 0, prd_mgr->a_pdf_subst_pdf, true,true);//   
			ld.AddQuery(_T('d'), i8, 0, prd_mgr->a_pdf_prd, true,true);

		ld.LoadEx();
	}
	if(CPSMDoc::m_show_zagotov_in_nauo && ext1.GetSize())
	{
		CaplLoadData ld(&item->m_doc_data,DEF_SOURCE);
		for(i=0;i<ext1.Size;i++)
		{
			if(!ext1[i]) continue;
			if(ext1[i]->GetAccessmode()>aplRO) continue;
			ld.AddQuery(0,ext1[i],true);
		}
		int i1,i12;
		i1=	ld.AddQuery(_T('r'), 0, prd_mgr->e_design_make_from, prd_mgr->a_pdr_r_ting, true,true);
		i12=ld.AddQuery(_T('d'), i1, 0, prd_mgr->a_pdr_r_ted,true,true);
			ld.AddQuery(_T('d'), i12,0, prd_mgr->a_pdf_prd, true,true);
		i12=ld.AddQuery(_T('d'), i1, 0, prd_mgr->a_pdr_r_ting,true,true);
			ld.AddQuery(_T('d'), i12, 0,prd_mgr->a_pdf_prd, true,true);

		ld.LoadEx();
	}
	SetRedraw(FALSE);
	//
	aplExtent ext_design;
	item->m_doc_data.GetEntityExtent(prd_mgr->e_design_make_from,ext_design);
	for(i=0;i<ext0.Size;i++)
	{
		//item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_pdr_r_ting,inst0);
		item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_pdr_r_ted,i_pdf);
		item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_prd,i_prd);
		if(i_prd!=0)
		{

			CString form_type,type_rus;
			int ico;
			bool b_has_eff=false;
			ico = item->m_doc->m_api.GetInstIco(i_pdf);
			item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_apl_pdf_type,form_type);
			/*
			if(form_type==_T("assembly")){ico=ICON_ASSEMBLY;}
			else if(form_type==_T("material")){ico=ICON_MATERIAL;}
			else if(form_type==_T("kit")){ico=ICON_KIT;}
			else if(form_type==_T("komplex")){ico=ICON_KOMPLEX;}
			else {ico=ICON_PART;}
			*/
			buf=item->m_doc->m_api.m_prd_mgr.StrConvertPdfType2Rus(form_type);
			type_rus=buf;

			item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_pdr_id,id);
			buf.Format(_T("%2s"),LPCTSTR(id));
			k=LIST.InsertItem(-1,buf,ico);
			LIST.SetItemData(k,(long)ext0[i]);

			LIST.SetItemText(k,5,type_rus);

			item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_id,id);
			LIST.SetItemText(k,1,id);

			item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_name,name);
			LIST.SetItemText(k,2,name);
			
			item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_id,ver);
			LIST.SetItemText(k,3,ver);

			item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_code,code);
			LIST.SetItemText(k,7,code);

			buf=_T("");
			double count=1;
			if(item->m_doc_data.IsKindOf(ext0[i],prd_mgr->e_apl_qacu))
			{
				item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_apl_qacu_value,count);
				item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_apl_qacu_unit,inst1);
				item->m_doc->m_api.m_charact_mgr.GetUnitName(inst1,buf);
			}
			buf1 = Double2Str(count)+_T(" ")+buf;
			//buf1.Format(_T("%g %s"),count,buf);
			if(CPSMDoc::m_show_subst_in_nauo)
			{
				prd_mgr->LoadAllSubstitutes(ext0[i],ext_subst_rel,ext_subst_pdf,false);
				if(ext_subst_rel.GetSize())
				{
					subst_descr=buf1+ APL_T(" . ");
					//  
					int subst_count=0;
					CStringArray subst_group;
					for(int z=0;z<ext_subst_rel.GetSize();z++)
					{
						if(!ext_subst_rel[z]) continue;
						CString subst_name;
						item->m_doc_data.GetAttr(ext_subst_rel[z],prd_mgr->a_pdf_subst_name,subst_name);
						int y;
						bool found=false;
						for(y=0;y<subst_group.GetSize();y++)
						{
							if(subst_group[y]==subst_name) 
							{
								found=true;
								break;
							}
						}
						if(found) continue;
						subst_group.Add(subst_name);
						item->m_doc_data.GetAttr(ext_subst_rel[z],prd_mgr->a_pdf_subst_id,buf);
						if(buf==_T("")) buf= APL_T("' '");
						subst_count++;
						if(subst_count==1)
						{
							subst_descr+= APL_T(" .")+buf;
						}
						else
						{
							subst_descr+= APL_T("   .")+buf;
						}
						int together_subst_count=0;
						for(y=0;y<ext_subst_rel.GetSize();y++)
						{
							if(ext_subst_rel[y]==ext_subst_rel[z]) continue;
							item->m_doc_data.GetAttr(ext_subst_rel[y],prd_mgr->a_pdf_subst_name,buf);
							if(buf==subst_name)
							{
								item->m_doc_data.GetAttr(ext_subst_rel[y],prd_mgr->a_pdf_subst_id,buf);
								if(together_subst_count==0)
								{
									subst_descr+= APL_T("   .")+buf;
								}
								else
								{
									subst_descr+= APL_T(",.")+buf;
								}
								together_subst_count++;
							}
							
						}
					}
					LIST.SetItemText(k,8,subst_descr);
				}
				else
				{
					LIST.SetItemText(k,4,buf1);
				}
			}
			else
			{
				LIST.SetItemText(k,4,buf1);
			}
			//   
			int j;
			aplExtent ext3;
			CaplInstance *inst0;
			item->m_doc_data.GetEntityExtent(prd_mgr->e_pd_eff,ext3);
			for(j=0;j<ext3.Size;j++)
			{
				item->m_doc_data.GetAttr(ext3[j],prd_mgr->a_pde_usage,inst0);
				if(inst0==ext0[i]) 
				{//ico++; 
				   b_has_eff=true;	
				   break;
				}
			}
			//SetItemImage(ico_eff,IDX_IL_TREE_EFF,false);	
			if(b_has_eff) LIST.SetItemText(k,6,_T("X"));
		}
	}
	if(CPSMDoc::m_show_zagotov_in_nauo)//
	{
		for(int i=0;i<ext1.GetSize();i++)
		{
			if(!ext1[i]) continue;if(!ext1[i]->GetType()) continue;if(ext1[i]->GetAccessmode()>aplRO) continue;

			CaplInstance *pdf_rel_ing;
			CString type;
			for(int j=0;j<ext_design.GetSize();j++)
			{
				if(!ext_design[j]) continue;if(!ext_design[j]->GetType()) continue;
				item->m_doc_data.GetAttr(ext_design[j],prd_mgr->a_pdr_r_ting,pdf_rel_ing);
				if(pdf_rel_ing==ext1[i])
				{
					item->m_doc_data.GetAttr(ext_design[j],prd_mgr->a_pdr_r_ted,i_pdf);
					if(!i_pdf) continue;if(!i_pdf->GetType()) continue;if(i_pdf->GetAccessmode()>aplRO) continue;
					item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_apl_pdf_type,type);
					item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_prd,i_prd);
					if(!i_prd) continue;if(!i_prd->GetType()) continue;if(i_prd->GetAccessmode()>aplRO) continue;
					if(type==_T("part"))//    
					{
						int ico = item->m_doc->m_api.GetInstIco(i_pdf);
						item->m_doc_data.GetAttr(ext_design[j],prd_mgr->a_pdr_id,id);
						buf.Format(_T("%2s"),LPCTSTR(id));
						k=LIST.InsertItem(-1,buf,ico);
						LIST.SetItemData(k,(long)ext_design[j]);
						
						buf=item->m_doc->m_api.m_prd_mgr.StrConvertPdfType2Rus(type);
						LIST.SetItemText(k,5,buf);
						item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_id,id);
						LIST.SetItemText(k,1,id);

						item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_name,name);
						LIST.SetItemText(k,2,name);
						
						item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_id,ver);
						LIST.SetItemText(k,3,ver);
						item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_code,code);
						LIST.SetItemText(k,7,code);

						buf=_T("");
						double count=1;
						item->m_doc_data.GetAttr(ext_design[j],prd_mgr->a_apl_qacu_value,count);
						if(count)
						{
							item->m_doc_data.GetAttr(ext_design[j],prd_mgr->a_apl_qacu_unit,inst1);
							item->m_doc->m_api.m_charact_mgr.GetUnitName(inst1,buf);
							buf1 = Double2Str(count)+_T(" ")+buf;
//							buf1.Format(_T("%g %s"),count,buf);
							LIST.SetItemText(k,4,buf1);
						}

						item->m_doc_data.GetAttr(ext1[i],prd_mgr->a_pdf_prd,i_prd);
						if(i_prd)
						{
							buf= APL_T("  ");
							item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_id,id);
							buf+=id;
							LIST.SetItemText(k,8,buf);
						}
					}
				}
			}
		}
	}
	if(CPSMDoc::m_show_subst_in_nauo && ext0.GetSize())
	{
		for(i=0;i<ext0.Size;i++)
		{
			if(!item->m_doc_data.IsKindOf(ext0[i],prd_mgr->e_apl_qacu)) continue;
			
			item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_pdr_r_ted,i_pdf);
			if(!i_pdf) continue;
			if(i_pdf->GetAccessmode()>aplRO) continue;

			prd_mgr->LoadAllSubstitutes(ext0[i],ext_subst_rel,ext_subst_pdf,false);
	
			CString nauo_id=_T("");
			item->m_doc_data.GetAttr(ext0[i],prd_mgr->a_pdr_id,nauo_id);
			if(nauo_id==_T("")) nauo_id= APL_T("' '");
			for(int j=0;j<ext_subst_rel.GetSize();j++)
			{
				CString subst_name;
				item->m_doc_data.GetAttr(ext_subst_rel[j],prd_mgr->a_pdf_subst_pdf,subst_pdf);
				item->m_doc_data.GetAttr(ext_subst_rel[j],prd_mgr->a_pdf_subst_name,subst_name);
				if(!subst_pdf) continue;
				if(subst_pdf->GetAccessmode()>aplRO) continue;
				item->m_doc_data.GetAttr(subst_pdf,prd_mgr->a_pdf_prd,subst_prd);
				if(!subst_prd) continue;
				if(subst_prd->GetAccessmode()>aplRO) continue;
				
				CString form_type,type_rus;
				int ico;
				bool b_has_eff=false;
				item->m_doc_data.GetAttr(subst_pdf,prd_mgr->a_apl_pdf_type,form_type);
				ico = item->m_doc->m_api.GetInstIco(subst_pdf);
				/*if(form_type==_T("assembly")){ico=ICON_ASSEMBLY;}
				else if(form_type==_T("material")){ico=ICON_MATERIAL;}
				else if(form_type==_T("kit")){ico=ICON_KIT;}
				else if(form_type==_T("komplex")){ico=ICON_KOMPLEX;}
				else {ico=ICON_PART;}*/

				buf=item->m_doc->m_api.m_prd_mgr.StrConvertPdfType2Rus(form_type);
				type_rus=buf;

				item->m_doc_data.GetAttr(ext_subst_rel[j],prd_mgr->a_pdf_subst_id,id);
				buf.Format(_T("%2s"),LPCTSTR(id));
				k=LIST.InsertItem(-1,buf,ico);
				LIST.SetItemData(k,(long)ext_subst_rel[j]);
				LIST.SetItemText(k,5,type_rus);

				item->m_doc_data.GetAttr(subst_prd,prd_mgr->a_prd_id,id);
				LIST.SetItemText(k,1,id);

				item->m_doc_data.GetAttr(subst_prd,prd_mgr->a_prd_name,name);
				LIST.SetItemText(k,2,name);
				
				item->m_doc_data.GetAttr(subst_pdf,prd_mgr->a_pdf_id,ver);
				LIST.SetItemText(k,3,ver);

				buf=_T("");
				double count=1;
				item->m_doc_data.GetAttr(ext_subst_rel[j],prd_mgr->a_pdf_subst_value,count);
				item->m_doc_data.GetAttr(ext_subst_rel[j],prd_mgr->a_pdf_subst_unit,inst1);
				item->m_doc->m_api.m_charact_mgr.GetUnitName(inst1,buf);
				buf1 = Double2Str(count)+_T(" ")+buf;
//				buf1.Format(_T("%g %s"),count,buf);

				subst_descr=buf1+ APL_T(" .");
				//  
				int more_subst_count=0;
				for(int z=0;z<ext_subst_rel.GetSize();z++)
				{
					if(!ext_subst_rel[z]) continue;
					if(ext_subst_rel[z]==ext_subst_rel[j]) continue;			
					item->m_doc_data.GetAttr(ext_subst_rel[z],prd_mgr->a_pdf_subst_name,buf);
					if(buf==subst_name)
					{
						item->m_doc_data.GetAttr(ext_subst_rel[z],prd_mgr->a_pdf_subst_id,buf);
						if(buf==_T("")) buf= APL_T("' '");
						more_subst_count++;
						if(more_subst_count==1)
						{
							subst_descr+= APL_T("  .")+buf;
						}
						else
						{
							subst_descr+=_T(",")+buf;
						}
					}

				}
				subst_descr+= APL_T("  .")+nauo_id;

				
				LIST.SetItemText(k,8,subst_descr);
			}
		}
	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CProductStructureListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplInstance *inst=(CaplInstance *)LIST.GetItemData(i);
			if(inst!=0)
			{
				CaplProductManager *prd_mgr=0;
				if(m_cur_item) prd_mgr=&(m_cur_item->m_doc->m_api.m_prd_mgr);
				if(!prd_mgr) return;
				if(m_cur_item->m_doc_data.IsKindOf(inst,prd_mgr->e_pdr))
				{
					if(CPSMDoc::m_dbl_click_prd_struct_expand_tree==FALSE)
					{
						CaplInstance *i_pdf;//,i_prd;
						m_cur_item->m_doc_data.GetAttrBN(inst,S::related_pd,i_pdf);
						///m_cur_item->m_doc_data.GetAttrBN(i_pdf,S::of_product,i_prd);
						CaplProductTreeItem *doc_item=new CaplProductTreeItem(0,m_cur_item->m_doc,0,i_pdf);
						if(doc_item!=0) 
						{
							doc_item->m_nauo=inst;
							doc_item->ShowProperties();
							m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(doc_item));
						}
					}
					else
					{
						//  
						((CaplProductTreeItem*)m_cur_item)->ShowAllSubProduct();
						HTREEITEM item1=m_cur_item->m_tree->GetChildItem(m_cur_item->m_item);
						while(item1!=0)
						{
							HTREEITEM item2=item1;
							item1=m_cur_item->m_tree->GetNextItem(item1, TVGN_NEXT);
							CaplTreeItem *item=(CaplTreeItem*)(m_cur_item->m_tree->GetItemData(item2));
							if(item==0) continue;
							if(item->m_type!=APL_TREE_ITEM_PRODUCT) continue;
							if(((CaplProductTreeItem*)item)->m_nauo!=inst) continue;
							//m_cur_item->m_tree->Select(item2,TVGN_FIRSTVISIBLE);
							m_cur_item->m_tree->SelectItem(item2);
							m_cur_item->m_tree->SelectDropTarget(item2);
							return;
						}
					}
					UpdateTreeItem(m_cur_item);
				}
				else 
				{
					CaplInstance *i_pdf=0,*i_prd=0;
					m_cur_item->m_doc_data.GetAttr(inst,prd_mgr->a_pdf_subst_pdf,i_pdf);
					if(!i_pdf) return;
					m_cur_item->m_doc_data.GetAttr(inst,prd_mgr->a_pdf_prd,i_prd);
					CaplProductTreeItem *prd_item=new CaplProductTreeItem(0,m_cur_item->m_doc,i_prd,i_pdf);
					if(prd_item!=0) 
					{
						prd_item->m_subst=inst;
						prd_item->ShowProperties();
						//    
						for(int i=0;i<m_cur_item->m_doc->m_items.GetSize();i++)
						{
							if(m_cur_item->m_doc->m_items[i]->m_type==APL_TREE_ITEM_PRODUCT)
							{
								CaplProductTreeItem *tree_prd_item=(CaplProductTreeItem*)m_cur_item->m_doc->m_items[i];
								if(tree_prd_item) if(tree_prd_item->m_pdf==i_pdf) tree_prd_item->RefreshItem();
							}
						}

						m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(prd_item));
						UpdateTreeItem(m_cur_item);
					}	
				}

			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}

LRESULT CProductStructureListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
