// ProjectsListView.cpp: implementation of the CProjectsListView class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "psm.h"
#include "ProjectsListView.h"

#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "aplProjectTreeItem.h"
#include "apl_prd_inst_item.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CProjectsListView, CaplListView)

CProjectsListView::CProjectsListView()
{
	SetUniqueName(_T("CProjectsListView"));
}

CProjectsListView::~CProjectsListView()
{

}

BEGIN_MESSAGE_MAP(CProjectsListView, CaplListView)
	//{{AFX_MSG_MAP(CProjectsListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProjectsListView drawing

void CProjectsListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CProjectsListView diagnostics

#ifdef _DEBUG
void CProjectsListView::AssertValid() const
{
	CListView::AssertValid();
}

void CProjectsListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CProjectsListView message handlers

int CProjectsListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,110);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,110);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(4, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(5, APL_T("."),LVCFMT_LEFT,80);
	LIST.InsertColumn(6, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(7, APL_T("  "),LVCFMT_LEFT,50);
	LIST.InsertColumn(8, APL_T("  "),LVCFMT_LEFT,50);
	LIST.InsertColumn(9, APL_T("  "),LVCFMT_LEFT,50);
	LIST.InsertColumn(10, APL_T("  "),LVCFMT_LEFT,50);
	LIST.InsertColumn(11, APL_T(""),LVCFMT_LEFT,50);
	LIST.InsertColumn(12, APL_T(" "),LVCFMT_LEFT,50);

	SetColumnDate(7);SetColumnDate(8);SetColumnDate(9);SetColumnDate(10);
	return 0;
}

void CProjectsListView::UpdateTreeItem(CaplTreeItem *item)
{
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	
	int i,j,k;
	CaplInstance *baseinst=0;
	CString buf,buf0;
	COleDateTime dt;

	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{
		baseinst=((CaplProductTreeItem*)item)->m_prd;
		CaplInstance *pdf=((CaplProductTreeItem*)item)->m_pdf;
		if(pdf) baseinst=pdf;
	}
	else if(item->m_type==APL_TREE_ITEM_PRDINST) baseinst=((CaplPrdInstTreeItem*)item)->m_inst;

	if(baseinst==0)return;
	if(baseinst->GetAccessmode()>aplRO) return;

	StartBusy();
	SetStatusString( APL_T("  "));

	aplExtent ext,ext_rel;
	item->m_doc->m_project_mgr->FindAssociatedProjects(baseinst, ext, ext_rel);

	SetStatusString(_T(""));
	SetRedraw(FALSE);
	for(i=0;i<ext.GetSize();i++)
	{
		if(!ext[i]) continue;
		if(ext[i]->GetAccessmode()>aplRO) continue;
		j=0;

		k=LIST.InsertItem(j,_T(""));
		LIST.SetItemData(k,(long)ext[i]);

		CaplInstance *ver=item->m_doc->m_project_mgr->CheckMyLock(ext[i],false);
		
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_api.m_project_mgr->a_project_adm_ver_id,buf);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_id,buf);
		LIST.SetItemText(k,j,buf);j++;

		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_api.m_project_mgr->a_project_adm_ver_name,buf);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_name,buf);
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		CaplInstance *type=0;
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_api.m_project_mgr->a_project_adm_ver_type,type);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_type,type);
		if(type) item->m_doc_data.GetAttr(type,item->m_doc->m_api.m_project_mgr->a_project_type_name,buf);
		LIST.SetItemText(k,j,buf);j++;

		item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_state,buf);
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		CaplInstance *customer=0;
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_api.m_project_mgr->a_project_adm_ver_customer,customer);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_customer,customer);
		if(customer) item->m_doc->m_api.GetItemName(customer,buf);
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		CaplInstance *kurator=0;
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_api.m_project_mgr->a_project_adm_ver_kurator,kurator);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_api.m_project_mgr->a_project_kurator,kurator);
		if(kurator) item->m_doc->m_api.GetItemName(kurator,buf);
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		aplExtent executors;

		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_project_mgr->a_project_adm_ver_executors,executors);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_executors,executors);
		for(int l=0;l<executors.GetSize();l++)
		{
			//item->m_doc->m_api.m_appr_mgr.GetPersonName(executors[l],buf0);
			item->m_doc->m_api.GetItemName(executors[l],buf0);
			if(buf0!=_T(""))
			{
				buf+=buf; 
				if(l!=(executors.GetSize()-1)) buf+=_T(", "); 
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_project_mgr->a_project_adm_ver_date_planned_begin,buf);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_date_planned_begin,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_project_mgr->a_project_adm_ver_date_planned_end,buf);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_date_planned_end,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_date_actual_begin,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		buf=_T("");
		item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_date_actual_end,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		//
		buf=_T("");
		double num=0;
		CaplInstance *labor=0,*unit=0;
		if(ver) item->m_doc_data.GetAttr(ver,item->m_doc->m_project_mgr->a_project_adm_ver_labor_useness,labor);
		else item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_labor_useness,labor);
		if(labor)
		{
			item->m_doc_data.GetAttr(labor,item->m_doc->m_project_mgr->a_labor_value,num);
			if(num)	buf.Format(_T("%f"),num);
			item->m_doc_data.GetAttr(labor,item->m_doc->m_project_mgr->a_labor_unit,unit);
			if(unit)
			{
				if(!num) 
				buf+=_T("0");
				buf+=_T(" ");
				item->m_doc->m_api.m_charact_mgr.GetUnitName(unit,buf0);
				buf+=buf0;
			}
		}
		LIST.SetItemText(k,j,buf);j++;

		// 
		buf=_T("");
		item->m_doc_data.GetAttr(ext[i],item->m_doc->m_project_mgr->a_project_persentage,num);
		if(num)	buf.Format(_T("%f"),num);
		LIST.SetItemText(k,j,buf);j++;

	}
	//LoadColumnWidths();
	//SortColumn(m_aCombinedSortedColumns[0]);
	//SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CProjectsListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplInstance *inst=(CaplInstance *)LIST.GetItemData(i);
			if(inst!=0)
			{
				CaplProjectTreeItem *prj_item=new CaplProjectTreeItem(0,m_cur_item->m_doc,inst);
				if(prj_item!=0) 
				{
					prj_item->ShowProperties();
					//    
					for(int i=0;i<m_cur_item->m_doc->m_items.GetSize();i++)
					{
						if(m_cur_item->m_doc->m_items[i]->m_type==APL_TREE_ITEM_PROJECT)
						{
							CaplProjectTreeItem *tree_prj_item=(CaplProjectTreeItem*)m_cur_item->m_doc->m_items[i];
							if(tree_prj_item) if(tree_prj_item->m_inst==inst) tree_prj_item->RefreshItem();
						}
					}

					m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(prj_item));
					UpdateTreeItem(m_cur_item);
				}
			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}

LRESULT CProjectsListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
