// ShorPdfInstanceHistory.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "ShorPdfInstanceHistory.h"
#include "PSMDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShorPdfInstanceHistory dialog


CShorPdfInstanceHistory::CShorPdfInstanceHistory(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CShorPdfInstanceHistory::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShorPdfInstanceHistory)
	m_prd_name = _T("");
	m_pdf_id = _T("");
	m_prd_id = _T("");
	//}}AFX_DATA_INIT

	m_list.SetUniqueName(_T("CShorPdfInstanceHistory"));

	m_pdf=0;
	m_pApi=0;

}


void CShorPdfInstanceHistory::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShorPdfInstanceHistory)
	DDX_Control(pDX, ID_SAVE_TO_FILE, m_save_to_file_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Text(pDX, IDC_PRD_NAME, m_prd_name);
	DDX_Text(pDX, IDC_PDF_ID, m_pdf_id);
	DDX_Text(pDX, IDC_PRD_ID, m_prd_id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShorPdfInstanceHistory, CaplResizableDialog)
	//{{AFX_MSG_MAP(CShorPdfInstanceHistory)
	ON_BN_CLICKED(ID_SAVE_TO_FILE, OnSaveToFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShorPdfInstanceHistory message handlers

BOOL CShorPdfInstanceHistory::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	// TODO: Add extra initialization here
	if(m_pdf==0) return FALSE;

	RECT rect={5,10,100,200};
	CWnd* wnd=GetDlgItem(IDC_ST_LIST) ;
	if(wnd!=0)
	{
		wnd->GetWindowRect(&rect);
		ScreenToClient(&rect);
	}
	m_list.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,rect,this,IDC_CONTENTS);
	//CaplResizableDialog::OnInitDialog();
	
	m_list.InsertColumn(0, APL_T(""),LVCFMT_LEFT,110);
	m_list.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,90);
	m_list.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	m_list.InsertColumn(3, APL_T(""),LVCFMT_LEFT,100);
	m_list.InsertColumn(4, APL_T(""),LVCFMT_LEFT,100);
	m_list.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,70);
	m_list.InsertColumn(6, APL_T(" "),LVCFMT_LEFT,100);
	m_list.InsertColumn(7, APL_T(" "),LVCFMT_LEFT,200);

	m_list.SetColumnDate(2);
	m_list.SetColumnDate(3);

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_save_to_file_btn.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_save_to_file_btn.SetFlat(FALSE);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(ID_SAVE_TO_FILE, BOTTOM_LEFT);

	AddAnchor(IDC_PDF_ID, TOP_RIGHT);
	AddAnchor(IDC_ST_VER_NAME, TOP_RIGHT);

	AddAnchor(IDC_PRD_ID, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_PRD_NAME, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_ST_PRD_RAMK, TOP_LEFT, TOP_RIGHT);

	AddAnchor(IDC_CONTENTS, TOP_LEFT, BOTTOM_RIGHT);

	//  
	int i,j,ico=0,item;
	CaplAPI &m_api=*m_pApi;
	CString id, sn, buf,ver;
	CaplInstance *inst,*rel,*prd,*pdf;

	m_api.m_data.GetAttr(m_pdf,m_api.m_prd_mgr.a_pdf_id,m_pdf_id);
	m_api.m_data.GetAttr(m_pdf,m_api.m_prd_mgr.a_pdf_prd,prd);
	m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_id,m_prd_id);
	m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_name,m_prd_name);
	UpdateData(FALSE);

	//   
	StartBusy();
	m_list.SetRedraw(FALSE);
	aplExtent ext_pi,ext_rel,ext;
	m_api.m_prd_inst_mgr.FindAllPdfInstances(m_pdf,ext_pi);
	for(i=0; i<ext_pi.Size;i++)
	{
		CaplInstance *pi=ext_pi[i];

		m_api.m_data.GetAttr(pi,m_api.m_prd_inst_mgr.a_prd_inst_id,id);
		m_api.m_data.GetAttr(pi,m_api.m_prd_inst_mgr.a_prd_inst_sn,sn);

		m_api.m_prd_inst_mgr.WhereUsedPIinPI(pi,ext_rel,ext);

		if(ext_rel.Size==0)
		{
			//    
			item=m_list.InsertItem(i,id);
			m_list.SetItemData(item,(long)pi);
			m_list.SetItemText(item,1,sn);
		}
		else
		{
			for(j=0;j<ext_rel.Size;j++)
			{
				rel=ext_rel[j];
				if(rel==0) continue;
				item=m_list.InsertItem(i,id);
				m_list.SetItemData(item,(long)rel);
				m_list.SetItemText(item,1,sn);

				m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
				if(buf!=_T(""))
				{
					COleDateTime odt;
					aplString2Date(buf,odt);
					buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
					m_list.SetItemText(item,2,buf);
					
					m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
					if(buf!=_T(""))
					{
						aplString2Date(buf,odt);
						buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
						m_list.SetItemText(item,3,buf);
					}
				}
				
				m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_relating,inst);
				if(inst==0) continue;
				if(!m_api.m_data.IsKindOf(inst,m_api.m_prd_inst_mgr.e_prd_inst)) continue;

				m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_id,buf);
				m_list.SetItemText(item,4,buf);

				m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_sn,buf);
				m_list.SetItemText(item,5,buf);
				
				m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_pdf,pdf);
				if(pdf!=0)
				{
					m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_id,ver);
					m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_prd,prd);
					m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_id,buf);
					if(ver!=_T("")) {buf+=_T(" - "); buf+=ver;}
					m_list.SetItemText(item,6,buf);
					m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_name,buf);
					m_list.SetItemText(item,7,buf);
				}
			}
		}
	}
	m_list.SetRedraw(TRUE);
	StopBusy();

	if(ext_pi.Size==0) AfxMessageBox( APL_T("       !"));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShorPdfInstanceHistory::OnSaveToFile() 
{
	CString buf=m_prd_id;
	if(m_pdf_id!=_T("")){buf+=_T("-");buf+=m_pdf_id;}
	CString buf1=m_prd_name;
	buf1+=_T("   "); buf1+=buf;
	apl_SaveListCtrlToFile(&m_list,LPCTSTR(buf),buf1);
	
}
