#ifndef _APL_CHANGE_TREE_ITEM_H_
#define _APL_CHANGE_TREE_ITEM_H_

#include "aplTreeItem.h"

class CaplChangeTreeItem: public CaplTreeItem
{
public:
	CaplChangeTreeItem(CTreeCtrl *tree= 0, CPSMDoc *doc= 0, 
		CaplInstance* chng= NULL, CaplInstance* chngItem= NULL);
	~CaplChangeTreeItem(){RemoveFromParenContents(m_chng);}
    bool GetName(CString &name);
    bool RefreshItem();
    bool CreateTreeItem(HTREEITEM parent_item);
	bool Expand(UINT action);
	void ShowProperties();
	bool ShowInListCtrl(CListCtrl *list);
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	bool PasteItem(CaplTreeItem *item, CPoint *point= 0);
	bool PasteFile(LPCTSTR file, CPoint *point);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	void GetAccessedInstances(aplExtent &ext);
	void ShowChangeContent();
	
	bool CheckOut();

public:
	CaplInstance* m_chng;
	CaplInstance* m_chng_item;
	CaplInstance* m_folder;
	CaplInstance* m_classifier;
	aplExtent m_all_items;	
	aplExtent m_sub_folders;
};

#endif //_APL_CHANGE_TREE_ITEM_H_