// aplCharacteristicGroupTreeItem.cpp


// aplTreeCharacteristicItem.cpp

//#include <stdafx.h>

#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplTreeApprovalItem.h"
#include "aplDocTreeItem.h"
#include "TabView.h"
#include "aplBPTreeItem.h"


//****************************************************************
//****************************************************************
//****************************************************************
CaplCharacteristicGroupTreeItem::CaplCharacteristicGroupTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *group)
{ 
	m_type=APL_TREE_ITEM_CHARACTERISTICGROUP;
	m_group=group;
	m_doc=doc;
	m_tree=tree;
	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************
bool CaplCharacteristicGroupTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_GROUP_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	aplExtent ext_cons;
	GetGroupAss(ext_cons);
	if(!ext_cons.GetSize()) 
	{
		pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
	}
	else
	{
		int num_of_locked=0,num_of_unlocked=0;
		for(int i=0;i<ext_cons.GetSize();i++)
		{
			if(m_doc->m_api.m_charact_mgr.GetLock(ext_cons[i],false))
				num_of_locked++;
			else
				num_of_unlocked++;
		}
		if(num_of_locked==ext_cons.GetSize())
			pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
		if(num_of_unlocked==ext_cons.GetSize())
		{
			pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);	
		}
	}
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);

	switch(res)
	{
	case ID_DELETE :
		{
			if(m_group!=0)
			{
				if(m_group->GetAccessmode()>aplOWN)
				{
					AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
					return true;
				}
			}
			if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDYES)
			{
				int i;
				aplExtent ext0;
				GetGroupAss(ext0);
				for(i=0;i<ext0.Size;i++)
				{
					if(ext0[i]!=0)
					{
						if(ext0[i]->GetAccessmode()>aplOWN)
						{
							AfxMessageBox( APL_T("         !!!"),MB_OK|MB_ICONSTOP);
							return false;
						}
					}
				}
				CaplInstance *item=0;
				m_doc->m_api.m_data.GetAttr(m_group,m_doc->m_api.m_charact_mgr.a_charact_val_group_item,item);
				if(!item) return false;
				CaplInstance *lock=0,*bp_ver=0;	
				
				if(m_doc->m_api.m_charact_mgr.m_bUseVersions && m_doc->m_api.m_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
				{
					if(!m_doc->m_api.m_bp_mgr.CheckMyLockAndCheckOut(item))
						return false;
					CaplBPTreeItem *parent_item=(CaplBPTreeItem*)GetParentItem(this);
					if(parent_item) parent_item->RefreshItem();

					CaplInstance *bp_lock=m_doc->m_api.m_bp_mgr.CheckMyLock(item,true);
					if(!bp_lock) return false;
				}
				for(i=0;i<ext0.Size;i++)
				{
					m_doc->m_api.m_charact_mgr.DeleteCharacteristic(ext0[i],false,true);
				}
				m_doc_data.DeleteInstance(m_group);
				
				for(i=0;i<m_doc->m_items.Size;i++)
				{
					if(m_doc->m_items[i]!=this)
					{
						if(m_doc->m_items[i]->m_type==m_type)
						{
							CaplCharacteristicGroupTreeItem *item1=
								(CaplCharacteristicGroupTreeItem*)m_doc->m_items[i];
							{
								if(item1->m_group==m_group)
								{m_doc->m_items.Remove(i); i--;}
							}
						}
					}
				}
				m_doc_data.NET_SaveChanges();
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
		}
		break;
	case ID_ITEM_CHECK_IN:CheckIn();break;
	case ID_ITEM_CHECK_OUT:CheckOut();break;
	case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
	default: PrepareContextMenu(res); break;
	}
	return true;
}
//****************************************************************
void CaplCharacteristicGroupTreeItem::ShowCmd(long cmd)
{
	switch(cmd)
	{
		case ID_SHOW_ALL_CONTENTS: {Expand(2); MyExpand(); break;} 
		case ID_ITEM_CHECK_IN:CheckIn();break;
		case ID_ITEM_CHECK_OUT:CheckOut();break;
		case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
		default: PrepareContextMenu(cmd);break;
	}
}

BOOL CaplCharacteristicGroupTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT || pCmdUI->m_nID==ID_ITEM_CHECK_IN || pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)
	{
		aplExtent ext;
		GetGroupAss(ext);
		if(!ext.GetSize()) return false;
		int num_of_locked=0,num_of_unlocked=0;
		for(int i=0;i<ext.GetSize();i++)
		{
			if(m_doc->m_api.m_charact_mgr.GetLock(ext[i],false))
				num_of_locked++;
			else
				num_of_unlocked++;
		}
		if(num_of_locked==ext.GetSize())
			if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return false;
		if(num_of_unlocked==ext.GetSize())
			if(pCmdUI->m_nID==ID_ITEM_CHECK_IN || pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT) return false;
	}
	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
//	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
//	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
//	case ID_SHOW_ALL_VERSION:
//	case ID_CREATE_PRODUCT:
//	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_ITEM_CHECK_OUT:
	case ID_ITEM_CHECK_IN:
	case ID_ITEM_UNDO_CHECK_OUT:
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplCharacteristicGroupTreeItem::GetName(CString &name)
{
//	name=_T("CharacteristicGroup");
	CHECK_GET_NAME(m_group);
	
	CaplInstance *def;
	m_doc_data.GetAttr(m_group,m_doc->m_api.m_charact_mgr.a_charact_val_group_def,def);
	if(def!=0)m_doc_data.GetAttr(def,m_doc->m_api.m_charact_mgr.a_apl_charact_union_name,name);
	return true;
}
//****************************************************************
void CaplCharacteristicGroupTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_group!=0)ext.Add(m_group);
//	if(AfxMessageBox(APL_T("      ?"),MB_YESNO|MB_ICONQUESTION)==IDYES)
	{
		aplExtent ext0;
		GetGroupAss(ext0);
		for(int i=0;i<ext0.Size;i++)
		{
			if(ext0[i]!=0) {if(ext0[i]->GetType()!=0)ext.Add(ext0[i]);}
		}
	}
}
//****************************************************************
bool CaplCharacteristicGroupTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	int ico = m_doc->m_api.GetInstIco(m_group);
	InsetItem(buf,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	RefreshItem();
	return true;
}

//****************************************************************
bool CaplCharacteristicGroupTreeItem::RefreshItem()
{
/*
	UINT ico=0,ico1=0;
	ico=ICON_CHARACTERISTIC;ico1=ICON_CHARACTERISTIC;
*/
	if(m_tree==0) return false;
	if(m_group==0) return false;
	if(m_group->GetType()==0)
	{
		m_doc->m_items.Remove(m_doc->m_items.Find(this));
		return false;
	}
	Sort();
	m_tree->RedrawWindow();
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}
//****************************************************************
void CaplCharacteristicGroupTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_doc->m_api.m_charact_mgr.ShowGroupProperties(m_group))
	{
		RefreshItem();
		Expand(1);
		Expand(2);
		Sort(true);
	}
}
//****************************************************************
bool CaplCharacteristicGroupTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	if(m_doc==0)return false;
	CHECK_SHOW_LIST_CTRL(m_group);

	if(m_doc->m_BShowInListCtrl==false) return true;
	CString buf;
	CaplInstance *def=0;
	int i;
	if(m_group!=0)
	m_doc_data.GetAttr(m_group,m_doc->m_api.m_charact_mgr.a_charact_val_group_def,def);
	if(def!=0)m_doc_data.GetAttr(def,m_doc->m_api.m_charact_mgr.a_apl_charact_union_name,buf);
	i=list->InsertItem(0, APL_T(":"));
	list->SetItemText(i,1,buf);

	list->InsertItem(2,_T(""));
	i=list->InsertItem(3, APL_T(":"));
	GetAccessName(m_group,buf);
	list->SetItemText(i,1,buf);

	aplExtent ext;
	CStringArray comment;
	if(m_group!=0){ comment.Add(_T("")); ext.Add(m_group);}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}
/*
//****************************************************************
void CaplCharacteristicGroupTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *new_ass=0, *new_val=0;

	if(m_val==0) return ;
	if(m_val->type==0) return ;
	if(m_val->GetAccessmode()>=aplRO)
	{
		aplErrorMessage(S::NoAccessRight,m_val);
		return ;
	}

	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(m_ass,ass,val,&new_ass, &new_val))
	{
		if(CaplTreeItem::m_AutoUzurpireCharacteristic)
		{
			aplExtent ext; ext.Add(new_val);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}

		CaplCharacteristicGroupTreeItem *characteristic_item=
			new CaplCharacteristicGroupTreeItem(m_tree,m_doc,new_ass);
		characteristic_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(new_ass);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}*/

//****************************************************************
bool CaplCharacteristicGroupTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
//	if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
		if (item->m_type != APL_TREE_ITEM_DOCUMENT)
			return false;

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup=0;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

//	if (item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
//		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	if (item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		CString state;
		m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
		if(state==_T("canceled")) return false;
		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
	}
	
	if(pPopup!=0)
	{
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

/*		//  
		if (res == ID_CHARACTERISTIC_COPY)
		{
			CaplInstance *i_ass=((CaplCharacteristicGroupTreeItem *)item)->m_ass;
			CaplInstance *i_val=((CaplCharacteristicGroupTreeItem *)item)->m_val;
			CreateCharacteristic(i_ass,i_val);
		}
		else */
		if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_group))
				MyExpand();
		}
	}
	m_tree->RedrawWindow();
	return true;
}

void CaplCharacteristicGroupTreeItem::GetGroupAss(aplExtent &ext)
{
	m_doc->m_api.m_charact_mgr.GetGroupContents(m_group,ext);
}

//****************************************************************
bool CaplCharacteristicGroupTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
//	_APL_TREE_ITEM_CHEK_PARAM

	if(action==2)
	{
		if(m_expanded) return true;
		//if(m_hasSubItem)Expand(1);
		if(m_fictive_item!=0) {m_tree->DeleteItem(m_fictive_item);m_fictive_item=0;}
		aplExtent ext0;
		GetGroupAss(ext0);
		
		m_tree->SetRedraw(FALSE);
		for(int i=0;i<ext0.Size;i++)
		{
			if(m_characteristics.Find(ext0[i])<0)
			{
				CaplCharacteristicTreeItem *characteristic_item=
					new CaplCharacteristicTreeItem(m_tree,m_doc,ext0[i]);
				characteristic_item->CreateTreeItem(m_item);
				m_characteristics.Add(ext0[i]);
			}
		}
		m_tree->SetRedraw(TRUE);
		bool old = m_bShowNoFoundMessage;
		m_bShowNoFoundMessage = old;
		m_ExecMyExpand = true;
		if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_DOC)
			ShowAllDocs(false,false);
		if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_APPROVAL)
			ShowAllApproval(false);
		m_bShowNoFoundMessage = old;
		m_ExecMyExpand = true;
		Sort();
	}
	else if(action==1)
	{
		CollapseItem();
		m_characteristics.Clear();
	}
	return true;
}

bool CaplCharacteristicGroupTreeItem::CheckOut()
{
	bool check_out_result=false;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_group,_T("item"),item);
	if(!item) return false;
	check_out_result=m_doc->m_api.m_charact_mgr.CheckOutGroup(m_group); 
	if(check_out_result)
	{
		if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_BP)
				{
					CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
					bool has_version=bp_item->m_has_version;
					bp_item->Expand(1);
					bp_item->m_has_version=has_version;
					bp_item->Expand(2);
					bp_item->RefreshItem();
					bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
					bp_item->ShowAllCharacteristic();
					m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
				}
			}
		}
		else
		{
			Expand(1);
			Expand(2);
		}
	}
	return check_out_result;
}
bool CaplCharacteristicGroupTreeItem::CheckIn()
{
	bool check_in_result=false;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_group,_T("item"),item);
	if(!item) return false;
	check_in_result=m_doc->m_api.m_charact_mgr.CheckInGroup(m_group); 
	if(check_in_result)
	{
		if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_BP)
				{
					CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
					bool has_version=bp_item->m_has_version;
					bp_item->Expand(1);
					bp_item->m_has_version=has_version;
					bp_item->Expand(2);
					bp_item->RefreshItem();
					bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
					bp_item->ShowAllCharacteristic();
					m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
				}
			}
		}
		else
		{
			Expand(1);
			Expand(2);
		}
	}
	return check_in_result;
}
bool CaplCharacteristicGroupTreeItem::UndoCheckOut()
{
	bool undo_check_out_result=false;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_group,_T("item"),item);
	if(!item) return false;
	undo_check_out_result=m_doc->m_api.m_charact_mgr.UndoCheckOutGroup(m_group); 
	if(undo_check_out_result)
	{
		if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_BP)
				{
					CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
					bool has_version=bp_item->m_has_version;
					bp_item->Expand(1);
					bp_item->m_has_version=has_version;
					bp_item->Expand(2);
					bp_item->RefreshItem();
					bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
					bp_item->ShowAllCharacteristic();
					m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
				}
			}
		}
		else
		{
			Expand(1);
			Expand(2);
		}
	}
	return undo_check_out_result;
}