// aplDocTreeItem.h

#include "aplTreeItem.h"

class CaplDocTreeItem : public CaplTreeItem
{
        //Attributes
public:
	static bool m_bShowName;
	static bool m_bShowID;
	static bool m_bShowActiveVersion;
	static bool m_bShowType;
	static bool m_bShowSelectAppDlg;
	static CString m_EditPath;

	CaplInstance *m_inst;
	CaplInstance *m_rev;
	CaplInstance *m_rel;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_project;
	aplExtent *m_par_item_docs_ext;

	bool m_bRefreshRevision;
	bool m_has_version;
	bool bIsLock ; 

protected:
	aplExtent m_all_base_objects;
	aplExtent m_all_parent_prd_inst;
	aplExtent m_all_copyes;
	bool m_bCheclingAllowing;
	bool m_bHasVersionItems;
	CaplInstance * m_pLockInfo;
	CaplDocTreeItem * m_pDocItem;
	bool m_bStoreInBase;
	

    // Methods
protected:
	void InsertRevisionInTree(aplExtent &ext_rev_hist,CaplDocTreeItem *docitem, aplExtent *ext_approval=0);

public:
	CString ChangePathIfIntegration(CaplInstance* inst);
	void ShowAllCharacteristic(bool showMsg = true);
	static int RecursiveDoc(CPSMDoc* m_doc,CaplInstance *doc, CaplInstance *in_doc, aplExtent &insts);
    CaplDocTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *i_doc=0,CaplInstance *i_rel=0,CaplInstance *i_rev=0);
	~CaplDocTreeItem(){RemoveFromParenContents(m_inst);}
    bool GetName(CString &name);
    bool RefreshItem();
	bool RefreshAllThisDocItem();
 	bool RefreshAllDocItem();
	bool ChangeTextColor();
	bool DeleteWrongLoadedDocument(CaplInstance *document);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
    bool CreateTreeItem(HTREEITEM parent_item);
    bool Expand(UINT action);
    
	bool ShowInListCtrl(CListCtrl *list);
	void ShowProperties();
	void ShowCmd(long cmd);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	
	void HideAllVersion();
	void ShowAllVersion(bool showMsg = true, bool bFromActive=false);
	void ShowAllBaseObjects(CaplEntity *ent=0); //  ent!=0     
	void ShowWhereUsedAsComponent(bool bAnyTime); //       bAnyTime==false,    
	void ShowAllBPs(bool showMsg);
	void ShowAllHardCopyes(bool showMsg,bool b_show_dlg=false);
	
	void View(bool bShowSelectPtogram);
	void CheckIn();
	void CheckOut();
	void UndoCheckOut();
	void GetDocumentLatestVersion();

	void CreateCharacteristic(CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *group=0);
	void CreateBP(CaplInstance *inst_for_id=0);
	void CreateHardCopy();
	void CreateRefusal();

	void CopyDataToDataSource(CMyOleDataSource *pSource);


	virtual void GetAccessedInstances(aplExtent &ext);
	virtual void GetMainInstances(aplExtent &ext);
	
	bool PasteFile(LPCTSTR file, CPoint *point);
	bool PasteItem(CaplTreeItem *item, CPoint *point=0);
	
	bool ReplaceDocument();

	static bool CreateDocByDot(CPSMDoc* doc, CaplInstance* dot, CaplInstance* inst);
	static bool MoveDocument(CPSMDoc* doc, CaplDocTreeItem* doc_item, CaplTreeItem* from_item, CaplTreeItem* to_item);
	static bool InsertDoc(CPSMDoc *doc, CaplTreeItem *item,
						aplExtent *exist_items, CaplInstance *i_doc,CaplInstance *i_obj, bool add = true);
	//   i_doc  i_obj
};
