#pragma once
#include "afxwin.h"
#include "apl_gui.h"

// CaplRecurseFindDlg dialog

class CaplProductTreeItem;
class CaplClassifierTreeItem;

class CaplRecurseFindDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CaplRecurseFindDlg)

public:
	CaplRecurseFindDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CaplRecurseFindDlg();

	void InitButtons();
	void ExpandItem(HTREEITEM hItem);
	bool ShowItem(HTREEITEM parent, int direction);
	void SetTreeItem(CaplTreeItem *item, CaplInstance *rootItem);	

// Dialog Data
	enum { IDD = IDD_FIND_DLG };

	CEdit m_textEdit;
	CaplButton m_findBtn;
	CaplButton m_findNexBtn;
	CaplButton m_findPrevBtn;

	CaplAPI *m_api;
	aplExtent m_searchedItems;
	aplExtent m_validExtent;

	CaplTreeItem *m_item;
	std::map<CaplInstance*, std::vector<CaplInstance*>> m_relations;

	int GetSearchResultCount(CaplInstance *pdf);
	int LoadRecursiveDataProduct(CaplProductTreeItem *item);
	int LoadRecursiveDataClassifier(CaplClassifierTreeItem *item);
	void FillClassifierRelationMap(CaplInstance *edItem, std::map<CaplInstance*, CaplInstance*> &backwardRelations);
	

protected:
	virtual BOOL OnInitDialog();
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()	

	afx_msg void OnBnClickedFindFirst();
	afx_msg void OnBnClickedFindNext();
	afx_msg void OnBnClickedFindPrev();
};
