// aplTopLevelItem.h

#include "aplTreeItem.h"

class CaplProductTreeItem;

class CaplCategoryTreeItem : public CaplTreeItem
{
        //Attributes
public:
	static bool m_bShowName;
	static bool m_bShowID;

	CaplCategoryTreeItem *m_parent;
	CaplInstance *m_inst;
	CaplInstance *m_rev;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_pLockInfo;
	bool m_bIsPArent;
    // Methods
public:
	bool GetCategoryExtent(CaplAPI *api, CaplInstance *inst, aplExtent &ext);
    CaplCategoryTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplCategoryTreeItem *parent=0, CaplInstance *instance=0);
	~CaplCategoryTreeItem(){RemoveFromParenContents(m_inst);}
    bool GetName(CString &name);
    bool RefreshItem();
	bool CaplCategoryTreeItem::RefreshAllThisCategItem();
	void GetAccessedInstances(aplExtent &ext);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
    bool CreateTreeItem(HTREEITEM parent_item);
    bool Expand(UINT action);
	void ExpandSubCategory();
    bool ShowInListCtrl(CListCtrl *list);
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);

	bool PasteItem(CaplTreeItem *item, CPoint *point=0);
	bool PasteFile(LPCTSTR file, CPoint *point);

	aplExtent m_products;
protected:
	aplExtent m_all_category;

	void ShowProperties();
	void ShowAllVersion(bool showMsg);
	void LoadProperties();
	//void CreateCharacteristic(CaplInstance *val=0);
	//void CreateCharacteristicGroup(CaplInstance *group=0);

public:
	void CreateProduct(CaplProductTreeItem *baseitem=0);
};


