// aplTreeCharacteristicItem.cpp

#include <stdafx.h>

#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplTreeApprovalItem.h"
#include "aplDocTreeItem.h"
#include "TabView.h"
#include "aplBPTreeItem.h"

#define _APL_TREE_ITEM_CHEK_PARAM \
        if(m_tree==0) return false;\
        if(m_doc==0) return false;

bool CaplCharacteristicTreeItem::m_ShowValue=true;
bool CaplCharacteristicTreeItem::m_ShowUnit=true;
int CaplCharacteristicTreeItem::m_ShowID_or_Name=0;

//****************************************************************
//****************************************************************
//****************************************************************
CaplCharacteristicTreeItem::CaplCharacteristicTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *val)
{ 
	m_type=APL_TREE_ITEM_CHARACTERISTIC;
	m_val=val;
	m_doc=doc;
	m_tree=tree;
	m_bp_rev=0;
	m_pLockInfo=0;
	m_rev=0;
	m_parent_value_item=0;
	m_has_version=false;
	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************

bool CaplCharacteristicTreeItem::ExpandRefItems()
{
	if(0==m_val) return false;

	if(m_doc_data.IsKindOf(m_val,m_doc->m_api.m_charact_mgr.e_apl_reference_value))
	{
		CaplInstance *inst1;
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_reference_val,inst1);
		{
			if(inst1!=0)
			{
				InsertInstInTree(inst1,m_item,m_doc,m_tree,m_all_items,0);
			}
		}
		MyExpand();
	}
	else if(m_doc_data.IsKindOf(m_val,m_doc->m_api.m_charact_mgr.e_aggr_val))
	{
		CaplInstance *inst;
		CaplAggr aggr0;
			m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_aggr_val,aggr0);
		for(int i=0;i<aggr0.GetSize();i++)
		{
			aggr0.GetByIndex(i,inst);
			if(inst!=0)
			{
				CaplInstance *inst1;
				m_doc_data.GetAttr(inst,m_doc->m_api.m_charact_mgr.a_apl_reference_val,inst1);
				{
					if(inst1!=0)
					{
						InsertInstInTree(inst1,m_item,m_doc,m_tree,m_all_items,0);
					}
				}
			}
		}
		MyExpand();
	}

	return true;
}


////****************************************************************

bool CaplCharacteristicTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_val,_T("item"),item);
	if(!item)
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		return FALSE;
	}
	if(!m_doc->m_api.m_charact_mgr.m_bUseVersions)
	{
		pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
	}

	if(m_rev)
	{
		if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
		{
			pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
		}
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);

		pPopup->EnableMenuItem(ID_SHOW_CHARACTERISTIC_CHANGES, MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);
	}

	if (m_pLockInfo != NULL)
	{
		pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
		pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
	}
	if(m_val!=0)
	{
		if(!m_doc_data.IsKindOf(m_val,m_doc->m_api.m_charact_mgr.e_apl_reference_value))
			 if(!m_doc_data.IsKindOf(m_val,m_doc->m_api.m_charact_mgr.e_aggr_val))
				 pPopup->EnableMenuItem(ID_EXPAND_CHARACTERISTIC, MF_BYCOMMAND | MF_GRAYED);
	}
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	//if(res==ID_SHOW_PROPERTIES) ShowProperties();
	switch(res)
	{
		case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_val); break;
		case ID_CREATE_CHARACTERISTIC_GROUP: CreateCharacteristicGroup();break;
		case ID_EXPAND_CHARACTERISTIC: 
		{
			ExpandRefItems();
		}
		break;
		case ID_DELETE :
		{
			CaplInstance *bp_ver=0,*lock=0;
			if(!m_val) return false;
			if(m_val->GetAccessmode()>aplOWN)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return false;
			}
			if(m_rev)
			{
				if(m_rev->GetAccessmode()>aplOWN)
				{
					AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
					return false;
				}
				if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDNO)			
					return false;
				m_doc->m_api.m_charact_mgr.LoadCharacteristic(m_rev);
				if(!m_doc->m_api.m_charact_mgr.DeleteCharacteristic(m_rev)) return false;
			}
			else
			{
				if(AfxMessageBox( APL_T("     ?"),MB_YESNO)==IDNO)			
					return false;
				CaplInstance *item=0;
				m_doc->m_api.m_charact_mgr.LoadCharacteristic(m_val);

				m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_item,item);
				if(!item) m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
				if(item)
				{
					if(m_doc->m_api.m_charact_mgr.m_bUseVersions && m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
					{
						if(!m_doc->m_api.m_bp_mgr.CheckMyLockAndCheckOut(item))
							return false;
						CaplBPTreeItem *parent_item=(CaplBPTreeItem*)GetParentItem(this);
						if(parent_item) parent_item->RefreshItem();

						CaplInstance *bp_lock=m_doc->m_api.m_bp_mgr.CheckMyLock(item,true);
						if(!bp_lock) return false;
					}
				}
				if(!m_doc->m_api.m_charact_mgr.DeleteCharacteristic(m_val,false,true)) return false;
			}
			/*	m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_item,item);
				if(!item) m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
				if(!item) return false;
				
				if(m_doc->m_api.m_charact_mgr.m_bUseVersions && m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
				{
					CaplInstance *bp_lock=m_doc->m_api.m_bp_mgr.CheckMyLock(item,true);
					if(!bp_lock) return false;
					lock=m_doc->m_api.m_charact_mgr.CheckMyLock(m_val,false);
					if(!lock) return false;
					m_doc_data.GetAttr(lock,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_item,bp_ver);
					if(!bp_ver) return false;
				}
						
				if(AfxMessageBox(APL_T("     ?"),MB_YESNO)==IDNO)			
					return false;
			
				if(bp_ver)
				{
					if(bp_ver->GetAccessmode()>aplOWN)
					{
						AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
						return false;
					}
					CaplAggr aggr_char_ver;
					m_doc_data.GetAttr(bp_ver,m_doc->m_api.m_bp_mgr.a_bp_ver_char_val_versions,aggr_char_ver);
					m_doc->m_api.m_charact_mgr.LoadCharacteristic(aggr_char_ver);
					bool found=false;
					for(int i=0;i<aggr_char_ver.GetSize();i++)
					{
						CaplInstance *char_val,*char_val_ver=0;
						aggr_char_ver.GetByIndex(i,char_val_ver);
						if(!char_val_ver) return false;if(char_val_ver->GetAccessmode()>aplRO) return false;
						m_doc_data.GetAttr(char_val_ver,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_char_value,char_val);
						if(char_val==m_val)
						{
							found=true;
							aggr_char_ver.Remove(i);
							m_doc_data.PutAttr(bp_ver,m_doc->m_api.m_bp_mgr.a_bp_ver_char_val_versions,aggr_char_ver);
							if(!m_doc->m_api.m_charact_mgr.DeleteCharacteristic(lock)) 
								return false;
						}
					}
					if(!found) return false;
				}
				else
				{
					if(!m_doc->m_api.m_charact_mgr.DeleteCharacteristic(m_val)) 
						return false;
				}
			}*/
			
			if(m_doc->m_api.m_charact_mgr.m_AutoSave) 
				m_doc_data.NET_SaveChanges();			
			for(int i=0;i<m_doc->m_items.Size;i++)
			{
				if(m_doc->m_items[i]!=this)
				{
					if(m_doc->m_items[i]->m_type==m_type)
					{
						CaplCharacteristicTreeItem *item1=
							(CaplCharacteristicTreeItem*)m_doc->m_items[i];
						{
							if(m_rev)
							{
								if(item1->m_rev==m_rev)
									{m_doc->m_items.Remove(i); i--;}
							}
							else
							{
								if(item1->m_val==m_val)
									{m_doc->m_items.Remove(i); i--;}
							}

						}
					}
				}
			}
			CaplTreeItem *item0=GetParentItem(this);
			if(item0) item0->RefreshItem();
			m_doc_data.NET_SaveChanges();
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;

		case ID_ITEM_CHECK_IN:CheckIn();break;
		case ID_ITEM_CHECK_OUT:CheckOut();break;
		case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
		case ID_REVISION_MAKE_ACTIVE:
		{
			if(m_doc->m_api.m_charact_mgr.MakeCharValVersionActive(m_rev))
			{
				if(m_parent_value_item)
				{
					m_parent_value_item->RefreshItem();
					m_parent_value_item->ShowAllVersion();
				}
			}
		}
		break;
		case ID_SHOW_CHARACTERISTIC_CHANGES:
		{
			m_doc->m_api.m_charact_mgr.ShowCharactChanges(m_val);
			break;
		}
		default: PrepareContextMenu(res); break;
	}
	return true;
}
//****************************************************************
void CaplCharacteristicTreeItem::ShowCmd(long cmd)
{
	switch(cmd)
	{
		case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_val); break;
		case ID_ITEM_VIEW: ShowProperties();break;
		case ID_ITEM_CHECK_IN:CheckIn();break;
		case ID_ITEM_CHECK_OUT:CheckOut();break;
		case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
		default: PrepareContextMenu(cmd);break;
	}
}
BOOL CaplCharacteristicTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	CaplInstance *item=0;
	if(m_val==0) return FALSE;
	if(m_val->GetType()==0) return FALSE;

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		if(m_val->GetAccessmode()==aplOWN) return TRUE;
		return FALSE;
	}

	m_doc_data.GetAttrBN(m_val,_T("item"),item);
	if(!item)
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		return FALSE;
	}
	if((m_rev && m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp)) || !m_doc->m_api.m_charact_mgr.m_bUseVersions)
	{
		if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return FALSE;
	}
		
	if(m_rev || !m_doc->m_api.m_charact_mgr.m_bUseVersions)
	{
		if(pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_IN)  return FALSE;
		if(pCmdUI->m_nID==ID_CREATE_CHARACTERISTIC)  return FALSE;
		if(pCmdUI->m_nID==ID_CREATE_DOC)  return FALSE;
		if(pCmdUI->m_nID==ID_SHOW_ALL_VERSION)  return FALSE;
	}
	if(pCmdUI->m_nID==ID_SHOW_ALL_VERSION)
	{
		pCmdUI->Enable(TRUE); return TRUE;
	}

	if (m_pLockInfo)
	{
		if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return FALSE;
	}
	else
	{
		if(pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_IN)  return FALSE;
	}
	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
	case ID_SHOW_ALL_VERSION:
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
//	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
//	case ID_SHOW_ALL_VERSION:
//	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_ITEM_VIEW:
	case ID_ITEM_CHECK_OUT:
	case ID_ITEM_CHECK_IN:
	case ID_ITEM_UNDO_CHECK_OUT:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplCharacteristicTreeItem::GetName(CString &name)
{
	name=_T("Characteristic");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if(m_rev)
		return m_doc->m_api.GetItemName(m_rev, name);
	else
		return m_doc->m_api.GetItemName(m_val, name);
	return true;

/*
	CaplInstance *inst=0,*m_unit=0,*m_type=0;
	CString buf,buf1;
	CaplInstance *ver=m_rev;
	if(!ver) ver=m_doc->m_api.m_charact_mgr.CheckMyLock(m_val,false);
			
	if(ver)
	{
		if(ver->GetAccessmode()>aplRO) { name=APL_T(" ( )");return true;}
		m_doc_data.GetAttr(ver,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_charact,inst);
		m_doc_data.GetAttr(ver,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_type,m_type);
	}
	else
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_charact,inst);
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_type,m_type);
	}
	if(inst!=0) m_doc_data.GetAttrBN(inst,S::name,name);
	if(m_type!=0) m_doc_data.GetAttrBN(m_type,S::name,buf);
	if(buf!=_T("")) {name+=_T(" ("); name+=buf;name+=_T(")"); }
	if(inst!=0) m_doc_data.GetAttrBN(inst,_T("unit"),m_unit);
	if(m_rev) 
	{
		if(m_rev->GetAccessmode()<aplNO)
		{
			CString ver_num=_T("");
			m_doc_data.GetAttr(m_rev,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_version_num,ver_num);
			name=ver_num+_T(" : ")+name;
		}
	}
	
	if(m_doc->m_api.m_show.m_charact_value)
	{
		name+=_T(" = ");
		//  
		if(ver)
			m_doc->m_api.m_charact_mgr.PrintCharacteristicValue(ver,m_unit,buf);
		else
			m_doc->m_api.m_charact_mgr.PrintCharacteristicValue(m_val,m_unit,buf);
		if(buf!=_T(""))	name+=buf;
		else name+=APL_T(" ( )");
	}
	return true;
*/
}
//****************************************************************
void CaplCharacteristicTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_rev){if(m_rev->GetType()!=0)ext.Add(m_rev);}
	else if(m_val!=0){if(m_val->GetType()!=0)ext.Add(m_val);}
}
void CaplCharacteristicTreeItem::GetMainInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_rev)ext.Add(m_rev);
	else if(m_val!=0)ext.Add(m_val);
}
//****************************************************************
bool CaplCharacteristicTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	InsetItem(buf,ICON_CHARACTERISTIC,parent_item);
	RefreshItem();
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}

//****************************************************************
bool CaplCharacteristicTreeItem::RefreshItem()
{
	CString name,buf,buf1;
	UINT ico=0;
	ico=ICON_CHARACTERISTIC;
	if(m_tree==0) return false;
	if(m_val==0) return false;
	if(m_val->GetType()==0)
	{
//		m_doc->m_items.Remove(m_doc->m_items.Find(this));
		GetName(name);
		m_tree->SetItemText(m_item,name);
		m_tree->RedrawWindow();
		return false;
	}
	
	CaplInstance *lock=0;
	if(m_doc->m_api.m_charact_mgr.m_bUseVersions)
		m_pLockInfo=m_doc->m_api.m_charact_mgr.GetLock(m_val,false);

	ico = m_doc->m_api.GetInstIco(m_val);

	if(m_rev)
	{
		ico = m_doc->m_api.GetInstIco(m_rev);
		CaplInstance *act=0;
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_act_ver,act);
		SetItemImage(ICO_REL_VER, IDX_IL_TREE_REL_TYPE);
		if(m_rev==act)
			SetItemImage(ICO_REL_ACTIVE_VER, IDX_IL_TREE_REL_TYPE);

	}
	GetName(name);

	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_tree->SetItemText(m_item,name);
	
	Sort();
	m_tree->RedrawWindow();

	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}
//****************************************************************
void CaplCharacteristicTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	CaplInstance *val=m_val;
	if(m_rev) val=m_rev;
	if(m_doc->m_api.m_charact_mgr.ShowProperties(val) && !m_rev) 
	{
		CaplInstance *item=0;
		m_doc_data.GetAttrBN(m_val,_T("item"),item);
		if(!item) m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		if(item)
		{
			if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp) && m_tree)
			{
				CaplTreeItem *p_item=GetParentItem(this);
				if(p_item) 
				{
					if(p_item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
						p_item=GetParentItem(p_item);
					if(p_item)
					{
						if(p_item->m_type==APL_TREE_ITEM_BP)
						{
							CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
							bp_item->Expand(1);
							//bp_item->Expand(2);	  ..  - -   ""
							// .   MessageBox'  ,   -  
							bp_item->RefreshAllThisBPItem();
							bp_item->ShowAllCharacteristic();
						}
					}
				}
			}
			else
			{
				RefreshItem();
				if(m_has_version) ShowAllVersion();
			}

		}
	}
}
//****************************************************************
bool CaplCharacteristicTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	if(m_doc==0)return false;
	if(m_doc->m_BShowInListCtrl==false) return true;
	CHECK_SHOW_LIST_CTRL(m_val);

	CaplInstance *inst,*unit= NULL,*type=0;
	CString buf,buf1,buf2;
	int i,pos=0;

	if(m_val->GetAccessmode()>aplRO) 
	{
		buf= APL_T("( )");
		i=list->InsertItem(0,_T(""));
		list->SetItemText(i,0,buf);
		return false;
	}
	CaplInstance *val=m_val;
	CaplInstance *ver=m_rev;

	if(!ver) ver=m_doc->m_api.m_charact_mgr.CheckMyLock(m_val,false);
	if(ver) 
	{
		if(!ver->GetType())
		{
//			m_doc->m_items.Remove(m_doc->m_items.Find(this));
			i=list->InsertItem(pos++, APL_T(":"));
			list->SetItemText(i,1, APL_T("   !!"));
			RefreshItem();
			return false;
		}	
		val=ver;
	}
	
	m_doc_data.GetAttrBN(val,_T("characteristic"),inst);
	if(inst!=0) m_doc_data.GetAttrBN(inst,S::name,buf);
	
	i=list->InsertItem(pos++, APL_T(":"));
	list->SetItemText(i,1,buf);

	if(inst!=0) m_doc_data.GetAttrBN(inst, _T("unit"), unit);

	m_doc->m_api.m_charact_mgr.PrintCharacteristicValue(val,unit,buf);

	i=list->InsertItem(pos++, APL_T(":"));
	list->SetItemText(i,1,buf);

	i=list->InsertItem(pos++, APL_T(" :"));
	m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_type,type);
	if(type!=0){
		m_doc_data.GetAttr(type,m_doc->m_api.m_charact_mgr.a_apl_charact_type_name,buf);
		list->SetItemText(i,1,buf);
	}

	list->InsertItem(pos++,_T(""));
	i=list->InsertItem(pos++, APL_T(":"));
	GetAccessName(val,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(pos++,_T(""));
	if(m_rev!=0)
	{
		buf1=_T("");
		CaplInstance *user=0,*po=0;
		m_doc_data.GetAttr(m_rev,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_author,user);
		if(user!=0)
		{
			i=list->InsertItem(pos++, APL_T(":"));
			m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_po,po);
			if(po==0) m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_name,buf1);
			//else m_doc->m_api.m_appr_mgr.GetPersonName(po,buf1);
			else m_doc->m_api.GetItemName(po,buf1);
			list->SetItemText(i,1,buf1);
		}

		//m_doc_data.GetAttr(m_rev,m_doc->m_api.m_bp_mgr.a_bp_ver_basis,buf1);
		//i=list->InsertItem(11,APL_T(":"));
		//list->SetItemText(i,1,buf1);
		
		m_doc_data.GetAttr(m_rev,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_start_date,buf1);
		if(buf1!=_T(""))
		{
			i=list->InsertItem(pos++, APL_T(" :"));
			COleDateTime odt;
			aplString2Date(buf1,odt);	
			buf1=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf1);
		}
		m_doc_data.GetAttr(m_rev,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_end_date,buf1);
		if(buf1!=_T(""))
		{
			i=list->InsertItem(pos++, APL_T(" :"));
			COleDateTime odt;
			aplString2Date(buf1,odt);	
			buf1=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf1);
		}
	}
	else if(m_pLockInfo!=0 && m_pLockInfo->GetType()!=0)
	{
		buf1=_T("");
		CaplInstance *user=0,*po=0;
		m_doc_data.GetAttr(m_pLockInfo,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_author,user);
		if(user!=0)
		{
			i=list->InsertItem(pos++, APL_T(":"));
			m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_po,po);
			if(po==0) m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_name,buf1);
			//else m_doc->m_api.m_appr_mgr.GetPersonName(po,buf1);
			else m_doc->m_api.GetItemName(po,buf1);
			list->SetItemText(i,1,buf1);
		}
		
		m_doc_data.GetAttr(m_pLockInfo,m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_start_date,buf1);
		if(buf1!=_T(""))
		{
			i=list->InsertItem(pos++, APL_T(" :"));
			COleDateTime odt;
			aplString2Date(buf1,odt);	
			buf1=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf1);
		}
	}

	aplExtent ext;
	CStringArray comment;
	if(m_val!=0){
		comment.Add( APL_T(" ")); ext.Add(m_val);
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_charact,inst);
		if(inst!=0){comment.Add( APL_T("")); ext.Add(inst);}
		m_doc_data.GetAttr(inst,m_doc->m_api.m_charact_mgr.a_apl_charact_unit,unit);
		if(unit!=0){comment.Add( APL_T(" ")); ext.Add(unit);}
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_type,type);
		if(type!=0){comment.Add( APL_T(" ")); ext.Add(type);}
	}
	if(m_rev!=0){ comment.Add( APL_T("")); ext.Add(m_rev);}
	if(m_bp_rev!=0){ comment.Add( APL_T(" ")); ext.Add(m_bp_rev);}
	if(m_pLockInfo!=0){ comment.Add( APL_T("")); ext.Add(m_pLockInfo);}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}
//****************************************************************
void CaplCharacteristicTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *new_val=0;

	if(val==0) return ;
	if(val->GetType()==0) return ;
	if(val->GetAccessmode()>=aplRO)
	{
		aplErrorMessage(S::NoAccessRight(),val);
		return ;
	}
	CaplInstance *val1=0;
	if(m_val!=val) val1=val;

	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(m_val,val1, &new_val,0,0,true))
	{
		/*
		if(CaplTreeItem::m_AutoUzurpireCharacteristic)
		{
			aplExtent ext; ext.Add(new_val);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}*/

		CaplCharacteristicTreeItem *characteristic_item=
			new CaplCharacteristicTreeItem(m_tree,m_doc,new_val);
		characteristic_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(new_val);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}

//****************************************************************
bool CaplCharacteristicTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
	if (item->m_type != APL_TREE_ITEM_CHARACTERISTICGROUP)
		if (item->m_type != APL_TREE_ITEM_DOCUMENT)
			return false;

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	if ((item->m_type == APL_TREE_ITEM_CHARACTERISTIC)||(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP))
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	if (item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		CString state;
		m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
		if(state==_T("canceled")) return false;
		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
	}
	
	if(pPopup!=0)
	{
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
		if(parent_item && parent_item->m_type==APL_TREE_ITEM_QUERY)
		{
			pPopup->EnableMenuItem(ID_DOCUMENT_MOVE, MF_BYCOMMAND|MF_GRAYED);
		}

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}
		}
		else if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
				
			HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
			CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
			aplAccessModeType access =aplOWN;
			if(Item)
			{
				aplExtent instances;
				Item->GetAccessedInstances(instances);
				if(instances.GetSize()>0)
					access = instances.GetAt(0)->GetAccessmode();
			}
			
			if(m_val->GetAccessmode()>aplRW || access>aplRO)
			{
				AfxMessageBox( APL_T("   "));
				return false;
			}
			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_val))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		else if(res == ID_DOCUMENT_BYDOT)
		{
			CaplInstance *inst = m_val;
			CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
				
			aplExtent instances;
			GetAccessedInstances(instances);
			if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		// 
		else if(res == ID_DOCUMENT_MOVE)
		{
			CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
			HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
			CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
			
			CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
		}
	}
	m_tree->RedrawWindow();
	return true;
}
//****************************************************************
void CaplCharacteristicTreeItem::CreateCharacteristicGroup(CaplInstance *group)
{
	CaplInstance *group_new=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristicGroup(m_val,&group_new,group))
	{
		if(group!=0)
		{
			/*
			if(CaplTreeItem::m_AutoUzurpireCharacteristic)
			{
				aplExtent ext; ext.Add(group);
				m_doc_data.NET_BecomeInstancesOwner(&ext);
			}*/

		}
		CaplCharacteristicGroupTreeItem *characteristic_group_item=
			new CaplCharacteristicGroupTreeItem(m_tree,m_doc,group_new);
		characteristic_group_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(group_new);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}
//****************************************************************
bool CaplCharacteristicTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	_APL_TREE_ITEM_CHEK_PARAM
	if(action==TVE_EXPAND)
	{
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}

		ExpandRefItems();

			bool old = m_bShowNoFoundMessage;
			m_bShowNoFoundMessage = old;
			m_ExecMyExpand = true;
			if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_DOC)
				ShowAllDocs(false,false);
			if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_CHARACT)
				ShowAllCharacteristic(false);
			if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_APPROVAL)
				ShowAllApproval(false);
			if(m_doc->m_auto_expand_items.m_showintree_charact&APL_SHOW_VER)
				ShowAllVersion(false);
			m_bShowNoFoundMessage = old;
			m_ExecMyExpand = true;
		
/*		if(m_expanded) return true;
		if(m_hasSubItem)Expand(1);
		if(m_bShowNoFoundMessage) m_tree->SetRedraw(FALSE);
		ExpandSubCategory();
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		m_expanded=true;
		CaplAggr aggr;
		CaplInstance *inst;
		if(m_instance!=0)
		{
			if(m_doc_data.IsKindOfBN(m_instance,S::prd_rel_prd_cat))
			{

				if(m_doc_data.IsConnected())
				{
					if(m_instance->id!=0)
					{
						//   
						CArray<apl_NET_LoadQuery,  apl_NET_LoadQuery &> m_aplQuery;
						CaplAttr *attr;
						long laplError;
						SetStatusString(APL_T("  "));
						StartBusy();
						attr=m_doc_data.GetAttrDefinition(m_instance->type,S::products);
						if(attr!=0) {apl_NET_LoadQuery q={1, _T('i'), m_instance->id, 0, attr->id, true,false}; m_aplQuery.Add(q);}

						attr=m_doc_data.GetAttrDefinitionBN(S::product,S::id);
						if(attr!=0) {apl_NET_LoadQuery q={2, _T('d'), 1, 0, attr->id, true,false}; m_aplQuery.Add(q);}

						attr=m_doc_data.GetAttrDefinitionBN(S::product,S::name);
						if(attr!=0) {apl_NET_LoadQuery q={3, _T('d'), 1, 0, attr->id, true,false}; m_aplQuery.Add(q);}

						if (!m_doc_data.NET_Load( m_aplQuery.GetData(),m_aplQuery.GetSize()))
						{
							StopBusy();
							AfxMessageBox(IDS_ERROR_LOAD_DATA_APL);
						}
						StopBusy();
						SetStatusString(_T(""));
					}
				}				
				m_doc_data.GetAttrBN(m_instance,S::products,aggr);
				for(int i=0;i<aggr.GetSize();i++)
				{
					aggr.GetByIndex(i,inst);
					if(inst!=0)	AddProductToCategory(inst);
				}
			}
		}
		RefreshItem();
		if(m_bShowNoFoundMessage) m_tree->SetRedraw(TRUE);*/
	}
	else if(action==TVE_COLLAPSE)
	{
		if(m_rev) return true;
		HideAllVersion();
		CollapseItem(true);
		m_all_items.Clear();
		m_parent_value_item=0;
	}
	return true;
}

//****************************************************************
void CaplCharacteristicTreeItem::ShowAllVersion(bool showMsg)
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	if(m_val==0) return;
	if(m_val->GetAccessmode()>aplRO) return;
	if(m_rev) return;
	if(m_has_version) HideAllVersion();

	aplExtent ext_rev,top_rev;
	int i;
	StartBusy();
	//   
	SetStatusString( APL_T("  "));
	
	m_doc->m_api.m_charact_mgr.LoadCharacteristic(m_val);
	m_doc->m_api.m_charact_mgr.GetAllCharactVersion(m_val,ext_rev);
	
	CaplInstance *lock=m_doc->m_api.m_charact_mgr.GetLock(m_val,false);

	SetStatusString(_T(""));
	StopBusy();
	if(ext_rev.Size<=0 && showMsg) {AfxMessageBox( APL_T("  !")); return;}
	//  
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(FALSE);

	//   
	CaplInstance *inst=0;
	for(i=0;i<ext_rev.Size;i++)
	{
		if(ext_rev[i]==0) continue;
		if(ext_rev[i]->GetType()==0) continue;
		bool flag=false;
		
		if(ext_rev[i]==lock) //    
		{
			ext_rev.Remove(i);
			i--;
		}
		if(i<0) continue;
		m_doc_data.GetAttr(ext_rev[i],m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_base,inst);
		if(inst==0) top_rev.Add(ext_rev[i]);
		else if(inst->GetAccessmode()>aplRO) top_rev.Add(ext_rev[i]);

	}
	//  
	for(i=0;i<top_rev.Size;i++)
	{
//		if(-1!=m_all_version.Find(top_rev[i])) continue;

		CaplCharacteristicTreeItem *char_item=
			new CaplCharacteristicTreeItem(m_tree, m_doc, m_val);
		char_item->CreateTreeItem(m_item);
		char_item->m_rev=top_rev[i];
		char_item->m_parent_value_item=this;
		m_all_version.Add(top_rev[i]);
		char_item->RefreshItem();
		char_item->InsertRevisionInTree(ext_rev,this);
		m_has_version=true;
		m_tree->Expand(char_item->m_item,TVE_EXPAND);

	}
	
	m_has_version=true;
	MyExpand();

	StopBusy();
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(TRUE);
	m_tree->Select(m_item,TVGN_FIRSTVISIBLE);
}

//****************************************************************
void CaplCharacteristicTreeItem::InsertRevisionInTree(aplExtent &ext_rev,CaplCharacteristicTreeItem *parent_value_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	//  
	CaplInstance *inst=0;
	//m_pDocItem=docitem;
	bool b=false;
	for(int i=0;i<ext_rev.GetSize();i++)
	{

		if(ext_rev[i]==0) continue;
		if(ext_rev[i]->GetType()==0) continue;

		m_doc_data.GetAttr(ext_rev[i],m_doc->m_api.m_charact_mgr.a_apl_charact_val_ver_base,inst);
		if(inst==m_rev)
		{
			b=true;
			CaplCharacteristicTreeItem *char_item=
				new CaplCharacteristicTreeItem(m_tree, m_doc, m_val);
			char_item->CreateTreeItem(m_item);
			char_item->m_rev=ext_rev[i];
			char_item->m_parent_value_item=parent_value_item;
			m_all_version.Add(ext_rev[i]);
			char_item->RefreshItem();	
			char_item->InsertRevisionInTree(ext_rev,parent_value_item);
		}
	}
	if(b) { Sort();m_tree->Expand(m_item,TVE_EXPAND);}
}

void CaplCharacteristicTreeItem::CheckOut()
{

	CaplInstance *lock=m_doc->m_api.m_charact_mgr.GetLock(m_val,false);
	if(lock) return;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_val,_T("item"),item);
	if(!item)
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		return;
	}
	if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
	{
		if(m_rev) return;
		if(m_doc->m_api.m_bp_mgr.CheckOutWithRequest(item))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
					p_item=GetParentItem(p_item);
				if(p_item)
				{
					if(p_item->m_type==APL_TREE_ITEM_BP)
					{
						CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
						bool has_version=bp_item->m_has_version;
						bp_item->Expand(1);
						bp_item->m_has_version=has_version;
						bp_item->Expand(2);
						bp_item->RefreshItem();
						bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
						bp_item->ShowAllCharacteristic();
						m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
					}
				}
			}
		}
	}	
	
#ifdef _DEBUG
//++
	else
		if (m_doc_data.IsKindOf(item,m_doc->m_api.m_doc_mgr.e_doc))
		{
		
			CaplDocTreeItem *p_item=(CaplDocTreeItem*)GetParentItem(this);
			p_item->CheckOut();
		}

#endif

	else 
	{
		CaplInstance *val=m_val;
		if(m_rev) val=m_rev;
		if(m_doc->m_api.m_charact_mgr.CheckOut(val)) 
		{
			if(m_rev)
			{
				if(m_parent_value_item) 
				{
					CaplCharacteristicTreeItem *c_item=m_parent_value_item;
					c_item->Expand(1);
					c_item->Expand(2);
					c_item->RefreshItem();
					c_item->ShowAllVersion();
				}
			}
			else
			{
				RefreshItem();
				if(m_has_version) ShowAllVersion();
			}
		}
	}
}
void CaplCharacteristicTreeItem::CheckIn()
{
	CaplInstance *lock=m_doc->m_api.m_charact_mgr.GetLock(m_val,false);
	if(!lock) return;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_val,_T("item"),item);
	if(!item)
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		return;
	}
	if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
	{
		if(m_doc->m_api.m_bp_mgr.CheckInWithRequest(item))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
					p_item=GetParentItem(p_item);
				if(p_item)
				{
					if(p_item->m_type==APL_TREE_ITEM_BP)
					{
						CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
						bool has_version=bp_item->m_has_version;
						bp_item->Expand(1);
						bp_item->m_has_version=has_version;
						bp_item->Expand(2);
						bp_item->RefreshItem();
						bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
						bp_item->ShowAllCharacteristic();
						m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
					}
				}
			}
		}
	}
#ifdef _DEBUG
	//++
	else
		if (m_doc_data.IsKindOf(item,m_doc->m_api.m_doc_mgr.e_doc))
		{

			CaplDocTreeItem *p_item=(CaplDocTreeItem*)GetParentItem(this);
			p_item->CheckIn();
		}
#endif

	else if(m_doc->m_api.m_charact_mgr.CheckIn(m_val))
	{
		RefreshItem();
		if(m_has_version) ShowAllVersion();
	}

}
void CaplCharacteristicTreeItem::UndoCheckOut()
{
	CaplInstance *lock=m_doc->m_api.m_charact_mgr.GetLock(m_val,false);
	if(!lock) return;
	CaplInstance *item=0;
	m_doc_data.GetAttrBN(m_val,_T("item"),item);
	if(!item)
	{
		m_doc_data.GetAttr(m_val,m_doc->m_api.m_charact_mgr.a_apl_charact_val_base_item,item);
		return;
	}
	if(m_doc_data.IsKindOf(item,m_doc->m_api.m_bp_mgr.e_bp))
	{
		if(m_doc->m_api.m_bp_mgr.UndoCheckOutWithRequest(item))
		{
			CaplTreeItem *p_item=GetParentItem(this);
			if(p_item) 
			{
				if(p_item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
					p_item=GetParentItem(p_item);
				if(p_item)
				{
					if(p_item->m_type==APL_TREE_ITEM_BP)
					{
						CaplBPTreeItem *bp_item=(CaplBPTreeItem*)p_item;
						bool has_version=bp_item->m_has_version;
						bp_item->Expand(1);
						bp_item->m_has_version=has_version;
						bp_item->Expand(2);
						bp_item->RefreshItem();
						bool old_m_bShowNoFoundMessage=m_bShowNoFoundMessage;m_bShowNoFoundMessage=false;
						bp_item->ShowAllCharacteristic();
						m_bShowNoFoundMessage=old_m_bShowNoFoundMessage;
					}
				}
			}
		}
	}	
	#ifdef _DEBUG

//++

	else
		if (m_doc_data.IsKindOf(item,m_doc->m_api.m_doc_mgr.e_doc))
		{

			CaplDocTreeItem *p_item=(CaplDocTreeItem*)GetParentItem(this);
			p_item->UndoCheckOut();
		}




#endif
	else if(m_doc->m_api.m_charact_mgr.UndoCheckOut(m_val))
	{
		RefreshItem();
		if(m_has_version) ShowAllVersion();
	}
}

void CaplCharacteristicTreeItem::HideAllVersion()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID

	int i;
	m_tree->SetRedraw(FALSE);
	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]->m_type==APL_TREE_ITEM_CHARACTERISTIC)
		{
			CaplCharacteristicTreeItem *item=(CaplCharacteristicTreeItem*)m_doc->m_items[i];
			if(item->m_parent_value_item==this) {m_doc->m_items.Remove(i); i--;}
		}
	}
	m_tree->SetRedraw(TRUE);
	m_has_version=false;
}