// aplTreeItem.h

#include <apl_gui.h>
#include "aplRecurseFindDlg.h"

#ifndef APL_TREE_ITEM
#define APL_TREE_ITEM

#define _APL_TREE_ITEM_CHEK_PARAM_BOOL \
        if(m_tree==0) return false;\
        if(m_doc==0) return false;

#define _APL_TREE_ITEM_CHEK_PARAM_VOID \
        if(m_tree==0) return;\
        if(m_doc==0) return;

#define CHECK_GET_NAME(inst) name=_T("???");\
	if(inst==0){name= APL_T("<  >");return false;}\
	if(inst->GetType()==0){name= APL_T("< >");return false;}\
	if(inst->GetAccessmode()>aplRO){name = _T("<   >");return true;}

#define CHECK_INSTANCE_ITEM_B(inst) \
	if(inst==0){RefreshItem();return false;}\
	if(inst->GetType()==0){RefreshItem();return false;}\
	if(inst->GetAccessmode()>aplRO){RefreshItem();return true;}

#define CHECK_INSTANCE_ITEM(inst) \
	if(inst==0){RefreshItem();return;}\
	if(inst->GetType()==0){RefreshItem();return;}\
	if(inst->GetAccessmode()>aplRO){RefreshItem();return;}


#define CHECK_SHOW_LIST_CTRL(inst) if (inst == 0){int i = list->InsertItem(list->GetItemCount(), APL_T(":"));\
	list->SetItemText(i, 1,APL_T(" .   "));return false;}\
	if (inst->GetType() == 0){int i = list->InsertItem(list->GetItemCount(), APL_T(":"));\
	list->SetItemText(i, 1,APL_T("  .   "));return false;}

#define CHECK_SHOW_LIST_CTRL_TOP(inst,name) if (inst == 0){int i = list->InsertItem(list->GetItemCount(), APL_T(":"));\
	list->SetItemText(i, 1,name);return true;}\
	if (inst->GetType() == 0){int i = list->InsertItem(list->GetItemCount(), APL_T(":"));\
	list->SetItemText(i, 1,APL_T("  .   "));return false;}


//////////////////////////////////////////////////////////////////////////////////////////////
//                                 definies                         //
//////////////////////////////////////////////////////////////////////////////////////////////
/*   apl_gui.h
#define IDX_IL_TREE_REL_TYPE 0
#define IDX_IL_TREE_EFF 1
#define IDX_IL_TREE_ITEM 2
#define IDX_IL_TREE_STATE 3
#define IDX_IL_TREE_OBJ_STATE 4
*/

#define ICO_REL_VER			1
#define ICO_REL_MATER		2
#define ICO_REL_MAKE		3
#define ICO_REL_ALTERNATE	4
#define ICO_REL_SUPLIED		5
#define ICO_REL_WHERE_USED	6
#define ICO_REL_ACTIVE_VER	7
#define ICO_REL_ICO1		8
#define ICO_REL_K			9
#define ICO_REL_I			10
#define ICO_REL_B			11
#define ICO_REL_DEPEND		12

#define ICO_EFF_NO			0
#define ICO_EFF_EFF			1
#define ICO_EFF_CON			2
#define ICO_EFF_EFFCON		3
#define ICO_EFF_NOT_USED	7

#define APLICM_NORMALE		1
#define APLICM_INSERT		2
#define APLICM_DELETE		3
#define APLICM_REFERENCES	4
/////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                     //
//////////////////////////////////////////////////////////////////////////////////////////////


class CPSMDoc;
class CMyOleDataSource;

extern bool bShowMultiIcon;

class CaplTreeItem : public CaplTreeItemData
{
        //Attributes
public:
    HTREEITEM m_fictive_item;
    CString m_type;
    CPSMDoc *m_doc;
	static bool m_bShowNoFoundMessage;
	static int m_num_doc_4_group; 

	bool m_bWOForNote; //  ()  " "

	aplExtent m_all_approval;
	aplExtent m_all_caracteristic;
	aplExtent m_all_documents;
	aplExtent m_all_version;
	aplExtent m_all_projects;
	aplExtent m_all_bp_inst;
	aplExtent m_all_bp;
	aplExtent m_all_refusal;

	aplExtent m_contents;

protected:
    int m_hasSubItem;
	bool m_expanded;
	bool m_expanding;
	bool m_PropertiesLoaded;
	bool m_ShowContentsOnExpand;
	bool m_ExecMyExpand;
	bool m_addInCall; 

public:		
	static bool m_def_context_menu;
	static bool m_LbDblClick_Open;
	static CaplRecurseFindDlg m_dlg;

	
	virtual void Sort(bool bRefreshParent=false);

	bool IsExpandet(){return m_expanded;};
	void CollapseItem(bool bInsertFictive=true);
    // Methods
public:
	virtual DWORD GetAddInType();
	bool CreateNote();
	void ShowNotes();
	CaplTreeItem* GetParentItem(CaplTreeItem* item);
 	void UpdateMenu(CMenu** menu, UINT view_mode);
    CaplTreeItem();
    virtual ~CaplTreeItem();

	void MyExpand(bool ShowContents=true);
	void RemoveFromParenContents(CaplInstance *inst);
	virtual void ShowCmd(long cmd){}; 
	virtual BOOL ShowToolBarButton(CCmdUI* pCmdUI){return FALSE;}; 

    virtual bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE){return true;};
    virtual bool GetName(CString &name){name=_T("?"); return true;};
    virtual bool CreateTreeItem(HTREEITEM parent_item){return true;};
//    virtual bool RefreshItem(){return true;};
//    virtual bool Expand(UINT action){return true;};
    virtual bool ShowInListCtrl(CListCtrl *list){return true;};
	void ShowInstanceInfoInListCtrl(aplExtent &ext, CListCtrl *list,CStringArray *comment=0);
	virtual void ShowProperties(){};
	virtual void ShowAllVersion(bool showMsg = true){};
	virtual void LoadProperties(){};

	virtual bool PasteItem(CaplTreeItem *item, CPoint *point=0){return false;};
	virtual bool PasteFile(LPCTSTR file, CPoint *point=0){return false;};

	virtual void GetAccessedInstances(aplExtent &ext);
	virtual void GetMainInstances(aplExtent &ext){GetAccessedInstances(ext);};
	void FrezeInstances();
	void SetInstancesAccess();
	void SetInstancesAccessRecursive();
	void SetAccessFromPattern(CString &pattern);
	void SetInstancesOwner();
	void PrepareContextMenu(int command);

	void ShowContainedFolder(CaplInstance *inst,bool showMsg = true);
	void ShowContainedClassifier(CaplInstance *inst,bool showMsg = true);
	void ShowContainedProccess(CaplInstance *inst,bool showMsg = true);
	void ShowContainedProjects(CaplInstance *inst,bool showMsg = true);

	void FindContainedMessage(CaplInstance *inst, aplExtent &ext_msg);
	void ShowContainedMessage(CaplInstance *inst,bool showMsg = true);
	void ShowContainedTasks(CaplInstance *inst,bool showMsg = true);
	void ShowContainedAlert(CaplInstance *inst,bool showMsg = true);

	void ShowAllApproval(bool showMsg, aplExtent *ext_approval=0); //  ext_approval   approval   
    virtual	void ShowAllCharacteristic(bool  showMsg);
	virtual void ShowAllDocs(bool bExpand=true, bool showMsg = true);
	void ShowDocsInVirtualFolders(aplExtent &ext_doc_rel);
	void ShowAllProjects(CaplInstance *inst,bool showMsg = true);
	void ShowAllBPInst(CaplInstance *inst, bool showMsg);
	void ShowAllBPs(CaplInstance *inst, bool showMsg = true);
	void ShowAllResusal(bool bExpand=true, bool showMsg = true);

	void CreateApproval();
	virtual void CreateDoc(CaplInstance *inst_for_id=0, LPCTSTR file_name=0);

	void ExpandAll(int &level, bool showdlg=true, CWinThread *par_trd=0,  BOOL contents=true, BOOL doc=true, BOOL appr=TRUE, 
			               BOOL charact=TRUE, BOOL material=true, BOOL lot=TRUE, BOOL prdinst=TRUE, BOOL act=TRUE, BOOL res=TRUE,BOOL subst=TRUE, BOOL req=TRUE);

	virtual void CopyDataToDataSource(CMyOleDataSource *pSource){};
	virtual bool RefreshItem(){return true;};
	bool RefreshAllChildItem();

    static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);

	//  inst   contents        -  false
	static bool InsertInstInTree(CaplInstance *inst, HTREEITEM item, CPSMDoc *doc, CTreeCtrl *tree,	aplExtent &contents, CaplInstance *folder=0, CaplTreeItem **result_item=0,CaplInstance *classifier=0, bool bShowNoteIcon= false);

//	CArray<CMenu*, CMenu*> m_sub_menu;
	void AppendAddIn(CMenu* popupMenu);
	//void AppendForms(CMenu* popupMenu);     . 
	void AppendAccessPattern(CMenu* popupMenu);

	void GetInstID(CaplInstance *inst,CString &str_id,CString *str_name=0);
	void CreateCharacteristic(CaplInstance *inst,CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *inst,CaplInstance *group=0);
	CaplInstance *GetItemInstance(CaplTreeItem *item);
};

#endif
