// apl_prd_inst_item.h


#include "aplTreeItem.h"
 
class CaplPrdInstTreeItem: public CaplTreeItem
{
        //Attributes
public:
	CaplInstance *m_inst;
	CaplInstance *m_prd_inst_rel;
	CaplInstance *m_used_inst_rel;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_lot;
	CaplInstance *m_project;

	aplExtent m_all_prd_instances;
	aplExtent m_all_parent;
	aplExtent m_all_parent_bps;

	CaplPrdInstTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *inst=0);
	~CaplPrdInstTreeItem(){RemoveFromParenContents(m_inst);}

    bool CreateTreeItem(HTREEITEM parent_item); 
	bool GetName(CString &name);
    bool RefreshItem();
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool Expand(UINT action);
	bool PasteItem(CaplTreeItem *item, CPoint *point);
	bool PasteFile(LPCTSTR file, CPoint *point);
	void RemoveFromCategory();
	void RemoveRelation();

	void CreateBP();
	void CreateBPInst();
	void CreateBPCopy(CaplInstance *base_bp);
	void CreateBPInstCopy(CaplInstance *base_bp_inst);
	void CreateProject();
	void CreateRefusal();

	void ShowAllBPs(bool showMsg = true);
	void ShowAllBPInst(bool showMsg = true);
	void ShowAllUsesBP();

	void ShowProperties();
	bool ShowInListCtrl(CListCtrl *list);
 	void GetAccessedInstances(aplExtent &ext);

	void CreateCharacteristic(CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *group=0);
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
};

