#if !defined(AFX_PACKETDLG_H__74CF2F00_0E70_47A2_9558_B5BD63817BBB__INCLUDED_)
#define AFX_PACKETDLG_H__74CF2F00_0E70_47A2_9558_B5BD63817BBB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// PacketDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CPacketDlg dialog
#include "aplPacketMgr.h"
#include "resource.h"

class CPacketDlg : public CaplTranslateDialog
{
// Construction
private:
	class CDataSetTreeItem : public CaplTreeItemData
	{
	protected:
		CaplAPI					*m_api;
		CaplPacketMgr			*m_packet_mgr;
		bool					m_bExpanded;
		bool					m_bIsFolder;
		CaplTAggr<CDataSetTreeItem*, CDataSetTreeItem*, APLAGGR_LIST_OR_AUTOKILLREF>	*m_pItemsArray;
		HTREEITEM				m_fictive_item;

	public:
		CDataSetTreeItem(CaplAPI *api, CTreeCtrl *pTree, CaplTAggr<CDataSetTreeItem*, CDataSetTreeItem*, APLAGGR_LIST_OR_AUTOKILLREF> *pItemsArray, CaplInstance* inst);
		CDataSetTreeItem(CaplAPI *api, CTreeCtrl *pTree, CaplTAggr<CDataSetTreeItem*, CDataSetTreeItem*, APLAGGR_LIST_OR_AUTOKILLREF> *pItemsArray, CDataSet* pDataSet);
		virtual ~CDataSetTreeItem();

		//{{Virtual functions
		virtual bool CreateItem(HTREEITEM htParent = TVI_ROOT);
		virtual bool Expand(UINT action);
		virtual bool GetName(CString &name, int &ico);
		virtual bool RefreshItem();
		virtual BOOL ShowContextMenu(CPoint pt, CWnd *pWnd);
		//}}Virtual functions
		
		bool CollapseItems();
		void Sort();
		static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);
		static void Sort(CTreeCtrl* tree);

		//members
		CaplInstance	*m_inst;
		CDataSet		*m_pDataSet;
	};

	CaplTAggr<CDataSetTreeItem*, CDataSetTreeItem*, APLAGGR_LIST_OR_AUTOKILLREF> m_ItemsArray;
protected:
	CaplAPI			*m_api;
	CaplPacketMgr	*m_packet_mgr;

public:
	CPacketDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor

	CaplPacket		*m_pPacket;
	CaplInstance	*m_inst;
	CaplInstance	*m_Provider;
	CaplInstance	*m_Registrator;
	CaplInstance	*m_Unpacker;
	CaplInstance	*m_Sender;

	bool			m_bOut;

// Dialog Data
	//{{AFX_DATA(CPacketDlg)
	enum { IDD = IDD_PACKET_DLG };
	CTreeCtrl	m_TreeCtrl;
	CDateTimeCtrl	m_dtSendCtrl;
	CDateTimeCtrl	m_dtUnpackCtrl;
	CDateTimeCtrl	m_dtRegistrCtrl;
	CaplButton	m_browseprovider_btn;
	CaplButton	m_cancel_btn;
	CaplButton	m_ok_btn;
	CString	m_sProvider;
	CString	m_sId;
	CString	m_sDescr;
	CString	m_sState;
	CString	m_sRegistrator;
	CString	m_sUnpacker;
	CString	m_sSender;
	CString	m_sComment;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPacketDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void FillTree();

	// Generated message map functions
	//{{AFX_MSG(CPacketDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnBrowseProvider();
	afx_msg void OnItemexpandingTree(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PACKETDLG_H__74CF2F00_0E70_47A2_9558_B5BD63817BBB__INCLUDED_)
