// DiagramPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DiagramPropDlg.h"
#include "SelectDSColumnDlg.h"
#include "PropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDiagramPropDlg dialog
enum {aplColumnHeaderCol, aplColumnShow, aplColumnTitle, aplColumnWidth, aplColumnColor};

CDiagramPropDlg::CDiagramPropDlg(CWnd* pParent /*=NULL*/)
	: CPageDialog(CDiagramPropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDiagramPropDlg)
	m_sName = _T("");
	//}}AFX_DATA_INIT
	m_DefcolorInd = 0;
	m_DefColors[0]=RGB(220, 0, 0);
	m_DefColors[1]=RGB(36, 0, 220);
	m_DefColors[2]=RGB(0, 220, 0);
	m_DefColors[3]=RGB(220, 0, 220);
	m_DefColors[4]=RGB(255, 70, 70);
	m_DefColors[5]=RGB(150, 150, 150);
	m_DefColors[6]=RGB(0, 0, 0);

	m_ShowModes.Add(APL_T(" "));
	m_ShowModes.Add(APL_T("   "));
	m_ShowModes.Add(APL_T("  "));
	m_ShowModes.Add(APL_T("   "));
}


void CDiagramPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CPageDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiagramPropDlg)
	DDX_Control(pDX, IDC_SELECT_DS_COLUMN, m_select_ds_btn);
	DDX_Control(pDX, IDC_ADD_COLUMN, m_add_btn);
	DDX_Control(pDX, IDC_DELETE, m_delete_btn);
	DDX_Control(pDX, IDC_DS_COLUMNS, m_DSColumnCtrl);
	DDX_Control(pDX, IDC_LINES_LIST, m_LinesListCtrl);
	DDX_Text(pDX, IDC_NAME, m_sName);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SORT_TYPE, m_sort_type_ctrl);
}


BEGIN_MESSAGE_MAP(CDiagramPropDlg, CPageDialog)
	//{{AFX_MSG_MAP(CDiagramPropDlg)
	ON_BN_CLICKED(IDC_ADD_COLUMN, OnAddColumn)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_STARTEDIT(IDC_LINES_LIST, OnLinesListCtrlStartEdir)
	ON_BN_CLICKED(IDC_SELECT_DS_COLUMN, OnSelectDsColumn)
	ON_CBN_SELCHANGE(IDC_DS_COLUMNS, OnSelchangeDsColumns)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiagramPropDlg message handlers

BOOL CDiagramPropDlg::OnInitDialog() 
{
	CPageDialog::OnInitDialog();

	if(m_elem==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	m_select_ds_btn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_select_ds_btn.SetWindowText(_T(""));
	m_add_btn.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_add_btn.SetWindowText(_T(""));
	m_delete_btn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_delete_btn.SetWindowText(_T(""));

	//  
	int i;
	int ind;
	CString buf;

	m_DSColumnCtrl.SetItemData(m_DSColumnCtrl.AddString(_T("")), 0);
	m_DSColumnCtrl.SetCurSel(0);
	for(i=0; i<m_elem->m_ReportMgr->m_header->GetSize(); i++)
		m_DSColumnCtrl.SetItemData(m_DSColumnCtrl.AddString(m_elem->m_ReportMgr->m_header->GetColumn(i)->GetName()), (DWORD)m_elem->m_ReportMgr->m_header->GetColumn(i));
	for(i=0; i<m_elem->m_ReportMgr->m_base_query->GetSize(); i++)
		m_DSColumnCtrl.SetItemData(m_DSColumnCtrl.AddString(m_elem->m_ReportMgr->m_base_query->GetColumn(i)->GetName()), (DWORD)m_elem->m_ReportMgr->m_base_query->GetColumn(i));

	m_sName = m_elem->m_name;
	m_pGroupCol = m_elem->m_pGroupColumn;
	if(m_pGroupCol)
		SelectColumn(m_pGroupCol);

	m_sort_type_ctrl.InsertString(aplAZ, APL_T(" "));
	m_sort_type_ctrl.InsertString(aplZA, APL_T(" "));
	m_sort_type_ctrl.InsertString(aplSortNone, APL_T(""));
	m_sort_type_ctrl.SetCurSel(m_elem->m_SortDirection);

	CRect cl_rect;
	m_LinesListCtrl.GetClientRect(&cl_rect);
	m_LinesListCtrl.InsertColumn(aplColumnHeaderCol, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.25));
	m_LinesListCtrl.InsertColumn(aplColumnShow, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.2));
	m_LinesListCtrl.InsertColumn(aplColumnTitle, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.3));
	m_LinesListCtrl.InsertColumn(aplColumnWidth, APL_T(" "), LVCFMT_LEFT, (int)(cl_rect.Width()*0.12));
	m_LinesListCtrl.InsertColumn(aplColumnColor, APL_T(""), LVCFMT_LEFT, (int)(cl_rect.Width()*0.12));
	m_LinesListCtrl.ModifyStyle(0, LVS_OWNERDRAWFIXED);

	for(i=0; i<m_elem->m_Elements.GetSize(); i++)
	{
		ind =	m_LinesListCtrl.InsertItem(m_LinesListCtrl.GetItemCount(), m_elem->m_Elements[i]->m_pDSColumn->GetName());
		switch(m_elem->m_Elements[i]->m_show_mode)
		{
		case aplShowValue: buf = APL_T(" "); break;
		case aplShowSumm: buf = APL_T("   "); break;
		case aplShowCount: buf = APL_T("   "); break;
		case aplShowAverage: buf = APL_T("    "); break;
		}
				m_LinesListCtrl.SetItemText(ind, aplColumnShow, buf);
				m_LinesListCtrl.SetItemText(ind, aplColumnTitle, m_elem->m_Elements[i]->m_name);
		buf.Format(_T("%g"), (double)m_elem->m_Elements[i]->m_line_width/10);
				m_LinesListCtrl.SetItemText(ind, aplColumnWidth, buf);
				m_LinesListCtrl.SetItemBkColor(ind, aplColumnColor, m_elem->m_Elements[i]->m_color);
				m_LinesListCtrl.SetItemData(ind, (DWORD)m_elem->m_Elements[i]);

				if(m_pGroupCol!=NULL)
					m_LinesListCtrl.SetItemEditType(ind, aplColumnShow, aplComboCtrl, &m_ShowModes);
				m_LinesListCtrl.SetItemEditType(ind, aplColumnTitle, aplTextCtrl);
				m_LinesListCtrl.SetItemEditType(ind, aplColumnColor, aplUser);
				m_LinesListCtrl.SetItemEditType(ind, aplColumnWidth, aplRealCtrl);
	}
	OnSelchangeDsColumns();

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

bool CDiagramPropDlg::UpdateDlg()
{
	if(!UpdateData()) return false;
	int cur = m_DSColumnCtrl.GetCurSel();
	m_elem->m_pGroupColumn = cur>-1?(CHeaderColumn*)m_DSColumnCtrl.GetItemData(cur):NULL;

	// 
	int i;
	CDiagramItem *pItem;
	CString buf;

	for(i=0; i<m_deleted_items.GetSize(); i++)
	{
		m_deleted_items[i]->Delete();
		m_elem->m_Elements.Remove(m_elem->m_Elements.Find(m_deleted_items[i]));
	}
	m_deleted_items.Clear();
	/// 
	for(i=0; i<m_added_items.GetSize(); i++)
		m_elem->m_Elements.Add(m_added_items[i]);
	m_added_items.Clear();

	// 
	for(i=0; i<m_LinesListCtrl.GetItemCount(); i++)
	{
		pItem = (CDiagramItem*)m_LinesListCtrl.GetItemData(i);
		pItem->m_line_width = (int)(__atof(m_LinesListCtrl.GetItemText(i, aplColumnWidth))*10);
		pItem->m_name = m_LinesListCtrl.GetItemText(i, aplColumnTitle);
		buf = m_LinesListCtrl.GetItemText(i, aplColumnShow);
		if(buf==APL_T(" "))
			pItem->m_show_mode=aplShowValue;
		else if(buf==APL_T("   "))
			pItem->m_show_mode=aplShowCount;
		else if(buf==APL_T("  "))
			pItem->m_show_mode=aplShowSumm;
		else if(buf==APL_T("   "))
			pItem->m_show_mode=aplShowAverage;
	}

	m_elem->m_SortDirection = m_sort_type_ctrl.GetCurSel();

	return true;
}

void CDiagramPropDlg::OnAddColumn() 
{
	UpdateData();
	CSelectDSColumnDlg dlg;
	dlg.m_ReportMgr = m_elem->m_ReportMgr;
	dlg.m_bShowEmptyColumn = false;
	if(dlg.DoModal()==IDOK)
	{
		int ind;
		CString buf;
		CHeaderColumn* pCol = dlg.m_selected;
		if(pCol)
		{
			CDiagramItem *pItem = new CDiagramItem(m_elem->m_ReportMgr);
			buf.Format(_T("%g"), (double)pItem->m_line_width/10);
			ind =	m_LinesListCtrl.InsertItem(m_LinesListCtrl.GetItemCount(), pCol->GetName());
					m_LinesListCtrl.SetItemText(ind, aplColumnShow, APL_T(" "));
					m_LinesListCtrl.SetItemText(ind, aplColumnTitle, pCol->GetName());
					m_LinesListCtrl.SetItemEditType(ind, aplColumnTitle, aplTextCtrl);
					m_LinesListCtrl.SetItemText(ind, aplColumnWidth, buf);
					m_LinesListCtrl.SetItemEditType(ind, aplColumnWidth, aplRealCtrl);
					m_LinesListCtrl.SetItemBkColor(ind, aplColumnColor, m_DefColors[m_DefcolorInd]);
					m_LinesListCtrl.SetItemEditType(ind, aplColumnColor, aplUser);

					pItem->m_color = m_DefColors[m_DefcolorInd++];
					if(m_DefcolorInd>6) m_DefcolorInd = 0;
					pItem->m_name = pCol->GetName();
					pItem->m_pDSColumn = pCol;
					pItem->m_show_mode = aplShowValue;
					m_added_items.Add(pItem);
					m_LinesListCtrl.SetItemData(ind, (DWORD)pItem);

					OnSelchangeDsColumns();
		}
	}
	UpdateData(FALSE);
}

void CDiagramPropDlg::OnDelete() 
{
	int cur = m_LinesListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return;

	CDiagramItem *pItem = (CDiagramItem*)m_LinesListCtrl.GetItemData(cur);
	if(m_added_items.Find(pItem)>-1)
	{
		m_added_items.Remove(m_added_items.Find(pItem));
		delete pItem;
	}
	else
		m_deleted_items.Add(pItem);
	m_LinesListCtrl.DeleteItem(cur);
}

void CDiagramPropDlg::OnLinesListCtrlStartEdir(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW lpNMListView = (LPNMLISTVIEW)pNMHDR;

	*pResult = 0;

	if(lpNMListView->iSubItem==aplColumnColor)
	{
		CDiagramItem *pItem = (CDiagramItem*)m_LinesListCtrl.GetItemData(lpNMListView->iItem);
		if(pItem==NULL) return;
		CColorDialog dlg(pItem->m_color);
		dlg.m_cc.Flags |= CC_FULLOPEN | CC_RGBINIT;
		dlg.m_cc.lpCustColors = new COLORREF[16];
		dlg.m_cc.lpCustColors[0] = pItem->m_color;
		dlg.m_cc.lpCustColors[1]=RGB(220, 0, 0);
		dlg.m_cc.lpCustColors[2]=RGB(36, 0, 220);
		dlg.m_cc.lpCustColors[3]=RGB(0, 220, 0);
		dlg.m_cc.lpCustColors[4]=RGB(220, 0, 220);
		dlg.m_cc.lpCustColors[5]=RGB(255, 70, 70);
		dlg.m_cc.lpCustColors[6]=RGB(150, 150, 150);
		dlg.m_cc.lpCustColors[7]=RGB(0, 0, 0);
		dlg.m_cc.lpCustColors[8]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[9]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[10]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[11]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[12]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[13]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[14]=RGB(255, 255, 255);
		dlg.m_cc.lpCustColors[15]=RGB(255, 255, 255);

		if(dlg.DoModal())
		{
			pItem->m_color = dlg.m_cc.rgbResult;
			m_LinesListCtrl.SetItemBkColor(lpNMListView->iItem, lpNMListView->iSubItem, dlg.m_cc.rgbResult);
		}
		delete dlg.m_cc.lpCustColors;
	}
}

void CDiagramPropDlg::OnSelectDsColumn() 
{
	CSelectDSColumnDlg dlg;
	dlg.m_ReportMgr = m_elem->m_ReportMgr;
	if(dlg.DoModal()==IDOK)
		SelectColumn(dlg.m_selected);
}

void CDiagramPropDlg::SelectColumn(CHeaderColumn *pColumn)
{
	int i;
	for(i=0; i<m_DSColumnCtrl.GetCount(); i++)
	{
		if(m_DSColumnCtrl.GetItemData(i)==(DWORD)pColumn)
		{
			m_DSColumnCtrl.SetCurSel(i);
			return;
		}
	}
	m_DSColumnCtrl.SetCurSel(0);
}

BOOL CDiagramPropDlg::DestroyWindow() 
{
	int i;
	for(i=0; i<m_added_items.GetSize(); i++)
		delete m_added_items[i];
	
	return CPageDialog::DestroyWindow();
}


void CDiagramPropDlg::OnCancel() 
{
	if(m_LinesListCtrl.EndEdit(false)) return;

	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}

void CDiagramPropDlg::OnOK() 
{
	if(m_LinesListCtrl.EndEdit()) return;
	if(!UpdateData()) return;

	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CDiagramPropDlg::OnSelchangeDsColumns() 
{
	int cur = m_DSColumnCtrl.GetCurSel();
	int i;
	if(cur>-1)
	{
		if(m_DSColumnCtrl.GetItemData(cur)>0)
		{
			for(i=0; i<m_LinesListCtrl.GetItemCount(); i++)
				m_LinesListCtrl.SetItemEditType(i, aplColumnShow, aplComboCtrl, &m_ShowModes);
			return;
		}
	}
	for(i=0; i<m_LinesListCtrl.GetItemCount(); i++)
	{
		m_LinesListCtrl.SetItemEditType(i, aplColumnShow, aplNone);
		m_LinesListCtrl.SetItemText(i, aplColumnShow, APL_T(" "));
	}
}

bool CDiagramPropDlg::TestUpdate()
{
	if(!UpdateData()) return false;

	return true;
}
