// LevelPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "reportdict.h"
#include "LevelPropDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLevelPropDlg dialog


CLevelPropDlg::CLevelPropDlg(CaplReportMgr *ReportMgr, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CLevelPropDlg::IDD, pParent)
{
	ASSERT(ReportMgr);

	m_ReportMgr = ReportMgr;
	//{{AFX_DATA_INIT(CLevelPropDlg)
	m_name = _T("");
	m_not_show_if_empty = FALSE;
	m_height = 8.0;
	m_bBreakString = FALSE;
	m_bAutoCalcHeight = FALSE;
	m_bUseMultipleHeight = FALSE;
	m_iMinRows = 1;
	m_bUseRowColor = FALSE;
	//}}AFX_DATA_INIT

	m_row_color = RGB(200, 200, 200);
	m_pLevel = NULL;
	m_pLevelPrototipe = NULL;

	m_pLevels = NULL;

	m_space_para = aplSpacePara15;
}


void CLevelPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLevelPropDlg)
	DDX_Control(pDX, IDC_ROW_COLOR, m_RowColorCtrl);
	DDX_Control(pDX, IDC_NOT_SHOW_EMPTY_ROWS_ON_NEW_PAGES, m_NSERONPCtrl);
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDC_SPACE2, m_space2_btn);
	DDX_Control(pDX, IDC_SPACE15, m_space15_btn);
	DDX_Control(pDX, IDC_SPACE1, m_space1_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_NAME, m_name);
	DDX_Check(pDX, IDC_NOT_SHOW_IF_EMPTY, m_not_show_if_empty);
	DDX_Text(pDX, IDC_HEIGHT, m_height);
	DDV_MinMaxDouble(pDX, m_height, 0., 100.);
	DDX_Check(pDX, IDC_BREAK_STRING, m_bBreakString);
	DDX_Check(pDX, IDC_AUTO_CALC_HEIGHT, m_bAutoCalcHeight);
	DDX_Check(pDX, IDC_USE_MULTIPLE_HEIGHT, m_bUseMultipleHeight);
	DDX_Text(pDX, IDC_MIN_ROWS, m_iMinRows);
	DDV_MinMaxInt(pDX, m_iMinRows, 1, 10);
	DDX_Check(pDX, IDC_USE_ROW_COLOR, m_bUseRowColor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLevelPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CLevelPropDlg)
	ON_BN_CLICKED(IDC_AUTO_CALC_HEIGHT, OnAutoCalcHeight)
	ON_BN_CLICKED(IDC_BREAK_STRING, OnBreakString)
	ON_BN_CLICKED(IDC_USE_MULTIPLE_HEIGHT, OnUseMultipleHeight)
	ON_BN_CLICKED(IDC_SPACE1, OnSpace1)
	ON_BN_CLICKED(IDC_SPACE15, OnSpace15)
	ON_BN_CLICKED(IDC_SPACE2, OnSpace2)
	ON_EN_CHANGE(IDC_MIN_ROWS, OnChangeMinRows)
	ON_BN_CLICKED(IDC_ROW_COLOR, OnRowColor)
	ON_BN_CLICKED(IDC_USE_ROW_COLOR, OnUseRowColor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLevelPropDlg message handlers

void CLevelPropDlg::OnOK() 
{
	if(!UpdateData()) return;
	
	if(m_name.IsEmpty())
	{
		AfxMessageBox(APL_T("   ."));
		return;
	}

	//Unique
	int i;
	int NSRONP = m_NSERONPCtrl.GetCheck();
	for(i=0; i<m_pLevels->GetSize(); i++)
	{
		if(m_pLevels->GetAt(i)==m_pLevel && m_pLevel!=NULL) continue;

		if(m_pLevels->GetAt(i)->m_name.CompareNoCase(m_name)==0)
		{
			AfxMessageBox(APL_T("   !"));
			return;
		}
	}

	if(m_height<=0)
	{
		AfxMessageBox(APL_T("        0."));
		return;
	}

	if(m_pLevel==NULL)
	{
		m_pLevel = new CSectionLevel(m_ReportMgr);
		m_pLevels->Add(m_pLevel);
	}

	m_pLevel->m_name = m_name;
	m_pLevel->m_height = int(m_height*10);
	m_pLevel->m_flag = 0;
	if(m_not_show_if_empty)
		m_pLevel->m_flag |= APL_SEC_LEVEL_SKIP_IF_EMPTY;
	if(m_bBreakString)
	{
		m_pLevel->m_flag |= APL_SEC_LEVEL_NOT_BREAK_STRING;
		if(m_bAutoCalcHeight)
		{
			m_pLevel->m_flag |= APL_SEC_LEVEL_AUTOCLAC_HEIGHT;
			if(m_bUseMultipleHeight)
				m_pLevel->m_flag |= APL_SEC_LEVEL_USE_MULTIPLE_HEIGHT;
		}
	}
	m_pLevel->m_MinRows = m_iMinRows;
	if(m_iMinRows>1 && NSRONP!=0)
		m_pLevel->m_flag|=APL_SEC_LEVEL_NOT_SHOW_EMPTY_ROWS_ON_NEW_PAGE;
	if(m_bUseRowColor)
		m_pLevel->m_flag|=APL_SEC_LEVEL_USE_ROW_COLOR;
	m_pLevel->m_space_para = GetSpacePara();

	m_pLevel->m_row_color = m_row_color;
	
	CaplTranslateDialog::OnOK();
}

BOOL CLevelPropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	ASSERT(m_pLevels);
	
	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	CImageList Buttons_il;
	CBitmap bm;
	bm.LoadBitmap(IDB_TEXT_FORMAT);
	Buttons_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
	Buttons_il.Add(&bm, RGB(192,192,192));

	m_space2_btn.SetIcon(Buttons_il.ExtractIcon(11));
	m_space2_btn.SetWindowText(_T(""));
	m_space15_btn.SetIcon(Buttons_il.ExtractIcon(10));
	m_space15_btn.SetWindowText(_T(""));
	m_space1_btn.SetIcon(Buttons_il.ExtractIcon(9));
	m_space1_btn.SetWindowText(_T(""));

	Buttons_il.DeleteImageList();

	m_pLevelPrototipe = m_pLevel!=NULL?m_pLevel:m_pLevelPrototipe;
	if(m_pLevelPrototipe)
	{
		m_height = ((double)m_pLevelPrototipe->m_height/10);
		m_space_para = m_pLevelPrototipe->m_space_para;
		m_name = m_pLevelPrototipe->m_name;
		m_iMinRows = m_pLevelPrototipe->m_MinRows;
		m_bAutoCalcHeight = (m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_AUTOCLAC_HEIGHT)?TRUE:FALSE;
		m_bBreakString = (m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_NOT_BREAK_STRING)?TRUE:FALSE;
		m_bUseMultipleHeight = (m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_USE_MULTIPLE_HEIGHT)?TRUE:FALSE;
		m_not_show_if_empty = (m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_SKIP_IF_EMPTY)?TRUE:FALSE;
		m_bUseRowColor = (m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_USE_ROW_COLOR)?TRUE:FALSE;
		m_row_color = m_pLevelPrototipe->m_row_color;
		m_NSERONPCtrl.SetCheck((m_pLevelPrototipe->m_flag&APL_SEC_LEVEL_NOT_SHOW_EMPTY_ROWS_ON_NEW_PAGE)?TRUE:FALSE);
	}
	else
		m_NSERONPCtrl.SetCheck(TRUE);
	GetDlgItem(IDC_AUTO_CALC_HEIGHT)->EnableWindow(m_bBreakString);
	GetDlgItem(IDC_USE_MULTIPLE_HEIGHT)->EnableWindow(m_bAutoCalcHeight);
	
	m_space15_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space1_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space2_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_NSERONPCtrl.EnableWindow(m_iMinRows>1?TRUE:FALSE);
	m_RowColorCtrl.SetBkColor(m_row_color);
	SetSpaceState(m_space_para);
	
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLevelPropDlg::OnAutoCalcHeight() 
{
	if(!UpdateData()) return;
	GetDlgItem(IDC_USE_MULTIPLE_HEIGHT)->EnableWindow(m_bAutoCalcHeight);
	m_space15_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space1_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space2_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
}

void CLevelPropDlg::OnBreakString() 
{
	if(!UpdateData()) return;
	GetDlgItem(IDC_AUTO_CALC_HEIGHT)->EnableWindow(m_bBreakString);
	m_space15_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space1_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space2_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
}

void CLevelPropDlg::OnUseMultipleHeight() 
{
	if(!UpdateData()) return;
	m_space15_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space1_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
	m_space2_btn.EnableWindow(m_bAutoCalcHeight&&!m_bUseMultipleHeight);
}

void CLevelPropDlg::OnSpace1() 
{
	SetSpaceState(aplSpacePara1);
}

void CLevelPropDlg::OnSpace15() 
{
	SetSpaceState(aplSpacePara15);
}

void CLevelPropDlg::OnSpace2() 
{
	SetSpaceState(aplSpacePara2);
}

void CLevelPropDlg::SetSpaceState(int space_para)
{
	m_space15_btn.SetState(0);
	m_space1_btn.SetState(0);
	m_space2_btn.SetState(0);
	
	if(space_para==aplSpacePara1)
		m_space1_btn.SetState(1);
	else if(space_para==aplSpacePara15)
		m_space15_btn.SetState(1);
	else if(space_para==aplSpacePara2)
		m_space2_btn.SetState(1);
}

int CLevelPropDlg::GetSpacePara()
{
	if(m_space1_btn.GetState()>0)
		return aplSpacePara1;
	else if(m_space15_btn.GetState()>0)
		return aplSpacePara15;
	else if(m_space2_btn.GetState()>0)
		return aplSpacePara2;
	
	return aplSpacePara15;
}

void CLevelPropDlg::OnChangeMinRows() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	CString buf;
	GetDlgItem(IDC_MIN_ROWS)->GetWindowText(buf);
	if(!IsInteger(buf) || buf.IsEmpty()) 
	{
		m_NSERONPCtrl.EnableWindow(FALSE);
		return;
	}
	UpdateData();

	m_NSERONPCtrl.EnableWindow(m_iMinRows>1?TRUE:FALSE);
}

void CLevelPropDlg::OnRowColor() 
{
	if(!m_bUseRowColor) return;

	CColorDialog dlg(m_row_color);
	if(dlg.DoModal()==IDOK)
	{
		m_row_color = dlg.GetColor();
		m_RowColorCtrl.SetBkColor(m_row_color);
	}
}

void CLevelPropDlg::OnUseRowColor() 
{
	UpdateData();
	m_RowColorCtrl.EnableWindow(m_bUseRowColor);
}
