// RectProperDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ReportDict.h"
#include "RectProperDlg.h"
#include "PropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRectProperDlg dialog


CRectProperDlg::CRectProperDlg(CWnd* pParent /*=NULL*/)
	: CPageDialog(CRectProperDlg::IDD, pParent)
{
	elem = NULL;
	//{{AFX_DATA_INIT(CRectProperDlg)
	m_cx = 0.0;
	m_cy = 0.0;
	m_x = 0.0;
	m_y = 0.0;
	m_line_width = 0.0;
	m_fixed = FALSE;
	//}}AFX_DATA_INIT
	m_line_color = 0;
	m_bChangedColor = false;
}


void CRectProperDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRectProperDlg)
	DDX_Control(pDX, IDC_SPIN_Y, m_SpinYCtrl);
	DDX_Control(pDX, IDC_SPIN_X, m_SpinXCtrl);
	DDX_Control(pDX, IDC_SPIN_H, m_SpinHCtrl);
	DDX_Control(pDX, IDC_SPIN_W, m_SpinWCtrl);
	DDX_Control(pDX, IDC_SPIN_LW, m_SpinLWCtrl);
	DDX_Control(pDX, IDC_STATIC_COLOR, m_color_ctrl);
	DDX_Text(pDX, IDC_EDIT_CX, m_cx);
	DDX_Text(pDX, IDC_EDIT_CY, m_cy);
	DDX_Text(pDX, IDC_EDIT_X, m_x);
	DDX_Text(pDX, IDC_EDIT_Y, m_y);
	DDX_Text(pDX, IDC_LINE_WIDTH, m_line_width);
	DDV_MinMaxDouble(pDX, m_line_width, 0.0, 10.0);
	DDX_Check(pDX, IDC_FIXED, m_fixed);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRectProperDlg, CPageDialog)
	//{{AFX_MSG_MAP(CRectProperDlg)
	ON_BN_CLICKED(IDC_STATIC_COLOR, OnStaticColor)
	ON_WM_LBUTTONDBLCLK()
	ON_BN_CLICKED(IDC_FIXED, OnFixed)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_LW, OnDeltaposSpinLw)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_X, OnDeltaposSpinX)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_W, OnDeltaposSpinW)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_H, OnDeltaposSpinH)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_Y, OnDeltaposSpinY)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRectProperDlg message handlers

BOOL CRectProperDlg::OnInitDialog()
{
	CPageDialog::OnInitDialog();

	m_SpinLWCtrl.SetRange(0, 1000);
	m_SpinYCtrl.SetRange32(0, 1000000);
	m_SpinXCtrl.SetRange32(0, 1000000);
	m_SpinHCtrl.SetRange32(-100000, 1000000);
	m_SpinWCtrl.SetRange32(-100000, 1000000);
	
	if(m_elems->GetSize()<1)
	{
		EndDialog(0);
		return FALSE;
	}

	elem = m_elems->GetAt(0);
	if(m_elems->GetSize()>=1)
	{
		m_y = double(-elem->m_org_pt.y)/10;
		m_x = double(elem->m_org_pt.x)/10;
		m_cy = -double(elem->m_size.cy)/10;
		m_cx = double(elem->m_size.cx)/10;

		m_line_color = elem->m_color;

		m_line_width = (double)(elem->m_line_width)/10;
		
		m_fixed = elem->m_fixed>0?TRUE:FALSE;

		m_str_x.Format(_T("%g"), m_x);
		m_str_cx.Format(_T("%g"), m_cx);
		m_str_y.Format(_T("%g"), m_y);
		m_str_cy.Format(_T("%g"), m_cy);

		m_str_lw.Format(_T("%g"), m_line_width);

		UpdateData(FALSE);

		if(m_elems->GetSize()>1 && mode==0)
		{
			//
			int TstVal;
			COLORREF color;
			int i;
			CEdit* wnd = NULL;
			int cnt = m_elems->GetSize();
			TstVal = elem->m_org_pt.x;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_org_pt.x!=TstVal)
				{
					wnd = (CEdit*)GetDlgItem(IDC_EDIT_X);
					wnd->SetWindowText(_T(""));
					m_str_x.Empty();
					break;
				}
			}
			TstVal = elem->m_org_pt.y;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_org_pt.y!=TstVal)
				{
					wnd = (CEdit*)GetDlgItem(IDC_EDIT_Y);
					wnd->SetWindowText(_T(""));
					m_str_y.Empty();
					break;
				}
			}
			TstVal = elem->m_size.cx;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_size.cx!=TstVal)
				{
					wnd = (CEdit*)GetDlgItem(IDC_EDIT_CX);
					wnd->SetWindowText(_T(""));
					m_str_cx.Empty();
					break;
				}
			}
			TstVal = elem->m_size.cy;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_size.cy!=TstVal)
				{
					wnd = (CEdit*)GetDlgItem(IDC_EDIT_CY);
					wnd->SetWindowText(_T(""));
					m_str_cy.Empty();
					break;
				}
			}
			TstVal = elem->m_line_width;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_line_width!=TstVal)
				{
					wnd = (CEdit*)GetDlgItem(IDC_LINE_WIDTH);
					wnd->SetWindowText(_T(""));
					m_str_lw.Empty();
					break;
				}
			}
			color = elem->m_color;
			for(i=1; i<cnt; i++)
			{
				if(m_elems->GetAt(i)->m_color!=color)
				{
					m_line_color = ::GetSysColor(COLOR_BTNFACE);
					break;
				}
			}
			for(i=1; i<cnt; i++)
			{
				if((m_elems->GetAt(i)->m_fixed>0?TRUE:FALSE)!=m_fixed)
				{
					((CButton*)GetDlgItem(IDC_FIXED))->SetCheck(2);
					break;
				}
			}
		}
		else
			((CButton*)GetDlgItem(IDC_FIXED))->ModifyStyle(BS_3STATE, BS_AUTOCHECKBOX);
	}
	else
		((CButton*)GetDlgItem(IDC_FIXED))->ModifyStyle(BS_3STATE, BS_AUTOCHECKBOX);
	if(mode>0)
	{
		CEdit* wnd = (CEdit*)GetDlgItem(IDC_EDIT_X);
		wnd->SetReadOnly();
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_Y);
		wnd->SetReadOnly();
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_CX);
		wnd->SetReadOnly();
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_CY);
		wnd->SetReadOnly();
	} 
	else if(mode>1)
	{
		CEdit* wnd = (CEdit*)GetDlgItem(IDC_LINE_WIDTH);
		wnd->SetReadOnly();
	}

	m_color_ctrl.SetBkColor(m_line_color);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRectProperDlg::OnOK() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CRectProperDlg::OnCancel() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}


bool CRectProperDlg::UpdateDlg(BOOL UPD)
{
	int fixed = ((CButton*)GetDlgItem(IDC_FIXED))->GetCheck();
	if(mode==0 && m_elems->GetSize()==1)
	{
		elem->m_size.cx = int(m_cx*10);
		elem->m_size.cy = -int(m_cy*10);
		elem->m_org_pt.x = int(m_x*10);
		elem->m_org_pt.y = int(-m_y*10);


		elem->m_color = m_line_color;

		double tmp = m_line_width*10;
		for(int i=0; i<m_elems->GetSize();i++)
		{
			m_elems->GetAt(i)->m_line_width = int(tmp);
			m_elems->GetAt(i)->m_fixed = m_fixed;
		}
	}
	else if(m_elems->GetSize()>1 && mode==0)
	{
		CString width;
		int i;
		CEdit* wnd = (CEdit*)GetDlgItem(IDC_EDIT_X);
		wnd->GetWindowText(m_str_x);
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_Y);
		wnd->GetWindowText(m_str_y);
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_CX);
		wnd->GetWindowText(m_str_cx);
		wnd = (CEdit*)GetDlgItem(IDC_EDIT_CY);
		wnd->GetWindowText(m_str_cy);
		wnd = (CEdit*)GetDlgItem(IDC_LINE_WIDTH);
		wnd->GetWindowText(width);
		if(!m_str_x.IsEmpty())
			m_x = __atof(m_str_x);
		if(!m_str_y.IsEmpty())
			m_y = __atof(m_str_y);
		if(!m_str_cx.IsEmpty())
			m_cx = __atof(m_str_cx);
		if(!m_str_cy.IsEmpty())
			m_cy = __atof(m_str_cy);

		CReportElement* tst = NULL;
		double tmp = __atof(width)*10;

		for(i=0; i<m_elems->GetSize();i++)
		{
			tst = m_elems->GetAt(i);
			if(!width.IsEmpty())
				tst->m_line_width = int(tmp);
			if(!m_str_x.IsEmpty())
				tst->m_org_pt.x = int(m_x*10);
			if(!m_str_y.IsEmpty())
				tst->m_org_pt.y = int(-m_y*10);
			if(!m_str_cx.IsEmpty())
				tst->m_size.cx = int(m_cx*10);
			if(!m_str_cy.IsEmpty())
				tst->m_size.cy = int(-m_cy*10);
			if(m_bChangedColor)
				tst->m_color = m_line_color;
			if(fixed!=2)
				tst->m_fixed = fixed;
		}
	}
	return true;
}

void CRectProperDlg::OnStaticColor() 
{
	CColorDialog dlg(m_line_color);
	if(dlg.DoModal()==IDOK)
	{
		m_bChangedColor = true;
		m_line_color = dlg.GetColor();
		m_color_ctrl.SetBkColor(m_line_color);
	}
}

void CRectProperDlg::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CRect rect;
	m_color_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	if(rect.PtInRect(point))
		OnStaticColor();
	
	CDialog::OnLButtonDblClk(nFlags, point);
}

void CRectProperDlg::OnFixed() 
{
	((CButton*)GetDlgItem(IDC_FIXED))->ModifyStyle(BS_3STATE, BS_AUTOCHECKBOX);
}

#define ReturnMessage() {AfxMessageBox(APL_T("         .      !"), MB_OK|MB_ICONINFORMATION); return false;}

bool CRectProperDlg::IsValidPositionandSize(CPoint pt, CSize sz, CReportSheet* pOwner)
{
	if(pt.x<0) ReturnMessage();
	if(pt.y>0) ReturnMessage();

	if(pt.x+sz.cx<0) ReturnMessage();
	if(pt.y+sz.cy>0) ReturnMessage();

	if(pt.x+sz.cx>pOwner->m_size.cx) ReturnMessage();
	if(pt.y+sz.cy<-pOwner->m_size.cy) ReturnMessage();

	return true;
}

bool CRectProperDlg::TestUpdate()
{
	if(mode==0 && m_elems->GetSize()==1)
	{
		if(!UpdateData()) return false;
		
		if(!IsValidPositionandSize(CPoint(int(m_x*10), -int(m_y*10)), CSize(int(m_cx*10), int(-m_cy*10)), elem->m_owner_sheet)) return false;
	}
	else
	{
		CReportElement* tst = NULL;
		int i;
		int tst_x, tst_y, tst_cx, tst_cy;
		for(i=0; i<m_elems->GetSize(); i++)
		{
			tst = m_elems->GetAt(i);
			tst_x = !m_str_x.IsEmpty() ? int(m_x*10) : tst->m_org_pt.x;
			tst_y = !m_str_y.IsEmpty() ? -int(m_y*10) : tst->m_org_pt.y;
			tst_cx = !m_str_cx.IsEmpty() ? int(m_cx*10) : tst->m_size.cx;
			tst_cy = !m_str_cy.IsEmpty() ? -int(m_cy*10) : tst->m_size.cy;
			if(!IsValidPositionandSize(CPoint(tst_x, tst_y), CSize(tst_cx, tst_cy), tst->m_owner_sheet)) return false;
		}
	}

	return true;
}

void CRectProperDlg::OnDeltaposSpinLw(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here

	if(m_str_lw.IsEmpty()) return;
	
	m_line_width+=pNMUpDown->iDelta>0?0.1:-0.1;
	if(m_line_width>10) m_line_width = 10;
	if(m_line_width<0) m_line_width = 0;
	m_str_lw.Format(_T("%g"), m_line_width);
	GetDlgItem(IDC_LINE_WIDTH)->SetWindowText(m_str_lw);

	*pResult = 0;
}

void CRectProperDlg::OnDeltaposSpinX(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	if(m_str_x.IsEmpty()) return;
	
	m_x+=pNMUpDown->iDelta>0?0.1:-0.1;
	if(m_x<0) m_x = 0;
	m_str_x.Format(_T("%g"), m_x);
	GetDlgItem(IDC_EDIT_X)->SetWindowText(m_str_x);

	*pResult = 0;
}

void CRectProperDlg::OnDeltaposSpinW(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	
	if(m_str_cx.IsEmpty()) return;
	
	m_cx+=pNMUpDown->iDelta>0?0.1:-0.1;
	if(m_cx<0) m_cx = 0;
	m_str_cx.Format(_T("%g"), m_cx);
	GetDlgItem(IDC_EDIT_CX)->SetWindowText(m_str_cx);
	
	*pResult = 0;
}

void CRectProperDlg::OnDeltaposSpinH(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	if(m_str_cy.IsEmpty()) return;
	m_cy+=pNMUpDown->iDelta>0?0.1:-0.1;
	m_str_cy.Format(_T("%g"), m_cy);
	GetDlgItem(IDC_EDIT_CY)->SetWindowText(m_str_cy);
	
	*pResult = 0;
}

void CRectProperDlg::OnDeltaposSpinY(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

	if(m_str_y.IsEmpty()) return;

	m_y+=pNMUpDown->iDelta>0?0.1:-0.1;
	if(m_y<0) m_y = 0;
	m_str_y.Format(_T("%g"), m_y);
	GetDlgItem(IDC_EDIT_Y)->SetWindowText(m_str_y);
	
	*pResult = 0;
}
