// SelectDSColumnDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SelectDSColumnDlg.h"
#include "reportdict.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectDSColumnDlg dialog


CSelectDSColumnDlg::CSelectDSColumnDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectDSColumnDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectDSColumnDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_ReportMgr = NULL;
	m_selected = NULL;
	m_header = new CHeader(m_ReportMgr);

	m_bShowEmptyColumn = true;
}


void CSelectDSColumnDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectDSColumnDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_LIST, m_list);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectDSColumnDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectDSColumnDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectDSColumnDlg message handlers

BOOL CSelectDSColumnDlg::OnInitDialog() 
{
	int i;
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_ReportMgr==0)
	{
		EndDialog(0);
		return FALSE;
	}
	for(i=0; i<m_ReportMgr->m_base_query->GetSize();i++)
	{
		if(m_ReportMgr->m_base_query->GetColumn(i)->m_type==aplINSTANCE) continue;
		CHeaderColumn* col = new CHeaderColumn(m_ReportMgr);
		*col = *m_ReportMgr->m_base_query->GetColumn(i);
		m_header->AddColumn(col);
	}
	for(i=0; i<m_ReportMgr->m_header->GetSize();i++)
	{
		if(m_ReportMgr->m_header->GetColumn(i)->m_type==aplINSTANCE) continue;
		CHeaderColumn* col = new CHeaderColumn(m_ReportMgr);
		*col = *m_ReportMgr->m_header->GetColumn(i);
		m_header->AddColumn(col);
	}

	m_list.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_list.InsertColumn(0,APL_T(""),LVCFMT_LEFT,200);
	ShowInListCtrl();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CSelectDSColumnDlg::DestroyWindow() 
{
	m_header->RemoveAll();		
	delete m_header;
	
	return CaplTranslateDialog::DestroyWindow();
}

void CSelectDSColumnDlg::ShowInListCtrl()
{
	int ind;
	int i;

	m_list.DeleteAllItems();
	if(m_bShowEmptyColumn)
		m_list.SetItemData(m_list.InsertItem(m_list.GetItemCount(),_T(" ")), 0);
	for(i=0; i<m_ReportMgr->m_base_query->GetSize();i++)
	{
		if(m_ReportMgr->m_base_query->GetColumn(i)->m_type==aplINSTANCE) continue;
		ind = m_list.InsertItem(m_list.GetItemCount(),m_ReportMgr->m_base_query->GetColumn(i)->GetName());
		m_list.SetItemData(ind,DWORD(m_ReportMgr->m_base_query->GetColumn(i)));
	}
	for(i=0; i<m_ReportMgr->m_header->GetSize();i++)
	{
		if(m_ReportMgr->m_header->GetColumn(i)->m_type==aplINSTANCE) continue;
		ind = m_list.InsertItem(m_list.GetItemCount(),m_ReportMgr->m_header->GetColumn(i)->GetName());
		m_list.SetItemData(ind,DWORD(m_ReportMgr->m_header->GetColumn(i)));
	}
}

void CSelectDSColumnDlg::OnOK() 
{
	int cur = m_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<0) return;
	CHeaderColumn* col = (CHeaderColumn*)m_list.GetItemData(cur);
	m_selected = col;		
	
	CaplTranslateDialog::OnOK();
}

void CSelectDSColumnDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CListCtrl* lc = (CListCtrl*)GetDlgItem(IDC_LIST);
	int cur=lc->GetNextItem(-1,LVIS_SELECTED);
	if(cur>-1)
		OnOK();
	
	*pResult = 0;
}
