// SetupgroupsPage.cpp : implementation file
//

#include "stdafx.h"
#include "SetupgroupsPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupgroupsPage dialog


CSetupgroupsPage::CSetupgroupsPage(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSetupgroupsPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupgroupsPage)
	m_GroupType = -1;
	//}}AFX_DATA_INIT
	m_pHeader = NULL;
}


void CSetupgroupsPage::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupgroupsPage)
	DDX_Control(pDX, IDC_UP, m_up_btn);
	DDX_Control(pDX, IDC_DN, m_down_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDC_GROUP_COLUMNS_LIST, m_GroupColumns_ListCtrl);
	DDX_Control(pDX, IDC_POSSIBLE_COLUMNST_LIST, m_PossibleColumns_ListCtrl);
	DDX_Radio(pDX, IDC_TITLE_GROUP, m_GroupType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupgroupsPage, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSetupgroupsPage)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DN, OnDn)
	ON_LBN_SELCHANGE(IDC_GROUP_COLUMNS_LIST, OnSelchangeGroupColumnsList)
	ON_BN_CLICKED(IDC_TITLE_GROUP, OnTitleGroup)
	ON_BN_CLICKED(IDC_ROW_GROUP, OnRowGroup)
	ON_LBN_DBLCLK(IDC_POSSIBLE_COLUMNST_LIST, OnDblclkPossibleColumnstList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupgroupsPage message handlers

void CSetupgroupsPage::OnOK() 
{
	// TODO: Add extra validation here
	
//	CaplTranslateDialog::OnOK();
}

void CSetupgroupsPage::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CaplTranslateDialog::OnCancel();
}

void CSetupgroupsPage::OnAdd() 
{
	int cur;
	CHeaderColumn* pColumn = NULL;
	cur = m_PossibleColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pColumn = (CHeaderColumn*)m_PossibleColumns_ListCtrl.GetItemData(cur);

	CTMGroupCol* pGrCol = new CTMGroupCol;
	//        CTemplateMaster
	pGrCol->pColumn = pColumn;

	m_GroupColumns_ListCtrl.SetItemData(m_GroupColumns_ListCtrl.AddString(pColumn->GetName()), (DWORD)pGrCol);

	m_PossibleColumns_ListCtrl.DeleteString(cur);
	if(cur>-1 && m_PossibleColumns_ListCtrl.GetCount()>0)
		m_PossibleColumns_ListCtrl.SetCurSel(cur>=m_PossibleColumns_ListCtrl.GetCount()?m_PossibleColumns_ListCtrl.GetCount()-1:cur);
}

void CSetupgroupsPage::OnDel() 
{
	UpdateData();
	int cur;
	CTMGroupCol* pColumn = NULL;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pColumn = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	
	m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(pColumn->pColumn->GetName()), (DWORD)pColumn->pColumn);

	delete pColumn;
	
	m_GroupColumns_ListCtrl.DeleteString(cur);
	if(cur>-1 && m_GroupColumns_ListCtrl.GetCount()>0)
	{
		m_GroupColumns_ListCtrl.SetCurSel(cur>=m_GroupColumns_ListCtrl.GetCount()?m_GroupColumns_ListCtrl.GetCount()-1:--cur);
		OnSelchangeGroupColumnsList();
	}
	else
	{
		m_GroupType = -1;
		UpdateData(FALSE);
	}
}

void CSetupgroupsPage::OnUp() 
{
	int cur;
	CTMGroupCol* pColumn = NULL;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<1 || cur>=m_GroupColumns_ListCtrl.GetCount()) return;
	
	pColumn = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	m_GroupColumns_ListCtrl.DeleteString(cur--);
	m_GroupColumns_ListCtrl.SetItemData(m_GroupColumns_ListCtrl.InsertString(cur, pColumn->pColumn->GetName()), (DWORD)pColumn);
	
	m_GroupColumns_ListCtrl.SetCurSel(cur);
}

void CSetupgroupsPage::OnDn() 
{
	int cur;
	CTMGroupCol* pColumn = NULL;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<0 || cur>=m_GroupColumns_ListCtrl.GetCount()-1) return;
	
	pColumn = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	m_GroupColumns_ListCtrl.DeleteString(cur++);
	m_GroupColumns_ListCtrl.SetItemData(m_GroupColumns_ListCtrl.InsertString(cur, pColumn->pColumn->GetName()), (DWORD)pColumn);
	
	m_GroupColumns_ListCtrl.SetCurSel(cur);
}

bool CSetupgroupsPage::UpdateLists()
{
	m_PossibleColumns_ListCtrl.ResetContent();
	ResetData();
	if(m_pHeader==NULL) return false;

	int i;
	CString buf;
	CHeaderColumn* pColumn;
	for(i=0; i<m_pHeader->GetSize(); i++)
	{
		pColumn = m_pHeader->GetColumn(i);
		buf = pColumn->GetName();
		m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
	}

	return true;
}

void CSetupgroupsPage::OnSelchangeGroupColumnsList() 
{
	UpdateData();
	int cur;
	CTMGroupCol *pCol;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	m_GroupType = pCol->iMode;
	UpdateData(FALSE);
}

void CSetupgroupsPage::OnTitleGroup() 
{
	UpdateData();
	int cur;
	CTMGroupCol *pCol;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	pCol->iMode = m_GroupType;
}

void CSetupgroupsPage::OnRowGroup() 
{
	UpdateData();
	int cur;
	CTMGroupCol *pCol;
	cur = m_GroupColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(cur);
	pCol->iMode = m_GroupType;
}

void CSetupgroupsPage::OnDblclkPossibleColumnstList() 
{
	OnAdd();
}

void CSetupgroupsPage::ResetData()
{
	CTMGroupCol *pCol;
	int i;
	for(i=0; i<m_GroupColumns_ListCtrl.GetCount(); i++)
	{
		pCol = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(i);
		delete pCol;
	}
	m_GroupColumns_ListCtrl.ResetContent();
}

bool CSetupgroupsPage::GetGroups(CArray<CTMGroupCol*, CTMGroupCol*> *pGrArr)
{
	if(pGrArr==NULL) return false;

	pGrArr->RemoveAll();
	CTMGroupCol *pCol;
	int i;
	for(i=0; i<m_GroupColumns_ListCtrl.GetCount(); i++)
	{
		pCol = (CTMGroupCol*)m_GroupColumns_ListCtrl.GetItemData(i);
		pGrArr->Add(pCol);
	}

	return true;
}

BOOL CSetupgroupsPage::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_add_btn.SetIcon(aplGetStdIco16(APL_STD_RIGHT));
	m_add_btn.SetWindowText(_T(""));
	m_del_btn.SetIcon(aplGetStdIco16(APL_STD_LEFT));
	m_del_btn.SetWindowText(_T(""));
	m_up_btn.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_up_btn.SetWindowText(_T(""));
	m_down_btn.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));
	m_down_btn.SetWindowText(_T(""));
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
