// SetupsortPage.cpp : implementation file
//

#include "stdafx.h"
#include "SetupsortPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupsortPage dialog


CSetupsortPage::CSetupsortPage(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSetupsortPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupsortPage)
	//}}AFX_DATA_INIT
	m_pTemplate = NULL;
}


void CSetupsortPage::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupsortPage)
	DDX_Control(pDX, IDC_UP, m_up_btn);
	DDX_Control(pDX, IDC_DOWN, m_down_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDC_SORT_LIST, m_SortColumns_ListCtrl);
	DDX_Control(pDX, IDC_POSSIBLE_LIST, m_PossibleColumns_ListCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupsortPage, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSetupsortPage)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	ON_LBN_DBLCLK(IDC_POSSIBLE_LIST, OnDblclkPossibleList)
	ON_LBN_DBLCLK(IDC_SORT_LIST, OnDblclkSortList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupsortPage message handlers

void CSetupsortPage::OnOK() 
{
	// TODO: Add extra validation here
	
//	CaplTranslateDialog::OnOK();
}

void CSetupsortPage::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CaplTranslateDialog::OnCancel();
}

bool CSetupsortPage::UpdateList()
{
	m_PossibleColumns_ListCtrl.ResetContent();
	m_SortColumns_ListCtrl.ResetContent();

	if(m_pTemplate==NULL) return false;

	int i, j;
	CArray<CHeaderColumn*, CHeaderColumn*> ColumnsArray;
	CHeaderColumn* pColumn;
	bool bFound;
	CString buf;

	for(i=0; i<m_pTemplate->m_pHeader->GetSize(); i++)
	{
		pColumn = m_pTemplate->m_pHeader->GetColumn(i);
		bFound = false;
		for(j=0; j<m_pTemplate->m_GroupsArray.GetSize(); j++)
		{
			if(m_pTemplate->m_GroupsArray[j]->pColumn==pColumn)
			{
				bFound = true;
				break;
			}
		}
		if(!bFound)
			ColumnsArray.Add(pColumn);
	}
	//    
	for(i=0; i<ColumnsArray.GetSize(); i++)
	{
		pColumn = ColumnsArray[i];
		buf = pColumn->GetName();
		m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
	}

	return true;
}

void CSetupsortPage::OnAdd() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_PossibleColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CHeaderColumn*)m_PossibleColumns_ListCtrl.GetItemData(cur);
	m_PossibleColumns_ListCtrl.DeleteString(cur);
	m_SortColumns_ListCtrl.SetItemData(m_SortColumns_ListCtrl.AddString(pCol->GetName()), (DWORD)pCol);
	
	if(cur>-1 && m_PossibleColumns_ListCtrl.GetCount()>0)
		m_PossibleColumns_ListCtrl.SetCurSel(cur>=m_PossibleColumns_ListCtrl.GetCount()?m_PossibleColumns_ListCtrl.GetCount()-1:cur);
}

void CSetupsortPage::OnDel() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_SortColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CHeaderColumn*)m_SortColumns_ListCtrl.GetItemData(cur);
	m_SortColumns_ListCtrl.DeleteString(cur);
	m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(pCol->GetName()), (DWORD)pCol);
	
	if(cur>-1 && m_SortColumns_ListCtrl.GetCount()>0)
		m_SortColumns_ListCtrl.SetCurSel(cur>=m_SortColumns_ListCtrl.GetCount()?m_SortColumns_ListCtrl.GetCount()-1:--cur);
}

void CSetupsortPage::OnUp() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_SortColumns_ListCtrl.GetCurSel();
	if(cur<1) return;
	pCol = (CHeaderColumn*)m_SortColumns_ListCtrl.GetItemData(cur);
	m_SortColumns_ListCtrl.DeleteString(cur--);
	m_SortColumns_ListCtrl.SetItemData(m_SortColumns_ListCtrl.InsertString(cur, pCol->GetName()), (DWORD)pCol);
	
	m_SortColumns_ListCtrl.SetCurSel(cur);
}

void CSetupsortPage::OnDown() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_SortColumns_ListCtrl.GetCurSel();
	if(cur<0 || cur>=m_SortColumns_ListCtrl.GetCount()-1) return;
	pCol = (CHeaderColumn*)m_SortColumns_ListCtrl.GetItemData(cur);
	m_SortColumns_ListCtrl.DeleteString(cur++);
	m_SortColumns_ListCtrl.SetItemData(m_SortColumns_ListCtrl.InsertString(cur, pCol->GetName()), (DWORD)pCol);
	
	m_SortColumns_ListCtrl.SetCurSel(cur);
}

void CSetupsortPage::OnDblclkPossibleList() 
{
	OnAdd();
}

void CSetupsortPage::OnDblclkSortList() 
{
	OnDel();
}

bool CSetupsortPage::GetSortList()
{
	if(m_pTemplate==NULL) return false;
	m_pTemplate->m_SortsArray.RemoveAll();
	int i;
	CHeaderColumn* pCol = NULL;
	for(i=0; i<m_SortColumns_ListCtrl.GetCount(); i++)
	{
		pCol = (CHeaderColumn*)m_SortColumns_ListCtrl.GetItemData(i);
		m_pTemplate->m_SortsArray.Add(pCol);
	}
	return true;
}

BOOL CSetupsortPage::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_add_btn.SetIcon(aplGetStdIco16(APL_STD_RIGHT));
	m_add_btn.SetWindowText(_T(""));
	m_del_btn.SetIcon(aplGetStdIco16(APL_STD_LEFT));
	m_del_btn.SetWindowText(_T(""));
	m_up_btn.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_up_btn.SetWindowText(_T(""));
	m_down_btn.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));
	m_down_btn.SetWindowText(_T(""));
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
