// aplPSS.cpp: implementation of the CaplPSS class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplPSS.h"
#include <afxtempl.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplPSSApp::CaplPSSApp()
{
	m_cur_tree_item= NULL;
	m_api= NULL;
}

bool CaplPSSApp::RefreshCurrentItem()
{
	if(!m_cur_tree_item) return false;
	if(!m_cur_tree_item->m_tree) return false;

	m_cur_tree_item->RefreshItem();

	return true;
}

bool CaplPSSApp::RefreshAllItems()
{
	if(!m_cur_tree_item) return false;
	CTreeCtrl* tree= m_cur_tree_item->m_tree;
	if(!tree) return false;
	
	tree->SetRedraw(FALSE);
	__refreshChildsItems(tree);
	tree->SetRedraw(TRUE);

	return true;
}

bool CaplPSSApp::ExpandItem(CaplTreeItemData *item)
{
	if(!m_cur_tree_item) return false;
	m_cur_tree_item->Expand(2);
	return true;
}

bool CaplPSSApp::CollapseItem(CaplTreeItemData *item)
{
	if(!m_cur_tree_item) return false;
	m_cur_tree_item->Expand(1);
	return true;
}

CaplTreeItemData* CaplPSSApp::GetParent()
{
	if(!m_cur_tree_item) return NULL;
	if(!m_cur_tree_item->m_item) return NULL;
	if(!m_cur_tree_item->m_tree) return NULL;

	HTREEITEM hPItem= m_cur_tree_item->m_tree->GetParentItem(m_cur_tree_item->m_item);
	return (CaplTreeItemData*)m_cur_tree_item->m_tree->GetItemData(hPItem);
}

bool CaplPSSApp::GetChilds(aplTIArray &childs)
{
	if(!m_cur_tree_item) return false;
	if(!m_cur_tree_item->m_item) return false;
	if(!m_cur_tree_item->m_tree) return false;
	
	HTREEITEM hItem= m_cur_tree_item->m_tree->GetChildItem(m_cur_tree_item->m_item);
	
	while(1)
	{
		if(!hItem) break;
		CaplTreeItemData *item=(CaplTreeItemData*)m_cur_tree_item->m_tree->GetItemData(hItem);
		if(item) childs.Add(item);
		hItem= m_cur_tree_item->m_tree->GetNextItem(m_cur_tree_item->m_item, TVGN_NEXT);
	}	

	return true;
}

void CaplPSSApp::CommandExecute(long cmd)
{
	m_cur_tree_item->ShowCmd(MapCmd(cmd));
}

void CaplPSSApp::__refreshChildsItems(CTreeCtrl* tree, HTREEITEM item)
{
	if(!item) return;

	HTREEITEM hChildItem = tree->GetChildItem(item);

	while(1)
	{
		if(!hChildItem) break;
		
		CaplTreeItemData *item=(CaplTreeItemData*)tree->GetItemData(hChildItem);
		if(item){ item->RefreshItem(); TRACE(_T("Update\n"));}
		__refreshChildsItems(tree, hChildItem);
		hChildItem = tree->GetNextItem(hChildItem, TVGN_NEXT);
	}
}

long CaplPSSApp::MapCmd(long cmd)
{
	long pss_cmd= -1;

	switch(cmd) {
		
	case APLCMD_SHOW_ALL: pss_cmd= 61454; break;
	case APLCMD_SHOW_ALL_DOCS: pss_cmd= 32836; break;
	case APLCMD_SHOW_ALL_REVISION: pss_cmd= 33076; break;
	case APLCMD_SHOW_ALL_CHARACTS: pss_cmd= 33824; break;
	case APLCMD_SHOW_ALL_BPS: pss_cmd= 33156; break;
	case APLCMD_SHOW_ALL_MATERIALS: pss_cmd= 32896; break;
	case APLCMD_SHOW_ALL_INSTANCES: pss_cmd= 32983; break;
	case APLCMD_SHOW_ALL_LOTS: pss_cmd= 32982; break;
	case APLCMD_SHOW_ALL_RESOURCES: pss_cmd= 33168; break;
	case APLCMD_SHOW_ALL_APPOVALS: pss_cmd= 32843; break;
	case APLCMD_SHOW_ALL_BP_INSTANCES: pss_cmd= 61689; break;
	case APLCMD_SHOW_ALL_NOTES: pss_cmd= 61835; break;
	
	case APLCMD_CREATE_APPROVAL: pss_cmd= 32940; break;
	case APLCMD_CREATE_PRODUCT: pss_cmd= 32805; break;
	case APLCMD_CREATE_DOCUMENT: pss_cmd= 32948; break;
	case APLCMD_CREATE_CHARACTERISTIC: pss_cmd= 32823; break;
	case APLCMD_CREATE_BP: pss_cmd= 33147; break;
	case APLCMD_CREATE_BP_INSTANCE: pss_cmd= 61684; break;
	case APLCMD_CREATE_NOTE: pss_cmd= 61834; break;
	
	case APLCMD_CHECKOUT: pss_cmd= 33204; break;
	case APLCMD_CHECKIN: pss_cmd= 33206; break;
	case APLCMD_UNDO_CHECKOUT: pss_cmd= 33207; break;
	
	case APLCMD_PROPERTIES: pss_cmd= 32781; break;
	case APLCMD_COPY: pss_cmd= 0xE122; break;
	case APLCMD_PAST: pss_cmd= 0xE125; break;
	case APLCMD_CHANGE_WFS: pss_cmd= 61826; break;
	case APLCMD_SHOW_WFS_HISTORY: pss_cmd= 61825; break;
	
	case APLCMD_DELETE: pss_cmd= 32942; break;
	case APLCMD_DELETE_FROM_FOLDER: pss_cmd= 32950; break;
	
	case APLCMD_DOC_VIEW: pss_cmd= 33205; break;
	case APLCMD_DOC_EDIT: pss_cmd= 61673; break;
	case APLCMD_DOC_LAST_REVISION: pss_cmd= 32845; break;
	case APLCMD_DOC_SHOW_CHANGES: pss_cmd= 33033; break;
	case APLCMD_DOC_SHOW_ACCOCIATIONS: pss_cmd= 33079; break;
	case APLCMD_DOC_SHOW_DEPENDENCES: pss_cmd= 61843; break;
	case APLCMD_DOC_DELETE_RELATION: pss_cmd= 32923; break;
	case APLCMD_DOC_EDIT_SUBSCRIPTION: pss_cmd= 61856; break;
	
	case APLCMD_DOC_REV_MAKE_ACTIVE: pss_cmd= 32850; break;

	case APLCMD_MES_CREATE: pss_cmd= 33068; break;
	case APLCMD_MES_READ: pss_cmd=  33053; break;
	case APLCMD_MES_REPLY: pss_cmd= 33054; break;
	case APLCMD_MES_FORWARD: pss_cmd= 33055; break;
	case APLCMD_MES_SEND: pss_cmd= 33058; break;
	case APLCMD_MES_SHOW_ITEMS: pss_cmd= 33067; break;
	case APLCMD_MES_SHOW_HISTORY: pss_cmd= 61639; break;
	case APLCMD_MES_SHOW_SUBSCRIBE_STATE: pss_cmd= 61659; break;

/*
	case : pss_cmd= ; break;
	case : pss_cmd= ; break;
	case : pss_cmd= ; break;
*/
	default: pss_cmd= -1;
	
	}
	
	return pss_cmd;
}
