// PrintGant.h: interface for the CPrintGant class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PRINTGANT_H__34E8384B_BAE5_44C5_8885_4231200CDD6B__INCLUDED_)
#define AFX_PRINTGANT_H__34E8384B_BAE5_44C5_8885_4231200CDD6B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define APL_DM_TEXT		1
#define APL_DM_RECT		2
#define APL_DM_VLINES	4
#define APL_DM_HLINES	8

class CaplTreeListCtrl;

class CaplPrintGant  
{
	struct  ColData
	{
		int cdPosX;
		int cdWidth;
		int cdInd;
		CString cdName;
	};

protected:
	int m_hPages;
	int m_TitleCY;
	int m_RowCY;
	int m_dTitleCY;
	int m_dRowCY;

	int m_tree_CX;
	int m_gant_CX;

	LOGFONT m_title_lf;
	LOGFONT m_text_lf;
	CFont m_title_font;
	CFont m_text_font;

	CaplTreeListCtrl* m_TLCtrl;
public:
	bool SetupPrinter();
	void DrawTextInRect(CDC* pDC, CString text, int x, int y, int cx, int cy, UINT mode = APL_DM_RECT|APL_DM_TEXT);
	int Print(CDC *pDC, int cur_hPage, int cur_page);
	bool PrintGant(CaplTreeListCtrl* Ctrl);
	CaplPrintGant();
	virtual ~CaplPrintGant();

};

#endif // !defined(AFX_PRINTGANT_H__34E8384B_BAE5_44C5_8885_4231200CDD6B__INCLUDED_)
