#pragma once
// CPrjMonitorDlg dialog
#include <apl_api.h>
#include "resource.h"
#include "aplProjectMgr.h"
#include "FilterDlg.h"
//#include "afxwin.h"
#include "apl_gui.h"
#include "afxwin.h"

class CPrjMonitorDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CPrjMonitorDlg)

public:
	CPrjMonitorDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CPrjMonitorDlg();

	CaplAPI *m_api;
	CaplProjectManager *m_prj_mgr;
	aplExtent m_ext_projects;

	bool m_bShowPrognoz;

	CArray <aplExtent*,aplExtent*> m_prev_extents;

	CaplMap m_map_prj_index;
	CaplProjectManager::apl_CPrjPrognozItem_array m_array_progn_items;

	static CFilterStruct m_filter;

	CaplSizingListCtrl *m_list;
	bool UpdateList();
	bool UpdateItem(int item);
// Dialog Data
	enum { IDD = IDD_PRJ_MONITOR };

	int GetOptionWidth(LPCTSTR sOption, int default_width);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
	CaplButton m_cancel_btn;
	CaplButton m_save2file_btn;
	CaplButton m_show_gant_btn;
	CaplButton m_find_btn;
	CaplButton m_prj_prop_btn;
	CaplButton m_show_subprj;
	CaplButton m_backBtn;
	CaplButton m_prj_notes_btn;	
	CaplButton m_refresj_btn;
	CaplButton m_show_color_legend_btn;
	CButton m_ShowPrognozBtn;
	afx_msg void OnBnClickedSave2file();
	afx_msg void OnNMDblclkPrjList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedShowGant();
	afx_msg void OnBnClickedShowSubPrj();
	afx_msg void OnBnClickedPrjProperties();
	afx_msg void OnBnClickedBack();
	afx_msg void OnBnClickedRefresh();
	afx_msg void OnBnClickedFind();
	afx_msg void OnBnClickedShowColorLegend();
	afx_msg void OnBnClickedPrjNotes();
	afx_msg void OnBnClickedShowPrognoz();
	virtual BOOL DestroyWindow();
};
