// SelectTransactionFilterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelectTransactionFilterDlg.h"
#include <apl_api.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectTransactionFilterDlg dialog


CSelectTransactionFilterDlg::CSelectTransactionFilterDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectTransactionFilterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectTransactionFilterDlg)
	m_bUseBeginDate = FALSE;
	m_dtBegin = COleDateTime::GetCurrentTime();
	m_dtEnd = COleDateTime::GetCurrentTime();
	m_bUseEndDate = FALSE;
	m_bFact = FALSE;
	m_bFHelp = FALSE;
	m_bPlan = FALSE;
	//}}AFX_DATA_INIT

	/*m_bFact = (BOOL)AfxGetApp()->GetProfileInt(_T("Settings"), _T("TransactionFilterFact"), 1);
	m_bPlan = (BOOL)AfxGetApp()->GetProfileInt(_T("Settings"), _T("TransactionFilterPlan"), 1);
	m_bFHelp = (BOOL)AfxGetApp()->GetProfileInt(_T("Settings"), _T("TransactionFilterFHelp"), 1);

	m_bUseBeginDate = (BOOL)AfxGetApp()->GetProfileInt(_T("Settings"), _T("TransactionFilterUseBeginDate"), 0);
	m_bUseEndDate = (BOOL)AfxGetApp()->GetProfileInt(_T("Settings"), _T("TransactionFilterUseEndDate"), 0);
	*/

}


void CSelectTransactionFilterDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectTransactionFilterDlg)
	DDX_Control(pDX, IDC_DATE_END, m_dtEndCtrl);
	DDX_Control(pDX, IDC_DATE_BEGIN, m_dtBeginCtrl);
	DDX_Control(pDX, IDC_BEGIN, m_bUseBeginDateCtrl);
	DDX_Control(pDX, IDC_END, m_bUseEndDateCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_DateTimeCtrl(pDX, IDC_DATE_BEGIN, m_dtBegin);
	DDX_DateTimeCtrl(pDX, IDC_DATE_END, m_dtEnd);
	DDX_Check(pDX, IDC_BEGIN, m_bUseBeginDate);
	DDX_Check(pDX, IDC_END, m_bUseEndDate);
	DDX_Check(pDX, IDC_FACT, m_bFact);
	DDX_Check(pDX, IDC_FHELP, m_bFHelp);
	DDX_Check(pDX, IDC_PLAN, m_bPlan);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectTransactionFilterDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectTransactionFilterDlg)
	ON_BN_CLICKED(IDC_END, OnEnd)
	ON_BN_CLICKED(IDC_BEGIN, OnBegin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectTransactionFilterDlg message handlers

void CSelectTransactionFilterDlg::OnOK() 
{
	if(!UpdateData()) return;

	/*AfxGetApp()->WriteProfileInt(_T("Settings"), _T("TransactionFilterFact"), m_bFact);
	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("TransactionFilterPlan"), m_bPlan);
	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("TransactionFilterFHelp"), m_bFHelp);
	
	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("TransactionFilterUseBeginDate"), m_bUseBeginDate);
	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("TransactionFilterUseEndDate"), m_bUseEndDate);*/

	if(m_bUseBeginDate)
		aplDate2String(m_dtBegin, m_sDateBegin);
	else
		m_sDateBegin.Empty();
	
	if(m_bUseEndDate)
		aplDate2String(m_dtEnd, m_sDateEnd);
	else
		m_sDateEnd.Empty();

	CaplTranslateDialog::OnOK();
}

BOOL CSelectTransactionFilterDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(!m_sDateBegin.IsEmpty())
	{
		m_bUseBeginDate=TRUE; 
		aplString2Date(m_sDateBegin,m_dtBegin);
	}
	else m_dtBeginCtrl.EnableWindow(FALSE);

	if(!m_sDateEnd.IsEmpty())
	{
		m_bUseEndDate=TRUE;
		aplString2Date(m_sDateEnd,m_dtEnd );
	}
	else m_dtEndCtrl.EnableWindow(FALSE);
	
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectTransactionFilterDlg::OnBegin() 
{
	if(0==m_bUseBeginDateCtrl.GetCheck()) m_dtBeginCtrl.EnableWindow(FALSE);
	else m_dtBeginCtrl.EnableWindow(TRUE);
	
}

void CSelectTransactionFilterDlg::OnEnd() 
{
	if(0==m_bUseEndDateCtrl.GetCheck()) m_dtEndCtrl.EnableWindow(FALSE);
	else m_dtEndCtrl.EnableWindow(TRUE);
}
