// AlertDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AlertDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "apl_api.h"

/////////////////////////////////////////////////////////////////////////////
// CAlertDlg dialog


CAlertDlg::CAlertDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAlertDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAlertDlg)
	m_iSpan = 30;
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_alert= NULL;
	m_bUserProcessing=true;
}


void CAlertDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAlertDlg)
	DDX_Control(pDX, IDC_ALERT_TEXT_STATIC, m_alertTextStatic);
	DDX_Control(pDX, IDC_ALERT_SPAN_EDIT, m_alertSpan);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_TEXT_STATIC, m_textStatic);
	DDX_Text(pDX, IDC_ALERT_SPAN_EDIT, m_iSpan);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAlertDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAlertDlg)
	ON_EN_CHANGE(IDC_ALERT_SPAN_EDIT, OnChangeAlertSpanEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlertDlg message handlers

BOOL CAlertDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	if(m_api && m_api->m_data.IsConnected())
	{
		if(m_alert)
		{
			COleDateTime cur_odt, odt;
			m_api->m_data.NET_GetServerDateTime(cur_odt);
			
			cur_odt.SetDateTime(cur_odt.GetYear(), cur_odt.GetMonth(), cur_odt.GetDay(),
				0, 0, 0);
			
			CString buf;
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_date, buf);
			
			if(!buf.IsEmpty())
				aplString2Date(buf, odt);
			else
				EndDialog(IDCANCEL);

			COleDateTimeSpan odts= odt-cur_odt;
			int iDays= 0;
			if(odts.GetStatus()==COleDateTimeSpan::valid) iDays=odts.GetDays();
			else odts.SetDateTimeSpan(0,0,30,0);
			
			CString sText;
			COLORREF crTextColor= ::GetSysColor(COLOR_WINDOWTEXT);

			if(0==iDays)//
			{
				sText.Format( APL_T("   \n!"));
				crTextColor= RGB(0, 128, 0);
			}
			else if(iDays>0)// 
			{
				if(iDays==1)
					sText.Format( APL_T("     \n%i !"), iDays);				
				else
					sText.Format( APL_T("     \n%i !"), iDays);				

				crTextColor= RGB(0, 0, 255);
			}
			else if(iDays<0)//
			{
				if(iDays==-1)
					sText.Format( APL_T("    \n!"));
				else if(iDays>-5)
					sText.Format( APL_T("    \n%i  !"), -iDays);
				else if(iDays>-21)
					sText.Format( APL_T("    \n%i  !"), -iDays);
				else
					sText.Format( APL_T("    \n%i () !"), -iDays);

				crTextColor= RGB(255, 0, 0);				
			}

			double dSpan;
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_span, dSpan);
			odts.m_span= dSpan;
			double d1= odts.GetTotalDays();
			double d2= odts.GetTotalHours();

			m_iSpan= (int)odts.GetTotalMinutes();
				 		 
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_text, buf);
			if(buf.GetLength()>38)
			{
				for(int num= 38; num<buf.GetLength(); num+=38)
				{
					while(buf[num]!=' ') num--;					
					buf.SetAt(num, '\n');
				}
			}
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_next_date, buf);
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_span, odts.m_span);
			CString module=_T(""),function=_T("");
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_module, module);
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_function, function);
			if(module==_T("") && function==_T(""))
			{
				m_bUserProcessing=false;
				m_ok_btn.SetWindowText( APL_T(""));

			}
			m_alertTextStatic.SetText(buf);
			m_textStatic.SetTextColor(crTextColor);
			m_textStatic.SetText(sText);


			// 
			CaplInstance *person=m_api->m_appr_mgr.GetCurrentPerson();
			if(person!=0)
			{
				CString name;
				m_api->m_appr_mgr.GetPersonName(person,name);
				SetWindowText( APL_T(" (")+name+")");
			}

		}

		UpdateData(FALSE);
	}
	
	m_textStatic.SetFontBold(TRUE);
	m_textStatic.SetFontName(_T("Arial Cyr"));
	m_textStatic.SetFontSize(20);
	m_textStatic.SetAlignment(CaplStatic::HORZ_CENTER|CaplStatic::VERT_CENTER);	
	
	m_alertTextStatic.SetFontName(_T("MS Sans Serif"));
	m_alertTextStatic.SetFontSize(16);
	
	//if(!m_bSetCheck) m_alertSpan.SetReadOnly(TRUE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAlertDlg::SetNewSpan()
{
	COleDateTimeSpan odts;
	if(m_iSpan<5) 
	{
		AfxMessageBox( APL_T("      5 ! \n    5 "));
		m_iSpan= 5;
	}
	else if(m_iSpan>240) 
	{
		AfxMessageBox( APL_T("      4 ! \n    4 "));
		m_iSpan= 240;
	}
	if(!m_api->m_message_mgr.IsAdmin())//   (   5  240)  
								   // ,   
	{
		CaplInstance *m_author=0,*m_cur_person=m_api->m_message_mgr.GetCurrentPerson();
		m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_author, m_author);
		if(m_cur_person!=m_author)
		{
			double old_span,old_minuts;
			m_api->m_data.GetAttr(m_alert, m_api->m_message_mgr.a_alert_span, old_span);
			odts=old_span;
			if(odts.GetStatus()==COleDateTimeSpan::valid)
			{
				old_minuts=odts.GetTotalMinutes();
				if(int(old_minuts)<m_iSpan) 
				{
					AfxMessageBox( APL_T("        ! \n    ."));
					m_iSpan=int(old_minuts);
				}
			}
		}
	}
}

void CAlertDlg::OnCancel() 
{
	if(m_api && m_api->m_data.IsConnected())
	{
		COleDateTimeSpan odts;
		SetNewSpan();

		odts.SetDateTimeSpan(0, 0, m_iSpan, 0);
		COleDateTime odt;
		
		m_api->m_data.NET_GetServerDateTime(odt);
		odt+=odts;		
		CString buf;
		aplDate2String(odt, buf);
		
		if(m_alert && m_alert->GetType())
		{
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_next_date, buf);
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_span, odts.m_span);
			m_api->m_data.NET_SaveChanges();
		}
	}	
	CaplTranslateDialog::OnCancel();
}

void CAlertDlg::OnOK() 
{
	if(m_api && m_api->m_data.IsConnected())
	{
		COleDateTimeSpan odts;

		SetNewSpan();

		
		odts.SetDateTimeSpan(0, 0, m_iSpan, 0);
		COleDateTime odt;
		
		m_api->m_data.NET_GetServerDateTime(odt);
		odt+=odts;		
		CString buf;
		aplDate2String(odt, buf);

		if(m_alert && m_alert->GetType())
		{
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_next_date, buf);
			m_api->m_data.PutAttr(m_alert, m_api->m_message_mgr.a_alert_span, odts.m_span);
			if(!m_bUserProcessing)
			{
				m_api->m_message_mgr.SetAlertState(m_alert,m_api->m_message_mgr.m_alert_state_completed);
			}
			m_api->m_data.NET_SaveChanges();
		}
	}
	CaplTranslateDialog::OnOK();
}


void CAlertDlg::OnChangeAlertSpanEdit() 
{
	UpdateData();
	
	
	UpdateData(FALSE);
}

