// AssemblyChangeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AssemblyChangeDlg.h"
#include "apl_api.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "ChangeParamDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CAssemblyChangeDlg dialog

int CAssemblyChangeDlg::GetPdfIcon(CaplInstance* pdf)
{
	int prdIcon= -1;
	CString buf;

	apidata.GetAttr(pdf, m_api->m_prd_mgr.a_apl_pdf_type, buf);
	if(buf==_T("assembly")) prdIcon= ICON_ASSEMBLY;
	else if(buf==_T("part")) prdIcon= ICON_PART;
	else if(buf==_T("material")) prdIcon= ICON_MATERIAL;
	else if(buf==_T("kit")) prdIcon= ICON_KIT;
	else if(buf==_T("komplex")) prdIcon= ICON_KOMPLEX;
	else if(buf==_T("other")) prdIcon= ICON_OTHER;
	
	return prdIcon;
}

CAssemblyChangeDlg::CAssemblyChangeDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CAssemblyChangeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAssemblyChangeDlg)
	m_sProductName = _T("");
	m_sContext =  APL_T(" ");
	m_sEffectivity =  APL_T(" ");
	m_sProductId = _T("");
	m_sProductVer = _T("");
	m_iCont = -1;
	m_bDateSelected = TRUE;
	m_oleDate = COleDateTime::GetCurrentTime();
	m_bSNSelected = FALSE;
	m_sSN = _T("");
	//}}AFX_DATA_INIT
	
	m_mode= 0;
	m_api= NULL;
	
	m_psc= NULL;
	m_assPdf= NULL;
	m_curItem= NULL;

	m_items= NULL;
	m_newItems= NULL;
	m_delItems= NULL;
	
	m_curItem= NULL;
	m_index= -1;
	m_curPSC= NULL;
	m_curPSCInfo= NULL;

	m_sEffType= _T("none");
	m_sStartCond= _T("");
	m_sEndCond= _T("");
	
	m_change= NULL;

	m_bReadOnly= false;

	m_itemsList.SetUniqueName(_T("change_items_list"));
	m_whereUsedList.SetUniqueName(_T("where_used_list"));
}

 
void CAssemblyChangeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAssemblyChangeDlg)
	DDX_Control(pDX, IDC_CHG2_NEW_ASSEMBLY, m_nextEditBtn);
	DDX_Control(pDX, IDC_CHG2_WHERE_USE_LIST, m_whereUsedList);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_CHG2_SET_EFF, m_setEffBtn);
	DDX_Control(pDX, IDC_CHG2_PROP, m_itemPropBtn);
	DDX_Control(pDX, IDC_CHG2_ASS_REFRESH, m_refreshBtn);
	DDX_Control(pDX, IDC_CHG2_SN_CTRL, m_sn);
	DDX_Control(pDX, IDC_CHG2_DATE_CTRL, m_dateCtrl);
	DDX_Control(pDX, IDC_CHG2_CONTEXT_COMBO, m_contCtrl);
	DDX_Control(pDX, IDC_CHG2_CLEAR, m_itemClearBtn);
	DDX_Control(pDX, IDC_CHG2_ITEM_DELETE, m_itemDeleteBtn);
	DDX_Control(pDX, IDC_CHG2_ITEM_ADD, m_itemAddBtn);
	DDX_Control(pDX, IDC_CHG2_ITEM_CHANGE, m_itemChngBtn);
	DDX_Control(pDX, IDC_CHG2_ASSEMBLY_LIST, m_itemsList);
	DDX_Control(pDX, IDC_CHG2_ASS_SELECT, m_selectBtn);
	DDX_Text(pDX, IDC_CHG2_ASS_NAME, m_sProductName);
	DDX_Text(pDX, IDC_CHG2_ASS_ID, m_sProductId);
	DDX_Text(pDX, IDC_CHG2_ASS_VER, m_sProductVer);
	DDX_CBIndex(pDX, IDC_CHG2_CONTEXT_COMBO, m_iCont);
	DDX_Check(pDX, IDC_CHG2_DATE_CHECK, m_bDateSelected);
	DDX_DateTimeCtrl(pDX, IDC_CHG2_DATE_CTRL, m_oleDate);
	DDX_Check(pDX, IDC_CHG2_SN_CHECK, m_bSNSelected);
	DDX_Text(pDX, IDC_CHG2_SN_CTRL, m_sSN);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAssemblyChangeDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CAssemblyChangeDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_CHG2_ASSEMBLY_LIST, OnItemchangedChg2AssemblyList)
	ON_NOTIFY(NM_DBLCLK, IDC_CHG2_ASSEMBLY_LIST, OnDblclkChg2ItemsList)
	ON_BN_CLICKED(IDC_CHG2_ITEM_ADD, OnChg2ItemAdd)
	ON_BN_CLICKED(IDC_CHG2_ITEM_CHANGE, OnChg2ItemChange)
	ON_BN_CLICKED(IDC_CHG2_ITEM_DELETE, OnChg2ItemDelete)
	ON_BN_CLICKED(IDC_CHG2_CLEAR, OnChg2Clear)
	ON_BN_CLICKED(IDC_CHG2_DATE_CHECK, OnChg2DateCheck)
	ON_BN_CLICKED(IDC_CHG2_SN_CHECK, OnChg2SnCheck)
	ON_CBN_CLOSEUP(IDC_CHG2_CONTEXT_COMBO, OnCloseupChg2ContextCombo)
	ON_BN_CLICKED(IDC_CHG2_ASS_REFRESH, OnChg2AssRefresh)
	ON_NOTIFY(DTN_DATETIMECHANGE, IDC_CHG2_DATE_CTRL, OnDatetimechangeChg2DateCtrl)
	ON_EN_CHANGE(IDC_CHG2_SN_CTRL, OnChangeChg2SnCtrl)
	ON_BN_CLICKED(IDC_CHG2_PROP, OnChg2Prop)
	ON_BN_CLICKED(IDC_CHG2_ASS_SELECT, OnChg2AssSelect)
	ON_BN_CLICKED(IDC_CHG2_SET_EFF, OnChg2SetEff)
	ON_NOTIFY(NM_DBLCLK, IDC_CHG2_WHERE_USE_LIST, OnDblclkChg2WhereUseList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_CHG2_WHERE_USE_LIST, OnItemchangedChg2WhereUseList)
	ON_BN_CLICKED(IDC_CHG2_NEW_ASSEMBLY, OnChg2NewAssembly)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAssemblyChangeDlg message handlers

BOOL CAssemblyChangeDlg::OnInitDialog() 
{	
	RECT rect={5,180,600,365};
	CWnd* wnd=GetDlgItem( IDC_CNG2_ITM ) ;
	if(wnd!=0)
	{
		wnd->GetWindowRect(&rect);
		ScreenToClient(&rect);
	}
	m_itemsList.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,rect,this, IDC_CHG2_ASSEMBLY_LIST);
	
	wnd=GetDlgItem( IDC_CNG2_WU ) ;
	if(wnd!=0)
	{
		wnd->GetWindowRect(&rect);
		ScreenToClient(&rect);
	}
	m_whereUsedList.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,rect,this, IDC_CHG2_WHERE_USE_LIST);

	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_chngImageList.Create(IDR_CHANGE_TOOLBAR, 20, 6, RGB(255, 0, 255));
	m_chngImageList.SetImageCount(5);
	m_chngImageList.Replace(4, GetAplStdIco16(17));
	
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	m_refreshBtn.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_refreshBtn.SetFlat(FALSE);
	m_selectBtn.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_selectBtn.SetFlat(FALSE);

	m_nextEditBtn.SetIcon(GetAplStdIco16(17));
	m_nextEditBtn.SetFlat(FALSE);
	m_itemAddBtn.SetIcon(m_imageList.ExtractIcon(17));
	m_itemAddBtn.SetFlat(FALSE);
	m_itemChngBtn.SetIcon(m_imageList.ExtractIcon(ICON_CHANGE));
	m_itemChngBtn.SetFlat(FALSE);
	m_itemDeleteBtn.SetIcon(m_imageList.ExtractIcon(18));
	m_itemDeleteBtn.SetFlat(FALSE);

	AddAnchor(IDC_CHG2_ASSEMBLY_LIST, MIDDLE_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_CHG2_WHERE_USE_LIST, TOP_LEFT, MIDDLE_RIGHT);
	
	AddAnchor(IDC_PRODUCT_STATIC, TOP_LEFT, TOP_CENTER);
	AddAnchor(IDC_CHG2_ASS_ID, TOP_LEFT, TOP_CENTER);
	AddAnchor(IDC_CHG2_ASS_NAME, TOP_LEFT, TOP_CENTER);
	AddAnchor(IDC_CHG2_ASS_VER, TOP_LEFT, TOP_CENTER);
	AddAnchor(IDC_CHG2_ASS_SELECT, TOP_CENTER);
	
	AddAnchor(IDC_FILTER_STATIC, TOP_CENTER, TOP_RIGHT);
	AddAnchor(IDC_CHG2_SN_CTRL, TOP_CENTER, TOP_RIGHT);
	AddAnchor(IDC_CHG2_DATE_CTRL, TOP_CENTER, TOP_RIGHT);
	AddAnchor(IDC_CHG2_CONTEXT_COMBO, TOP_CENTER, TOP_RIGHT);
	AddAnchor(IDC_TEXT_CON_STATIC, TOP_CENTER);
	AddAnchor(IDC_CHG2_SN_CHECK, TOP_CENTER);
	AddAnchor(IDC_CHG2_DATE_CHECK, TOP_CENTER);
	AddAnchor(IDC_CHG2_ASS_REFRESH, TOP_RIGHT);
	
	AddAnchor(IDC_CHG2_SET_EFF, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_PROP, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_CLEAR, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_ITEM_DELETE, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_ITEM_ADD, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_ITEM_CHANGE, TOP_RIGHT);	
	AddAnchor(IDC_CHG2_NEW_ASSEMBLY, TOP_RIGHT);	
	
	AddAnchor(IDOK, BOTTOM_RIGHT);	
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);	

	m_itemsList.SetImageList(aplGetInstImageList(), LVSIL_SMALL);	
	m_itemsList.SetExtendedStyle(m_itemsList.GetExtendedStyle()|LVS_EX_FULLROWSELECT|
		LVS_EX_SUBITEMIMAGES);
	
	int i= 0;

	if(0==m_mode)
	{
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(" "), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(" "), LVCFMT_LEFT, 100);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_RIGHT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 70);	
		m_itemsList.InsertColumn(i++,  APL_T("\\"), LVCFMT_LEFT, 100);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(" "), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_RIGHT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);
		
		SetWindowText( APL_T("  "));
	}
	else if(1==m_mode)
	{
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 30);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 100);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_RIGHT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 70);	
		m_itemsList.InsertColumn(i++,  APL_T("\\"), LVCFMT_LEFT, 100);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_RIGHT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);	
		m_itemsList.InsertColumn(i++,  APL_T(""), LVCFMT_LEFT, 50);			
		
		SetWindowText( APL_T("    "));
	}

//	m_itemsList.SetColumnDate(0);
	
	m_whereUsedList.SetExtendedStyle(m_whereUsedList.GetExtendedStyle()|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
	m_whereUsedList.SetImageList(&m_chngImageList, LVSIL_SMALL);
	m_whereUsedList.InsertColumn(0,  APL_T(" "), LVCFMT_LEFT, 500);
	
	CString buf;
	int j;
	
	m_itemAddBtn.EnableWindow(FALSE);
	m_itemChngBtn.EnableWindow(FALSE);
	m_itemDeleteBtn.EnableWindow(FALSE);

	m_nextEditBtn.EnableWindow(FALSE);

	m_itemClearBtn.EnableWindow(FALSE);
	m_itemPropBtn.EnableWindow(FALSE);
	

	if(m_api && apidata.IsConnected())
	{
		//  
		apidata.GetEntityExtent(m_api->m_prd_mgr.e_pd_context, m_contexts);
		for(int i=0; i<m_contexts.GetSize(); i++)
		{
			apidata.GetAttr(m_contexts[i], m_api->m_prd_mgr.a_pd_context_name, buf);
			j= m_contCtrl.AddString(buf);
			m_contCtrl.SetItemData(j, (long)m_contexts[i]);
		}
		m_iCont=m_contCtrl.AddString( APL_T(" "));
		m_contCtrl.SetItemData(m_iCont, 0);

		// 
		if(!m_assPdf)
		{
			CaplInstance* inst= NULL;
			if(m_psc) apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_changed_product, inst);		
			if(!inst) inst= m_pscInfo.m_pdr;
			
			if(inst)
			{
				if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_apl_pdf)) m_assPdf= inst;
				else if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_pdr)) 
					apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdr_r_ting, m_assPdf);
			}

			if(m_assPdf)
			{
				m_itemAddBtn.EnableWindow();
				apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
				if(inst)
				{
					apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, m_sProductId);
					apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, m_sProductName);
				}
				apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_id, m_sProductVer);
				
				m_itemAddBtn.EnableWindow();
			}
		}
		
		UpdateData(FALSE);
		OnChg2AssRefresh();

//		if(0==m_mode)m_api->m_prd_mgr.LoadAllSubProduct(0, 0, m_assPdf, m_extRels, m_extPdfs);
//		else if(1==m_mode)m_api->m_prd_mgr.LoadAllZagotov(m_assPdf, m_extRels, m_extPdfs);
//
//		FillAssemblyData();
	}

	if(m_bDateSelected)	m_dateCtrl.EnableWindow();
	else m_dateCtrl.EnableWindow(FALSE);
	
	if(m_bReadOnly)
	{
		m_itemAddBtn.EnableWindow(FALSE);
		m_selectBtn.EnableWindow(FALSE);
		m_okBtn.EnableWindow(FALSE);
	}

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAssemblyChangeDlg::OnOK() 
{
	for(int i= 0; i<m_newestItems.GetSize(); i++)
	{
		m_newItems->Add(m_newestItems[i]);
	}

	CResizableDialog::OnOK();
}

void CAssemblyChangeDlg::OnCancel() 
{

	CResizableDialog::OnCancel();
}

void CAssemblyChangeDlg::OnDblclkChg2ItemsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CString buf;
	if(-1!=m_index) buf= m_itemsList.GetItemText(m_index, 5);
	if(!buf.IsEmpty()) OnChg2Prop();
	*pResult = 0;
}

void CAssemblyChangeDlg::OnItemchangedChg2AssemblyList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	CString buf;
	m_curPSC= NULL;
	m_curPSCInfo= NULL;
	
	m_whereUsedList.DeleteAllItems();
	m_nextEditBtn.EnableWindow(FALSE);

	if(pNMListView->uNewState==3)
	{
		m_index= pNMListView->iItem;
		buf= m_itemsList.GetItemText(m_index, 5);
		m_curItem= (CaplInstance*)m_itemsList.GetItemData(m_index);

		if(m_curItem && apidata.IsKindOf(m_curItem, m_api->m_prd_mgr.e_pdr))
		{
			CaplInstance* inst= NULL;
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_pdr_r_ted, inst);
			if(inst)
			{
				aplExtent rels, ext;
				m_api->m_prd_mgr.WhereUsedProduct(inst, rels, ext);
				
				aplExtent inListExt; 
				int num= 0;

				for(int i=0; i<rels.GetSize(); i++)
				{
					if(m_mode==0 && !m_api->m_data.IsKindOf(rels[i], m_api->m_prd_mgr.e_acu)) continue;
					if(m_mode==1 && !m_api->m_data.IsKindOf(rels[i], m_api->m_prd_mgr.e_make_from)) continue;

					inst= NULL;
					apidata.GetAttr(rels[i], m_api->m_prd_mgr.a_pdr_r_ting, inst);
					if(inst && -1==inListExt.Find(inst))
					{
						inListExt.Add(inst);

						CString name, buf;
						CaplInstance* prd= NULL;
						apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdf_prd, prd);
						if(prd)
						{
							apidata.GetAttr(prd, m_api->m_prd_mgr.a_prd_id, name);
							apidata.GetAttr(prd, m_api->m_prd_mgr.a_prd_name, buf);
							if(!name.IsEmpty()) name+=_T(":"); name+=buf;
						}
						apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdf_id, buf);
						if(!name.IsEmpty()) name+=_T(":"); name+=buf;
						int ico= -1;
						if(inst==m_assPdf) ico= 4;
						if(!name.IsEmpty())
						{
							m_whereUsedList.InsertItem(num, name, ico);
							m_whereUsedList.SetItemData(num, (DWORD)rels[i]);
							num++;
						}
					}
				}
			}
		}
	}
	else
	{
		m_index= -1;
		m_curItem= NULL;
	}

	m_itemChngBtn.EnableWindow(FALSE);
	m_itemDeleteBtn.EnableWindow(FALSE);

	m_itemClearBtn.EnableWindow(FALSE);
	m_itemPropBtn.EnableWindow(FALSE);
	
	if(buf== APL_T(""))
	{
		if(!m_bReadOnly)
		{
			m_itemClearBtn.EnableWindow();
			m_itemDeleteBtn.EnableWindow();
		}

		m_itemPropBtn.EnableWindow();		
	}
	else if(buf== APL_T(""))
	{
		if(!m_bReadOnly)
			m_itemClearBtn.EnableWindow();
		
		m_itemPropBtn.EnableWindow();	
	}
	else if(buf== APL_T(""))
	{
		if(!m_bReadOnly)
		{
			m_itemClearBtn.EnableWindow();		
			m_itemChngBtn.EnableWindow();
		}

		m_itemPropBtn.EnableWindow();
	}
	else
	{
		if(m_index!=-1 && !m_bReadOnly)
		{
			m_itemChngBtn.EnableWindow();
			m_itemDeleteBtn.EnableWindow();
		}
	}

	*pResult = 0;
}

void CAssemblyChangeDlg::OnChg2AssSelect() 
{
	UpdateData();

	CaplInstance*  inst= m_api->m_change_mgr.SelectInstance(APL_MODE_SELECT_PDF, 
		 APL_T("   "));
	if(inst)
	{
		m_assPdf= inst;
		apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
		if(inst)
		{
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, m_sProductId);
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, m_sProductName);
		}
		apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_id, m_sProductVer);
		UpdateData(FALSE);	

		m_itemAddBtn.EnableWindow();
		OnChg2AssRefresh();
	}
}

void CAssemblyChangeDlg::OnChg2DateCheck() 
{
	UpdateData();
	if(m_bDateSelected)	m_dateCtrl.EnableWindow();
	else m_dateCtrl.EnableWindow(FALSE);
}

void CAssemblyChangeDlg::OnChg2SnCheck() 
{
	UpdateData();
	if(m_bSNSelected)	m_sn.SetReadOnly(FALSE);
	else m_sn.SetReadOnly();	
}
////////////////////////////////////////////////////
void CAssemblyChangeDlg::OnChg2ItemAdd() 
{
	CChangeParamDlg dlg;
	dlg.m_api= m_api;
	dlg.m_mode= m_mode;
	dlg.m_upLevelPdf= m_assPdf;

	dlg.m_sEffType= m_sEffType;
	dlg.m_sStart= m_sStartCond;
	dlg.m_sEnd= m_sEndCond;

	dlg.m_parent_pdf=m_assPdf;

	if(IDOK==dlg.DoModal())
	{
		CPSCItemInfo info;
		info.m_pdr= m_assPdf;
		info.m_pdf= dlg.m_newPdf;
		info.m_sId= dlg.m_sRegNum;
		info.m_sName= dlg.m_sPdrName;
		info.m_sDscr= dlg.m_sPdrDscr;
		info.m_sPosition= dlg.m_sPosition;
		info.m_sPositionNum= dlg.m_sPositionNum;
		info.m_value= dlg.m_iValue;
		info.m_unit= dlg.m_unitInst;
		
		info.m_sEffType= dlg.m_sEffType;
		info.m_sStartCond= dlg.m_sStart;
		info.m_sEndCond= dlg.m_sEnd;
		
		info.m_der_unit= dlg.m_derUnitInst;
		info.m_der_value= dlg.m_iDerValue;

		info.m_sort= dlg.m_assortment;
		info.m_prior= dlg.m_iPrior;
		info.m_razmer= dlg.m_sZagotov;
		info.m_tehTreb= dlg.m_sCondition;
		info.m_contexts.Append(dlg.m_contexts);

		m_newestItems.Add(info);
		FillAssemblyData();
	}
}

void CAssemblyChangeDlg::OnChg2ItemChange() 
{
	CChangeParamDlg dlg;
	dlg.m_api= m_api;
	dlg.m_mode= m_mode;
	
	dlg.m_sType= _T("change");
	
	dlg.m_sEffType= m_sEffType;
	dlg.m_sStart= m_sStartCond;
	dlg.m_sEnd= m_sEndCond;

	dlg.m_parent_pdf=m_assPdf;
	
	bool bNew= false;
	if(!FindItem(&dlg))// ,   
	{
		bNew= true;
		//       pdr
		if(0==m_mode)
		{
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_pdr_id, dlg.m_sPosition);
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_acu_ref_des, dlg.m_sPositionNum);
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_apl_qacu_value, dlg.m_iValue);
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_apl_qacu_unit, dlg.m_unitInst);
		}
		else if(1==m_mode)
		{
			m_api->m_data.GetAttr(m_curItem, m_api->m_prd_mgr.a_make_from_ranking, dlg.m_iPrior);
//			m_api->m_data.GetAttrBN(m_curItem, _T("value_component"), dlg.m_iValue);
//			m_api->m_data.GetAttrBN(m_curItem, _T("unit_component"), dlg.m_unitInst);
		}
	}
	if(IDOK==dlg.DoModal())
	{
		if(bNew)
		{
			CPSCItemInfo info;
			info.m_pdr= m_curItem;
			info.m_pdf= dlg.m_newPdf;
			info.m_sId= dlg.m_sRegNum;
			info.m_sName= dlg.m_sPdrName;
			info.m_sDscr= dlg.m_sPdrDscr;
			info.m_sPosition= dlg.m_sPosition;
			info.m_sPositionNum= dlg.m_sPositionNum;
			info.m_value= dlg.m_iValue;
			info.m_unit= dlg.m_unitInst;
			
			info.m_sEffType= dlg.m_sEffType;
			info.m_sStartCond= dlg.m_sStart;
			info.m_sEndCond= dlg.m_sEnd;
		
			info.m_der_unit= dlg.m_derUnitInst;
			info.m_der_value= dlg.m_iDerValue;

			info.m_sort= dlg.m_assortment;
			info.m_prior= dlg.m_iPrior;
			info.m_razmer= dlg.m_sZagotov;
			info.m_tehTreb= dlg.m_sCondition;			
			
			info.SetContexts(dlg.m_contexts);

			aplExtent ext;
			apidata.GetAttr(m_curItem, m_api->m_prd_mgr.a_pdr_frames_of_reference, ext);
			info.SetAttachment(ext);
			
			m_newestItems.Add(info);			
		}
		FillAssemblyData();
	}
}

void CAssemblyChangeDlg::OnChg2ItemDelete() 
{
	CChangeParamDlg dlg;
	if(!FindItem(&dlg))
	{//   
		dlg.m_api= m_api;
		dlg.m_mode= m_mode;

		dlg.m_sType= _T("delete");
	
		dlg.m_sEffType= m_sEffType;
		dlg.m_sStart= m_sStartCond;
		dlg.m_sEnd= m_sEndCond;

		dlg.m_parent_pdf=m_assPdf;
		
		if(IDOK==dlg.DoModal())
		{
			CPSCItemInfo info;
			info.m_pdr= m_curItem;
			info.m_pdf= NULL;
			info.m_sId= dlg.m_sRegNum;
			info.m_sPosition= _T("");
			info.m_sPositionNum= _T("");
			info.m_value= 0;
			info.m_unit= NULL;
			
			info.m_der_unit= 0;
			info.m_der_value= NULL;

			info.m_sort= NULL;
			info.m_prior= 0;
			info.m_razmer= _T("");
			info.m_tehTreb= _T("");			
			
			info.m_sEffType= dlg.m_sEffType;
			info.m_sStartCond= dlg.m_sStart;
			info.m_sEndCond= dlg.m_sEnd;
						
			m_newestItems.Add(info);
		}
	} 
	else// ,   
	{
		CaplInstance* inst= NULL;
		if(m_curPSC) 
		{
			apidata.PutAttr(m_curPSC, m_api->m_change_mgr.a_psc_changing_product, (CaplInstance*)NULL);
			apidata.PutAttr(m_curPSC, m_api->m_change_mgr.a_psc_position, _T(""));
			apidata.PutAttr(m_curPSC, m_api->m_change_mgr.a_psc_value, 0.0);
			apidata.PutAttr(m_curPSC, m_api->m_change_mgr.a_psc_unit, inst);

			if(m_api->m_data.IsKindOf(m_curPSC, m_api->m_change_mgr.e_mat))
			{
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_assort, (CaplInstance*)NULL);
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_der_unit, (CaplInstance*)NULL);
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_der_value, 0.0);
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_renking, 0);
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_requir, _T(""));
				m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_size, _T(""));
			}
		}
		else if(m_curPSCInfo) 
		{
			m_curPSCInfo->m_pdf= inst;
			m_curPSCInfo->m_sPosition= _T("");
			m_curPSCInfo->m_sPositionNum= _T("");
			m_curPSCInfo->m_value= 0;
			m_curPSCInfo->m_unit= NULL;
			
			m_curPSCInfo->m_der_unit= 0;
			m_curPSCInfo->m_der_value= NULL;

			m_curPSCInfo->m_sort= NULL;
			m_curPSCInfo->m_prior= 0;
			m_curPSCInfo->m_razmer= _T("");
			m_curPSCInfo->m_tehTreb= _T("");			
		}
	}
	FillAssemblyData();
}

void CAssemblyChangeDlg::OnChg2Prop() 
{
	CChangeParamDlg dlg;
	dlg.m_api= m_api;
	dlg.m_mode= m_mode;
	dlg.m_bReadOnly= m_bReadOnly;
	dlg.m_change= m_change;

	dlg.m_parent_pdf=m_assPdf;

	CString buf= m_itemsList.GetItemText(m_index, (m_mode==0)?5:4);
	if(buf== APL_T("")) dlg.m_sType= _T("delete");
	else if(buf== APL_T("")) dlg.m_sType= _T("change");

	FindItem(&dlg);

	if(IDOK==dlg.DoModal())
	{
		FillAssemblyData();
	}
}

void CAssemblyChangeDlg::OnChg2Clear() 
{
	if(IDYES==MessageBox( APL_T("      ?"),
		 APL_T(""), MB_YESNO|MB_ICONWARNING))
	{
		FindItem(NULL, true);
		FillAssemblyData();
	}
}
////////////////////////////////////////////////////
void CAssemblyChangeDlg::OnChg2AssRefresh() 
{
	UpdateData();

	if(0==m_mode)m_api->m_prd_mgr.LoadAllSubProduct(0, 0, m_assPdf, m_extRels, m_extPdfs);		
	else if(1==m_mode)m_api->m_prd_mgr.LoadAllZagotov(m_assPdf, m_extRels, m_extPdfs);
	aplExtent ext;
	if(m_bDateSelected)
	{
		m_api->m_prd_mgr.FilterlByDate(m_extRels, m_oleDate, ext);
		m_extRels.Clear();
		for(int i= 0; i<ext.GetSize(); i++) m_extRels.Add(ext[i]);
		ext.Clear();
	}
	if(m_bSNSelected)
	{
		m_api->m_prd_mgr.FilterlBySN(m_extRels, m_sSN, ext);
		m_extRels.Clear(); 
		for(int i= 0; i<ext.GetSize(); i++) m_extRels.Add(ext[i]);
		ext.Clear();
	}
	
	CaplInstance* cont= (CaplInstance*)m_contCtrl.GetItemData(m_contCtrl.GetCurSel());

	if(cont)
	{
		for(int i= 0; i<m_extRels.GetSize(); i++)
		{
			if(!m_api->m_prd_mgr.IsItemInContext(m_extRels[i], cont, m_api->m_prd_mgr.a_pdr_frames_of_reference))
			{
				m_extRels.Remove(i);
				i--;
				continue;
			}
		}
	}
	FillAssemblyData();
}
////////////////////////////////////////////////////
bool CAssemblyChangeDlg::FillAssemblyData()
{
	m_itemsList.DeleteAllItems();
	int i;

	if(m_assPdf)
	{		
		CaplInstance* inst;
		CString name, buf;
		int index= -1;
		int iLN= 1;

		for(i= 0; i<m_extRels.GetSize(); i++)
		{
			iLN= 1;
			
			CaplInstance* inst2= NULL;
			apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_pdr_r_ted, inst2);
			
			if(!inst2 || !inst2->GetId() || !inst2->GetType()) continue;
			if(inst2->GetAccessmode()>aplRO) continue;
			
			UINT prdIcon= GetPdfIcon(inst2);

			apidata.GetAttr(inst2, m_api->m_prd_mgr.a_pdf_prd, inst);
			if(inst)
			{
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, name);
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, buf);
				if(!name.IsEmpty()) name+=_T(":"); name+=buf;
			}
			apidata.GetAttr(inst2, m_api->m_prd_mgr.a_pdf_id, buf);
			if(!name.IsEmpty()) name+=_T(":"); name+=buf;
			
			if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_qacu_nauo))
			{
				apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_pdr_id, buf);
			}
			else if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_make_from))
			{
				int iRank;
				apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_make_from_ranking, iRank);
				buf.Format(_T("%i"), iRank);
			}

			while (buf.GetLength()<4)
				buf= _T(" ")+buf;

			++index; int ind= m_itemsList.InsertItem(index, buf, prdIcon);
			m_itemsList.SetItemData(ind, (DWORD)m_extRels[i]);
			if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_qacu_nauo))
			{
				apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_acu_ref_des, buf);
				m_itemsList.SetItemText(ind, iLN++, buf);
			}
			
			m_itemsList.SetItemText(ind, iLN++, name);
			
			double dbl;
			apidata.GetAttrBN(m_extRels[i], _T("value_component"), dbl);
			apidata.GetAttrBN(m_extRels[i], _T("unit_component"), inst);
			buf= _T("");
			if(inst)
			{
				m_api->m_charact_mgr.GetUnitName(inst, buf);
//				m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, buf);
			}
			
			if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_qacu_nauo))
			{
				name.Format(_T("%g [%s]"), dbl, buf);
			}
			else if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_make_from))
			{
				double der_dbl;
				CaplInstance* der_unit= NULL;
				CString sUnitName;

				apidata.GetAttrBN(m_extRels[i], _T("derive_value_component"), der_dbl);
				apidata.GetAttrBN(m_extRels[i], _T("derive_unit_component"), der_unit);
				if(der_unit)
				{
					m_api->m_charact_mgr.GetUnitName(der_unit, sUnitName);
//					m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, sUnitName);
				}
				
//				name.Format(_T("%4.2f %s -> %4.2f %s"), dbl, buf, der_dbl, sUnitName);
				name.Format(_T("%g [%s]"), dbl, buf);
			}
			
			m_itemsList.SetItemText(index, iLN++, name);
			
			if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_qacu_nauo))
			{
				aplExtent aggr;
				apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_pdr_frames_of_reference, aggr);
				m_api->m_change_mgr.PrintItemContextInString(aggr, name);
				if(name.IsEmpty()) name=  APL_T(" ");
			}
			else if(m_api->m_data.IsKindOf(m_extRels[i], m_api->m_prd_mgr.e_make_from))
			{
				name=_T("");
				CaplInstance* assort= NULL;
				apidata.GetAttr(m_extRels[i], m_api->m_prd_mgr.a_make_from_assortment, assort);
				if(assort)
				{
					CString sBuf;
//					apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_id, name);
					apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_name, sBuf);
					if(!sBuf.IsEmpty()){if(!name.IsEmpty()) name+=_T(":"); name+=sBuf;}
				}
			}
			
			m_itemsList.SetItemText(index, iLN++, name);
			
			bool bFind= false;
			bool bContinue= true;

			CaplInstance* newPdf= NULL, *unit= NULL;
			CString sEffType, sStart, sEnd, sType, sPos, sPosNum, sPrior;
			double dCount= 1;

			for(int j= 0; j<m_items->GetSize(); j++)
			{
				bContinue= true;
				CaplInstance* item= m_items->GetAt(j);
				
				if(-1!=m_delItems->Find(item)) continue;
				
				CaplInstance* pdr_pdf= NULL, *new_pdr= NULL, *inst1= NULL;
				
				buf=_T("");
				
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_changed_product, pdr_pdf);
				if(apidata.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_apl_pdf)) {sType=  APL_T("");}
				else if(apidata.IsKindOf(pdr_pdf, m_api->m_prd_mgr.e_pdr)){sType=  APL_T("");}				
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_changing_product, newPdf);
				if(!newPdf) sType=  APL_T("");
				
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_created_pdr, new_pdr);
				if(m_extRels[i]==new_pdr)//      
				{
					// ,    
					bFind= true;
					bContinue= false;
					m_itemsList.DeleteItem(index);index--;
					break;
				}
				else if(m_extRels[i]==pdr_pdf)
				{
					bFind= true;
					
					if(newPdf)
					{
						if(0==m_mode)
						{
							apidata.GetAttr(item, m_api->m_change_mgr.a_psc_position, sPos);					
							apidata.GetAttr(item, m_api->m_change_mgr.a_psc_position_num, sPosNum);					
							apidata.GetAttr(item, m_api->m_change_mgr.a_psc_value, dCount);
							apidata.GetAttr(item, m_api->m_change_mgr.a_psc_unit, unit);
						}
						else if(1==m_mode)
						{
							CString sBuf; int iPrior;
							CaplInstance* assort= NULL;
							m_api->m_data.GetAttr(item, m_api->m_change_mgr.a_mat_assort, assort);
							if(assort)
							{
								m_api->m_data.GetAttr(assort, m_api->m_prd_mgr.a_assortment_name, sBuf);
								if(!sBuf.IsEmpty()){if(!sPos.IsEmpty()) sPos+=_T(":"); sPos+=sBuf;}									
							}
							m_api->m_data.GetAttr(item, m_api->m_change_mgr.a_psc_value, dCount);
							m_api->m_data.GetAttr(item, m_api->m_change_mgr.a_psc_unit, unit);
							m_api->m_data.GetAttr(item, m_api->m_change_mgr.a_mat_renking, iPrior);
							
							sPrior.Format(_T("%i"), iPrior);
						}
					}
					apidata.GetAttr(item, m_api->m_change_mgr.a_psc_eff_type, sEffType);
					if(sEffType==_T("dated"))
					{
						apidata.GetAttr(item, m_api->m_change_mgr.a_psc_start_date, sStart);
						apidata.GetAttr(item, m_api->m_change_mgr.a_psc_end_date, sEnd);
					}
					else if(sEffType==_T("numbered"))
					{
						apidata.GetAttr(item, m_api->m_change_mgr.a_psc_start_num, sStart);
						apidata.GetAttr(item, m_api->m_change_mgr.a_psc_end_num, sEnd);
					}
					break;
				}
			}//for(int i= 0; i<m_items->GetSize(); i++)
			if(!bFind)
			{
				for(int j= 0; j<m_newItems->GetSize(); j++)
				{
					if(apidata.IsKindOf(m_newItems->GetAt(j).m_pdr, m_api->m_prd_mgr.e_apl_pdf)) 
						sType=  APL_T("");
					else if(apidata.IsKindOf(m_newItems->GetAt(j).m_pdr, m_api->m_prd_mgr.e_pdr))
						sType=  APL_T("");
					
					if(!m_newItems->GetAt(j).m_pdf) {newPdf= NULL; sType=  APL_T("");}
					else newPdf= m_newItems->GetAt(j).m_pdf;
					
					if(m_extRels[i]==m_newItems->GetAt(j).m_pdr)
					{
						bFind= true;
						if(newPdf)
						{
							if(0==m_mode)
							{
								sPos= m_newItems->GetAt(j).m_sPosition;
								sPosNum= m_newItems->GetAt(j).m_sPositionNum; 
								dCount= m_newItems->GetAt(j).m_value;
								unit= m_newItems->GetAt(j).m_unit;
							}
							else if(1==m_mode)
							{
								CString sBuf;
								CaplInstance* assort= m_newItems->GetAt(j).m_sort;
								if(assort)
								{
//									apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_id, sPos);
									apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_name, sBuf);
									if(!sBuf.IsEmpty()){if(!sPos.IsEmpty()) sPos+=_T(":"); sPos+=sBuf;}									
								}
								
								sPrior.Format(_T("%i"), m_newItems->GetAt(j).m_prior);

								dCount= m_newItems->GetAt(j).m_value;
								unit= m_newItems->GetAt(j).m_unit;
							}
						}
						
						sEffType= m_newItems->GetAt(j).m_sEffType;
						sStart= m_newItems->GetAt(j).m_sStartCond;
						sEnd= m_newItems->GetAt(j).m_sEndCond;

						break;
					}
				}
			}

			if(!bFind)
			{//   
				for(int j= 0; j<m_newestItems.GetSize(); j++)
				{
					if(apidata.IsKindOf(m_newestItems.GetAt(j).m_pdr, m_api->m_prd_mgr.e_apl_pdf)) 
						sType=  APL_T("");
					else if(apidata.IsKindOf(m_newestItems.GetAt(j).m_pdr, m_api->m_prd_mgr.e_pdr))
						sType=  APL_T("");
					
					if(!m_newestItems.GetAt(j).m_pdf){newPdf= NULL; sType=  APL_T("");}
					else newPdf= m_newestItems.GetAt(j).m_pdf;
					
					if(m_extRels[i]==m_newestItems.GetAt(j).m_pdr)
					{
						bFind= true;
						if(newPdf)
						{
							if(0==m_mode)
							{
								sPos= m_newestItems.GetAt(j).m_sPosition;
								sPosNum= m_newestItems.GetAt(j).m_sPositionNum;
								dCount= m_newestItems.GetAt(j).m_value;
								unit= m_newestItems.GetAt(j).m_unit;
							}
							else if(m_mode==1)
							{
								CString sBuf;
								CaplInstance* assort= m_newestItems.GetAt(j).m_sort;
								if(assort)
								{
				//					apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_id, sPos);
									apidata.GetAttr(assort, m_api->m_prd_mgr.a_assortment_name, sBuf);
									if(!sBuf.IsEmpty()){if(!sPos.IsEmpty()) sPos+=_T(":"); sPos+=sBuf;}								
								}
								
								sPrior.Format(_T("%i"), m_newestItems.GetAt(j).m_prior);

								dCount= m_newestItems.GetAt(j).m_value;
								unit= m_newestItems.GetAt(j).m_unit;
							}
								
						}
						sEffType= m_newestItems.GetAt(j).m_sEffType;
						sStart= m_newestItems.GetAt(j).m_sStartCond;
						sEnd= m_newestItems.GetAt(j).m_sEndCond;

						break;
					}
				}
			}

			if(bFind && bContinue)
			{
				m_itemsList.SetItemText(index, iLN++, sType);
				InsertText(index, iLN, newPdf, dCount, unit, sPos, sPosNum, sEffType, sStart, sEnd, sPrior);
			}
		}
		
		//,        
		//  -  
		CaplInstance *pdr_pdf= NULL, 
			*newPdf= NULL, 
			*unit= NULL;
		CString sEffType, sStart, sEnd, sType, sPos, sPosNum, sPrior;
		double dCount= 1;
		int n;
		for(n= 0; n<m_items->GetSize(); n++)
		{
			iLN=(m_mode==0)?5:4;
			CaplInstance* item= m_items->GetAt(n);
			
			if(-1!=m_delItems->Find(item)) continue;

			apidata.GetAttr(item, m_api->m_change_mgr.a_psc_changed_product, pdr_pdf);
			if(m_assPdf==pdr_pdf)
			{
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_changing_product, newPdf);
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_position, sPos);					
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_position_num, sPosNum);					
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_value, dCount);
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_unit, unit);
				apidata.GetAttr(item, m_api->m_change_mgr.a_psc_eff_type, sEffType);
				if(sEffType==_T("dated"))
				{
					apidata.GetAttr(item, m_api->m_change_mgr.a_psc_start_date, sStart);
					apidata.GetAttr(item, m_api->m_change_mgr.a_psc_end_date, sEnd);
				}
				else if(sEffType==_T("numbered"))
				{
					apidata.GetAttr(item, m_api->m_change_mgr.a_psc_start_num, sStart);
					apidata.GetAttr(item, m_api->m_change_mgr.a_psc_end_num, sEnd);
				}
				
				if(1==m_mode)
				{
					int iPrior;
					m_api->m_data.GetAttr(item, m_api->m_change_mgr.a_mat_renking, iPrior);
					sPrior.Format(_T("%i"), iPrior);
				}

//				UINT prdIcon= GetPdfIcon(newPdf);
				
				++index; m_itemsList.InsertItem(index, _T(""), -1);
				m_itemsList.SetItemData(index, (DWORD)newPdf);
				m_itemsList.SetItemText(index, iLN++,  APL_T(""));				
				InsertText(index, iLN, newPdf, dCount, unit, sPos, sPosNum, sEffType, sStart, sEnd, sPrior);
				i++;
			}
		}

		for(n= 0; n<m_newItems->GetSize(); n++)
		{
			iLN=(m_mode==0)?5:4;
			if(m_assPdf==m_newItems->GetAt(n).m_pdr)
			{
//				UINT prdIcon= GetPdfIcon(m_newItems->GetAt(n).m_pdf);

				++index; m_itemsList.InsertItem(index, _T(""), -1);				
				m_itemsList.SetItemData(i, (DWORD)m_newItems->GetAt(n).m_pdf);
				m_itemsList.SetItemText(i, iLN++,  APL_T(""));				
				
				sPrior.Format(_T("%i"), m_newItems->GetAt(n).m_prior);
				
				InsertText(index, iLN, m_newItems->GetAt(n).m_pdf, 
					m_newItems->GetAt(n).m_value, m_newItems->GetAt(n).m_unit, 
					m_newItems->GetAt(n).m_sPosition, 
					m_newItems->GetAt(n).m_sPositionNum, 
					m_newItems->GetAt(n).m_sEffType, 
					m_newItems->GetAt(n).m_sStartCond, 
					m_newItems->GetAt(n).m_sEndCond,
					sPrior);				
				i++;
			}
		}

		for(n= 0; n<m_newestItems.GetSize(); n++)
		{
			iLN=(m_mode==0)?5:4;
			if(m_assPdf==m_newestItems.GetAt(n).m_pdr)
			{
//				UINT prdIcon= GetPdfIcon(m_newestItems.GetAt(n).m_pdf);

				++index; m_itemsList.InsertItem(index, _T(""), -1);
				m_itemsList.SetItemData(index, (DWORD)m_newestItems.GetAt(n).m_pdf);
				m_itemsList.SetItemText(index, iLN++,  APL_T(""));				
				
				sPrior.Format(_T("%i"), m_newestItems.GetAt(n).m_prior);
				
				InsertText(index, iLN, m_newestItems.GetAt(n).m_pdf, 
					m_newestItems.GetAt(n).m_value, m_newestItems.GetAt(n).m_unit, 
					m_newestItems.GetAt(n).m_sPosition, 
					m_newestItems.GetAt(n).m_sPositionNum, 
					m_newestItems.GetAt(n).m_sEffType, 
					m_newestItems.GetAt(n).m_sStartCond, 
					m_newestItems.GetAt(n).m_sEndCond,
					sPrior);
				
				i++;
			}			
		}
	}

	return true;
}

void CAssemblyChangeDlg::InsertText(int num, int nextInd, CaplInstance* newPdf, double dCount, CaplInstance* unit, 
		CString sPos, CString sPosNum, CString sEffType, CString sStart, CString sEnd,
		CString sPrior)
{
	CaplInstance* inst;
	CString buf, name;

	while(sPos.GetLength()<4)
		sPos=_T(" ")+sPos;

	if(newPdf)
	{
		if(!newPdf->attrs!=0)m_api->m_prd_mgr.LoadPrdInfo(newPdf);
		int prdIcon= GetPdfIcon(newPdf);
		apidata.GetAttr(newPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
		if(inst)
		{
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, name);
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, buf);
			if(!name.IsEmpty()) name+=_T(":"); name+=buf;
		}
		apidata.GetAttr(newPdf, m_api->m_prd_mgr.a_pdf_id, buf);
		if(!name.IsEmpty()) name+=_T(":"); name+=buf;
		
		m_itemsList.SetItemText(num, nextInd, name);		
		m_itemsList.SetItem(num, nextInd++, LVIF_IMAGE, name, prdIcon, 0, 0, 0);
				
		int index= 6;
		if(1==m_mode) index++;
		
		if(unit)
		{
			m_api->m_charact_mgr.GetUnitName(unit, name);
//			m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, name);
		}
		buf.Format(_T("%g [%s]"), dCount, name);
		
		if(0==m_mode)
		{
			m_itemsList.SetItemText(num, nextInd++, sPos);
			m_itemsList.SetItemText(num, nextInd++, sPosNum);
			m_itemsList.SetItemText(num, nextInd++, buf);
			m_itemsList.SetItemText(num, nextInd++, PrintEffectivityInString
				(sEffType, sStart, sEnd));
			
		}
		else if(1==m_mode)
		{
			m_itemsList.SetItemText(num, nextInd++, sPrior);
			m_itemsList.SetItemText(num, nextInd++, buf);
			m_itemsList.SetItemText(num, nextInd++, sPos);
			m_itemsList.SetItemText(num, nextInd++, PrintEffectivityInString
				(sEffType, sStart, sEnd));
		}
	}

}

CString CAssemblyChangeDlg::PrintEffectivityInString(CString type, CString start, CString end)
{
	CString buf= _T("");
	
	if(type==_T("none"))
	{
		buf=  APL_T("   ");
	}
	else if(type==_T("dated"))
	{
		COleDateTime odt;
		if(!start.IsEmpty())
		{
			aplString2Date(start, odt);
			buf=  APL_T(": ") + odt.Format(_T("%d:%m:%Y %H:%M:%S"));
		}
		if(!end.IsEmpty())
		{
			aplString2Date(end, odt);
			buf+= APL_T(" : ") + odt.Format(_T("%d:%m:%Y %H:%M:%S"));				
		}		
	}
	else if(type==_T("numbered"))
	{
		if(!start.IsEmpty())
		{
			buf=  APL_T(": ") + start;
		}
		if(!end.IsEmpty())
		{
			buf+= APL_T(" : ") + end;				
		}		
	}

	return buf;
}

///////////////////////////////////////////////////
void CAssemblyChangeDlg::OnDatetimechangeChg2DateCtrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
	m_refreshBtn.EnableWindow();
	*pResult = 0;
}

void CAssemblyChangeDlg::OnChangeChg2SnCtrl()
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	m_refreshBtn.EnableWindow();
}

void CAssemblyChangeDlg::OnCloseupChg2ContextCombo() 
{
	m_refreshBtn.EnableWindow();	
}
///////////////////////////////////////////////////
bool CAssemblyChangeDlg::FindItem(CChangeParamDlg *dlg, bool bDelete)
{
	bool bFind= false;
	m_curPSC= NULL;
	m_curPSCInfo= NULL;
	int i;

	for(i= 0; i<m_items->GetSize(); i++)
	{
		CaplInstance* inst= m_items->GetAt(i);

		CaplInstance* pdr= NULL, *pdf= NULL;
		CString sPos;
		CString buf= m_itemsList.GetItemText(m_index, (m_mode==0)?7:6);
		buf.TrimRight();buf.TrimLeft();

		apidata.GetAttr(inst, m_api->m_change_mgr.a_psc_changed_product, pdr);
		apidata.GetAttr(inst, m_api->m_change_mgr.a_psc_changing_product, pdf);
		if(0==m_mode) apidata.GetAttr(inst, m_api->m_change_mgr.a_psc_position, sPos);
		else if(1==m_mode)
		{
			int iPrior;
			apidata.GetAttr(inst, m_api->m_change_mgr.a_mat_renking, iPrior);
			sPos.Format(_T("%i"), iPrior);
		}

		
		if(m_curItem==pdr || (pdr==m_assPdf && m_curItem==pdf && !buf.CompareNoCase(sPos)))
		{//      pdf,    
			bFind= true;
			m_curPSC= inst;
			if(dlg)dlg->m_psc= inst;
			if(bDelete) m_delItems->Add(inst);
			break;
		}
	}
	
	if(!bFind)
	{
		for(i= 0; i<m_newItems->GetSize(); i++)
		{
			CString buf= m_itemsList.GetItemText(m_index, (m_mode==0)?7:6);
			buf.TrimRight();buf.TrimLeft();
			CString buf1;
			
			if(0==m_mode) buf1= m_newItems->GetAt(i).m_sPosition;
			else if(1==m_mode)buf1.Format(_T("%i"), m_newItems->GetAt(i).m_prior);
			if(m_curItem==m_newItems->GetAt(i).m_pdr || 
				(m_curItem==m_newItems->GetAt(i).m_pdf &&
					!buf.CompareNoCase(buf1)))
			{//      pdf,    
				bFind= true;
				m_curPSCInfo= &m_newItems->ElementAt(i);
				if(dlg)	dlg->m_pscInfo= &m_newItems->ElementAt(i);
				if(bDelete) m_newItems->RemoveAt(i);
				break;
			}
		}
	}
	if(!bFind)
	{
		for(i= 0; i<m_newestItems.GetSize(); i++)
		{
			CString buf= m_itemsList.GetItemText(m_index, (m_mode==0)?7:6);
			buf.TrimRight();buf.TrimLeft();
			CString buf1;

			if(0==m_mode) buf1= m_newestItems.GetAt(i).m_sPosition;
			else if(1==m_mode)buf1.Format(_T("%i"), m_newestItems.GetAt(i).m_prior);
			
			if(m_curItem==m_newestItems.GetAt(i).m_pdr || 
				(m_curItem==m_newestItems.GetAt(i).m_pdf &&
					!buf.CompareNoCase(buf1)))
			{//      pdf,    
				bFind= true;
				m_curPSCInfo= &m_newestItems.ElementAt(i);
				if(dlg)	dlg->m_pscInfo= &m_newestItems.ElementAt(i);
				if(bDelete) m_newestItems.RemoveAt(i);
				break;
			}
		}
	}

	return bFind;
}

void CAssemblyChangeDlg::OnChg2SetEff() 
{
	CChangeParamDlg dlg;	
	dlg.m_sType= _T("eff_type");	
	
	dlg.m_sEffType= m_sEffType;
	dlg.m_sStart= m_sStartCond;
	dlg.m_sEnd= m_sEndCond;

	dlg.m_parent_pdf=m_assPdf;
	
	if(IDOK==dlg.DoModal())
	{
		m_sEffType= dlg.m_sEffType;
		m_sStartCond= dlg.m_sStart;
		m_sEndCond= dlg.m_sEnd;
	}	
}

void CAssemblyChangeDlg::OnDblclkChg2WhereUseList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int index= m_whereUsedList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);	
	OnChg2NewAssembly();
	*pResult = 0;
}

void CAssemblyChangeDlg::OnItemchangedChg2WhereUseList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	m_nextEditBtn.EnableWindow(FALSE);
	if(pNMListView->uNewState==3)//
	{
		int ind= pNMListView->iItem;
		if(-1!=ind) m_nextEditBtn.EnableWindow();
	}
	
	*pResult = 0;
}

void CAssemblyChangeDlg::OnChg2NewAssembly() 
{
	UpdateData();	
	
	int ind= m_whereUsedList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);	
	if(-1!=ind)
	{
		CaplInstance* inst= NULL, *prd= NULL;
		inst= (CaplInstance*)m_whereUsedList.GetItemData(ind);
		
		apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdr_r_ting, prd);

		if(prd)
		{
			m_assPdf= prd;
			apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
			if(inst)
			{
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, m_sProductId);
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, m_sProductName);
			}
			apidata.GetAttr(m_assPdf, m_api->m_prd_mgr.a_pdf_id, m_sProductVer);
			UpdateData(FALSE);	
			
			if(!m_bReadOnly) m_itemAddBtn.EnableWindow();
			
			OnChg2AssRefresh();
		}
	}
}
