#if !defined(AFX_ASSEMBLYCHANGEDLG_H__2ACF210C_48DA_420F_94BC_8876E3037E8D__INCLUDED_)
#define AFX_ASSEMBLYCHANGEDLG_H__2ACF210C_48DA_420F_94BC_8876E3037E8D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// AssemblyChangeDlg.h : header file
//
#include "ResizableDialog.h"

#include "resource.h"
#include "apl_gui.h"
#include "CommonChangeClasses.h"
#include "apl_api.h"

class CChangeParamDlg;
/////////////////////////////////////////////////////////////////////////////
// CAssemblyChangeDlg dialog
 
class CAssemblyChangeDlg : public CResizableDialog
{
// Construction
public:
	CAssemblyChangeDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CAssemblyChangeDlg)
	enum { IDD = IDD_CHANGE_ASS_DIALOG };
	CSortListCtrl	m_whereUsedList;
	CSortListCtrl m_itemsList;
	CaplButton	m_okBtn;
	CaplButton	m_cancelBtn;
	CaplButton	m_refreshBtn;
	CaplButton	m_selectBtn;
	CaplButton	m_nextEditBtn;
	CButton	m_setEffBtn;
	CButton	m_itemPropBtn;
	CButton	m_itemClearBtn;
	CaplButton	m_itemDeleteBtn;
	CaplButton	m_itemAddBtn;
	CaplButton	m_itemChngBtn;
	CEdit	m_sn;
	CDateTimeCtrl	m_dateCtrl;
	CComboBox	m_contCtrl;
	CString	m_sProductName;
	CString	m_sContext;
	CString	m_sEffectivity;
	CString	m_sProductId;
	CString	m_sProductVer;
	int		m_iCont;
	BOOL	m_bDateSelected;
	COleDateTime	m_oleDate;
	BOOL	m_bSNSelected;
	CString	m_sSN;
	//}}AFX_DATA
	
	long m_mode;
	CaplAPI *m_api;
	
	CaplInstance* m_change;

	CaplInstance* m_psc;// 
	CPSCItemInfo m_pscInfo;// 

	aplExtent *m_items; //,     
	CArray<CPSCItemInfo, CPSCItemInfo> *m_newItems; // 
	CArray<CPSCItemInfo, CPSCItemInfo> m_newestItems; //:))  
	aplExtent *m_delItems; // 

	aplExtent m_contexts;// 

	CaplInstance* m_assPdf; //
	//  
	aplExtent m_extPdfs;//   
	aplExtent m_extRels;//
	aplRealArray m_extCounts;//-
	aplExtent m_extUnits;//..

	CImageList m_imageList;
	CImageList m_chngImageList;
	int GetPdfIcon(CaplInstance* pdf);
	
	CaplInstance* m_curItem;
	int m_index;
	CaplInstance* m_curPSC;
	CPSCItemInfo* m_curPSCInfo;
	
	//    
	CString m_sEffType;
	CString m_sStartCond;
	CString m_sEndCond;

	bool m_bReadOnly; // " "
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAssemblyChangeDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	bool FillAssemblyData();
	CString PrintEffectivityInString(CString type, CString start, CString end);
	void InsertText(int num, int nextInd, CaplInstance* newPdf, double dCount, CaplInstance* unit, 
		CString sPos, CString sPosNum, CString sEffType, CString sStart, CString sEnd, CString sPrior= _T(""));
	
	bool FindItem(CChangeParamDlg *dlg, bool bDelete= false);
	

	// Generated message map functions
	//{{AFX_MSG(CAssemblyChangeDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnItemchangedChg2AssemblyList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkChg2ItemsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChg2ItemAdd();
	afx_msg void OnChg2ItemChange();
	afx_msg void OnChg2ItemDelete();
	afx_msg void OnChg2Clear();
	afx_msg void OnChg2DateCheck();
	afx_msg void OnChg2SnCheck();
	afx_msg void OnCloseupChg2ContextCombo();
	afx_msg void OnChg2AssRefresh();
	afx_msg void OnDatetimechangeChg2DateCtrl(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChangeChg2SnCtrl();
	afx_msg void OnChg2Prop();
	afx_msg void OnChg2AssSelect();
	afx_msg void OnChg2SetEff();
	afx_msg void OnDblclkChg2WhereUseList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemchangedChg2WhereUseList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChg2NewAssembly();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ASSEMBLYCHANGEDLG_H__2ACF210C_48DA_420F_94BC_8876E3037E8D__INCLUDED_)
