// BaseFrame.cpp : implementation file
//

#include "stdafx.h"
#include "BaseFrame.h"
#include "ClassifierTreeFrame.h"
#include "ClassifierTableFrame.h"
#include "ClassifierTreeView.h"
#include "ClassifierTableItemsView.h"
#include "PictureView.h"
#include <afxpriv.h>
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBaseFrame

#define UI_UPDATE_TIMER WM_USER+65

IMPLEMENT_DYNCREATE(CBaseFrame, CFrameWnd)

CBaseFrame::CBaseFrame()
{
	m_Mode = 0;
}

CBaseFrame::CBaseFrame(UINT Mode)
{
	m_Mode = Mode;
}

CBaseFrame::~CBaseFrame()
{
}


BEGIN_MESSAGE_MAP(CBaseFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CBaseFrame)
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseFrame message handlers

BOOL CBaseFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CRect rect;
	GetClientRect(&rect);
	if(m_Mode&APL_HIDE_TABLE)
	{
		if(m_Mode&APL_HIDE_ESQUISSE)
		{
			CCreateContext cont;
			CView *pView;
			if(pContext==NULL)
			{
				cont.m_pNewViewClass = RUNTIME_CLASS(CClassifierTreeView);
				pView = (CView*)CreateView(&cont);
			}
			else
			{
				pContext->m_pNewViewClass = RUNTIME_CLASS(CClassifierTreeView);
				pView = (CView*)CreateView(pContext);
			}
			SetActiveView(pView);
		}
		else
		{
			m_wndVSplitter.CreateStatic(this, 2, 1);
			m_wndVSplitter.CreateView(0, 0, RUNTIME_CLASS(CClassifierTreeFrame), CSize(200,300), pContext);
			m_wndVSplitter.CreateView(1, 0, RUNTIME_CLASS(CPictureView), CSize(200,150), pContext);
			((CView*)m_wndVSplitter.GetPane(1,0))->SendMessage(WM_INITIALUPDATE);
		}
	}
	else
	{
		m_wndHSplitter.CreateStatic(this, 1, 2);
		
		if(m_Mode&APL_HIDE_ESQUISSE)
		{
			m_wndHSplitter.CreateView(0, 0, RUNTIME_CLASS(CClassifierTreeFrame), CSize(200,300), pContext);
			m_wndHSplitter.CreateView(0, 1, RUNTIME_CLASS(CClassifierTableFrame), CSize(200,200), pContext);
		}
		else
		{
			m_wndVSplitter.CreateStatic(&m_wndHSplitter, 2, 1, WS_CHILD|WS_VISIBLE, m_wndHSplitter.IdFromRowCol(0,0));
			m_wndVSplitter.CreateView(0, 0, RUNTIME_CLASS(CClassifierTreeFrame), CSize(200,300), pContext);
			m_wndVSplitter.CreateView(1, 0, RUNTIME_CLASS(CPictureView), CSize(200,150), pContext);
			m_wndHSplitter.CreateView(0, 1, RUNTIME_CLASS(CClassifierTableFrame), CSize(200,200), pContext);
			((CView*)m_wndVSplitter.GetPane(1,0))->SendMessage(WM_INITIALUPDATE);
		}
	}

	return TRUE;
}

void CBaseFrame::OnSize(UINT nType, int cx, int cy) 
{
	bool isMainNoIconic=true;
	CWnd *mainWnd=AfxGetMainWnd();
	if(0!=mainWnd)isMainNoIconic=!mainWnd->IsIconic();

	if(isMainNoIconic && ::IsWindow(m_wndHSplitter.m_hWnd) && ::IsWindow(m_wndVSplitter.m_hWnd) && ((GetParent() && !GetParent()->IsIconic()) || (!GetParent() && !IsIconic())))
	{
		int vpos, tmp;
		
		m_wndVSplitter.GetRowInfo(1, vpos, tmp);

		CFrameWnd::OnSize(nType, cx, cy);

		int dy = 0;
		dy = 11;
		m_wndVSplitter.SetRowInfo(0, cy-vpos-dy<0 ? 0 : cy-vpos-dy, 0);
		m_wndVSplitter.SetRowInfo(1, vpos, 0);
		m_wndVSplitter.RecalcLayout();
	}
	else
		CFrameWnd::OnSize(nType, cx, cy);

}

int CBaseFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if(m_Mode&APL_HIDE_ESQUISSE && m_Mode&APL_HIDE_TABLE)
	{
		if (!m_wndToolBar.CreateEx(this,TBSTYLE_FLAT, WS_CHILD|WS_VISIBLE|CBRS_TOP|
			CBRS_NOALIGN| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
			CRect(0,0,0,0), AFX_IDW_TOOLBAR) ||
			!m_wndToolBar.LoadToolBar(IDR_CLASSIFIER_TREE_TB))
		{
			TRACE0("Failed to create toolbar\n");
			return -1;      // fail to create
		}
		
		m_wndToolBar.EnableToolTips();
		
		
		CBitmap bm;
		bm.LoadBitmap(IDB_ELEMBAR16);
		m_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
		m_il.Add(&bm, RGB(192,192,192));
		bm.DeleteObject();
		m_wndToolBar.GetToolBarCtrl().SetImageList(&m_il);
		
		HIMAGELIST tmp_il1=aplImageListCopyAsSpecificBlend((HIMAGELIST)(*m_wndToolBar.GetToolBarCtrl().GetImageList()),35,true);//,RGB(255,255,255));
		m_ild.Attach(tmp_il1);
		m_wndToolBar.GetToolBarCtrl().SetDisabledImageList(&m_ild);

		m_wndToolBar.GetToolBarCtrl().DeleteButton(0);
		m_wndToolBar.GetToolBarCtrl().DeleteButton(0);
	}

	if(lpCreateStruct->style&WS_CHILD)
		SetTimer(UI_UPDATE_TIMER, 100, NULL);
	
	if(lpCreateStruct->style&WS_MAXIMIZE)
	{
		ShowWindow(SW_MAXIMIZE);
		MoveWindow(lpCreateStruct->x, lpCreateStruct->y, lpCreateStruct->cx, lpCreateStruct->cy, FALSE);
	}

	return 0;
}

void CBaseFrame::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent==UI_UPDATE_TIMER)
		SendMessageToDescendants(WM_IDLEUPDATECMDUI, 0, 0, TRUE, TRUE);
	
	CFrameWnd::OnTimer(nIDEvent);
}

bool CBaseFrame::Init(CaplAPI *api, CaplInstance* BaseClassifierSystem)
{
	CClassifierTableItemsView *pTableView = NULL;
	CClassifierTreeView*	pTreeView = NULL;

	//if(!(m_Mode&APL_HIDE_TABLE))
	if(m_wndHSplitter.GetColumnCount()>1)
	{
		pTableView = ((CClassifierTableItemsView*)((CFrameWnd*)(m_wndHSplitter.GetPane(0, 1)))->GetActiveView());
		pTableView->m_api = api;
		pTableView->m_Mode = m_Mode;

		((CClassifierTableFrame*)(m_wndHSplitter.GetPane(0, 1)))->SetMode(m_Mode);
		
		int k=200;
		CWinApp *app=AfxGetApp(); //    ActiveX  0
		if(0!=app) k=app->GetProfileInt(_T("Classifiers Settings"), _T("HSplitterWidth"), 200);

		m_wndHSplitter.SetColumnInfo(0, k, 0);
		m_wndHSplitter.RecalcLayout();
	}

	if(m_Mode&APL_HIDE_ESQUISSE)
	{
		if(!(m_Mode&APL_HIDE_TABLE))
		{
			pTreeView = (CClassifierTreeView*)((CFrameWnd*)(m_wndHSplitter.GetPane(0, 0)))->GetActiveView();
			((CClassifierTreeFrame*)(m_wndHSplitter.GetPane(0, 0)))->SetMode(m_Mode);
		}
		else
			pTreeView = (CClassifierTreeView*)GetActiveView();
	}
	else
	{
		pTreeView = (CClassifierTreeView*)((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView();
// 		pTreeView->m_api = api;
// 		pTreeView->m_pTableView = pTableView;
		pTreeView->m_pPictureView = (CPictureView*)m_wndVSplitter.GetPane(1, 0);
		
		((CClassifierTreeFrame*)(m_wndVSplitter.GetPane(0, 0)))->SetMode(m_Mode);
		
		pTreeView->m_pPictureView->SendMessage(WM_INITIALUPDATE);

		int k=150;
		CWinApp *app=AfxGetApp(); //    ActiveX  0
		if(0!=app) k=app->GetProfileInt(_T("Classifiers Settings"), _T("VSplitterHeigth"), 150);
		
		m_wndVSplitter.SetRowInfo(1, k, 0);
		m_wndVSplitter.RecalcLayout();
	}

	if(BaseClassifierSystem!=NULL)
		pTreeView->m_BaseSystems.Add(BaseClassifierSystem);
	pTreeView->m_api = api;
	pTreeView->m_pTableView = pTableView;
	pTreeView->SendMessage(WM_INITIALUPDATE);

	//if(!(m_Mode&APL_HIDE_TABLE))
	if(m_wndHSplitter.GetColumnCount()>1)
		((CFrameWnd*)(m_wndHSplitter.GetPane(0, 1)))->GetActiveView()->SendMessage(WM_INITIALUPDATE);
	
	return true;
}

BOOL CBaseFrame::DestroyWindow() 
{
	int cx, tmp;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	
	if(::IsWindow(m_wndHSplitter.m_hWnd)!=NULL)
	{
		m_wndHSplitter.GetColumnInfo(0, cx, tmp);
		if(0!=app) app->WriteProfileInt(_T("Classifiers Settings"), _T("HSplitterWidth"), cx);
	}
	
	if(::IsWindow(m_wndVSplitter.m_hWnd))
	{
		m_wndVSplitter.GetRowInfo(1, cx, tmp);
		if(0!=app) app->WriteProfileInt(_T("Classifiers Settings"), _T("VSplitterHeigth"), cx);
	}
	
	int size = sizeof(RECT);
	BYTE zoomed = IsZoomed()?1:0;
	BYTE *pBytes = new BYTE[size+1];
	if(IsZoomed())
		ShowWindow(SW_NORMAL);
	RECT w_rect;
	GetWindowRect(&w_rect);
	memcpy(pBytes, &w_rect, size);
	pBytes[size] = zoomed;

	if(0!=app) app->WriteProfileBinary(_T("Classifiers Settings"), _T("WindowPosition"), pBytes, sizeof(RECT)+1);

	delete pBytes;
	
	return CFrameWnd::DestroyWindow();
}

BOOL CBaseFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	RECT w_rect;
	BYTE *pBytes = NULL;
	UINT size = sizeof(RECT)+1;
	
	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app) app->GetProfileBinary(_T("Classifiers Settings"), _T("WindowPosition"), &pBytes, &size);
	if(pBytes)
	{
		memcpy(&w_rect, pBytes, sizeof(RECT));
		if(pBytes[sizeof(RECT)]==1)
			cs.style |=WS_MAXIMIZE;
		delete pBytes;

		cs.cx = w_rect.right - w_rect.left;
		cs.cy = w_rect.bottom - w_rect.top;
		cs.x = w_rect.left;
		cs.y = w_rect.top;
	}
	
	return CFrameWnd::PreCreateWindow(cs);
}
