#pragma once
#include "aplstepmanager.h"

#include <set>

#define LDF_DISABLE_FINDCOMPONENTS			0x0001
#define LDF_DISABLE_FIND_LSIINSTANCES		0x0002
#define LDF_DISABLE_FIND_PRODUCT_INSTANCE	0x0004
#define LDF_DISABLE_FIND_LSS_JOBS			0x0008
#define LDF_DISABLE_FIND_CHANGE_RESOURCES	0x0010
#define LDF_DISABLE_FIND_RESOURCE_CORRECT	0x0020
#define LDF_DISABLE_FIND_REFUSALS			0x0040
#define LDF_DISABLE_FIND_BULLETINS			0x0080
#define LDF_DISABLE_FIND_LSS3_COMPONENTS	0x0100
#define LDF_DISABLE_FIND_INSTALLED			0x0200

typedef std::set<int>		TIntSet;
typedef TIntSet::iterator	TIntSet_it;

#define TEST_DEDUCTION_CLASSIFIER_LVL			APL_T("  ")
#define CULPRIT_DEDUCTION_CLASSIFIER_LVL		APL_T("  ")
#define REFUSAL_TYPE_CLASSIFIER_LVL				APL_T(" ")
#define REFUSAL_STAGE_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_CONDITIONS_CLASSIFIER_LVL		APL_T(" ")
#define REFUSAL_DOF_CLASSIFIER_LVL				APL_T(" ")
#define REFUSAL_REASON_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_METHOD_CLASSIFIER_LVL			APL_T(" ")
#define REFUSAL_CONSEQ_CLASSIFIER_LVL			APL_T("")
#define REFUSAL_MANIF_CLASSIFIER_LVL			APL_T("  ")

typedef enum {aplFindPrdInstToRefusal=0, aplFindAllPrdInst, aplFindInstalledPrdInst, aplFindNonused, aplFindItemChilds, aplFindPrdInstCallback} TFindPrdInstModes;
typedef enum {aplFindAllPdf, aplFindPlanerPdf, aplFindSystemPdf, aplFindZonePdf, aplFindPKIPdf, aplFindPdfUserCallback, aplFindPdfById} TFindPdfModes;
typedef enum {aplSelectSystem=0, aplSelectPlanerSystem} TSelectSystemMode;

//////////////////////////////////////////////////////////////////////////
//                           Find PKI Dialog                            //
//////////////////////////////////////////////////////////////////////////
#define APL_FD_SHOW_CREATE_BTN				0x0001	//   ""
#define APL_FD_DISABLE_ID					0x0002
#define APL_FD_DISABLE_NAME					0x0004
#define APL_FD_DISABLE_SN					0x0008
#define APL_FD_USE_SIMPLE_CREATE_DIALOG		0x0010
#define APL_FD_AUTOCREATE					0x0020
#define APL_FD_INCLUDE_ANALOGS				0x0040
#define APL_FD_ONLY_BASE					0x0080	//    (  )

class CLASS_DECL_APL_STEP_MGR CaplPreExploitationMgr : public CaplStepManager
{
public:
	CaplPreExploitationMgr();
	virtual ~CaplPreExploitationMgr();

	/**   (    ) 
	@return true     false    */
	virtual bool			Attach(CaplAPI *api);
	virtual void			Detach();

	// 

	/************************************************************************/
	/*                                                      */
	/************************************************************************/
	CaplEntity*	e_apl_resource_change;
	CaplAttr*	a_apl_rc_type;
	CaplAttr*	a_apl_rc_charact;
	CaplAttr*	a_apl_rc_charact_type;
	CaplAttr*	a_apl_rc_delta;
	CaplAttr*	a_apl_rc_basis;
	CaplAttr*	a_apl_rc_recursive;
	CaplAttr*	a_apl_rc_item;
	CaplAttr*	a_apl_rc_guid;
	/************************************************************************/
	/*                                                                */
	/************************************************************************/
	CaplEntity*	e_apl_refusal;
	CaplAttr*	a_apl_refusal_planer;	//
	CaplAttr*	a_apl_refusal_item;		////
	CaplAttr*	a_apl_refusal_system;		//
	CaplAttr*	a_apl_refusal_part;//,     
	CaplAttr*	a_apl_refusal_date_detection;	// 
	CaplAttr*	a_apl_refusal_date_removal;		// 
	CaplAttr*	a_apl_refusal_type;				//  (/)
	CaplAttr*	a_apl_refusal_conditions;		// 
	CaplAttr*	a_apl_refusal_method;			// 
	CaplAttr*	a_apl_refusal_reason_of_delay;	//  
	CaplAttr*	a_apl_refusal_time_delay;		//   
	CaplAttr*	a_apl_refusal_faultreason;		//
	CaplAttr*	a_apl_refusal_manifestation;	//
	CaplAttr*	a_apl_refusal_dof;				//
	CaplAttr*	a_apl_refusal_faultreg1;		//
	CaplAttr*	a_apl_refusal_faultreg2;		//
	CaplAttr*	a_apl_refusal_faultreg3;		//
	CaplAttr*	a_apl_refusal_faultreg4;		//
	CaplAttr*	a_apl_refusal_disclosuremethod;	//
	CaplAttr*	a_apl_refusal_stafferrorreasen;	//
	CaplAttr*	a_apl_refusal_incident;			//
	CaplAttr*	a_apl_refusal_guid;				//
	CaplAttr*	a_apl_refusal_union_passport_num;	//  

	CaplAttr*	a_apl_refusal_consequences;					//
	CaplAttr*	a_apl_refusal_culprit;						//
	CaplAttr*	a_apl_refusal_description;					// 
	CaplAttr*	a_apl_refusal_accepted_arrangements_str;	//  ()
	CaplAttr*	a_apl_refusal_accepted_arrangements_obj;	//  ()
	CaplAttr*	a_apl_refusal_document_str;					//   ()
	CaplAttr*	a_apl_refusal_document_date;				//   ()
	CaplAttr*	a_apl_refusal_document_obj;					//  ()
	CaplAttr*	a_apl_refusal_certificate_of_compliance_str;//   ()
	CaplAttr*	a_apl_refusal_certificate_of_compliance_date;//   
	CaplAttr*	a_apl_refusal_certificate_of_compliance_obj;//   ()

	CaplAttr*	a_apl_refusal_is_not_confirm;				// 
	CaplAttr*	a_apl_refusal_repair_job;					//  
	CaplAttr*	a_apl_refusal_detect_job;					//,   
	CaplAttr*	a_apl_refusal_pre_condition;	//

	CaplAttr*	a_apl_refusal_state;				// 
	CaplAttr*	a_apl_refusal_stage;				// 
	CaplAttr*	a_apl_refusal_doc_type;				//   (, ,   ..)
	CaplAttr*	a_apl_refusal_doc_num;				//  
	CaplAttr*	a_apl_refusal_doc_date;				//   
	CaplAttr*	a_apl_refusal_org;					// ,   
	CaplAttr*	a_apl_refusal_sector;				// ,   
	CaplAttr*	a_apl_refusal_ext_view;				//    ()
	CaplAttr*	a_apl_refusal_research_first;		//   
	CaplAttr*	a_apl_refusal_research_second;		//   
	CaplAttr*	a_apl_refusal_research_result;		//  
	CaplAttr*	a_apl_refusal_test_deduction;		//   
	CaplAttr*	a_apl_refusal_culprit_deduction;	//   
	CaplAttr*	a_apl_refusal_dispose_data;			//   
	CaplAttr*	a_apl_refusal_result_decision;		//  	
	CaplAttr*	a_apl_refusal_research_act_obj;		// ,  
	CaplAttr*	a_apl_refusal_research_act_str;		//   
	CaplAttr*	a_apl_refusal_research_act_date;	//   
	CaplAttr*	a_apl_refusal_arrangm_act_str;		//    
	CaplAttr*	a_apl_refusal_arrangm_act_date;		//    
	CaplAttr*	a_apl_refusal_arrangm_act_obj;		//   
	CaplAttr*	a_apl_refusal_research_lab;			//   
	CaplAttr*	a_apl_refusal_research_sector;		//  
	CaplAttr*	a_apl_refusal_manifestation_str;	//    
	CaplAttr*	a_apl_refusal_resources_str;		//    
	CaplAttr*	a_apl_refusal_item_lot;				//   ()
	CaplAttr*	a_apl_refusal_part_lot;				//   
	CaplAttr*	a_apl_refusal_parent;				//  
	CaplAttr*	a_apl_refusal_necassary_arrangm;	//   
	CaplAttr*	a_apl_refusal_files;				//   (apl_stored_document)

	CaplAttr*	a_apl_refusal_fed_to_developer;		//  "  "
	CaplAttr*	a_apl_refusal_ignore_in_reliability;//  "     "
	CaplAttr*	a_apl_refusal_developer_comments;	//   

	//   
	CaplAttr*	a_apl_refusal_spec;							//  ( )
	CaplAttr*	a_apl_refusal_det_method;					//   ( )
	CaplAttr*	a_apl_refusal_planer_garantee;				//   ( )
	CaplAttr*	a_apl_refusal_pki_garantee;					//   ( )
	CaplAttr*	a_apl_refusal_search_time;					//    ()
	CaplAttr*	a_apl_refusal_search_labor;					//   ()
	CaplAttr*	a_apl_refusal_removal_time;					//    ()
	CaplAttr*	a_apl_refusal_removal_labor;				//   ()
	CaplAttr*	a_apl_refusal_engine_id;					//  () 
	CaplAttr*	a_apl_refusal_engine_sn;					//   
	CaplAttr*	a_apl_refusal_engine_date_manuf;			//   
	CaplAttr*	a_apl_refusal_engine_derived;				//   
	CaplAttr*	a_apl_refusal_engine_last_repair_derived;	//   
	CaplAttr*	a_apl_refusal_engine_date_last_repair;		//   
	CaplAttr*	a_apl_refusal_engine_manufacturer;			//   
	CaplAttr*	a_apl_refusal_engine_org_last_repair;		//   

	CaplEntity*	e_apl_logbook;
	CaplAttr*	a_apl_logbook_items;
	CaplAttr*	a_apl_logbook_id;
	CaplAttr*	a_apl_logbook_name;
	CaplAttr*	a_apl_logbook_descr;

	/************************************************************************/
	/*                               */
	/************************************************************************/
	CaplEntity* e_apl_export_logbook;
	CaplAttr*	a_apl_export_logbook_oflogbook;
	CaplAttr*	a_apl_export_logbook_language;

	/************************************************************************/
	/*                                                      */
	/************************************************************************/
	CaplEntity*	e_apl_logbook_item;
	CaplAttr*	a_apl_logbook_item_id;
	CaplAttr*	a_apl_logbook_item_name;
	CaplAttr*	a_apl_logbook_item_template;
	CaplAttr*	a_apl_logbook_item_use_to_export;
	CaplAttr*	a_apl_logbook_item_parent;
	CaplAttr*	a_apl_logbook_item_childs;
	CaplAttr*	a_apl_logbook_item_logbook;
	CaplAttr*	a_apl_logbook_item_language;
	CaplAttr*	a_apl_logbook_item_oflogbookitem;
	CaplAttr*	a_apl_logbook_item_descr;
	CaplAttr*	a_apl_logbook_item_edit_type;
	CaplAttr*	a_apl_logbook_item_pages;
	CaplAttr*	a_apl_logbook_item_print_fact_pages;

	CaplEntity*	e_apl_logbook_dsf_item;
	CaplAttr*	a_apl_logbook_dsf_item_defsource;

	CaplEntity*	e_apl_logbook_dll_item;
	CaplAttr*	a_apl_logbook_dll_item_function;
	CaplAttr*	a_apl_logbook_dll_item_dllname;

	CaplEntity*	e_apl_logbook_dsf;
	CaplAttr*	a_apl_logbook_dsf_dsfitem;
	CaplAttr*	a_apl_logbook_dsf_source;
	CaplAttr*	a_apl_logbook_dsf_export_source;
	CaplAttr*	a_apl_logbook_dsf_item;
	/************************************************************************/
	/*                                                                */
	/************************************************************************/
	CaplEntity*	e_apl_logbook_access;
	CaplAttr*	a_apl_logbook_access_person;
	CaplAttr*	a_apl_logbook_access_item;
	CaplAttr*	a_apl_logbook_access_level;
	CaplAttr*	a_apl_logbook_access_context;
	/************************************************************************/
	/*                                                                 */
	/************************************************************************/
	CaplEntity*	e_apl_flier;

	CaplAttr*	a_apl_flier_flier_day;
	CaplAttr*	a_apl_flier_flier;
	CaplAttr*	a_apl_flier_item;
	CaplAttr*	a_apl_flier_parashut_number;
	CaplAttr*	a_apl_flier_fuel_type;
	CaplAttr*	a_apl_flier_fuel_plotnost;
	CaplAttr*	a_apl_flier_fuel_ostatok;
	CaplAttr*	a_apl_flier_fuel_dozaprav;
	CaplAttr*	a_apl_flier_fuel_P;
	CaplAttr*	a_apl_flier_fuel_T;
	CaplAttr*	a_apl_flier_fuel_num_rashod_vedom;
	CaplAttr*	a_apl_flier_maslo_left_eng;
	CaplAttr*	a_apl_flier_maslo_right_eng;
	CaplAttr*	a_apl_flier_maslo_rashod_left_eng;
	CaplAttr*	a_apl_flier_maslo_rashod_right_eng;
	CaplAttr*	a_apl_flier_maslo_amg10_1gs;
	CaplAttr*	a_apl_flier_maslo_amg10_2gs;
	CaplAttr*	a_apl_flier_azot_fonar;
	CaplAttr*	a_apl_flier_azot_avarijn_system;
	CaplAttr*	a_apl_flier_oxygen_base;
	CaplAttr*	a_apl_flier_oxygen_additional;
	CaplAttr*	a_apl_flier_anti_obled_zhidkost;
	CaplAttr*	a_apl_flier_generator_maslo_left;
	CaplAttr*	a_apl_flier_generator_maslo_right;
	CaplAttr*	a_apl_flier_units_of_fire;

	/************************************************************************/
	/*                                                    */
	/************************************************************************/
	CaplEntity*	e_apl_fixing;

	CaplAttr*	a_apl_fixing_person;
	CaplAttr*	a_apl_fixing_item;
	CaplAttr*	a_apl_fixing_fix_basis;
	CaplAttr*	a_apl_fixing_ufix_basis;

	/************************************************************************/
	/*                                                 */
	/************************************************************************/
	CaplEntity*	e_apl_transfer;

	CaplAttr*	a_apl_transfer_item;
	CaplAttr*	a_apl_transfer_date_time_delivered;
	CaplAttr*	a_apl_transfer_date_time_recieved;
	CaplAttr*	a_apl_transfer_state;
	CaplAttr*	a_apl_transfer_basis_obj;
	CaplAttr*	a_apl_transfer_basis_str;
	CaplAttr*	a_apl_transfer_delivered_obj;
	CaplAttr*	a_apl_transfer_recieved_obj;
	CaplAttr*	a_apl_transfer_comment;

	/************************************************************************/
	/*                                                                      */
	/************************************************************************/

	CaplEntity*	e_apl_item_place_group;
	CaplAttr*	a_apl_item_place_group_final_item;
	CaplAttr*	a_apl_item_place_group_id;

	CaplEntity*	e_apl_item_place;
	CaplAttr*	a_apl_item_place_group;
	CaplAttr*	a_apl_item_place_id;
	CaplAttr*	a_apl_item_place_parent_item;
	CaplAttr*	a_apl_item_place_zone;
	CaplAttr*	a_apl_item_place_item;
	CaplAttr*	a_apl_item_place_final_item;

	CaplEntity* e_apl_logbook_state_history;
	CaplAttr*   a_apl_logbook_state_history_new_state;
	CaplAttr*   a_apl_logbook_state_history_old_state;
	CaplAttr*   a_apl_logbook_state_history_date_time;
	CaplAttr*   a_apl_logbook_state_history_person;
	CaplAttr*   a_apl_logbook_state_history_item;
	CaplAttr*	a_apl_logbook_state_history_description;

	/************************************************************************/
	/*                                                                      */
	/************************************************************************/

	CaplEntity	*e_apl_logbook_job_journal_item;
	CaplAttr	*a_apl_logbook_job_journal_item_id;
	CaplAttr	*a_apl_logbook_job_journal_item_state;
	CaplAttr	*a_apl_logbook_job_journal_item_executer;
	CaplAttr	*a_apl_logbook_job_journal_item_date_plan;
	CaplAttr	*a_apl_logbook_job_journal_item_date_fact;
	CaplAttr	*a_apl_logbook_job_journal_item_remove;
	CaplAttr	*a_apl_logbook_job_journal_item_install;
	CaplAttr	*a_apl_logbook_job_journal_item_system;
	CaplAttr	*a_apl_logbook_job_journal_item_zone;
	CaplAttr	*a_apl_logbook_job_journal_item_position;
	CaplAttr	*a_apl_logbook_job_journal_item_planer;
	CaplAttr	*a_apl_logbook_job_journal_item_descr;
	CaplAttr	*a_apl_logbook_job_journal_item_type;
	CaplAttr	*a_apl_logbook_job_journal_item_org;

	/************************************************************************/
	/*																*/
	/************************************************************************/
	CaplEntity	*e_apl_incident;
	CaplAttr	*a_apl_incident_report_incident;
	CaplAttr	*a_apl_incident_report_operative_message;
	CaplAttr	*a_apl_incident_id;
	CaplAttr	*a_apl_incident_date;
	CaplAttr	*a_apl_incident_category;
	CaplAttr	*a_apl_incident_airport;
	CaplAttr	*a_apl_incident_planer;
	CaplAttr	*a_apl_incident_department;
	CaplAttr	*a_apl_incident_system;
	CaplAttr	*a_apl_incident_flight_crew;
	CaplAttr	*a_apl_incident_engine;
	CaplAttr	*a_apl_incident_conditions;
	CaplAttr	*a_apl_incident_reason;
	CaplAttr	*a_apl_incident_description;
	CaplAttr	*a_apl_incident_group;
	CaplAttr	*a_apl_incident_situation;
	CaplAttr	*a_apl_incident_revision_number;
	CaplAttr	*a_apl_incident_user;
	CaplAttr	*a_apl_incident_revision_date;
	CaplAttr	*a_apl_incident_refusals;
	CaplAttr	*a_apl_incident_next_version;
	CaplAttr	*a_apl_incident_name;
	CaplAttr	*a_apl_incident_date_gmt;
	CaplAttr	*a_apl_incident_state;
	CaplAttr	*a_apl_incident_location;
	CaplAttr	*a_apl_incident_flight_phase;
	CaplAttr	*a_apl_incident_ground;
	CaplAttr	*a_apl_incident_class;
	CaplAttr	*a_apl_incident_damage_aircraft;
	CaplAttr	*a_apl_incident_damage_aerodrome;
	CaplAttr	*a_apl_incident_damage_third_party;
	CaplAttr	*a_apl_incident_injury_level;
	CaplAttr	*a_apl_incident_flight;
	CaplAttr	*a_apl_incident_report_date;
	CaplAttr	*a_apl_incident_report_org;
	CaplAttr	*a_apl_incident_report_investigate;
	CaplAttr	*a_apl_incident_victims_number;
	CaplAttr	*a_apl_incident_meteo;
	CaplAttr	*a_apl_incident_status;

	/************************************************************************/
	/*							  						*/
	/************************************************************************/
	CaplEntity	*e_apl_incident_info;
	CaplAttr	*a_apl_incident_info_incident;
	CaplAttr	*a_apl_incident_info_id;
	CaplAttr	*a_apl_incident_info_kind;
	CaplAttr	*a_apl_incident_info_date;
	CaplAttr	*a_apl_incident_info_org;
	CaplAttr	*a_apl_incident_info_description;
	CaplAttr	*a_apl_incident_info_parent;

	/************************************************************************/
	/*							 						*/
	/************************************************************************/
	CaplEntity	*e_apl_incident_element;
	CaplAttr	*a_apl_incident_element_incident;
	CaplAttr	*a_apl_incident_element_parent;
	CaplAttr	*a_apl_incident_element_id;
	CaplAttr	*a_apl_incident_element_type;
	CaplAttr	*a_apl_incident_element_code;
	CaplAttr	*a_apl_incident_element_modifier;
	CaplAttr	*a_apl_incident_element_mission_phase;
	CaplAttr	*a_apl_incident_element_description;

	/************************************************************************/
	/*							 								*/
	/************************************************************************/
	CaplEntity	*e_apl_crew;
	CaplAttr	*a_apl_crew_id;
	CaplAttr	*a_apl_crew_role;
	CaplAttr	*a_apl_crew_certification;
	CaplAttr	*a_apl_crew_rating;
	CaplAttr	*a_apl_crew_qualification;
	CaplAttr	*a_apl_crew_time_total;
	CaplAttr	*a_apl_crew_time_fi;
	CaplAttr	*a_apl_crew_time_total_90days;
	CaplAttr	*a_apl_crew_time_fi_90days;
	CaplAttr	*a_apl_crew_incident;

	/************************************************************************/
	/*							 ( )				*/
	/************************************************************************/
	CaplEntity	*e_apl_bulletin;
	CaplAttr	*a_apl_bulletin_bp;
	CaplAttr	*a_apl_bulletin_status;
	CaplAttr	*a_apl_bulletin_reason;
	CaplAttr	*a_apl_bulletin_solution;
	CaplAttr	*a_apl_bulletin_jobs_begin_date;
	CaplAttr	*a_apl_bulletin_jobs_end_date;
	CaplAttr	*a_apl_bulletin_jobs_labor;
	CaplAttr	*a_apl_bulletin_jobs_finance;
	CaplAttr	*a_apl_bulletin_jobs_place;
	CaplAttr	*a_apl_bulletin_jobs_place_orgs;
	CaplAttr	*a_apl_bulletin_jobs_place_description;
	CaplAttr	*a_apl_bulletin_jobs_execute;
	CaplAttr	*a_apl_bulletin_jobs_execute_orgs;
	CaplAttr	*a_apl_bulletin_jobs_execute_description;

	/************************************************************************/
	/*																	*/
	/************************************************************************/
	CaplEntity	*e_apl_solution;
	CaplAttr	*a_apl_solution_id;
	CaplAttr	*a_apl_solution_date;
	CaplAttr	*a_apl_solution_bulletin;

	/************************************************************************/
	/*                              Bulletin  ( )           */
	/************************************************************************/
	CaplEntity  *e_ils_bulletin;
	CaplAttr	*a_ils_bulletin_number;
	CaplAttr	*a_ils_bulletin_date;
	CaplAttr	*a_ils_bulletin_code;
	CaplAttr	*a_ils_bulletin_status;
	CaplAttr	*a_ils_bulletin_reason;
	CaplAttr	*a_ils_bulletin_jobs_begin_date;
	CaplAttr	*a_ils_bulletin_jobs_end_date;
	CaplAttr	*a_ils_bulletin_jobs_labor;
	CaplAttr	*a_ils_bulletin_jobs_finance;
	CaplAttr	*a_ils_bulletin_jobs_place;
	CaplAttr	*a_ils_bulletin_jobs_place_orgs;
	CaplAttr	*a_ils_bulletin_jobs_place_description;
	CaplAttr	*a_ils_bulletin_jobs_execute;
	CaplAttr	*a_ils_bulletin_jobs_execute_orgs;
	CaplAttr	*a_ils_bulletin_jobs_execute_description;
	CaplAttr	*a_ils_bulletin_guid;
	CaplAttr	*a_ils_bulletin_max_working_hours;
	CaplAttr	*a_ils_bulletin_max_exploitation_hours;
	CaplAttr	*a_ils_bulletin_solution_id;
	CaplAttr	*a_ils_bulletin_solution_date;
	CaplAttr	*a_ils_bulletin_id;
	CaplAttr	*a_ils_bulletin_name;
	CaplAttr	*a_ils_bulletin_conditions;
	CaplAttr	*a_ils_bulletin_developer;
	CaplAttr	*a_ils_by_contract;
	CaplAttr	*a_ils_by_receive;
	CaplAttr	*a_ils_bulletin_max_working_flights;
	CaplAttr	*a_ils_bulletin_kind;
	CaplAttr	*a_ils_bulletin_jobs_plan;
	CaplAttr	*a_ils_bulletin_urgent;
	CaplAttr	*a_ils_bulletin_apply_date;
	CaplAttr	*a_ils_bulletin_demand_doc_change;
	CaplAttr	*a_ils_bulletin_parent;
	CaplAttr	*a_ils_bulletin_part_of_doc;

	/************************************************************************/
	/*								Bulletin reference                      */
	/************************************************************************/
	CaplEntity	*e_ils_bulletin_ref;
	CaplAttr	*a_ils_bulletin_ref_bulletin;
	CaplAttr	*a_ils_bulletin_ref_product;
	CaplAttr	*a_ils_bulletin_ref_guid;
	CaplAttr	*a_ils_bulletin_ref_date;
	CaplAttr	*a_ils_bulletin_ref_type;

	/************************************************************************/
	/*                         ils_base_product_instance                    */
	/************************************************************************/
	CaplEntity*	e_ils_base_product_instance;
	CaplAttr*	a_ils_base_product_instance_of_ils_base_product;
	CaplAttr*	a_ils_base_product_instance_serial_number;
	CaplAttr*	a_ils_base_product_instance_id;
	CaplAttr*	a_ils_base_product_instance_description;
	CaplAttr*	a_ils_base_product_instance_developer;
	CaplAttr*	a_ils_base_product_instance_manufacturer;
	CaplAttr*	a_ils_base_product_instance_provider;
	CaplAttr*	a_ils_base_product_instance_date_manufacture;
	CaplAttr*	a_ils_base_product_instance_state;
	CaplAttr*	a_ils_base_product_instance_guid;
	CaplAttr*	a_ils_base_product_instance_not_check_composition;
	CaplAttr*	a_ils_base_product_instance_date_change_check_composition;
	CaplAttr*	a_ils_base_product_instance_owner;
	CaplAttr*	a_ils_base_product_instance_operator;
	CaplAttr*	a_ils_base_product_instance_exploit_type;
	CaplAttr*	a_ils_base_product_instance_contract_number;
	CaplAttr*	a_ils_base_product_instance_contract_date;
	CaplAttr*	a_ils_base_product_instance_date_start_garantee;
	CaplAttr*	a_ils_base_product_instance_airport;
	CaplAttr*	a_ils_base_product_instance_person_change_check_composition;
	CaplAttr*	a_ils_base_product_instance_config;
	CaplAttr*	a_ils_base_product_instance_date_provide;
	CaplAttr*	a_ils_base_product_instance_individual_resource;
	CaplAttr*	a_ils_base_product_instance_auto;
	CaplAttr*	a_ils_base_product_instance_software_version;
	CaplAttr*	a_ils_base_product_instance_control_type;
	CaplAttr*	a_ils_base_product_instance_control_value;
	CaplAttr*	a_ils_base_product_instance_date_recalc;
	CaplAttr*	a_ils_base_product_instance_reg_num;
	CaplAttr*	a_ils_base_product_instance_date_registration;
	CaplAttr*	a_ils_base_product_instance_workability_date_begin;
	CaplAttr*	a_ils_base_product_instance_workability_date_end;
	CaplAttr*	a_ils_base_product_instance_workability_date_renewal;
	CaplAttr*	a_ils_base_product_instance_date_start_operate;
	CaplAttr*	a_ils_base_product_instance_repair_org;
	CaplAttr*	a_ils_base_product_instance_date_last_repair;
	CaplAttr*	a_ils_base_product_instance_amount_repairs;
	CaplAttr*	a_ils_base_product_instance_status;
	CaplAttr*	a_ils_base_product_instance_delivery_contract;
	CaplAttr*	a_ils_base_product_instance_current_status;
	CaplAttr*	a_ils_base_product_instance_pass_number;
	CaplAttr*	a_ils_base_product_instance_pass_id;
	CaplAttr*	a_ils_base_product_instance_folder_number;
	CaplAttr*	a_ils_base_product_instance_topfull;
	CaplAttr*	a_ils_base_product_instance_of_product_revision;
	CaplAttr*	a_ils_base_product_instance_hide_sn;
	CaplAttr*	a_ils_base_product_instance_delivery_part_number;
	CaplAttr*	a_ils_base_product_instance_date_garantee_void_fact;
	CaplAttr*	a_ils_base_product_instance_fnn;
	CaplAttr*	a_ils_base_product_instance_pss_instance;
	CaplAttr*	a_ils_base_product_instance_expl_doc_type;
	CaplAttr*	a_ils_base_product_instance_amount;
	CaplAttr*	a_ils_base_product_instance_short_description;
	CaplAttr*   a_ils_base_product_instance_has_composition;
	CaplAttr*	a_ils_base_product_instance_id_ext;

	/************************************************************************/
	/*							                         */
	/************************************************************************/
	CaplEntity	*e_apl_recovery_point;
	CaplAttr	*a_apl_recovery_point_id;
	CaplAttr	*a_apl_recovery_point_user_session_id;

	/************************************************************************/
	/*                         LSS REFUSAL		                            */
	/************************************************************************/
	CaplEntity	*e_lss_refusal;
	CaplAttr	*a_lss_refusal_id;
	CaplAttr	*a_lss_refusal_planer;
	CaplAttr	*a_lss_refusal_system;
	CaplAttr	*a_lss_refusal_system_inst;
	CaplAttr	*a_lss_refusal_system_real_component;
	CaplAttr	*a_lss_refusal_item;
	CaplAttr	*a_lss_refusal_date_detected;
	CaplAttr	*a_lss_refusal_date_removal;
	CaplAttr	*a_lss_refusal_kun_number;
	CaplAttr	*a_lss_refusal_kun_date;
	CaplAttr	*a_lss_refusal_type;
	CaplAttr	*a_lss_refusal_type_for_system;
	CaplAttr	*a_lss_refusal_manifestation;
	CaplAttr	*a_lss_refusal_manifestation_eng;
	CaplAttr	*a_lss_refusal_stage_detection;
	CaplAttr	*a_lss_refusal_stage_detection_lvl;
	CaplAttr	*a_lss_refusal_consequence;
	CaplAttr	*a_lss_refusal_consequence_lvl;
	CaplAttr	*a_lss_refusal_exception;
	CaplAttr	*a_lss_refusal_detection_form;
	CaplAttr	*a_lss_refusal_detection_confirm;
	CaplAttr	*a_lss_refusal_incident_type;
	CaplAttr	*a_lss_refusal_delay;
	CaplAttr	*a_lss_refusal_delay_reason;
	CaplAttr	*a_lss_refusal_form_removal;
	CaplAttr	*a_lss_refusal_search_job_duration;
	CaplAttr	*a_lss_refusal_search_job_idle;
	CaplAttr	*a_lss_refusal_search_job_labor;
	CaplAttr	*a_lss_refusal_search_job_cost;
	//CaplAttr	*a_lss_refusal_repair_job_labor;
	CaplAttr	*a_lss_refusal_removal_job_duration;
	CaplAttr	*a_lss_refusal_removal_job_spare_parts_idle;
	CaplAttr	*a_lss_refusal_removal_job_other_idle;
	CaplAttr	*a_lss_refusal_removal_job_labor;
	CaplAttr	*a_lss_refusal_removal_job_staff_cost;
	CaplAttr	*a_lss_refusal_removal_job_spare_parts_cost;
	CaplAttr	*a_lss_refusal_removal_job_total_cost;
	CaplAttr	*a_lss_refusal_item_manifestation;
	CaplAttr	*a_lss_refusal_item_reason;
	CaplAttr	*a_lss_refusal_accepted_arrangements;
	CaplAttr	*a_lss_refusal_method;
	CaplAttr	*a_lss_refusal_description;
	CaplAttr	*a_lss_refusal_temperature;
	CaplAttr	*a_lss_refusal_humidity;
	CaplAttr	*a_lss_refusal_pressure;
	CaplAttr	*a_lss_refusal_recovery_time;
	CaplAttr	*a_lss_refusal_element_block;
	CaplAttr	*a_lss_refusal_element_node;
	CaplAttr	*a_lss_refusal_element_subblock;
	CaplAttr	*a_lss_refusal_element_group;
	CaplAttr	*a_lss_refusal_element_scheme_number;
	CaplAttr	*a_lss_refusal_defective_items;
	CaplAttr	*a_lss_refusal_planer_serial_number;
	CaplAttr	*a_lss_refusal_planer_repair_count;
	CaplAttr	*a_lss_refusal_planer_last_repair_date;
	CaplAttr	*a_lss_refusal_planer_last_repair_executer;
	CaplAttr	*a_lss_refusal_item_serial_number;
	CaplAttr	*a_lss_refusal_item_manufacturer;
	CaplAttr	*a_lss_refusal_item_date_manufactured;
	CaplAttr	*a_lss_refusal_item_repair_count;
	CaplAttr	*a_lss_refusal_item_last_repair_date;
	CaplAttr	*a_lss_refusal_item_last_repair_executer;
	CaplAttr	*a_lss_refusal_item_last_install_date;
	CaplAttr	*a_lss_refusal_item_reason_determined;
	CaplAttr	*a_lss_refusal_item_type;
	CaplAttr	*a_lss_refusal_item_of_manufacturer;
	CaplAttr	*a_lss_refusal_mission_failure;
	CaplAttr	*a_lss_refusal_mission;
	CaplAttr	*a_lss_refusal_confirmed;
	CaplAttr	*a_lss_refusal_consider_in_analyse;
	CaplAttr	*a_lss_refusal_refused_instance;
	CaplAttr	*a_lss_refusal_reason_lvl;
	CaplAttr	*a_lss_refusal_reason_description;
	CaplAttr	*a_lss_refusal_reason_description_eng;
	CaplAttr	*a_lss_refusal_preliminary_cause_lvl;
	CaplAttr	*a_lss_refusal_preliminary_cause_description;
	CaplAttr	*a_lss_refusal_preliminary_cause_description_eng;
	CaplAttr	*a_lss_refusal_ext_manifistation_lvl;
	CaplAttr	*a_lss_refusal_conditions_lvl;
	CaplAttr	*a_lss_refusal_remedy_lvl;
	CaplAttr	*a_lss_refusal_remedy_description;
	CaplAttr	*a_lss_refusal_led_to_incident;
	CaplAttr	*a_lss_refusal_nature_lvl;
	CaplAttr	*a_lss_refusal_precipitation_lvl;
	CaplAttr	*a_lss_refusal_lifecycle_stage_lvl;
	CaplAttr	*a_lss_refusal_hash;
	CaplAttr	*a_lss_refusal_comment;
	CaplAttr	*a_lss_refusal_comment_eng;
	CaplAttr	*a_lss_refusal_act_number;
	CaplAttr	*a_lss_refusal_reclamation_date;
	CaplAttr	*a_lss_refusal_satisfaction_date;
	CaplAttr	*a_lss_refusal_plan_satisfaction_date;
	CaplAttr	*a_lss_refusal_testing_date;
	CaplAttr	*a_lss_refusal_reclamation_id;
	CaplAttr	*a_lss_refusal_satisfaction_id;
	CaplAttr	*a_lss_refusal_testing_id;
	CaplAttr	*a_lss_refusal_incorrect_data;
	CaplAttr	*a_lss_refusal_speciality;
	CaplAttr	*a_lss_refusal_detection_type;
	CaplAttr	*a_lss_refusal_staff_reason;
	CaplAttr	*a_lss_refusal_essence;
	CaplAttr	*a_lss_refusal_essence_descr;
	CaplAttr	*a_lss_refusal_scenario;
	CaplAttr	*a_lss_refusal_item_derived;
	CaplAttr	*a_lss_refusal_notice_id;
	CaplAttr	*a_lss_refusal_notice_date;
	CaplAttr	*a_lss_refusal_replenish_id;
	CaplAttr	*a_lss_refusal_replenish_date;
	CaplAttr	*a_lss_refusal_reclamation_state;
	CaplAttr	*a_lss_refusal_mode;

	/************************************************************************/
	/*		      			        */
	/************************************************************************/

	CaplEntity*  e_ils_classifier_reference;
	CaplAttr*    a_ils_clssf_ref_classifier;
	CaplAttr*    a_ils_clssf_ref_refusal;
	CaplAttr*    a_ils_clssf_ref_type;

	/************************************************************************/
	/*							 LSS3			                    */
	/************************************************************************/
		//
	CaplEntity* e_apl_lss3_component ;
	
	CaplAttr*   a_apl_lss3comp_id ;
	CaplAttr*   a_apl_lss3comp_id_eng;
	CaplAttr*   a_apl_lss3comp_code;
	CaplAttr*   a_apl_lss3comp_name_rus ;
	CaplAttr*   a_apl_lss3comp_name_eng ;
	CaplAttr*   a_apl_lss3comp_short_name ;
	CaplAttr*   a_apl_lss3comp_short_name_eng;
	CaplAttr*   a_apl_lss3comp_descr_rus ;
	CaplAttr*   a_apl_lss3comp_descr_eng ;
	CaplAttr*   a_apl_lss3comp_kafi ;
	CaplAttr*   a_apl_lss3comp_kafi_str ;
	CaplAttr*   a_apl_lss3comp_type ;
	CaplAttr*   a_apl_lss3comp_recommend_as_part ;
	CaplAttr*   a_apl_lss3comp_is_MSI ;
	CaplAttr*   a_apl_lss3comp_fnn ;
	CaplAttr*   a_apl_lss3comp_spec_maint ;
	CaplAttr*   a_apl_lss3comp_expl_doc_type ;
	CaplAttr*   a_apl_lss3comp_is_fi ;
	CaplAttr*   a_apl_lss3comp_class ;
	CaplAttr*   a_apl_lss3comp_expl_method ;
	CaplAttr*   a_apl_lss3comp_maint_measure_type ;
	CaplAttr*   a_apl_lss3comp_ref_intense_calc ;
	CaplAttr*   a_apl_lss3comp_ref_intense_fact ;
	CaplAttr*   a_apl_lss3comp_ref_intense_required ;
	CaplAttr*   a_apl_lss3comp_mtbf_calc ;
	CaplAttr*   a_apl_lss3comp_mtbf_fact ;
	CaplAttr*   a_apl_lss3comp_mtbf_required ;
	CaplAttr*   a_apl_lss3comp_mtbur_calc ;
	CaplAttr*   a_apl_lss3comp_mtbur_fact ;
	CaplAttr*   a_apl_lss3comp_mtbur_required ;
	CaplAttr*   a_apl_lss3comp_time_between_rep ;
	CaplAttr*   a_apl_lss3comp_unit_of_usage ;
	CaplAttr*   a_apl_lss3comp_usage_resname ;
	CaplAttr*   a_apl_lss3comp_repairability ;
	CaplAttr*	a_apl_lss3comp_developer;
	CaplAttr*	a_apl_lss3comp_kind;
	CaplAttr*	a_apl_lss3comp_category;
	CaplAttr*   a_apl_lss3comp_id_ext;
	CaplAttr*   a_apl_lss3comp_hide_id;	
	CaplAttr*	a_apl_lss3comp_actual_supply_option;
	CaplAttr*	a_apl_lss3comp_essentiality_code;
	CaplAttr*	a_apl_lss3comp_actual_depot_balance;
	CaplAttr*	a_apl_lss3comp_is_standard;
	CaplAttr*	a_apl_lss3comp_make_or_buy;
	CaplAttr*	a_apl_lss3comp_normative_document;
	CaplAttr*	a_apl_lss3comp_weight;
	CaplAttr*	a_apl_lss3comp_replacement_labour;
	CaplAttr*	a_apl_lss3comp_replacement_service_type;
	CaplAttr*	a_apl_lss3comp_repair_service_type;
	CaplAttr*	a_apl_lss3comp_pdf;
	CaplAttr*	a_apl_lss3comp_height;
	CaplAttr*	a_apl_lss3comp_width;
	CaplAttr*	a_apl_lss3comp_depth;
	CaplAttr*	a_apl_lss3comp_shsc;
	CaplAttr*	a_apl_lss3comp_importance_category;
	CaplAttr*	a_apl_lss3comp_bolt_mark;
	CaplAttr*	a_apl_lss3comp_is_pure_functional;
	CaplAttr*	a_apl_lss3comp_material;
	CaplAttr*	a_apl_lss3comp_material_type;
	CaplAttr*	a_apl_lss3comp_is_ssi;
	CaplAttr*	a_apl_lss3comp_ssi;
	CaplAttr*	a_apl_lss3comp_lcn_structure;
	CaplAttr*	a_apl_lss3comp_unserializable;
	CaplAttr*   a_apl_lss3comp_part_of_la_form;
	CaplAttr*   a_apl_lss3comp_requires_cataloging;
	CaplAttr*	a_apl_lss3comp_standard;
	CaplAttr*	a_apl_lss3comp_unit;
	CaplAttr*	a_apl_lss3comp_equipment_type;
	CaplAttr*	a_apl_lss3comp_fm_classifier_ref;
	CaplAttr*	a_apl_lss3comp_date_recalc;

	/************************************************************************/
	/*							    '           */
	/************************************************************************/
	CaplEntity* e_ils_comp_zip_relation;
	CaplAttr* a_ils_comp_zip_relation_zip;
	CaplAttr* a_ils_comp_zip_relation_component;

	/************************************************************************/
	/*							    '             */
	/************************************************************************/

	CaplEntity* e_lss3_aggr_iun_relation;
	CaplAttr* 	a_lss3_aggr_iun_relation_aggr;
	CaplAttr* 	a_lss3_aggr_iun_relation_iun;

	/************************************************************************/
	/*							  LSS3	                    */
	/************************************************************************/
	// 
	CaplEntity* e_apl_lss3_component_revision;
	CaplAttr* 	a_apl_lss3_comprev_id;
	CaplAttr* 	a_apl_lss3_comprev_of_product;
	CaplAttr*	a_apl_lss3_comprev_actual_supply_option;
	CaplAttr* 	a_apl_lss3_comprev_weight;
	CaplAttr* 	a_apl_lss3_comprev_length;
	CaplAttr* 	a_apl_lss3_comprev_width;
	CaplAttr* 	a_apl_lss3_comprev_height;
	CaplAttr* 	a_apl_lss3_comprev_mass_unit;
	CaplAttr* 	a_apl_lss3_comprev_dim_unit;
	CaplAttr*	a_apl_lss3_comprev_sw_ver;
	CaplAttr* 	a_apl_lss3_comprev_id_ext;

	/************************************************************************/
	/*					   LSS3	                    */
	/************************************************************************/
	CaplEntity* e_apl_usage_unit ;

	CaplAttr* a_apl_usage_unit_product ;
	CaplAttr* a_apl_usage_unit_unit ;
	CaplAttr* a_apl_usage_unit_guid ;

	/************************************************************************/
	/*					  LSS3			                */
	/************************************************************************/
	CaplEntity* e_apl_lss3_logistic_element;

	CaplAttr*    	a_apl_lss3logel_lcn ;
	CaplAttr*    	a_apl_lss3logel_count_in_node ;	
	CaplAttr*    	a_apl_lss3logel_parent_element ;
	CaplAttr*    	a_apl_lss3logel_parent_component ;
	CaplAttr*    	a_apl_lss3logel_child_component ;
	CaplAttr*    	a_apl_lss3logel_name_rus ;
	CaplAttr*    	a_apl_lss3logel_name_eng ;
	CaplAttr*    	a_apl_lss3logel_cfi;
	CaplAttr*    	a_apl_lss3logel_element_type ;
	CaplAttr*    	a_apl_lss3logel_descr_rus ;
	CaplAttr*    	a_apl_lss3logel_descr_eng ;
	CaplAttr*    	a_apl_lss3logel_logistic_type ;
	CaplAttr*		a_apl_lss3logel_usage_resname ;
	CaplAttr*    	a_apl_lss3logel_guid ;
	CaplAttr*    	a_apl_lss3logel_child_comp_revision ;
	CaplAttr*		a_apl_lss3logel_expluatation_main_system;
	CaplAttr*		a_apl_lss3logel_reliability_system;
	CaplAttr*		a_apl_lss3logel_position;
	CaplAttr*		a_apl_lss3logel_sns;
	CaplAttr*		a_apl_lss3logel_scheme_id;
	CaplAttr*		a_apl_lss3logel_group;
	CaplAttr*		a_apl_lss3logel_is_MSI;
	CaplAttr*		a_apl_lss3logel_mtbf_required;
	CaplAttr*		a_apl_lss3logel_mtbf_calc;
	CaplAttr*		a_apl_lss3logel_ref_intense_required;
	CaplAttr*		a_apl_lss3logel_ref_intense_calc;
	CaplAttr*		a_apl_lss3logel_mtbur_required;
	CaplAttr*		a_apl_lss3logel_mtbur_calc;
	CaplAttr*		a_apl_lss3logel_shsc;
	CaplAttr*		a_apl_lss3logel_importance_category;
	CaplAttr*		a_apl_lss3logel_mtbf_source;
	CaplAttr*		a_apl_lss3logel_not_check_composition;			//     
	CaplAttr*		a_apl_lss3logel_context;
	CaplAttr*		a_apl_lss3logel_is_lhirf;
	CaplAttr*		a_apl_lss3logel_lhirf_analysis;
	CaplAttr*		a_apl_lss3logel_exclude_from_composition;
	CaplAttr*		a_apl_lss3logel_expl_method;
	CaplAttr*		a_apl_lss3logel_amount;
	CaplAttr*		a_apl_lss3logel_amount_unit;

	/************************************************************************/
	/*					    LSS3			                */
	/************************************************************************/
	CaplEntity*		e_apl_lss3_zone_access ;

	CaplAttr*    	a_apl_lss3_zone_code ;
	CaplAttr*    	a_apl_lss3_zone_name_rus ;
	CaplAttr*    	a_apl_lss3_zone_descr_rus ;
	CaplAttr*    	a_apl_lss3_zone_parent ;
	CaplAttr*    	a_apl_lss3_zone_type ;
	CaplAttr*    	a_apl_lss3_zone_parent_fi;
	CaplAttr*    	a_apl_lss3_zone_fistr;
	CaplAttr*    	a_apl_lss3_zone_analysis;
	CaplAttr*		a_apl_lss3_zone_is_need_rcm_analysis;

	/************************************************************************/
	/*                      ils_resource_name                               */
	/************************************************************************/
	CaplEntity*	e_ils_resource_name;
	CaplAttr*	a_ils_resource_name_id;
	CaplAttr*	a_ils_resource_name_name;
	CaplAttr*	a_ils_resource_name_name_eng;
	CaplAttr*	a_ils_resource_name_unit;
	CaplAttr*	a_ils_resource_name_elements;
	CaplAttr*	a_ils_resource_name_calculated;
	CaplAttr*	a_ils_resource_name_working_hours;
	CaplAttr*	a_ils_resource_name_shown_id;

	/************************************************************************/
	/*                      ils_resource_name_element                       */
	/************************************************************************/
	CaplEntity*	e_ils_resource_name_element;
	CaplAttr*	a_ils_resource_name_element_factor;
	CaplAttr*	a_ils_resource_name_element_element;

	/************************************************************************/
	/*                    ils_resource                                      */
	/************************************************************************/
	CaplEntity*	e_ils_resource;
	CaplAttr*	a_ils_resource_item;
	CaplAttr*	a_ils_resource_name;
	CaplAttr*	a_ils_resource_guid;
	CaplAttr*	a_ils_resource_set;
	CaplAttr*	a_ils_resource_garantee;
	CaplAttr*	a_ils_resource_first_repair;
	CaplAttr*	a_ils_resource_between_repair;
	CaplAttr*	a_ils_resource_befor_set;// 
	CaplAttr*	a_ils_resource_derived;
	CaplAttr*	a_ils_resource_last_repair_derived;
	CaplAttr*	a_ils_resource_ultimate_life;// 
	CaplAttr*	a_ils_resource_individual;	//   
	CaplAttr*	a_ils_resource_element;	//   
	CaplAttr*	a_ils_resource_average;
	CaplAttr*	a_ils_resource_limit;
	CaplAttr*	a_ils_resource_calculated;	//  
	CaplAttr*	a_ils_resource_set_as_parent;	//    
	CaplAttr*	a_ils_resource_parent;			//   (   )

	/************************************************************************/
	/*                      e_ils_flight                                    */
	/************************************************************************/
	CaplEntity*	 e_ils_flight;
	CaplAttr*    a_ils_flight_base_product;
	CaplAttr*    a_ils_flight_date_time;
	CaplAttr*    a_ils_flight_date_time_end;
	CaplAttr*    a_ils_flight_start_fuel_mass;
	CaplAttr*    a_ils_flight_end_fuel_mass;
	CaplAttr*    a_ils_flight_payload_mass;
	CaplAttr*    a_ils_flight_takeoff_mass;
	CaplAttr*    a_ils_flight_passengers_count;
	CaplAttr*    a_ils_flight_max_flight_overload;
	CaplAttr*    a_ils_flight_max_landing_overload;
	CaplAttr*    a_ils_flight_additional_events;
	CaplAttr*    a_ils_flight_comments;
	CaplAttr*    a_ils_flight_pilot;
	CaplAttr*    a_ils_flight_airport_departure;
	CaplAttr*    a_ils_flight_airport_arrival;
	CaplAttr*	 a_ils_flight_type;
	CaplAttr*	 a_ils_flight_guid;

	/************************************************************************/
	/*                      e_ils_query                                     */
	/************************************************************************/
	CaplEntity* e_ils_query;
	CaplAttr*	a_ils_query_parent;
	CaplAttr*	a_ils_query_id;
	CaplAttr*	a_ils_query_section;
	CaplAttr*	a_ils_query_name;
	CaplAttr*	a_ils_query_author;
	CaplAttr*	a_ils_query_date;
	CaplAttr*	a_ils_query_op;
	CaplAttr*	a_ils_query_read_only;
	CaplAttr*	a_ils_query_report;
	CaplAttr*	a_ils_query_description;
	CaplAttr*	a_ils_query_copy_from;
	CaplAttr*	a_ils_query_is_filter;

	/************************************************************************/
	/*                      e_ils_query_par_type                            */
	/************************************************************************/
	CaplEntity* e_ils_query_par_type;
	CaplAttr*	a_ils_query_par_type_parent;
	CaplAttr*	a_ils_query_par_type_id;
	CaplAttr*	a_ils_query_par_type_name;
	CaplAttr*	a_ils_query_par_type_type;
	CaplAttr*	a_ils_query_par_type_attr;
	CaplAttr*	a_ils_query_par_type_entity;
	CaplAttr*	a_ils_query_par_type_query;
	CaplAttr*	a_ils_query_par_type_first_level;
	CaplAttr*	a_ils_query_par_type_version;

	/************************************************************************/
	/*                      e_ils_query_parameter                           */
	/************************************************************************/
	CaplEntity* e_ils_query_parameter;
	CaplAttr*	a_ils_query_parameter_query;
	CaplAttr*	a_ils_query_parameter_type;
	CaplAttr*	a_ils_query_parameter_op;
	CaplAttr*	a_ils_query_parameter_relation;
	CaplAttr*	a_ils_query_parameter_value;
	CaplAttr*	a_ils_query_parameter_number;
	CaplAttr*	a_ils_query_parameter_object;
	CaplAttr*	a_ils_query_parameter_flag;
	CaplAttr*	a_ils_query_parameter_of_type;

	/************************************************************************/
	/*                     					                        */
	/************************************************************************/
	CaplEntity*		e_ils_report;
	CaplAttr*		a_ils_report_name;
	CaplAttr*		a_ils_report_section;
	CaplAttr*		a_ils_report_description;
	CaplAttr*		a_ils_report_template;
	CaplAttr*		a_ils_report_module;
	CaplAttr*		a_ils_report_function;
	CaplAttr*		a_ils_report_user;
	CaplAttr*		a_ils_report_version;
	CaplAttr*		a_ils_report_type;
	CaplAttr*		a_ils_report_icon_large;
	CaplAttr*		a_ils_report_icon_small;
	CaplAttr*		a_ils_report_data_class;

	/************************************************************************/
	/*                    ils_product		                                */
	/************************************************************************/
/*
	CaplEntity*	e_ils_product;
	CaplAttr*	a_ils_product_id;
	CaplAttr*	a_ils_product_modify;
	CaplAttr*	a_ils_product_name;
	CaplAttr*	a_ils_product_descr;
	CaplAttr*	a_ils_product_developer;
	CaplAttr*	a_ils_product_manufacturer;
	CaplAttr*	a_ils_product_provider;
	CaplAttr*	a_ils_product_pdf;
	CaplAttr*	a_ils_product_logbook;
	CaplAttr*	a_ils_product_type;
	CaplAttr*	a_ils_product_mi;
	CaplAttr*	a_ils_product_exploitation;
	CaplAttr*	a_ils_product_average_life_refusal;
	CaplAttr*	a_ils_product_par_flow_refusal;
	CaplAttr*	a_ils_product_average_life_removal;
	CaplAttr*	a_ils_product_refusal_count;
	CaplAttr*	a_ils_product_guid;
	CaplAttr*	a_ils_product_repairability;
	CaplAttr*	a_ils_product_price;
	CaplAttr*	a_ils_product_average_time_of_restoration;
	CaplAttr*	a_ils_product_price_unit;
	CaplAttr*	a_ils_product_control_type;
	CaplAttr*	a_ils_product_control_value;
	CaplAttr*	a_ils_product_chance_refusalless;
*/

	/************************************************************************/
	/*                 ils_base_product                                     */
	/************************************************************************/
	CaplEntity*	e_ils_base_product;
	CaplAttr*	a_ils_base_product_id;
	CaplAttr*	a_ils_base_product_name;
	CaplAttr*	a_ils_base_product_modify;
	CaplAttr*	a_ils_base_product_descr;
	CaplAttr*	a_ils_base_product_type;
	CaplAttr*	a_ils_base_product_developer;
	CaplAttr*	a_ils_base_product_manufacturer;
	CaplAttr*	a_ils_base_product_provider;
	CaplAttr*	a_ils_base_product_systems;
	CaplAttr*	a_ils_base_product_zones;
	CaplAttr*	a_ils_base_product_logbook;
	CaplAttr*	a_ils_base_product_mi;
	CaplAttr*	a_ils_base_product_guid;
	CaplAttr*	a_ils_base_product_pdf;
	CaplAttr*	a_ils_base_product_price;
	CaplAttr*	a_ils_base_product_price_unit;
	CaplAttr*	a_ils_base_product_control_type;
	CaplAttr*	a_ils_base_product_control_value;
	CaplAttr*	a_ils_base_product_exploitation_method;
	CaplAttr*	a_ils_base_product_average_life_refusal;
	CaplAttr*	a_ils_base_product_par_flow_refusal;
	CaplAttr*	a_ils_base_product_average_life_removal;
	CaplAttr*	a_ils_base_product_refusal_count;
	CaplAttr*	a_ils_base_product_repairability;
	CaplAttr*	a_ils_base_product_average_time_of_restoration;
	CaplAttr*	a_ils_base_product_chance_refusalless;

	/************************************************************************/
	/*                   reset_usage_by_change                              */
	/************************************************************************/

	CaplEntity*	 e_lss3_reset_usage_by_change;
	CaplAttr*    a_lss3_reset_usage_by_change_iun;
	CaplAttr*    a_lss3_reset_usage_by_change_change;
	CaplAttr*    a_lss3_reset_usage_by_change_value;
	CaplAttr*    a_lss3_reset_usage_by_change_date;
	CaplAttr*    a_lss3_reset_usage_by_change_res_name;

	/************************************************************************/
	/*                   ils_lsi                                            */
	/************************************************************************/
	CaplEntity*	e_ils_lsi;
	CaplAttr*	a_ils_lsi_lcn;
	CaplAttr*	a_ils_lsi_name;
	CaplAttr*	a_ils_lsi_description;
	CaplAttr*	a_ils_lsi_base_product;
	CaplAttr*	a_ils_lsi_cfi;
	CaplAttr*	a_ils_lsi_system;
	CaplAttr*	a_ils_lsi_zone;
	CaplAttr*	a_ils_lsi_access_place;
	CaplAttr*	a_ils_lsi_amount;
	CaplAttr*	a_ils_lsi_min_amount;
	CaplAttr*	a_ils_lsi_exploit_type;
	CaplAttr*	a_ils_lsi_guid;
	CaplAttr*	a_ils_lsi_parent;
	CaplAttr*	a_ils_lsi_res_by_product;
	CaplAttr*	a_ils_lsi_code;
	CaplAttr*	a_ils_lsi_auto;

	/************************************************************************/
	/*                   ils_product_variant                                */
	/************************************************************************/
	CaplEntity*	e_ils_product_variant;
	CaplAttr*	a_ils_product_variant_place;
	CaplAttr*	a_ils_product_variant_ils_product;
	CaplAttr*	a_ils_product_variant_priority;
	CaplAttr*	a_ils_product_variant_sns;
	CaplAttr*	a_ils_product_variant_guid;
	CaplAttr*	a_ils_product_variant_comment;
	CaplAttr*	a_ils_product_variant_catalog;
	CaplAttr*	a_ils_product_variant_mi;

	/************************************************************************/
	/*                         ils_product_instance                         */
	/************************************************************************/
/*
	CaplEntity*	e_ils_product_instance;
	CaplAttr*	a_ils_product_instance_of_ils_product;
	CaplAttr*	a_ils_product_instance_serial_number;
	CaplAttr*	a_ils_product_instance_description;
	CaplAttr*	a_ils_product_instance_developer;
	CaplAttr*	a_ils_product_instance_manufacturer;
	CaplAttr*	a_ils_product_instance_provider;
	CaplAttr*	a_ils_product_instance_date_manufacture;
	CaplAttr*	a_ils_product_instance_date_provide;
	CaplAttr*	a_ils_product_instance_state;
	//	CaplAttr*	a_ils_product_instance_additional_data;
	CaplAttr*	a_ils_product_instance_guid;
	CaplAttr*	a_ils_product_instance_id;
	CaplAttr*	a_ils_product_instance_individual_resource;	//    .  
	CaplAttr*	a_ils_product_instance_auto;				//   
	CaplAttr*	a_ils_product_instance_software_version;	//  
	CaplAttr*	a_ils_product_instance_owner;				// 
	CaplAttr*	a_ils_product_instance_control_type;
	CaplAttr*	a_ils_product_instance_control_value;
*/

	/************************************************************************/
	/*                         e_ils_component                              */
	/************************************************************************/
	CaplEntity*	e_ils_component;
	CaplAttr*	a_ils_component_place;
	CaplAttr*	a_ils_component_ils_product_instance;
	CaplAttr*	a_ils_component_date_install;
	CaplAttr*	a_ils_component_date_remove;
	CaplAttr*	a_ils_component_description;
	CaplAttr*	a_ils_component_folder_num;
	CaplAttr*	a_ils_component_passport_num;
	CaplAttr*	a_ils_component_guid;
	CaplAttr*	a_ils_component_product_owner;
	CaplAttr*	a_ils_component_type;
	CaplAttr*	a_ils_component_reg_num;
	CaplAttr*	a_ils_component_status;
	CaplAttr*	a_ils_component_root;
	CaplAttr*	a_ils_component_remove_reason;
	CaplAttr*	a_ils_component_basis;

	/************************************************************************/
	/*                        e_ils_substitution                            */
	/************************************************************************/
	CaplEntity*	e_ils_substitution;
	CaplAttr*	a_ils_substitution_predsessor;
	CaplAttr*	a_ils_substitution_sucessor;
	//	CaplAttr*	a_ils_substitution_job;
	CaplAttr*	a_ils_substitution_reason;
	CaplAttr*	a_ils_substitution_description;
	CaplAttr*	a_ils_substitution_guid;
	CaplAttr*	a_ils_substitution_basis;

	/************************************************************************/
	/*                      e_ils_lsi_instance                              */
	/************************************************************************/
	CaplEntity*	e_ils_lsi_instance;
	CaplAttr*	a_ils_lsi_instance_of_ils_lsi;
	CaplAttr*	a_ils_lsi_instance_of_product_instance;
	CaplAttr*	a_ils_lsi_instance_parent;
	CaplAttr*	a_ils_lsi_instance_cfi;
	CaplAttr*	a_ils_lsi_instance_id;
	CaplAttr*	a_ils_lsi_instance_auto;
	CaplAttr*	a_ils_lsi_instance_topfull;
	CaplAttr*	a_ils_lsi_instance_installed;
	CaplAttr*	a_ils_lsi_instance_amount;
	CaplAttr*   a_ils_lsi_instance_has_composition;
	CaplAttr*	a_ils_lsi_instance_date_remove;

	/************************************************************************/
	/*                      e_ils_change_resource                           */
	/************************************************************************/
	CaplEntity*  e_ils_change_resource;
	CaplAttr*    a_ils_change_resource_product_instance;
	CaplAttr*    a_ils_change_resource_resource_name;
	CaplAttr*    a_ils_change_resource_set_resource_change;
	CaplAttr*    a_ils_change_resource_set_resource_val;
	CaplAttr*    a_ils_change_resource_type;
	CaplAttr*    a_ils_change_resource_basis;
	CaplAttr*    a_ils_change_resource_garantee_resource_change;
	CaplAttr*    a_ils_change_resource_garantee_resource_val;
	CaplAttr*    a_ils_change_resource_first_repair_resource_change;
	CaplAttr*    a_ils_change_resource_first_repair_resource_val;
	CaplAttr*    a_ils_change_resource_between_repair_resource_change;
	CaplAttr*    a_ils_change_resource_between_repair_resource_val;
	CaplAttr*    a_ils_change_resource_before_set_resource_change;
	CaplAttr*    a_ils_change_resource_before_set_resource_val;
	CaplAttr*    a_ils_change_resource_derived_resource_change;
	CaplAttr*    a_ils_change_resource_derived_resource_val;
	CaplAttr*    a_ils_change_resource_last_repair_resource_change;
	CaplAttr*    a_ils_change_resource_last_repair_resource_val;
	CaplAttr*    a_ils_change_resource_actual;

	/************************************************************************/
	/*															*/
	/************************************************************************/
	CaplEntity*  e_ils_refusal;
	CaplAttr*    a_ils_refusal_planer;
	CaplAttr*    a_ils_refusal_refused_instance;
	CaplAttr*    a_ils_refusal_date_time;
	CaplAttr*    a_ils_refusal_description;
	CaplAttr*    a_ils_refusal_accepted_arrangements;
	CaplAttr*    a_ils_refusal_kun_number;
	CaplAttr*    a_ils_refusal_kun_date;
	CaplAttr*    a_ils_refusal_need_additional_info;
	CaplAttr*    a_ils_refusal_state;
	CaplAttr*    a_ils_refusal_conditions;
	CaplAttr*    a_ils_refusal_manifestation;
	CaplAttr*    a_ils_refusal_character;
	CaplAttr*    a_ils_refusal_faultreason;
	CaplAttr*    a_ils_refusal_method;
	CaplAttr*    a_ils_refusal_consequences;
	CaplAttr*    a_ils_refusal_culprit;
	CaplAttr*    a_ils_refusal_refusal_type;
	CaplAttr*    a_ils_refusal_incident;
	CaplAttr*    a_ils_refusal_premise;
	CaplAttr*    a_ils_refusal_assembly_instance;
	CaplAttr*	 a_ils_refusal_reason_of_delay;
	CaplAttr*	 a_ils_refusal_time_of_delay;
	CaplAttr*	 a_ils_refusal_fed_to_developer;
	CaplAttr*	 a_ils_refusal_ignore_in_reliability;
	CaplAttr*	 a_ils_refusal_developer_comments;
	CaplAttr*	 a_ils_refusal_airbase;
	CaplAttr*	 a_ils_refusal_person;
	CaplAttr*	 a_ils_refusal_organization;
	CaplAttr*	 a_ils_refusal_guid;
	CaplAttr*	 a_ils_refusal_not_check_composition;
	CaplAttr*	 a_ils_refusal_date_removal;
	CaplAttr*	 a_ils_refusal_document_str;
	CaplAttr*	 a_ils_refusal_document_date;
	CaplAttr*	 a_ils_refusal_form_removal;
	CaplAttr*	 a_ils_refusal_search_job_duration;
	CaplAttr*	 a_ils_refusal_search_job_idle;
	CaplAttr*	 a_ils_refusal_search_job_labor;
	CaplAttr*	 a_ils_refusal_search_job_cost;
	CaplAttr*	 a_ils_refusal_removal_job_duration;
	CaplAttr*	 a_ils_refusal_removal_job_spare_parts_idle;
	CaplAttr*	 a_ils_refusal_removal_job_other_idle;
	CaplAttr*	 a_ils_refusal_removal_job_labor;
	CaplAttr*	 a_ils_refusal_removal_job_staff_cost;
	CaplAttr*	 a_ils_refusal_removal_job_spare_parts_cost;
	CaplAttr*	 a_ils_refusal_removal_job_total_cost;
	CaplAttr*	 a_ils_refusal_system;
	CaplAttr*	 a_ils_refusal_zone;
	CaplAttr*	 a_ils_refusal_access_place;
	CaplAttr*	 a_ils_refusal_cfi;
	CaplAttr*	 a_ils_refusal_id;

	/************************************************************************/
	/*							 							*/
	/************************************************************************/
	CaplEntity	*e_ils_executed_job;
	CaplAttr	*a_ils_executed_job_id;
	CaplAttr	*a_ils_executed_job_name;
	CaplAttr	*a_ils_executed_job_descr;
	CaplAttr	*a_ils_executed_job_type;
	CaplAttr	*a_ils_executed_job_planer;
	CaplAttr	*a_ils_executed_job_date_begin;
	CaplAttr	*a_ils_executed_job_date_end;
	CaplAttr	*a_ils_executed_job_labor;
	CaplAttr	*a_ils_executed_job_price;
	CaplAttr	*a_ils_executed_job_item;
	CaplAttr	*a_ils_executed_job_duration;
	CaplAttr	*a_ils_executed_job_executer;
	CaplAttr	*a_ils_executed_job_bulletin_executer;

	/************************************************************************/
	/*					     			*/
	/************************************************************************/
	CaplEntity	*e_ils_executed_job_attachment;
	CaplAttr	*a_ils_executed_job_attachment_type;
	CaplAttr	*a_ils_executed_job_attachment_of_job;
	CaplAttr	*a_ils_executed_job_attachment_price;
	CaplAttr	*a_ils_executed_job_attachment_comment;
	CaplAttr	*a_ils_executed_job_attachment_num;
	CaplAttr	*a_ils_executed_job_attachment_guid;

	/************************************************************************/
	/*					  							*/
	/************************************************************************/
	CaplEntity	*e_ils_executed_job_attachment_pos;
	CaplAttr	*a_ils_executed_job_attachment_pos_task_id;
	CaplAttr	*a_ils_executed_job_attachment_pos_task_name;
	CaplAttr	*a_ils_executed_job_attachment_pos_task;
	CaplAttr	*a_ils_executed_job_attachment_pos_labor;

	/************************************************************************/
	/*								  							*/
	/************************************************************************/
	CaplEntity	*e_ils_executed_job_attachment_moves;
	CaplAttr	*a_ils_executed_job_attachment_moves_remove;
	CaplAttr	*a_ils_executed_job_attachment_moves_install;

	/************************************************************************/
	/*								  								*/
	/************************************************************************/
	CaplEntity	*e_ils_software_version_item;
	CaplAttr	*a_ils_software_version_item_of_ils_product;
	CaplAttr	*a_ils_software_version_item_value;

	/************************************************************************/
	/*								CFI 									*/
	/************************************************************************/
	CaplEntity	*e_ils_cfi;
	CaplAttr	*a_ils_cfi_id;
	CaplAttr	*a_ils_cfi_of_planer;
	CaplAttr	*a_ils_cfi_of_lsi;

	/************************************************************************/
	/*								ResourceCorrent							*/
	/************************************************************************/
	CaplEntity	*e_ils_resource_correct;
	CaplAttr	*a_ils_resource_correct_of_item;
	CaplAttr	*a_ils_resource_correct_date_time;
	CaplAttr	*a_ils_resource_correct_comments;
	CaplAttr	*a_ils_resource_correct_guid;
	CaplAttr	*a_ils_resource_correct_basis;
	CaplAttr	*a_ils_resource_correct_type;

	/************************************************************************/
	/*								ApplicabilityRule						*/
	/************************************************************************/
	CaplEntity	*e_ils_applicability_rule;
	CaplAttr	*a_ils_applicability_rule_id;
	CaplAttr	*a_ils_applicability_rule_name;
	CaplAttr	*a_ils_applicability_rule_item;
	CaplAttr	*a_ils_applicability_rule_invert;

	CaplEntity	*e_ils_applicability_rule_object;
	CaplAttr	*a_ils_applicability_rule_object_object;

	/************************************************************************/
	/*								                  */
	/************************************************************************/
	CaplEntity	*e_ils_planer_state;
	CaplAttr	*a_ils_planer_state_planer;
	CaplAttr	*a_ils_planer_state_date;
	CaplAttr	*a_ils_planer_state_date_end;
	CaplAttr	*a_ils_planer_state_date_planned ;
	CaplAttr	*a_ils_planer_state_description;
	CaplAttr	*a_ils_planer_state_state;
	CaplAttr	*a_ils_planer_state_res_hour;
	CaplAttr	*a_ils_planer_state_res_flight;
	CaplAttr	*a_ils_planer_state_res_hour_month;
	CaplAttr	*a_ils_planer_state_res_flight_month;
	// 
	CaplAttr	*a_ils_planer_state_maint_prog;
	// 
	CaplAttr	*a_ils_planer_state_maint_prog_set;
	CaplAttr	*a_ils_planer_state_problem_text;
	CaplAttr	*a_ils_planer_state_active_work_time;
	CaplAttr	*a_ils_planer_state_spare_down_time;
	CaplAttr	*a_ils_planer_state_other_down_time;
	CaplAttr	*a_ils_planer_state_responser;
	CaplAttr	*a_ils_planer_state_ready;

	/************************************************************************/
	/*				   		                */
	/************************************************************************/
	CaplEntity	*e_ils_planer_state_refusal;
	CaplAttr	*a_ils_planer_state_refusal_planer;
	CaplAttr	*a_ils_planer_state_refusal_description;
	CaplAttr	*a_ils_planer_state_refusal_date;
	CaplAttr	*a_ils_planer_state_refusal_date_removal;
	CaplAttr	*a_ils_planer_state_refusal_critical;
	CaplAttr	*a_ils_planer_state_refusal_accepted_arragements;

	/************************************************************************/
	/*				C                 */
	/************************************************************************/
	CaplEntity	*e_ils_state_refusal_link;
	CaplAttr	*a_ils_state_refusal_link_state;
	CaplAttr	*a_ils_state_refusal_link_refusal;


	/************************************************************************/
	/*				C             */
	/************************************************************************/
	CaplEntity	*e_ils_state_component_link;
	CaplAttr	*a_ils_state_component_link_state;
	CaplAttr	*a_ils_state_component_link_component;
	CaplAttr	*a_ils_state_component_link_instance;
	CaplAttr	*a_ils_state_component_link_type;
	CaplAttr	*a_ils_state_component_link_date_begin;
	CaplAttr	*a_ils_state_component_link_date_planned;
	CaplAttr	*a_ils_state_component_link_date_end;
	CaplAttr	*a_ils_state_component_link_result;



	/************************************************************************/
	/*                         LSS EXECUTED JOBS                            */
	/************************************************************************/
	CaplEntity	*e_lss_executed_job;
	CaplAttr	*a_lss_executed_job_id;
	CaplAttr	*a_lss_executed_job_planer;
	CaplAttr	*a_lss_executed_job_bulletin;
	CaplAttr	*a_lss_executed_job_date_begin;
	CaplAttr	*a_lss_executed_job_date_end;
	CaplAttr	*a_lss_executed_job_description;
	CaplAttr	*a_lss_executed_job_labor;
	CaplAttr	*a_lss_executed_job_duration;
	CaplAttr	*a_lss_executed_job_personnel_costs;
	CaplAttr	*a_lss_executed_job_price;
	CaplAttr	*a_lss_executed_job_refusal_select;
	CaplAttr	*a_lss_executed_job_price_unit;
	CaplAttr	*a_lss_executed_job_duration_unit;
	CaplAttr	*a_lss_executed_job_labor_unit;
	CaplAttr	*a_lss_executed_job_service_type;
	CaplAttr	*a_lss_executed_job_order_type;
	CaplAttr	*a_lss_executed_job_class;
	CaplAttr	*a_lss_executed_job_price_of_spare_parts;
	CaplAttr	*a_lss_executed_job_price_of_consumables;
	CaplAttr	*a_lss_executed_job_of_item;
	CaplAttr	*a_lss_executed_job_of_item_installed;
	CaplAttr	*a_lss_executed_job_of_item_count;
	CaplAttr	*a_lss_executed_job_downtime_waiting_for_spares;
	CaplAttr	*a_lss_executed_job_parent;
	CaplAttr	*a_lss_executed_job_place_lvl;
	CaplAttr	*a_lss_executed_job_place_org;
	CaplAttr	*a_lss_executed_job_wait_reason_lvl;
	CaplAttr	*a_lss_executed_job_performer_lvl;
	CaplAttr	*a_lss_executed_job_executor_org;
	CaplAttr	*a_lss_executed_job_repair_type;
	CaplAttr	*a_lss_executed_job_scenario;
	CaplAttr	*a_lss_executed_job_personnel_count;
	CaplAttr	*a_lss_executed_job_wait_time_before_start;
	CaplAttr	*a_lss_executed_job_duration_search;
	CaplAttr	*a_lss_executed_job_process_chart;

	CaplEntity	*e_lss_executed_periodical_job;
	CaplAttr	*a_lss_executed_periodical_job_type;
	CaplAttr	*a_lss_executed_periodical_job_cost_of_spare_parts;

	CaplEntity	*e_lss_executed_replacement_job;
	CaplAttr	*a_lss_executed_replacement_job_type;
	CaplAttr	*a_lss_executed_replacement_job_item_type;
	CaplAttr	*a_lss_executed_replacement_job_system;
	CaplAttr	*a_lss_executed_replacement_job_item;
	CaplAttr	*a_lss_executed_replacement_job_name;
	CaplAttr	*a_lss_executed_replacement_job_of_job;
	CaplAttr	*a_lss_executed_replacement_job_cost_of_spare_parts;
	CaplAttr	*a_lss_executed_replacement_job_cost_of_consumables;
	CaplAttr	*a_lss_executed_replacement_job_cost_of_repair;

	CaplEntity	*e_lss_executed_maintenance_job;
	CaplAttr	*a_lss_executed_maintenance_job_type;
	CaplAttr	*a_lss_executed_maintenance_job_cause;
	CaplAttr	*a_lss_executed_maintenance_job_system;
	CaplAttr	*a_lss_executed_maintenance_job_item;
	CaplAttr	*a_lss_executed_maintenance_job_name;
	CaplAttr	*a_lss_executed_maintenance_job_of_job;
	CaplAttr	*a_lss_executed_maintenance_job_cost_of_consumables;

	CaplEntity	*e_lss_executed_operational_job;
	CaplAttr	*a_lss_executed_operational_job_type;
	CaplAttr	*a_lss_executed_operational_job_cost_of_consumables;
	CaplAttr	*a_lss_executed_operational_job_amount;
	CaplAttr	*a_lss_executed_operational_job_avg_labor;
	CaplAttr	*a_lss_executed_operational_job_avg_durational;
	CaplAttr	*a_lss_executed_operational_job_avg_cost;

	CaplEntity	*e_lss_executed_refusal_search_job;
	CaplAttr	*a_lss_executed_refusal_search_job_type;

	/************************************************************************/
	/*	                                                  */
	/************************************************************************/
	CaplEntity*  e_ils_consumption;
	CaplAttr*    a_ils_consumption_id;
	CaplAttr*    a_ils_consumption_name;
	CaplAttr*    a_ils_consumption_description;
	CaplAttr*    a_ils_consumption_external_id;
	CaplAttr*    a_ils_consumption_standard;
	CaplAttr*    a_ils_consumption_is_standart;
	CaplAttr*    a_ils_consumption_nsn;
	CaplAttr*    a_ils_consumption_manufacturer;
	CaplAttr*    a_ils_consumption_supplier;
	CaplAttr*    a_ils_consumption_estimated_consumption_rate;
	CaplAttr*    a_ils_consumption_unit;
	CaplAttr*	 a_ils_consumption_make_or_buy;
	CaplAttr*	 a_ils_consumption_requires_cataloging;

	/************************************************************************/
	/*	                                            */
	/************************************************************************/
	CaplEntity*  e_ils_equipment;
	CaplAttr*    a_ils_equipment_id;
	CaplAttr*    a_ils_equipment_name;
	CaplAttr*    a_ils_equipment_description;
	CaplAttr*    a_ils_equipment_external_id;
	CaplAttr*    a_ils_equipment_is_standard;
	CaplAttr*    a_ils_equipment_nsn;
	CaplAttr*    a_ils_equipment_manufacturer;
	CaplAttr*    a_ils_equipment_supplier;
	CaplAttr*    a_ils_equipment_type;
	CaplAttr*	 a_ils_equipment_make_or_buy;
	CaplAttr*    a_ils_equipment_standard;
	CaplAttr*	 a_ils_equipment_requires_cataloging;

	/************************************************************************/
	/*	                                                */
	/************************************************************************/
	CaplEntity*  e_ils_process_chart;
	CaplAttr*    a_ils_process_chart_id_mrbr;
	CaplAttr*    a_ils_process_chart_id_mpd;
	CaplAttr*    a_ils_process_chart_name;
	CaplAttr*	 a_ils_process_chart_name_eng;
	CaplAttr*    a_ils_process_chart_ata;
	CaplAttr*    a_ils_process_chart_type;
	CaplAttr*    a_ils_process_chart_labour_unit;
	CaplAttr*    a_ils_process_chart_labour_full;
	CaplAttr*    a_ils_process_chart_labour_full_or_parts;
	CaplAttr*    a_ils_process_chart_labour_execution;
	CaplAttr*    a_ils_process_chart_labour_access;
	CaplAttr*    a_ils_process_chart_actual_ls_obj_link;
	CaplAttr*	 a_ils_process_chart_dm_code;
	CaplAttr*	 a_ils_process_chart_dm_info_link;
	CaplAttr*	 a_ils_process_chart_mean_time_work;
	CaplAttr*	 a_ils_process_chart_executor_count;
	CaplAttr*	 a_ils_process_chart_ssi_analysis_type;
	CaplAttr*	 a_ils_process_chart_zvi_analysis_type;
	CaplAttr*	 a_ils_process_chart_msi_analysis_type;
	CaplAttr*    a_ils_process_chart_task_interval_source;
	CaplAttr*    a_ils_process_chart_requirement_source;
	CaplAttr*	 a_ils_process_chart_consumables_price;
	CaplAttr*	 a_ils_process_chart_price_currency;

	/************************************************************************/
	/*	                                                   */
	/************************************************************************/
	CaplEntity*  e_ils_time_interval;
	CaplAttr*    a_ils_time_interval_type;
	CaplAttr*    a_ils_time_interval_value;
	CaplAttr*    a_ils_time_interval_plus;
	CaplAttr*    a_ils_time_interval_minus;
	CaplAttr*    a_ils_time_interval_unit;
	CaplAttr*    a_ils_time_interval_object;
	CaplAttr*    a_ils_time_interval_delay;
	CaplAttr*    a_ils_time_interval_info;
	CaplAttr*	 a_ils_time_interval_first;

	/************************************************************************/
	/*	                        */
	/************************************************************************/
	CaplEntity*  e_ils_maint_prog_item_proc_chart_relation;
	CaplAttr*    a_ils_maint_prog_item_proc_chart_relation_maintenance_program_item;
	CaplAttr*    a_ils_maint_prog_item_proc_chart_relation_process_chart;
	CaplAttr*    a_ils_maint_prog_item_proc_chart_relation_position;

	/************************************************************************/
	/*	                       */
	/************************************************************************/
	CaplEntity* e_ils_process_chart_applicability;	// 
	CaplAttr* a_ils_process_chart_fi;				//
	CaplAttr* a_ils_process_chart_config;			//
	CaplAttr* a_ils_process_chart_pc;				//

	/************************************************************************/
	/*	                       MRBR											*/
	/************************************************************************/
	CaplEntity*  e_ils_mrbr;
	CaplAttr*    a_ils_mrbr_id;
	CaplAttr*    a_ils_mrbr_fi;
	CaplAttr*    a_ils_mrbr_config;
	CaplAttr*    a_ils_mrbr_date;

	/************************************************************************/
	/*	                        MRBR  						*/
	/************************************************************************/
	CaplEntity*  e_ils_mrbr_pc_link;
	CaplAttr*    a_ils_mrbr_pc_link_mrbr;
	CaplAttr*    a_ils_mrbr_pc_link_pc;

	/************************************************************************/
	/*	                       MPD						                    */
	/************************************************************************/
	CaplEntity*  e_ils_mpd;
	CaplAttr*    a_ils_mpd_id;
	CaplAttr*    a_ils_mpd_fi;
	CaplAttr*    a_ils_mpd_config;
	CaplAttr*    a_ils_mpd_date;

	/************************************************************************/
	/*	                        MPD  	                    */
	/************************************************************************/
	CaplEntity*  e_ils_mpd_pc_link;
	CaplAttr*    a_ils_mpd_pc_link_mpd;
	CaplAttr*    a_ils_mpd_pc_link_pc;

	/************************************************************************/
	/*                         LSS REFUSAL_DEFECTIVE_ITEM                   */
	/************************************************************************/
	CaplEntity	*e_lss_refusal_defective_item;
	CaplAttr	*a_lss_refusal_defective_item_product;
	CaplAttr	*a_lss_refusal_defective_item_serial_number;
	CaplAttr	*a_lss_refusal_defective_item_place;
	CaplAttr	*a_lss_refusal_defective_item_confirm;
	CaplAttr	*a_lss_refusal_defective_item_of_ils_product;

	/************************************************************************/
	/*                      lss_flight										*/
	/************************************************************************/
	CaplEntity*	 e_lss_flight;
	CaplAttr*    a_lss_flight_base_product;
	CaplAttr*    a_lss_flight_date_time;

	/************************************************************************/
	/*                     Engeneer Support                                 */
	/************************************************************************/
	CaplEntity*		e_forum_question;
	CaplAttr*		a_forum_question_header;
	CaplAttr*		a_forum_question_section;
	CaplAttr*		a_forum_question_state;
	CaplAttr*		a_forum_question_creation_state;
	CaplAttr*		a_forum_question_author;
	CaplAttr*		a_forum_question_refusal;
	CaplAttr*		a_forum_question_job;
	CaplAttr*		a_forum_question_last_message;
	CaplAttr*		a_forum_question_date;
	CaplAttr*		a_forum_question_attachments;
	CaplAttr*		a_forum_question_planer;
	CaplAttr*		a_forum_question_planer_type;
	CaplAttr*		a_forum_question_system;
	CaplAttr*		a_forum_question_system_id;
	CaplAttr*		a_forum_question_item;
	CaplAttr*		a_forum_question_item_type;
	CaplAttr*		a_forum_question_assign;

	CaplEntity*		e_forum_section;
	CaplAttr*		a_forum_section_name;

	CaplEntity*		e_forum_message;
	CaplAttr*    	a_forum_message_text;
	CaplAttr*    	a_forum_message_author;
	CaplAttr*    	a_forum_message_creation_date;
	CaplAttr*    	a_forum_message_question;
	CaplAttr*		a_forum_message_attachments;
	CaplAttr*		a_forum_message_prev;
	CaplAttr*		a_forum_message_status;

	/************************************************************************/
	/*                                              */
	/************************************************************************/
	CaplEntity*		e_ils_launch_decision;
	CaplAttr*		a_ils_launch_decision_bulletin;
	CaplAttr*		a_ils_launch_decision_id;
	CaplAttr*		a_ils_launch_decision_date;

	/************************************************************************/
	/*                                             */
	/************************************************************************/
	CaplEntity*		e_ils_metal;
	CaplAttr*		a_ils_metal_item;
	CaplAttr*		a_ils_metal_au;
	CaplAttr*		a_ils_metal_ag;
	CaplAttr*		a_ils_metal_ir;
	CaplAttr*		a_ils_metal_pd;
	CaplAttr*		a_ils_metal_pt;
	CaplAttr*		a_ils_metal_rh;
	CaplAttr*		a_ils_metal_heavy;
	CaplAttr*		a_ils_metal_al;
	CaplAttr*		a_ils_metal_cu;
	CaplAttr*		a_ils_metal_ti;
	CaplAttr*		a_ils_metal_ni;
	CaplAttr*		a_ils_metal_lite;

	/************************************************************************/
	/*                     										*/
	/************************************************************************/
	CaplEntity*		e_ils_transaction;
	CaplAttr*		a_ils_transaction_time_begin;
	CaplAttr*		a_ils_transaction_time_end;
	CaplAttr*		a_ils_transaction_user;
	CaplAttr*		a_ils_transaction_session;

	/************************************************************************/
	/*                       								*/
	/************************************************************************/
	CaplEntity*		e_ils_depot_balance;
	CaplAttr*		a_ils_depot_balance_component;
	CaplAttr*		a_ils_depot_balance_organization;
	CaplAttr*		a_ils_depot_balance_balance;

	/************************************************************************/
	/*							  SSI							*/
	/************************************************************************/
	CaplEntity* e_ils_ssi;
	CaplAttr* a_ils_ssi_check_ssi_q1;
	CaplAttr* a_ils_ssi_check_ssi_q2;
	CaplAttr* a_ils_ssi_check_ssi_q3;
	CaplAttr* a_ils_ssi_check_ssi_q4;
	CaplAttr* a_ils_ssi_check_ssi_q5;
	CaplAttr* a_ils_ssi_check_ssi_q6;
	CaplAttr* a_ils_ssi_check_ssi_q7;
	CaplAttr* a_ils_ssi_check_ssi_q8;
	CaplAttr* a_ils_ssi_check_ssi_q1_descr;
	CaplAttr* a_ils_ssi_check_ssi_q2_descr;
	CaplAttr* a_ils_ssi_check_ssi_q3_descr;
	CaplAttr* a_ils_ssi_check_ssi_q4_descr;
	CaplAttr* a_ils_ssi_check_ssi_q5_descr;
	CaplAttr* a_ils_ssi_check_ssi_q6_descr;
	CaplAttr* a_ils_ssi_check_ssi_q7_descr;
	CaplAttr* a_ils_ssi_check_ssi_q8_descr;
	CaplAttr* a_ils_ssi_is_damage;			//     ?
	CaplAttr* a_ils_ssi_is_scheduled_views;	//    ,   ?
	CaplAttr* a_ils_ssi_is_fd_restrict;		//     FD    PSE/ALI?
	CaplAttr* a_ils_ssi_durability;			//  
	CaplAttr* a_ils_ssi_break_grow_speed;	//   
	CaplAttr* a_ils_ssi_break_size;			//   
	CaplAttr* a_ils_ssi_break_critical_size;//   
	CaplAttr* a_ils_ssi_period;				//  /
	CaplAttr* a_ils_ssi_is_metal;			//    SSI
	CaplAttr* a_ils_ssi_metal_rate;			//       SSI
	CaplAttr* a_ils_ssi_composite_rate;		//       SSI
	CaplAttr* a_ils_ssi_control_method;		//      

	/************************************************************************/
	/*			   SSI						*/
	/************************************************************************/
	CaplEntity* e_ils_ssi_metal_rate;
	CaplAttr*	a_ils_ssi_metal_rate_is_inner;									//     
	CaplAttr*	a_ils_ssi_metal_rate_is_outer;									//     
	CaplAttr*	a_ils_ssi_metal_rate_inner_accidental_damage_probability;		//    ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_accidental_damage_probability;		//    ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_maintenance_visibility;				//  SSI     ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_maintenance_visibility;				//  SSI     ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_environment_influence;				//       ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_environment_influence;				//       ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_accidental_damage_sensitivity;		//     ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_accidental_damage_sensitivity;		//     ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_corrosion_sensitivity;				//    (,   ..) ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_corrosion_sensitivity;				//    (,   ..) ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_corrosion_sensitivity_stress;		//      ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_corrosion_sensitivity_stress;		//      ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_corrosion_sensitivity_ad;			//    () ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_corrosion_sensitivity_ad;			//    () ( )
	CaplAttr*	a_ils_ssi_metal_rate_inner_environmental_protection;			//      ( )
	CaplAttr*	a_ils_ssi_metal_rate_outer_environmental_protection;			//      ( )
	CaplAttr*	a_ils_ssi_metal_rate_is_cpcp;									//     

	/************************************************************************/
	/*			    SSI						*/
	/************************************************************************/
	CaplEntity* e_ils_ssi_composite_rate;
	CaplAttr*	a_ils_ssi_composite_rate_is_inner;							//     								
	CaplAttr*	a_ils_ssi_composite_rate_is_outer;							//     
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_ground_handling_equipment;//  -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_ground_handling_equipment;//  -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_cargo_handling_equipment;	//  -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_cargo_handling_equipment;	//  -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_human_errors;				//     ,    ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_human_errors;				//     ,    ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_passengers;				//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_passengers;				//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_atmospheric_effects;		//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_atmospheric_effects;		//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_objects_runway;			//    -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_objects_runway;			//    -  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_liquid_leak;				//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_liquid_leak;				//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_hot_air;					//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_hot_air;					//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ad_other;					//  (  ) ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ad_other;					//  (  ) ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ed_ultraviolet;				//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ed_ultraviolet;				//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ed_humidity;					//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ed_humidity;					//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ed_liquid;					//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ed_liquid;					//  ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ed_high_temperature;			//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ed_high_temperature;			//   ( )
	CaplAttr*	a_ils_ssi_composite_rate_inner_ed_other;					//  (    ) ( )
	CaplAttr*	a_ils_ssi_composite_rate_outer_ed_other;					//  (    ) ( )

	/************************************************************************/
	/*			  									*/
	/************************************************************************/
	CaplEntity* e_ils_connect;
	CaplAttr*	a_ils_connect_element;
	CaplAttr*	a_ils_connect_couple;

	/************************************************************************/
	/*							 			                    */
	/************************************************************************/
	//   (e_ils_base_product_instance),    
	bool FindAssociatedInstances(CaplInstance* pInst/*in*/, aplExtent& extInstances/*out*/);
	//   (e_ils_base_product_instance),     
	bool FindAssociatedInstances(aplExtent& extIn/*in*/, aplExtent& extInstances/*out*/, bool bLoadAttrs = true);

	/************************************************************************/
	/*																*/
	/************************************************************************/
	// "-"
	typedef std::map<CaplInstance*, CaplInstance*> inst_to_link_map ;
	typedef std::map<CaplInstance*, CaplInstance*>::iterator iToLink_it ;

	bool FindAssociatedBulletins(CaplInstance* pInst/*in*/, inst_to_link_map& instRef_map/*out*/, bool bLoadFromDB=true);
	bool FindAssociatedBulletins(aplExtent& ext_items/*in*/, inst_to_link_map& instRef_map/*out*/, bool bLoadFromDB=true);

	/************************************************************************/
	/*																	*/
	/************************************************************************/
	typedef std::map<CaplInstance*, std::set<CaplInstance*>> inst_to_failures_map ;
	typedef std::map<CaplInstance*, std::set<CaplInstance*>>::iterator itofm_iterator ;

	bool FindAssociatedFailuresByInst(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/);
	bool FindAssociatedFailuresByInst(aplExtent& ext_items/*in*/,	aplExtent& extInstances/*out*/, bool bLoadAttrs = true);
	bool FindAssociatedFailuresByInst(aplExtent& ext_items/*in*/,	inst_to_failures_map& ResultMap/*out*/);
	bool FindAssociatedFailuresByComp(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/);
	bool FindAssociatedFailuresByComp(aplExtent& ext_items/*in*/,	aplExtent& extInstances/*out*/, bool bLoadAttrs = true, bool bFromBase = true);
	bool FindAssociatedFailuresByMission(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/);
	bool FindAssociatedFailuresByMission(aplExtent& ext_items/*in*/,	aplExtent& extInstances/*out*/);
	bool FindAssociatedFailuresByLogEl(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/);
	bool FindAssociatedFailuresByLogEl(aplExtent& ext_items/*in*/,	aplExtent& extInstances/*out*/, bool bFromBase = true);
	bool FindAssociatedFailuresByInstAndComp(CaplInstance*  Inst/*in*/, CaplInstance*  Comp/*in*/, aplExtent& extInstances/*out*/);

	//  
	CaplEntity*		e_apl_lss3_aftersales_system_project;
	CaplAttr*    	a_apl_lss3_aftersales_system_project_name;
	CaplAttr*    	a_apl_lss3_aftersales_system_project_ton_kilometer_cost;
	CaplAttr*    	a_apl_lss3_aftersales_system_project_cost_unit;

	//    (,   ..)/ /  
	CaplEntity* e_apl_lss3_component_organization_relation;

	CaplAttr*    	a_apl_lss3comp_org_rel_component;
	CaplAttr*    	a_apl_lss3comp_org_rel_organization;
	CaplAttr*    	a_apl_lss3comp_org_rel_type;
	CaplAttr*    	a_apl_lss3comp_org_rel_linked_organization;
	CaplAttr*    	a_apl_lss3comp_org_rel_date_active_begin;
	CaplAttr*    	a_apl_lss3comp_org_rel_date_active_end;
	CaplAttr*    	a_apl_lss3comp_org_rel_price;
	CaplAttr*    	a_apl_lss3comp_org_rel_price_unit;
	CaplAttr*    	a_apl_lss3comp_org_rel_supply_cycle;
	CaplAttr*    	a_apl_lss3comp_org_rel_supply_cycle_unit;
	CaplAttr*    	a_apl_lss3comp_org_rel_repair_tat;
	CaplAttr*    	a_apl_lss3comp_org_rel_repair_tat_unit;
	CaplAttr*    	a_apl_lss3comp_org_rel_delivery_time;
	CaplAttr*    	a_apl_lss3comp_org_rel_delivery_time_unit;
	CaplAttr*    	a_apl_lss3comp_org_rel_repair_price_part;
	CaplAttr*    	a_apl_lss3comp_org_rel_min_reserve_level;
	CaplAttr*    	a_apl_lss3comp_org_rel_aftersales_service_type;
	CaplAttr*    	a_apl_lss3comp_org_rel_delivery_distance;
	CaplAttr*    	a_apl_lss3comp_org_rel_ton_kilometer_cost;
	CaplAttr*    	a_apl_lss3comp_org_rel_cost_of_creation;
	CaplAttr*    	a_apl_lss3comp_org_rel_annual_cost_of_ownership;
	CaplAttr*    	a_apl_lss3comp_org_rel_aftersales_system_project;
	CaplAttr*    	a_apl_lss3comp_org_rel_aftersales_id;
	CaplAttr*    	a_apl_lss3comp_org_rel_aftersales_transportation_method;
	CaplAttr*    	a_apl_lss3comp_org_rel_annual_plan_labor;
	CaplAttr*		a_apl_lss3comp_org_rel_storage_price_per_year;
	CaplAttr*    	a_apl_lss3comp_org_rel_default;
	CaplAttr*    	a_apl_lss3comp_org_rel_aftersales_is_obj_of_supplier;
	CaplAttr*		a_apl_lss3comp_org_rel_aftersales_price_transportation_fi_to_km;
	CaplAttr*		a_apl_lss3comp_org_rel_supply_lower_levels;
	CaplAttr*		a_apl_lss3comp_org_rel_supply_model;
	CaplAttr*		a_apl_lss3comp_org_rel_min_count_in_zip;
	CaplAttr*		a_apl_lss3comp_org_rel_box_height;
	CaplAttr*		a_apl_lss3comp_org_rel_box_width;
	CaplAttr*		a_apl_lss3comp_org_rel_box_depth;
	CaplAttr*		a_apl_lss3comp_org_rel_weight_with_box;
	CaplAttr*		a_apl_lss3comp_org_rel_min_count_in_box;
	CaplAttr*		a_apl_lss3comp_org_rel_min_count_demand;

	/************************************************************************/
	/*							 							*/
	/************************************************************************/
	virtual bool LoadExtentInfo(aplExtent &ext, aplExtent* pExtRes = NULL);
	virtual bool LoadItemInfo(CaplInstance* item);

protected:
	//    ,      , 
	//   LoadExtentInfo - .     - !!!
	//         
	TIntSet	m_InlineDocUnionQueries;
	TIntSet	m_InlineResourcesUnionQueries;
	TIntSet m_InlineMetalsUnionQueries;

	bool	m_bFullInit;//    

	virtual int LDFillLSIInstance(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillComponent(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillBaseProductInstance(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillFlights(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillChRes(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillIncidents(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillBulletins(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    
	virtual int LDFillExecutedLSSJobs(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   21
	virtual int LDFillLSSRefusals(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//  
	virtual int LDFillClassifierItems(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//  ()
	virtual int LDFillPerson(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillPO(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFillUser(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual int LDFillResCorrects(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//  
	virtual int LDFillReports(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    3
	virtual int LDFillLSS3Component(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    3
	virtual int LDFillLSS3ComponentRevisions(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    () 3
	virtual int LDFillLSS3LSI(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   3
	virtual int LDFillLSS3Zone(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    LSS3
	virtual int LDFillLSS3Analogs(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual int LDFillLSS3Consumption(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    
	virtual int LDFillLSS3Equipment(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual int LDFillLSS3ProcessChart(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   SSI
	virtual int LDFillSSI(CaplLoadData* ld, int iInd, UINT nFlags = 0);

	//       
	virtual void LDFillInlineLoad(CaplLoadData *pLD);

	//nFlags -   
	//   "LDF_"
	//    CaplLoadData  ,       
	virtual void LDFindAssociatedResources(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//  
	virtual void LDFindAssociatedDocuments(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual void LDFindAssociatedMetals(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFindReferenceComponentsLSI(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	virtual int LDFindReferenceComponentsPI(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	// 21 :   
	virtual int LDFindAssociatedLSSJobs(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    
	virtual int LDFindBulletinReferences(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	// 21 :   
	virtual int LDFindAssociatedLSSRefusals(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//    
	virtual int LDFindAssociatedResourceChanges(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual int LDFillDocuments(CaplLoadData *ld, int iInd, UINT nFlags = 0);
	//   
	virtual int LDFindAssociatedLSS3Analogs(CaplLoadData *ld, int iInd, UINT nFlags = 0);

public:
	/************************************************************************/
	/*							 							*/
	/************************************************************************/

	//   
	virtual void LoadUnitsAndResourceNames();




	/************************************************************************/
	/*							  PSS						*/
	/************************************************************************/
	
	//       
	bool FindAssociatedRefusal(CaplInstance *item, aplExtent &ext_refusal, bool bLoadRefusionInfo=true);

	//    
	bool LoadRefusalsInfo(aplExtent &ext);

	//  
	// item -       ()
	CaplInstance  *CreateRefusal(CaplInstance *item=0);

	//   
	bool ShowRefusalProperies(CaplInstance *refusal);

	//  
	bool DeleteRefusal(CaplInstance *refusal);

	BOOL FindPrdInst1(CaplInstance **Result, TFindPrdInstModes Mode, UINT Flags = 0, LPCTSTR id = NULL, LPCTSTR name = NULL, LPCTSTR sn = NULL);

	BOOL FindPdf1(CaplInstance **Result, TFindPdfModes Mode, UINT Flags = 0, LPCTSTR id = NULL, LPCTSTR name = NULL, bool bAutoExecute = false);

	/**      
		param SelectedSystem -   ,     
		param Mode -   .
		param Planer - 
		return true,      false   */
	bool SelectPlanerSystem1(CaplInstance **SelectedSystem, TSelectSystemMode Mode, CaplInstance *Planer, bool bSkipPlanerAptec = false);



	//    PSS  ILS.  
	// bShowStructDlg -  true,       
	//  false,     PDF
	//    ILS  
	CaplInstance *CopyPdfToIls(bool bShowStructDlg);

	//   2 
	bool ImportStructPss2Ils(aplExtent &ext_pdf, aplExtent &ext_nauo);

};

//__declspec (dllexport) int AfxMessageBox(LPCTSTR lpszMsg, UINT mode = MB_OK);
//__declspec (dllexport) int AfxMessageBox(UINT iStrID, UINT mode = MB_OK);