// Choose_sub_bps_dlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "Choose_sub_bps_dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChoose_sub_bps_dlg dialog


CChoose_sub_bps_dlg::CChoose_sub_bps_dlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CChoose_sub_bps_dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChoose_sub_bps_dlg)
	m_basis = _T("");
	//}}AFX_DATA_INIT
	m_report_ctrl.SetUniqueName(_T("CChoose_sub_bps_dlg"));
	m_bp=0;
	m_api=0;
	m_title=_T("");
}


void CChoose_sub_bps_dlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChoose_sub_bps_dlg)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_BORDER, m_border);
	DDX_Text(pDX, IDC_BASIS, m_basis);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChoose_sub_bps_dlg, CResizableDialog)
	//{{AFX_MSG_MAP(CChoose_sub_bps_dlg)
	ON_BN_CLICKED(IDC_SELECT_ALL, OnSelectAll)
	ON_BN_CLICKED(IDC_SELECT_NONE, OnSelectNone)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChoose_sub_bps_dlg message handlers
void CChoose_sub_bps_dlg::BuildProcessList()
{
	if(!m_api) return;
	if(!m_bp) return;
	aplExtent ext,ext1;
	ext.Add(m_bp);
	m_api->m_bp_mgr.GetAllSubBP(m_bp,ext1);
	ext.Append(ext1);
	m_api->m_bp_mgr.LoadBPInfo(ext);
	for(int i=0;i<ext.GetSize();i++)
	{
		if(!ext[i]) continue;
		if(ext[i]->GetAccessmode()>aplRO) continue;
		int num=m_report_ctrl.InsertItem(i,_T(""));
		m_report_ctrl.SetItemData(num,DWORD(ext[i]));
		CString buf;
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_id,buf);
		m_report_ctrl.SetItemText(num,1,buf);
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_code,buf);
		m_report_ctrl.SetItemText(num,2,buf);
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_name,buf);
		m_report_ctrl.SetItemText(num,3,buf);
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_descr,buf);
		m_report_ctrl.SetItemText(num,4,buf);
		CaplInstance *type=0;
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_type,type);
		buf=_T("");
		if(type) m_api->m_data.GetAttr(type,m_api->m_bp_mgr.a_bp_type_name,buf);
		m_report_ctrl.SetItemText(num,5,buf);
	}
	m_report_ctrl.SetCheck(0);

}

BOOL CChoose_sub_bps_dlg::OnInitDialog() 
{
	RECT rect={5,5,10,10};
	m_report_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDS_REP_CTRL);//|LVS_SINGLESEL
	
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_border.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_report_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_report_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_report_ctrl.m_hWnd)
			|LVS_EX_CHECKBOXES |LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);


	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDS_REP_CTRL,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_BASIS_TEXT,BOTTOM_LEFT);
	AddAnchor(IDC_BASIS,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_SELECT_ALL,BOTTOM_LEFT);
	AddAnchor(IDC_SELECT_NONE,BOTTOM_LEFT);
	
	SetWindowText(m_title);
	m_report_ctrl.InsertColumn(0,_T(""),LVCFMT_LEFT,20);	
	m_report_ctrl.InsertColumn(1, APL_T(""),LVCFMT_LEFT,80);	
	m_report_ctrl.InsertColumn(2, APL_T(""),LVCFMT_LEFT,40);
	m_report_ctrl.InsertColumn(3, APL_T(""),LVCFMT_LEFT,100);	
	m_report_ctrl.InsertColumn(4, APL_T(""),LVCFMT_LEFT,100);	
	m_report_ctrl.InsertColumn(5, APL_T(""),LVCFMT_LEFT,100);

	BuildProcessList();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChoose_sub_bps_dlg::OnSelectAll() 
{
	// TODO: Add your control notification handler code here
	for(int i=0;i<m_report_ctrl.GetItemCount();i++)
		m_report_ctrl.SetCheck(i);

		

}

void CChoose_sub_bps_dlg::OnOK() 
{
	if(!UpdateData()) return;

	for(int i=0;i<m_report_ctrl.GetItemCount();i++)
	{
		if(m_report_ctrl.GetCheck(i))
		{
			CaplInstance *inst=(CaplInstance*)m_report_ctrl.GetItemData(i);
			ext_out.Add(inst);
		}
	}
	CResizableDialog::OnOK();
}

void CChoose_sub_bps_dlg::OnSelectNone() 
{
	// TODO: Add your control notification handler code here
	for(int i=0;i<m_report_ctrl.GetItemCount();i++)
		m_report_ctrl.SetCheck(i,false);
}
