// ClassifierTableFrame.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ClassifierTableFrame.h"
#include "ClassifierTableItemsView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClassifierTableFrame

IMPLEMENT_DYNCREATE(CClassifierTableFrame, CFrameWnd)

CClassifierTableFrame::CClassifierTableFrame()
{
}

CClassifierTableFrame::~CClassifierTableFrame()
{
}


BEGIN_MESSAGE_MAP(CClassifierTableFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CClassifierTableFrame)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierTableFrame message handlers

int CClassifierTableFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this,TBSTYLE_FLAT|TBSTYLE_LIST|TBSTYLE_WRAPABLE, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		CRect(0,0,0,0), AFX_IDW_TOOLBAR) ||
		!m_wndToolBar.LoadToolBar(IDR_CLASSIFIER_TABLE_TB))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	
	m_wndToolBar.EnableToolTips();
	
	CBitmap bm;
	HIMAGELIST tmp_il1;
	bm.LoadBitmap(IDB_CLASSIFIER_TABLE_BAR16);
	m_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
	m_il.Add(&bm, RGB(192,192,192));
	bm.DeleteObject();
	m_wndToolBar.GetToolBarCtrl().SetImageList(&m_il);
	
	tmp_il1=aplImageListCopyAsSpecificBlend((HIMAGELIST)(*m_wndToolBar.GetToolBarCtrl().GetImageList()),35,true,RGB(192,192,192));
	m_ild.Attach(tmp_il1);

	m_wndToolBar.GetToolBarCtrl().SetDisabledImageList(&m_ild);


	int idx=m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_SHOW_PROP_IN_FORM);


	for(int i=0;i<m_wndToolBar.GetToolBarCtrl().GetButtonCount();i++)
	{
		UINT but_style=m_wndToolBar.GetButtonStyle(i);
		if((but_style & TBBS_SEPARATOR)==0)
			m_wndToolBar.SetButtonStyle(i,but_style|TBBS_AUTOSIZE);
	}

	TBBUTTONINFO btinfo;
	btinfo.cbSize=sizeof(TBBUTTONINFO);
	btinfo.dwMask=TBIF_STYLE|TBIF_STATE;
	btinfo.fsStyle=TBSTYLE_CHECK|TBBS_AUTOSIZE;
	btinfo.fsState=TBSTATE_PRESSED|TBSTATE_CHECKED;
	m_wndToolBar.GetToolBarCtrl().SetButtonInfo(ID_SHOW_PROP_IN_FORM,&btinfo);
	btinfo.fsState=!TBSTATE_PRESSED&!TBSTATE_CHECKED;
	m_wndToolBar.GetToolBarCtrl().SetButtonInfo(ID_SHOW_BY_FILTR,&btinfo);

//  ID_SHOW_FILTR_PROP
//	ID_SHOW_BY_FILTR

	

//        .   
//	TBBUTTONINFO tbbi;
//	CRect r;
//	tbbi.cbSize = sizeof(TBBUTTONINFO);
//	tbbi.dwMask = TBIF_STATE|TBIF_IMAGE;
//	tbbi.dwMask = TBIF_STATE;
//	UINT cmd_index=m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_SHOW_PROP_IN_FORM);
//	m_wndToolBar.GetToolBarCtrl().GetItemRect(cmd_index, &r);
//	m_wndToolBar.GetToolBarCtrl().GetButtonInfo(ID_SHOW_PROP_IN_FORM, &tbbi);
//	tbbi.fsState |=TBSTATE_ENABLED;
//	tbbi.iImage  =-1;
//	res=m_wndToolBar.GetToolBarCtrl().SetButtonInfo(ID_SHOW_PROP_IN_FORM, &tbbi);
//	res=m_check_btn.Create(_T(""), WS_CHILD|WS_VISIBLE|BS_CHECKBOX|BS_AUTOCHECKBOX, r, &m_wndToolBar, ID_SHOW_PROP_IN_FORM);
//	res=m_wndToolBar.GetToolBarCtrl().EnableButton(ID_SHOW_PROP_IN_FORM);


	return 0;
}

BOOL CClassifierTableFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	pContext->m_pNewViewClass = RUNTIME_CLASS(CClassifierTableItemsView);
	CView* pView = (CView*)CreateView(pContext, AFX_IDW_PANE_FIRST);
	if(pView == NULL)
		return FALSE;
	
	SetActiveView(pView, FALSE);
	
	return TRUE;
}

bool CClassifierTableFrame::SetMode(UINT mode)
{
	if(!(mode&APL_CLASSIFIER_EXE_EDITOR))
	{
		int ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_DB_CONNECT);
		if(ind>-1)
		{
			m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
		}
	}
	return true;
}

UINT CClassifierTableFrame::ShowSelectEntityMenu()
{
	CRect rect;
	m_wndToolBar.GetItemRect(0, &rect);
	CaplMenu menu;
	CMenu *pPopup = NULL;
	menu.LoadMenu(IDR_CLASSIFIER_CONTEXT_MENU);
//	menu.Install(this);
	pPopup = menu.GetSubMenu(1);
	ASSERT(pPopup);

	CPoint pt(rect.left, rect.bottom);
	ClientToScreen(&pt);
	pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON, pt.x, pt.y, this);

	return 0;
}
