// ClassifierTreeFrame.cpp : implementation file
//

#include "stdafx.h"
#include "ClassifierTreeFrame.h"
#include "ClassifierTreeView.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClassifierTreeFrame

IMPLEMENT_DYNCREATE(CClassifierTreeFrame, CFrameWnd)

CClassifierTreeFrame::CClassifierTreeFrame()
{
	m_old_state = 0;
}

CClassifierTreeFrame::~CClassifierTreeFrame()
{
}


BEGIN_MESSAGE_MAP(CClassifierTreeFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CClassifierTreeFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_SHOW_ESQUISSE, OnShowEsquisse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierTreeFrame message handlers

int CClassifierTreeFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this,TBSTYLE_FLAT, WS_CHILD|WS_VISIBLE|CBRS_TOP|
		CBRS_NOALIGN| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		CRect(0,0,0,0), AFX_IDW_TOOLBAR) ||
		!m_wndToolBar.LoadToolBar(IDR_CLASSIFIER_TREE_TB))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	m_wndToolBar.EnableToolTips();
	

	CBitmap bm;
	bm.LoadBitmap(IDB_ELEMBAR16);
	m_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
	m_il.Add(&bm, RGB(192,192,192));
	bm.DeleteObject();
	m_wndToolBar.GetToolBarCtrl().SetImageList(&m_il);
	
	HIMAGELIST tmp_il1=aplImageListCopyAsSpecificBlend((HIMAGELIST)(*m_wndToolBar.GetToolBarCtrl().GetImageList()),35,true);//,RGB(255,255,255));
	m_ild.Attach(tmp_il1);
	m_wndToolBar.GetToolBarCtrl().SetDisabledImageList(&m_ild);
	
	return 0;
}

BOOL CClassifierTreeFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	pContext->m_pNewViewClass = RUNTIME_CLASS(CClassifierTreeView);
	CView* pView = (CView*)CreateView(pContext, AFX_IDW_PANE_FIRST);
	if(pView == NULL)
		return FALSE;
	
	SetActiveView(pView, FALSE);

	return TRUE;
}

BOOL CClassifierTreeFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

bool CClassifierTreeFrame::SetMode(UINT mode)
{
	if(mode&APL_HIDE_ESQUISSE)
	{
		int ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_SHOW_ESQUISSE)-1;
		m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
		m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
	}

	if(mode&APL_CLASSIFIER_EXE_EDITOR) return true;

	else if(mode&APL_CLASSIFIER_EDITOR)
	{
		if(::IsWindow(m_wndToolBar.m_hWnd))
		{
			int ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_DB_CONNECT);
			if(ind>-1)
			{
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			}
		}
	}
	else
	{
		if(::IsWindow(m_wndToolBar.m_hWnd))
		{
			int ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_DB_CONNECT);
			if(ind>-1)
			{
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			}
			ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_ADD_CLASSIFIER_SYSTEM);
			if(ind>-1)
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_ADD_CLASSIFIER_ELEMENT);
			if(ind>-1)
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_EDIT_ELEMENT);
			if(ind>-1)
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			ind = m_wndToolBar.GetToolBarCtrl().CommandToIndex(ID_DELETE_ELEMENT);
			if(ind>-1)
			{
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
				m_wndToolBar.GetToolBarCtrl().DeleteButton(ind);
			}
		}
	}

	return true;
}

void CClassifierTreeFrame::OnShowEsquisse() 
{
	CSplitterWnd *pWnd = (CSplitterWnd*)GetParent();
	if(pWnd && ::IsWindow(pWnd->m_hWnd))
	{
		int tmp, tmp1;
		pWnd->GetRowInfo(1, tmp1, tmp);
		if(tmp1!=0)
		{
			CRect rect;
			pWnd->GetClientRect(&rect);
			pWnd->SetRowInfo(0, rect.Height(), 0);
			pWnd->SetRowInfo(1, 0, 0);
			pWnd->RecalcLayout();
			m_old_state = tmp1;
		}
		else
		{
			CRect rect;
			pWnd->GetClientRect(&rect);
			pWnd->SetRowInfo(0, rect.Height()-m_old_state-11, 0);
			pWnd->SetRowInfo(1, 0, 0);
			pWnd->RecalcLayout();
		}
	}
}
