#ifndef _APL_CHNGS_COMMON_CLASSES_
#define _APL_CHNGS_COMMON_CLASSES_

#include "apl_api.h"

class CPSCItemInfo
{
public:
	CaplInstance* m_pdr; // -    
	CaplInstance* m_pdf; //  
	
	double m_value; // ...
	CaplInstance* m_unit; //. .

	CString m_sId; //
	CString m_sName;
	CString m_sDscr;
	CString m_sBasis; //
	CString m_sStock; //

	CString m_sEffType; // - none, dated, numbered
	CString m_sStartCond; //...
	CString m_sEndCond; //   

	CString m_sPosition;//  
	CString m_sPositionNum;// 
	aplExtent m_contexts;
	aplExtent m_attachment;
	
	double m_der_value; // ...
	CaplInstance* m_der_unit; //. .
	
	CString m_razmer;
	CString m_tehTreb;
	int m_prior;
	CaplInstance* m_sort;

	CPSCItemInfo(CaplInstance* pdr, CaplInstance* pdf, 
		CString id, CString name, CString dscr,  
		double d, CaplInstance* unit, double der_d, CaplInstance* der_unit, 
		int prior, CString razmer, CString tehTreb, CaplInstance* sort,
		CString type, CString start, CString end)
	{
		m_pdr= pdr;
		m_pdf= pdf;
		
		m_sId= id;
		m_sName= name;
		m_sDscr= dscr;
		
		m_value= d;
		m_unit= unit;
		m_der_value= der_d;
		m_der_unit= der_unit;
		
		m_prior= prior;
		m_razmer= razmer;
		m_tehTreb= tehTreb;
		m_sort= sort;
		
		m_sEffType= type;
		m_sStartCond= start;
		m_sEndCond= end;
	}

	CPSCItemInfo(CaplInstance* pdr= NULL, CaplInstance* pdf= NULL, 
		double d= 0, CaplInstance* unit= NULL, 
		CString id= _T(""), CString name= _T(""), CString dscr= _T(""),  
		CString basis= _T(""), CString stock= _T(""),
		CString type= _T(""), CString start= _T(""), CString end= _T(""))
	{
		m_pdr= pdr;
		m_pdf= pdf;
		
		m_value= d;
		m_unit= unit;
		
		m_sId= id;
		m_sName= name;
		m_sDscr= dscr;
		m_sBasis= basis;
		m_sStock= stock;

		m_sEffType= type;
		m_sStartCond= start;
		m_sEndCond= end;

		m_sPosition= _T("");
		m_sPositionNum= _T("");
		m_der_value= 0;
		m_der_unit= NULL;
		
		m_prior= -1;
		m_razmer= _T("");
		m_tehTreb= _T("");
		m_sort= NULL;
	}

	~CPSCItemInfo()
	{
		
	}

	bool SetContexts(const aplExtent &aggr)
	{
//		if(aggr.GetSize())
		{
			m_contexts.Clear();
			for(int i= 0; i<aggr.Size; i++)
			{
				m_contexts.Add(aggr[i]);
			}
		}
		return true;
	}

	bool SetAttachment(const aplExtent &aggr)
	{
//		if(aggr.GetSize())
		{
			m_attachment.Clear();
			for(int i= 0; i<aggr.Size; i++)
			{
				m_attachment.Add(aggr[i]);
			}
		}
		return true;
	}

	CPSCItemInfo(const CPSCItemInfo &x)
	{
		m_pdr		= x.m_pdr;
		m_pdf		= x.m_pdf;		
		m_value		= x.m_value;
		m_unit		= x.m_unit;
		m_sPosition	= x.m_sPosition;
		m_sPositionNum= x.m_sPositionNum;
		m_sId		= x.m_sId;
		m_sName		= x.m_sName;
		m_sDscr		= x.m_sDscr;
		m_sBasis	= x.m_sBasis;
		m_sStock	= x.m_sStock;

		m_sEffType	= x.m_sEffType;
		m_sStartCond= x.m_sStartCond;
		m_sEndCond	= x.m_sEndCond;
		
		m_der_value	= x.m_der_value;
		m_der_unit	= x.m_der_unit;
		
		m_prior		= x.m_prior;
		m_razmer	= x.m_razmer;
		m_tehTreb	= x.m_tehTreb;
		m_sort		= x.m_sort;
		
		SetContexts(x.m_contexts);
		SetAttachment(x.m_attachment);	
	}

	CPSCItemInfo & operator = (const CPSCItemInfo &x)
	{
		m_pdr		= x.m_pdr;
		m_pdf		= x.m_pdf;
		m_value		= x.m_value;
		m_unit		= x.m_unit;
		m_sPosition	= x.m_sPosition;
		m_sPositionNum	= x.m_sPositionNum;
		m_sId		= x.m_sId;
		m_sName		= x.m_sName;
		m_sDscr		= x.m_sDscr;
		m_sBasis	= x.m_sBasis;
		m_sStock	= x.m_sStock;
		m_sEffType	= x.m_sEffType;
		m_sStartCond= x.m_sStartCond;
		m_sEndCond	= x.m_sEndCond;
		
		m_der_value= x.m_der_value;
		m_der_unit= x.m_der_unit;
		
		m_prior= x.m_prior;
		m_razmer= x.m_razmer;
		m_tehTreb= x.m_tehTreb;
		m_sort= x.m_sort;
		
		SetContexts(x.m_contexts);
		SetAttachment(x.m_attachment);
		
		return *this;
	}
};
 
class CDAVCItemInfo
{
public:
	CString m_sId;			// 
	CString m_sDscr; 
	CString m_sNewState; 
	CString m_sNotes;		//   
	CString m_sBasis;		// 
	CString m_sStock;		// 
	CString m_sDate;		// 
	CaplInstance* m_newVer;
	CString m_sUser;
	CaplInstance* m_person;

	CString m_sMethod;

	aplExtent m_ext4AddToItem;
	aplExtent m_ext4DelFromItem;
	
	aplExtent m_attachment;

	CDAVCItemInfo(CaplInstance* newVer= NULL,
		CString id= _T(""), CString dscr= _T(""), CString sNewState= _T(""), CString basis= _T(""), CString stock= _T(""), CString date= _T(""), 
		CString user= _T(""), CaplInstance* person= NULL)
	{
		m_sId		= id;
		m_sDscr		= dscr;
		m_sBasis	= basis;
		m_sStock	= stock;
		m_newVer	= newVer;
		m_sDate		= date;
		m_sUser		= user;
		m_person	= person;
		m_sNewState	= sNewState;
	}

	CDAVCItemInfo(const CDAVCItemInfo & x)
	{
		m_sId		= x.m_sId;
		m_sDscr		= x.m_sDscr;
		m_sNotes	= x.m_sNotes;
		m_sBasis	= x.m_sBasis;
		m_sStock	= x.m_sStock;
		m_newVer	= x.m_newVer;
		m_sDate		= x.m_sDate;
		m_sUser		= x.m_sUser;
		m_person	= x.m_person;
		m_sNewState	= x.m_sNewState;

		SetAttachment(x.m_attachment);

		m_sMethod=x.m_sMethod;
		m_ext4AddToItem.Clear();	m_ext4AddToItem.Append(x.m_ext4AddToItem);
		m_ext4DelFromItem.Clear();	m_ext4DelFromItem.Append(x.m_ext4DelFromItem);
	}

	~CDAVCItemInfo()
	{
	}

	CDAVCItemInfo & operator = (const CDAVCItemInfo &x)
	{
		m_sId		= x.m_sId;
		m_sDscr		= x.m_sDscr;
		m_sNotes	= x.m_sNotes;
		m_sBasis	= x.m_sBasis;
		m_sStock	= x.m_sStock;
		m_newVer	= x.m_newVer;
		m_sDate		= x.m_sDate;
		m_sUser		= x.m_sUser;
		m_person	= x.m_person;
		m_sNewState	= x.m_sNewState;


		SetAttachment(x.m_attachment);

		m_sMethod=x.m_sMethod;
		m_ext4AddToItem.Clear();	m_ext4AddToItem.Append(x.m_ext4AddToItem);
		m_ext4DelFromItem.Clear();	m_ext4DelFromItem.Append(x.m_ext4DelFromItem);

		return *this;
	}

	bool SetAttachment(const aplExtent &aggr)
	{
//		if(aggr.GetSize())
		{
			m_attachment.Clear();
			m_attachment.Append(aggr);
		}
		return true;
	}
};

class CPdrChangeMap
{
	int m_type;

	CaplInstance* m_pdr;
	CaplInstance* m_psc;
};

#endif //_APL_CHNGS_COMMON_CLASSES_