// DlgEditStrParam.cpp : implementation file
//

#include "stdafx.h"
#include "DlgEditStrParam.h"
#include <CaplLDAP.h>

// CDlgEditStrParam dialog

IMPLEMENT_DYNAMIC(CDlgEditStrParam, CaplTranslateDialog)

CDlgEditStrParam::CDlgEditStrParam(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgEditStrParam::IDD, pParent)
	, m_NameParam(_T(""))
	, m_Param(_T(""))
	, m_NameValue(_T(""))
	, m_Value(_T(""))
{
	m_Titul = _T("");
}

CDlgEditStrParam::~CDlgEditStrParam()
{
}

void CDlgEditStrParam::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_PARAM, m_NameParam);
	DDX_Text(pDX, IDC_EDIT_PARAM, m_Param);
	DDX_Text(pDX, IDC_STATIC_NAME, m_NameValue);
	DDX_Text(pDX, IDC_EDIT_VALUE, m_Value);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_EDIT_PARAM, m_domain_ctrl);
	DDX_Control(pDX, IDC_EDIT_VALUE, m_srv_ctrl);
}


BEGIN_MESSAGE_MAP(CDlgEditStrParam, CaplTranslateDialog)
	ON_BN_CLICKED(ID_GET_CUR, &CDlgEditStrParam::OnBnClickedGetCur)
	ON_BN_CLICKED(ID_TEST, &CDlgEditStrParam::OnBnClickedTest)
END_MESSAGE_MAP()


// CDlgEditStrParam message handlers

BOOL CDlgEditStrParam::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	// TODO:  Add extra initialization here

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_Titul!=_T(""))
	{
		SetWindowText(m_Titul);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgEditStrParam::OnBnClickedGetCur()
{
	// TODO: Add your control notification handler code here
	CString domain,server;
	CaplLDAP::GetCurrentWindowsDomainName(domain);
	if(domain==_T("")) {AfxMessageBox(APL_T("    !")); return;}
	m_domain_ctrl.SetWindowText(domain);

	CaplLDAP::GetCurrentWindowsDomainServer(server);
	m_srv_ctrl.SetWindowText(server);

}

void CDlgEditStrParam::OnBnClickedTest()
{
	CString domain,server;
	m_domain_ctrl.GetWindowText(domain);
	m_srv_ctrl.GetWindowText(server);
	if(domain==_T("")) {AfxMessageBox(APL_T("  !")); return;}

	CaplLDAP ldap;
	if(ldap.Init(domain,server))AfxMessageBox(APL_T("    !\n\n(    !)"),MB_ICONINFORMATION |MB_OK);
	else AfxMessageBox(APL_T(" !"),MB_ICONSTOP|MB_OK);
}
