// DlgIPDiapazon.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgIPDiapazon.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


void PutIpFromDWORD(DWORD ip,CIPAddressCtrl &CtrlIP)
{
	BYTE b1,b2,b3,b4;
	b1=(BYTE)ip&0x000000FF;
	ip>>=8;
	b2=(BYTE)ip&0x000000FF;
	ip>>=8;
	b3=(BYTE)ip&0x000000FF;
	ip>>=8;
	b4=(BYTE)ip&0x000000FF;
	CtrlIP.SetAddress(b1,b2,b3,b4);
	
}

void GetIp2DWORD(CIPAddressCtrl &CtrlIP,DWORD &ip)
{
	BYTE b1,b2,b3,b4;
	CtrlIP.GetAddress(b1,b2,b3,b4);
	ip=b4*0x1000000+b3*0x10000+b2*0x100+b1;
	
}


/////////////////////////////////////////////////////////////////////////////
// CDlgIPDiapazon dialog


CDlgIPDiapazon::CDlgIPDiapazon(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgIPDiapazon::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgIPDiapazon)
	m_Mode = 1;
	//}}AFX_DATA_INIT
	m_IP1=0;
	m_IP2=0;

}


void CDlgIPDiapazon::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgIPDiapazon)
	DDX_Control(pDX, IDC_STATIC_TO, m_StTo);
	DDX_Control(pDX, IDC_STATIC_FROM, m_StFrom);
	DDX_Control(pDX, IDC_IPADDRESS2, m_CtrlIP2);
	DDX_Control(pDX, IDC_IPADDRESS1, m_CtrlIP1);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_CBIndex(pDX, IDC_COMBO_MODE, m_Mode);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_COMBO_MODE, m_ModeCtrl);
}


BEGIN_MESSAGE_MAP(CDlgIPDiapazon, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDlgIPDiapazon)
	ON_CBN_SELCHANGE(IDC_COMBO_MODE, OnSelchangeComboMode)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgIPDiapazon message handlers

BOOL CDlgIPDiapazon::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);

	m_ModeCtrl.ResetContent();
	m_ModeCtrl.InsertString(0,APL_T(" "));
	m_ModeCtrl.InsertString(1,APL_T(" "));

	// TODO: Add extra initialization here
	PutIpFromDWORD(m_IP1,m_CtrlIP1);
	PutIpFromDWORD(m_IP2,m_CtrlIP2);

	if(m_IP2==m_IP1){
		m_Mode=0;
	}
	UpdateData(FALSE);
	OnSelchangeComboMode();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CDlgIPDiapazon::OnOK() 
{
	// TODO: Add extra validation here
	GetIp2DWORD(m_CtrlIP1,m_IP1);
	if(m_Mode==0){
		m_IP2=m_IP1;
	}else{
		GetIp2DWORD(m_CtrlIP2,m_IP2);
	}
// 	m_CtrlIP1.GetAddress(m_IP1);
// 	m_CtrlIP2.GetAddress(m_IP2);
	
	CaplTranslateDialog::OnOK();

}

void CDlgIPDiapazon::OnSelchangeComboMode() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_Mode==0){
		m_StFrom.SetWindowText( _T("IP:"));
		m_StTo.ShowWindow(SW_HIDE);
		m_CtrlIP2.ShowWindow(SW_HIDE);
	}else{
		m_StFrom.SetWindowText(APL_T(":"));
		m_StTo.SetWindowText( APL_T(":"));
		m_StTo.ShowWindow(SW_SHOW);
		m_CtrlIP2.ShowWindow(SW_SHOW);
	}
}
