// DlgListCharTypes.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgListCharTypes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgListCharTypes dialog


CDlgListCharTypes::CDlgListCharTypes(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgListCharTypes::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgListCharTypes)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_ListCharact.SetUniqueName(_T("apl_psm_DlgListCharTypes"));
	m_selected_char=0;
	m_list_charact=0;

}


void CDlgListCharTypes::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgListCharTypes)
	DDX_Control(pDX, IDC_BUTTON_REMOVE, m_BtnCharRemove);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY, m_BtnCharProp);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_BtnCharAdd);
//	DDX_Control(pDX, IDC_LIST_ADJUST, m_ListCharact);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgListCharTypes, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDlgListCharTypes)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY, OnButtonProperty)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgListCharTypes message handlers

BOOL CDlgListCharTypes::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	if(m_api==0) return FALSE;
	if(m_list_charact==0) return FALSE;
	
	// TODO: Add extra initialization here
	m_BtnCharAdd.SetFlat(FALSE);
	m_BtnCharAdd.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_BtnCharProp.SetFlat(FALSE);
	m_BtnCharProp.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_BtnCharRemove.SetFlat(FALSE);
	m_BtnCharRemove.SetIcon(GetAplTableIco(APL_TABLE_DEL));

	CRect rect;
	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_CHARACT);
	::GetWindowRect(hWnd,rect);
	ScreenToClient(rect);
	m_ListCharact.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|WS_TABSTOP|LVS_SHOWSELALWAYS|LVS_SINGLESEL,rect,this,IDC_LIST_CHARACT);
//	m_ListCharact.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW);
//	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_CHARACT);
	ListView_SetExtendedListViewStyle(hWnd, 
		ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);
	
	//     
	m_ListCharact.GetWindowRect(&rect);
	m_ListCharact.InsertColumn(0, APL_T(""),LVCFMT_LEFT,(rect.Width()*6)/10);
	m_ListCharact.InsertColumn(1, APL_T(""),LVCFMT_LEFT,(rect.Width()*4)/10);
//	m_ListCharact.InsertColumn(2,APL_T(""),LVCFMT_LEFT,(rect.Width()*5)/20);

	FillCharacteristikList();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgListCharTypes::FillCharacteristikList()
{
	int i,pos;
	CaplInstance *char_and_type,*charact,*type;
	bool required;
	CString buf;
	m_ListCharact.DeleteAllItems();
	if(m_list_charact==0) return;
	for(i=0;i<m_list_charact->GetSize();i++){
		char_and_type=m_list_charact->GetAt(i);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_characteristic, charact);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_type, type);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_required, required);
		m_api->GetItemName(charact,buf);
		pos=m_ListCharact.InsertItem(i,buf);
		m_ListCharact.SetItemData(pos,(DWORD)char_and_type);
		if(m_selected_char==char_and_type){
			m_ListCharact.SetSelectionMark(pos);
		}
		if(type!=0){m_api->GetItemName(type,buf);}else{buf=_T("");}
		m_ListCharact.SetItemText(pos,1,buf);
		buf=required? APL_T(""):_T("");
		m_ListCharact.SetItemText(pos,2,buf);
	}

}

void CDlgListCharTypes::OnButtonAdd() 
{
	if(m_api==0) return;
	if(m_list_charact==0) return;
	// TODO: Add your control notification handler code here
	m_selected_char= m_api->m_charact_mgr.CreateCharacteristicAndType(0,0,0,false,true,m_list_charact);
	if(m_selected_char!=0){
		m_selected_char->SetTemporary(true);
		m_list_charact->Add(m_selected_char);
		FillCharacteristikList();
	}
	
}

void CDlgListCharTypes::OnButtonRemove() 
{
	if(m_api==0) return;
	if(m_list_charact==0) return;
	// TODO: Add your control notification handler code here
	// 
	int num_curr= m_ListCharact.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	m_selected_char=(CaplInstance*)m_ListCharact.GetItemData(num_curr);
	if(m_selected_char==0){
		AfxMessageBox( APL_T("  !   "));
		FillCharacteristikList(); 
		return;
	}
	int i;
	for(i=0;i<m_list_charact->GetSize();i++){
		if((*m_list_charact)[i]==m_selected_char){
			m_list_charact->Remove(i);break;
		}
	}
	m_selected_char=0;
	FillCharacteristikList();
}

void CDlgListCharTypes::OnButtonProperty() 
{
	if(m_api==0) return;
	if(m_list_charact==0) return;
	// TODO: Add your control notification handler code here
	int num_curr= m_ListCharact.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	m_selected_char=(CaplInstance*)m_ListCharact.GetItemData(num_curr);
	if(m_selected_char==0){
		AfxMessageBox( APL_T("  !   "));
		FillCharacteristikList(); 
		return;
	}
	if(m_api->m_charact_mgr.CharacteristicAndTypeProperties(m_selected_char,false))
	{
		FillCharacteristikList();
	}
	
}

