#include "stdafx.h"
#include "apl_api.h"
#include "FindQueryDlg.h"
#include "FindQueryDlgEx.h"
#include "dictionary.h"

#include "FindQueryNiiao.h"
#include "FindDlg.h"
#include "DlgListInstances.h"
#include "FindInContent.h"
#include "AnalizeGroupInstances.h"
#include "QueryChildFrame.h"



//////////////////////////////////////////////////////////////////////
//    MDI  child       
CMDIChildWnd* aplCreateQueryFrame(CMDIFrameWnd *pMainFrame, CaplAPI* api, UINT nFrameResourceID)
{
	if(api==NULL) return NULL;

	CQueryChildFrame* pFrame=(CQueryChildFrame*)pMainFrame->CreateNewChild(RUNTIME_CLASS(CQueryChildFrame), nFrameResourceID, NULL, NULL);
	if(pFrame)
	{
		if(!pFrame->Init(api))
		{
			pFrame->DestroyWindow();
			return 0;
		}
	}
	return pFrame;
}

//////////////////////////////////////////////////////////////////////
//          
CSplitterWnd* aplCreateQuerySplitter(CWnd* pParentWnd, CaplAPI* api, CCreateContext *pContext)
{
	RECT rect={-1,0,100,100};

	if(api==NULL) return NULL;

	CQuerySplitterWnd* pSplitter = (CQuerySplitterWnd*)(RUNTIME_CLASS(CQuerySplitterWnd)->CreateObject());
	if(pSplitter)
	{
		CaplSetResourceHandle setres(module_inst);

		pSplitter->CreateEx(pParentWnd,pContext);
		pSplitter->ShowWindow(SW_HIDE);

		pSplitter->Init(api);
	}
	return (CSplitterWnd*)pSplitter;
}


CaplQueryManager::CaplQueryManager(){
	Detach();
}
CaplQueryManager::~CaplQueryManager(){
	Detach();
}

bool CaplQueryManager::Attach(CaplAPI *api)
{
	if(api==0) {Detach();return false;}
	CaplStepManager::Attach(api);
	m_AllAttrDefined=true;
	m_is_old_dlg = false;
	
	CHECK_ZERO_ATTR(e_apl_query,m_data->GetEntityBN(_T("apl_query")));
	CHECK_ZERO_ATTR(a_apl_query_name,m_data->GetAttrDefinition(e_apl_query,_T("name")));
	CHECK_ZERO_ATTR(a_apl_query_name,m_data->GetAttrDefinition(e_apl_query,_T("name")));
	CHECK_ZERO_ATTR(a_apl_query_description,m_data->GetAttrDefinition(e_apl_query,_T("description")));
	CHECK_ZERO_ATTR(a_apl_query_is_text_query,m_data->GetAttrDefinition(e_apl_query,_T("is_text_query")));	
	CHECK_ZERO_ATTR(a_apl_query_text_query,m_data->GetAttrDefinition(e_apl_query,_T("text_query")));	
	CHECK_ZERO_ATTR(a_apl_query_dialog_data,m_data->GetAttrDefinition(e_apl_query,_T("dialog_data")));	
	CHECK_ZERO_ATTR(a_apl_query_content,m_data->GetAttrDefinition(e_apl_query,_T("content")));	
	CHECK_ZERO_ATTR(a_apl_query_execution_date,m_data->GetAttrDefinition(e_apl_query,_T("execution_date")));
	CHECK_ZERO_ATTR(a_apl_query_execution_size,m_data->GetAttrDefinition(e_apl_query,_T("execution_size")));
	CHECK_ZERO_ATTR(a_apl_query_make_table,m_data->GetAttrDefinition(e_apl_query,_T("make_table")));
	CHECK_ZERO_ATTR(a_apl_query_temp_data_index,m_data->GetAttrDefinition(e_apl_query,_T("temp_data_index")));
	CHECK_ZERO_ATTR(a_apl_query_mode,m_data->GetAttrDefinition(e_apl_query,_T("mode")));
	CHECK_ZERO_ATTR(a_apl_query_combined_table,m_data->GetAttrDefinition(e_apl_query,_T("combined_table")));
	
	CHECK_ZERO_ATTR(a_apl_query_type, m_data->GetAttrDefinition(e_apl_query,_T("type")));
	CHECK_ZERO_ATTR(a_apl_query_dot_name, m_data->GetAttrDefinition(e_apl_query,_T("dot_name")));
	CHECK_ZERO_ATTR(a_apl_query_folder, m_data->GetAttrDefinition(e_apl_query,_T("folder")));
	
	CHECK_ZERO_ATTR(e_apl_ct,m_data->GetEntityBN(_T("apl_combined_table")));
	CHECK_ZERO_ATTR(a_apl_ct_name,m_data->GetAttrDefinition(e_apl_ct,_T("name")));
	CHECK_ZERO_ATTR(a_apl_ct_description,m_data->GetAttrDefinition(e_apl_ct,_T("description")));
	CHECK_ZERO_ATTR(a_apl_ct_columns_data,m_data->GetAttrDefinition(e_apl_ct,_T("columns_data")));
	CHECK_ZERO_ATTR(a_apl_ct_query,m_data->GetAttrDefinition(e_apl_ct,_T("query")));
	CHECK_ZERO_ATTR(a_apl_ct_temp_data_index,m_data->GetAttrDefinition(e_apl_ct,_T("temp_data_index")));

	TUListPEntity ListTopLevelEntities;
	GetListTopLevelEntities(ListTopLevelEntities);
	m_ListTopLevelEntities.Clear();
	int i,j;
	CaplEntity* ent;
	for(i=0;i<ListTopLevelEntities.GetSize();i++)
	{
		ent=ListTopLevelEntities[i];
		if(ent==0)continue;
		m_ListTopLevelEntities.Add((long)ent,0);
		for(j=0;j<ent->all_subtypes.GetSize();j++)
		{
			m_ListTopLevelEntities.Add((long)ent->all_subtypes.GetAt(j),0);
		}
	}

	return true;
}

void CaplQueryManager::Detach()
{
	e_apl_query=0;
	a_apl_query_name=0;
	a_apl_query_description=0;
	a_apl_query_is_text_query=0;	
	a_apl_query_text_query=0;	
	a_apl_query_dialog_data=0;	
	a_apl_query_content=0;	
	a_apl_query_make_table=0;
	a_apl_query_temp_data_index=0;
	a_apl_query_mode=0;
	a_apl_query_combined_table=0;

	a_apl_query_type = NULL;
	a_apl_query_dot_name = NULL;
	a_apl_query_folder = NULL;

	e_apl_ct=0;
	a_apl_ct_name=0;
	a_apl_ct_description=0;
	a_apl_ct_columns_data=0;
	a_apl_ct_query=0;
	a_apl_ct_temp_data_index=0;
	
	m_data=0;

	m_ListTopLevelEntities.Clear();
}

/**        */
bool CaplQueryManager::LoadQueryInfo(CaplInstance *find,bool load_content,bool hide_error)
{
	if(find==0)		return false;
	if(find->GetId()==0)	return true;
	if(find->GetType()==0)	return false;
	if(m_data==0)	return false;
	
	aplExtent ext; ext.Unique=false;
	ext.Add(find);
	return LoadQueryInfo(ext,load_content,hide_error);
}

/**        */
bool CaplQueryManager::LoadQueryInfo(aplExtent  &ext,bool load_content,bool hide_error)
{
	int i,count=0;
	if(m_data==0)	return false;
	if(!m_data->IsConnected()) return false;
	CaplLoadData ld_find(m_data,DEF_SOURCE);
	
	for(i=0;i<ext.Size;i++)
	{
		CaplInstance *find=ext[i];
		if(find==0) continue;
		if(find->GetId()==0) continue;
		if(find->GetType()==0) continue;
		
		if(!m_data->IsKindOf(find,e_apl_query))
		{
			return false;
		}
		ld_find.AddQuery(0,find);
		count++;
		
	}
	if(count!=0){
		if(load_content){
			ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_content, true);
		}
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_name, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_description, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_dialog_data, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_execution_date, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_execution_size, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_is_text_query, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_make_table, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_text_query, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_temp_data_index, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_query_mode, true);
		
		if(!ld_find.LoadEx(true,0,_T(""),hide_error))return false;
	}
	
	return true;
}

/**         */
bool CaplQueryManager::LoadCombinedTableInfo(CaplInstance *ct,bool load_content,bool hide_error)
{
	if(ct==0)		return false;
	if(ct->GetId()==0)	return true;
	if(ct->GetType()==0)	return false;
	if(m_data==0)	return false;
	
	aplExtent ext; ext.Unique=false;
	ext.Add(ct);
	return LoadCombinedTableInfo(ext,load_content,hide_error);
}

/**         */
bool CaplQueryManager::LoadCombinedTableInfo(aplExtent  &ext,bool load_content,bool hide_error)
{
	int i,count=0;
	if(m_data==0)	return false;
	CaplLoadData ld_find(m_data,DEF_SOURCE);
	
	for(i=0;i<ext.Size;i++)
	{
		CaplInstance *ct=ext[i];
		if(ct==0) continue;
		if(ct->GetId()==0) continue;
		if(ct->GetType()==0) continue;
		
		if(!m_data->IsKindOf(ct,e_apl_ct))
		{
			return false;
		}
		ld_find.AddQuery(0,ct);
		count++;
		
	}
	if(count!=0){
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_ct_name, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_ct_description, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_ct_columns_data, true);
		ld_find.AddQuery(_T('d'), 0, 0,a_apl_ct_temp_data_index, true);
		i=	ld_find.AddQuery(_T('d'), 0, 0,a_apl_ct_query, true);


		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_name, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_description, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_dialog_data, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_execution_date, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_execution_size, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_is_text_query, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_make_table, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_text_query, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_temp_data_index, true);
		ld_find.AddQuery(_T('d'), i, 0,a_apl_query_mode, true);
		if(load_content){
			ld_find.AddQuery(_T('d'), i, 0,a_apl_query_content, true);
		}
		
		if(!ld_find.LoadEx(true,0,_T(""),hide_error))return false;
	}
	
	return true;
}

/**          */
bool CaplQueryManager::ReadCombinedTableColumnsInfo(CaplInstance *ct,CaplDataBuf &dbuf,bool hide_error)
{
	long size;
	if(m_data==0)	return false;

	if(ct==0) return false;
	if(ct->GetId()==0) return false;
	if(ct->GetTemporary()==0) return false;
	if(ct->GetType()==0) return false;
	
	if(!m_data->IsKindOf(ct,e_apl_ct))
	{
		return false;
	}
	dbuf.Clear();
	
	//  
	m_data->NET_GetBlobSize(ct,a_apl_ct_columns_data,size);
	dbuf.SetSize(size);
	m_data->NET_LoadBlob2Memory(ct,a_apl_ct_columns_data,(BYTE*)dbuf.GetBuffer(),size);
	
	return true;
}

/**          */
bool CaplQueryManager::SaveCombinedTableColumnsInfo(CaplInstance *ct,CaplDataBuf &dbuf,bool hide_error)
{
	long code;
	bool res_b = false;
	if(m_data==0)	return false;
	if(ct==0) return false;
	if(ct->GetId()==0) return false;
	if(ct->GetTemporary()) return false;
	if(ct->GetType()==0) return false;
	
	if(!m_data->IsKindOf(ct,e_apl_ct))
	{
		return false;
	}
	
	if(dbuf.m_Size>0){
		res_b=m_data->NET_SaveFileFromMemory(ct,a_apl_ct_columns_data,
			(BYTE*)dbuf.GetBuffer(),dbuf.m_Size,code);
	}

	return res_b;
}

CaplInstance* CaplQueryManager::ShowCombinedTable(CaplInstance *basic,CString name)
{
	CString str,str1;
	CaplInstance* combined_table=0;
	CaplInstance* query=0;
	if(basic==0){
		combined_table=m_data->CreateInstance(e_apl_ct,true);
		m_data->PutAttr(combined_table,a_apl_ct_name,name);
		m_data->PutAttr(combined_table,a_apl_ct_temp_data_index,0);
	}else{
		if(m_data->IsKindOf(basic,e_apl_ct)){
			combined_table=basic;
		}else if(m_data->IsKindOf(basic,e_apl_query)){
			UpdateTypeQuery(basic);
			m_data->GetAttr(basic,a_apl_query_mode,str);
			if(str!=_T("Query_niiao")){
				AfxMessageBox( APL_T("       !"));
				return 0;
			}
			m_data->GetAttr(basic,a_apl_query_combined_table,combined_table);
			if(combined_table==0){
				combined_table=m_data->CreateInstance(e_apl_ct,true);
				if(combined_table==0)return 0;
				GetName(basic,str,str1);
				str1= APL_T("     ")+str;
				m_data->PutAttr(combined_table,a_apl_ct_name,str1);
				m_data->PutAttr(combined_table,a_apl_ct_temp_data_index,0);
				query=CopyQuery(basic,true);
				m_data->PutAttr(query,a_apl_query_combined_table,combined_table);
				m_data->PutAttr(combined_table,a_apl_ct_query,query);
			}
		}else{
			AfxMessageBox( APL_T("      !"));
			return 0;
		}
	}

	CaplSetResourceHandle setres(module_inst);
	CAnalizeGroupInstances dlg;
	dlg.m_content=0;
	dlg.m_combined_table=combined_table;
	dlg.m_api=m_api;
	int res=dlg.DoModal();
	if(res==IDOK){
		res=res;
	}
	return combined_table;
}

CaplInstance* CaplQueryManager::PrepareFind(CaplInstance *query,CString mode,CString predef_id,CString predef_name)
{
	bool flag_create;
	CString str,str2,description;
	int temp_indx=0,indx=-1;

	CaplDataBuf *dbuf=0;
	DWORD res;
	if(m_data==0)	return 0;
	if(query==0){
		flag_create=true;
		query=m_data->CreateInstance(e_apl_query,true);
		if(query==0){
			AfxMessageBox( APL_T("  : ")+str,MB_OK|MB_ICONERROR);
			return 0;
		}
		m_data->PutAttr(query,a_apl_query_temp_data_index,0);
	}

	CFindDlg dlg;
	GetFindParams(query,&dlg);

	if(predef_id!=_T("")){
		dlg.m_id_str=predef_id;
		dlg.m_id=true;
	}
	if(predef_name!=_T("")){
		dlg.m_name_str=predef_name;
		dlg.m_name=true;
	}
	if(mode!=_T("")){
		dlg.m_mode=mode;
	}
	if(predef_id==_T("") && predef_name==_T("") || mode==_T("")){
		CaplSetResourceHandle setres(module_inst);
		
		res=dlg.DoModal();
		if(res!=IDOK) return 0;
	}else{
		dlg.m_name=(predef_name!=_T(""));
		dlg.m_id=(predef_id!=_T(""));
	}
	
	if(query->GetAccessmode()<aplRO){
		m_data->PutAttr(query,a_apl_query_mode,_T("Find"));
		m_data->PutAttr(query,a_apl_query_is_text_query,false);
		m_data->PutAttr(query,a_apl_query_description, APL_T(" "));
		m_data->PutAttr(query,a_apl_query_text_query,_T(""));
		m_data->PutAttr(query,a_apl_query_make_table,false);
	}
	
	description= APL_T(" : ");
	if(dlg.m_mode==_T("product")) description+= APL_T(" ");
	else if(dlg.m_mode==_T("document")) description+= APL_T(" ");
	else if(dlg.m_mode==_T("lot")) description+= APL_T("  ");
	else if(dlg.m_mode==_T("product_instance")) description+= APL_T("  ");
	else if(dlg.m_mode==_T("bp")) description+= APL_T(" -");
	else if(dlg.m_mode==_T("process")) description+= APL_T(" ");
	else if(dlg.m_mode==_T("change")) description+= APL_T("  ");
	
	if(dlg.m_id)
	{
		description+=_T(" ID ");
		if(dlg.m_id_equ) description+=_T("= "); else description+=_T("like ");
		description+=_T("\""); description+=dlg.m_id_str;description+=_T("\"");
	}
	if(dlg.m_name)
	{
		if(dlg.m_id) description+=_T(" AND");
		description+=_T(" NAME ");
		if(dlg.m_id_equ) description+=_T("= "); else description+=_T("like ");
		description+=_T("\""); description+=dlg.m_name_str;description+=_T("\"");
	}
	if(query->GetAccessmode()<aplRO)m_data->PutAttr(query,a_apl_query_description,description);

	
	SetFindParams(query,&dlg);
	
	return query;
}

/**    
	@param query -  . 
	@param mode -    .  :
		"product"
		"document"
		"lot"
		"product_instance"
		"bp"
	@param is_id -      id
	@param id -     id
	@param is_name -       (  )
	@param name -      (  )
	@param is_equal -  true,     ,  
					 false -   ,     
	@return true     false    */
bool CaplQueryManager::GetFindParams(CaplInstance *query,CString &mode,BOOL &is_id,CString &id,
							BOOL &is_name,CString &name,BOOL &is_equal)
{
	if(m_data==0)	return false;
	if(query==0)	return false;

	
	id=_T("");
	name=_T("");
	CFindDlg dlg;
	
	if(!GetFindParams(query,&dlg))return false;
	
	mode=dlg.m_mode;
	
	if(dlg.m_id==TRUE){is_id=TRUE;id=dlg.m_id_str;}else is_id=FALSE;
	if(dlg.m_name==TRUE){is_name=TRUE;name=dlg.m_name_str;}else is_name=FALSE;
	is_equal=dlg.m_id_equ==TRUE;

	return true;
}

bool CaplQueryManager::GetFindParams(CaplInstance *query,CFindDlg *dlg)
{
	int temp_indx=0,indx=-1;
	long size =0;
	BYTE* b_buf =0;
	CaplDataBuf *dbuf=0;
	CaplDataBuf dbuf_internal;
	
	if(query==0)return false;
	if(dlg==0)return false;

	if(query->GetTemporary())
	{
		m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
		dbuf=(CaplDataBuf*)temp_indx;
		indx=m_data->m_query_temporary_data.Find(dbuf);
		if(indx==-1){
			dbuf=&dbuf_internal;
		}
	}else{
		dbuf=&dbuf_internal;
		m_data->NET_GetBlobSize(query,a_apl_query_dialog_data,size);
		b_buf=new BYTE[size];
		m_data->NET_LoadBlob2Memory(query,a_apl_query_dialog_data,b_buf,size);
		dbuf->Clear();
		dbuf->Add(b_buf,size);
		delete []b_buf;
		b_buf=0;
	}
	
	dlg->LoadDataFromBuf(*dbuf);

	return true;
}

/**    
	@param query -  . 
	@param mode -    .  :
		"product"
		"document"
		"lot"
		"product_instance"
		"bp"
	@param is_id -      id
	@param id -     id
	@param is_name -       (  )
	@param name -      (  )
	@param is_equal -  true,     ,  
					 false -   ,     
	@return true     false    */
bool CaplQueryManager::SetFindParams(CaplInstance *query,CString &mode,BOOL is_id,CString &id,
							BOOL is_name,CString &name,BOOL is_equal)
{
	CFindDlg dlg;
	dlg.m_mode=mode;
	dlg.m_id=is_id;
	dlg.m_id_str=id;
	dlg.m_name=is_name;
	dlg.m_name_str=name;
	dlg.m_id_equ=is_equal;
	
	return SetFindParams(query,&dlg);
}

bool CaplQueryManager::SetFindParams(CaplInstance *query,CFindDlg *dlg)
{
	CaplDataBuf dbuf_internal;
	int temp_indx=0,indx=-1;

	if(query==0)return false;
	if(dlg==0)return false;
	
	dlg->SaveDataToBuf(dbuf_internal);

	CaplDataBuf* dbuf_tmp;
	//     
	m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
	//  
	if(temp_indx!=0){
		//      
		dbuf_tmp=(CaplDataBuf*)temp_indx;
		indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
		if(indx!=-1){
			m_data->m_query_temporary_data.Remove(indx);
		}
		m_data->PutAttr(query,a_apl_query_temp_data_index,(int)0);
	}
	//    
	if(query->GetTemporary()){
		//    
		dbuf_tmp=new CaplDataBuf();
		dbuf_tmp->Add(dbuf_internal.GetBuffer(),dbuf_internal.m_Size);
		m_data->m_query_temporary_data.Add(dbuf_tmp);
		m_data->PutAttr(query,a_apl_query_temp_data_index,(int)dbuf_tmp);
	}
	
	return true;
}
	

CaplInstance* CaplQueryManager::PrepareQueryOld(CaplInstance *query,
											 /*CaplDataBuf *dbuf,*/CString name,bool only_lng,
											 bool can_make_table,bool can_save,bool mode_slave,
											 CString mode_quiery,long type_find_object,CString text_query)
{
	if(m_data==0)return 0;
	CString str,str2;
	//CString text_query;
	int res_i;
	bool res_b;
	int is_ro_edit=1;
	bool is_old_edit;

	CFindQueryDlg dlg_std;

	CFindQueryNiiao dlg_niiao;
	int temp_indx=0,indx=-1;
	CaplDataBuf dbuf_internal;
	CaplDataBuf *dbuf=0;
	long code=0;
	long size=0;
	BYTE *b_buf=0;
	bool flag_create=false;
	bool read_only=true,changed=false;
	bool StateSaveQuery=false,IsMakeTableResult=false;
	if(mode_slave){
		can_make_table=false;
		can_save=false;
	}
	if(mode_quiery==_T(""))mode_quiery=_T("Query");
	if(query==0){
		flag_create=true;
		query=m_data->CreateInstance(e_apl_query,true);
		if(query==0){
			AfxMessageBox( APL_T("  : ")+str,MB_OK|MB_ICONERROR);
			return 0;
		}
		m_data->PutAttr(query,a_apl_query_description, APL_T(" "));
		m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
		m_data->PutAttr(query,a_apl_query_name,name);
		m_data->PutAttr(query,a_apl_query_text_query,text_query);
		m_data->PutAttr(query,a_apl_query_make_table,false);
		m_data->PutAttr(query,a_apl_query_mode,mode_quiery);
		m_data->PutAttr(query,a_apl_query_temp_data_index,0);
		IsMakeTableResult=false;
		is_old_edit=false;
	}else{
		//     
		if(!query->GetTemporary()){
			StateSaveQuery=true;
			LoadQueryInfo(query);
		}else{
		}
		if(query->GetAccessmode()>aplRO){
			MessageBox(NULL, S::NoAccessRight(),  APL_T("  "), MB_OK|MB_ICONERROR);
			return 0;
		}
		UpdateTypeQuery(query);
		m_data->GetAttr(query,a_apl_query_mode,mode_quiery);
		m_data->GetAttr(query,a_apl_query_is_text_query,is_old_edit);
		m_data->GetAttr(query,a_apl_query_make_table,IsMakeTableResult);
		only_lng=only_lng || is_old_edit;
	}

	if(mode_quiery==_T("Query")){
		dlg_std.m_can_save=can_save;
		dlg_std.m_mode_slave=mode_slave;
		dlg_std.m_api=m_api;
		dlg_std.m_can_make_table=can_make_table;
		dlg_std.m_StringNameQuery=name;
		dlg_std.m_vis_mode=type_find_object;
		dlg_std.m_instance=query;
		dlg_std.m_IsMakeTableResult=IsMakeTableResult;
	}else if(mode_quiery==_T("Query_niiao")){
		dlg_niiao.m_mode_slave=mode_slave;
		dlg_niiao.m_can_save=can_save;
		dlg_niiao.m_api=m_api;
		dlg_niiao.m_can_make_table=can_make_table;
		dlg_niiao.m_StringNameQuery=name;
		//dlg_niiao.m_mode=type_find_object;
		dlg_niiao.m_instance=query;
		dlg_niiao.m_IsMakeTableResult=IsMakeTableResult;
	}


	do{
		if(only_lng){
			m_data->GetAttr(query,a_apl_query_text_query,text_query);
			is_ro_edit=is_old_edit?0:1;
			if(query->GetAccessmode()>aplRW){
				is_ro_edit=2;
			}
			m_data->GetAttr(query,a_apl_query_name,str);
			do{
				if(!m_data->NET_QueryEditParse(text_query,true,0,&is_ro_edit,&str,&StateSaveQuery,&IsMakeTableResult)){
					if(flag_create)m_data->DeleteInstance(query,false);
					return 0;
				}
				if(is_ro_edit==0 && !TestNameQuery(str,query)){
					continue;
				}
				break;
			}while(true);
			if(is_ro_edit==0 && query->GetAccessmode()<aplRO){
				only_lng=true;
				m_data->PutAttr(query,a_apl_query_name,str);
				m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
				m_data->PutAttr(query,a_apl_query_text_query,text_query);
				m_data->PutAttr(query,a_apl_query_description, APL_T("    "));
				m_data->PutAttr(query,a_apl_query_make_table,false);
				m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
				if(!is_old_edit && !query->GetTemporary()){
					// str -  
					m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
				}
			}
			if(StateSaveQuery){
				query->SetTemporary(false);
			}
			CaplDataBuf* dbuf_tmp;
			m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
			if(temp_indx!=0){
				//      ,      
				dbuf_tmp=(CaplDataBuf*)temp_indx;
				indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
				if(indx!=-1){
					m_data->m_query_temporary_data.Remove(indx);
				}
				m_data->PutAttr(query,a_apl_query_temp_data_index,(int)0);
			}

			if(StateSaveQuery && m_AutoSave){
				m_data->NET_SaveChanges();
			}
			return query;
		}else{
			m_data->GetAttr(query,a_apl_query_name,str);
			if(mode_quiery==_T("Query")){
				if(!query->GetTemporary() || dlg_std.m_StringNameQuery==_T("")){
					dlg_std.m_StringNameQuery=str;
				}
			}else if(mode_quiery==_T("Query_niiao")){
				if(!query->GetTemporary() || dlg_niiao.m_StringNameQuery==_T("")){
					dlg_niiao.m_StringNameQuery=str;
				}
			}
			if(query->GetTemporary()){
				m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
				dbuf=(CaplDataBuf*)temp_indx;
				indx=m_data->m_query_temporary_data.Find(dbuf);
				if(indx==-1){
					dbuf=0;
				}
			}else{
				dbuf=&dbuf_internal;
				if(mode_quiery==_T("Query")){
					dlg_std.m_can_save=false;
					dlg_std.m_StateSaveQuery=true;
					if(query->GetAccessmode()>aplRW){
						dlg_std.m_read_only=true;
					}
				}else if(mode_quiery==_T("Query_niiao")){
					dlg_niiao.m_can_save=false;
					dlg_niiao.m_StateSaveQuery=true;
					if(query->GetAccessmode()>aplRW){
						dlg_niiao.m_read_only=true;
					}
				}
				if(!flag_create ){
					dbuf->Clear();
					res_b=m_data->NET_GetBlobSize(query,a_apl_query_dialog_data,size);
					if(res_b){
						b_buf=new BYTE[size];
						m_data->NET_LoadBlob2Memory(query,a_apl_query_dialog_data,b_buf,size);
						dbuf->Add(b_buf,size);
						delete []b_buf;
						b_buf=0;
					}else{
						m_data->PutAttr(query,a_apl_query_dialog_data,_T(""));
					}
				}
			}
			if(dbuf==0){dbuf=&dbuf_internal;}
			if(mode_quiery==_T("Query")){
				dlg_std.SetDataBuf(*dbuf);
			}else if(mode_quiery==_T("Query_niiao")){
				dlg_niiao.SetDataBuf(*dbuf);
			}

			CaplSetResourceHandle setres(module_inst);

			res_i=IDCANCEL;
			if(mode_quiery==_T("Query"))
			{
				res_i=dlg_std.DoModal();
				str2= APL_T(": \'")+dlg_std.m_mode_text+_T("\'; "); //D    SFindObjectDef.name4user !!!!!
				if(dlg_std.m_descrtiption != _T(""))
				{
					str2+=dlg_std.m_descrtiption;
				}
				text_query=dlg_std.m_QL_query;
				name=dlg_std.m_StringNameQuery;
				read_only=dlg_std.m_read_only;
				changed=dlg_std.m_changed;
				StateSaveQuery=(dlg_std.m_StateSaveQuery==TRUE);
				IsMakeTableResult=(dlg_std.m_IsMakeTableResult==TRUE);
			}
			else if(mode_quiery==_T("Query_niiao"))
			{
				res_i=dlg_niiao.DoModal();
				str2= APL_T("  \'")+dlg_niiao.m_mode_text+_T("\' ");
				if(dlg_niiao.m_is_adjustment){
					str2+= APL_T(" ");
				}
				text_query=dlg_niiao.m_QL_query;
				name=dlg_niiao.m_StringNameQuery;
				read_only=dlg_niiao.m_read_only;
				changed=dlg_niiao.m_changed;
				StateSaveQuery=(dlg_niiao.m_StateSaveQuery==TRUE);
				IsMakeTableResult=(dlg_niiao.m_IsMakeTableResult==TRUE);
			}

			if(res_i==IDOK || res_i==ID_SHOW_STEPQL)
			{
				if(!read_only)
				{
					m_data->PutAttr(query,a_apl_query_description,str2);
					m_data->PutAttr(query,a_apl_query_name,name);
				}
				if(StateSaveQuery)
				{
					query->SetTemporary(false);
				}
				dbuf=&dbuf_internal;

				if(mode_quiery==_T("Query"))
				{
					dlg_std.GetDataBuf(*dbuf);
				}
				else if(mode_quiery==_T("Query_niiao"))
				{
					dlg_niiao.GetDataBuf(*dbuf);
				}

				CaplDataBuf* dbuf_tmp;
				m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
				if(temp_indx!=0)
				{
					//      
					dbuf_tmp=(CaplDataBuf*)temp_indx;
					indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
					if(indx!=-1)
					{
						m_data->m_query_temporary_data.Remove(indx);
					}
					m_data->PutAttr(query,a_apl_query_temp_data_index,(int)0);
				}
				if(query->GetTemporary())
				{
					if(!only_lng)
					{
						//    
						dbuf_tmp=new CaplDataBuf();
						dbuf_tmp->Add(dbuf->GetBuffer(),dbuf->m_Size);
						m_data->m_query_temporary_data.Add(dbuf_tmp);
						m_data->PutAttr(query,a_apl_query_temp_data_index,(int)dbuf_tmp);
					}
					else
					{
						//      .      
					}
				}

				if(!read_only && (changed || flag_create))
				{
					m_data->PutAttr(query,a_apl_query_text_query,text_query);
					if(StateSaveQuery)
					{
						m_data->GetAttr(query,a_apl_query_dialog_data,str);
						if(str!=_T(""))
						{
							res_b=m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
						}
						if(dbuf!=0)
						{
							res_b=m_data->NET_SaveFileFromMemory(query,a_apl_query_dialog_data,
																			(BYTE*)dbuf->GetBuffer(),dbuf->m_Size,code);
						}
					}
				}
				if(StateSaveQuery && m_AutoSave)
				{
					m_data->NET_SaveChanges();
				}
			}
			if(res_i==IDOK)
			{
				res_b=m_data->NET_QueryEditParse(text_query,false,&str2);
				if(!read_only){
					if(res_b){
						bool flag_tmp=(IsMakeTableResult==1);
						m_data->PutAttr(query,a_apl_query_make_table,flag_tmp);
					}else{
						m_data->PutAttr(query,a_apl_query_make_table,false);
						str2+= APL_T(" ! !");
						m_data->PutAttr(query,a_apl_query_description,str2);
					}
				}

			}
			else if(res_i==ID_SHOW_STEPQL)
			{
				if(query->GetAccessmode()>aplRW){
					is_ro_edit=2;
				}
				m_data->GetAttr(query,a_apl_query_name,str);
				do{
					res_b=m_data->NET_QueryEditParse(text_query,true,&str2,&is_ro_edit,&str,&StateSaveQuery,&IsMakeTableResult);
					if(!res_b){
						//   ""						
						break;
					}
					if(is_ro_edit==0 && !TestNameQuery(str,query)){
						continue;
					}
					m_data->PutAttr(query,a_apl_query_name,str);
					m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
					break;
				}while(true);

				if(is_ro_edit==0 && !read_only)
				{
					//    STEP_QL    ""
					only_lng=true;
					str2= APL_T("    ");
					m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
					m_data->PutAttr(query,a_apl_query_name,str);
					m_data->PutAttr(query,a_apl_query_text_query,text_query);
					m_data->PutAttr(query,a_apl_query_description,str2);
					m_data->PutAttr(query,a_apl_query_make_table,false);
					m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
					if(dbuf!=0){dbuf->Clear();}
					if(!is_old_edit && !query->GetTemporary())
					{
						// str -  
						m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
					}

				}else{
					if(!res_b){
						//   ""						
						continue;
					}
					//   ""

				}
				if(StateSaveQuery)
				{
					query->SetTemporary(false);
				}

			}else{
				if(flag_create)m_data->DeleteInstance(query,false);
				return 0;
			}

			if(!res_b){
				if(str==_T("")){str= APL_T("  :")+text_query;}
				AfxMessageBox( APL_T("  : ")+str,MB_OK|MB_ICONERROR);
				return query;
			}
			if(StateSaveQuery && m_AutoSave)
			{
				m_data->NET_SaveChanges();
			}
			return query;
		}
	}while(true);

	if(flag_create)m_data->DeleteInstance(query,false);
	return 0;
}

void CaplQueryManager::SetStyleDlg(DWORD m_show_old_query_dlg)
{
	//   /  
	//-------------------------------------------------------------------
	//						\    |    0    |		1		|
	// m_show_old_query_dlg	 \			 |				 |				|
	//-------------------------------------------------------------------
	//          0                        |	  |  |
	//          1                        | 	 |  |
	//          0xFFFF                   |	  |	 |
	//-------------------------------------------------------------------
	//	     ,  CWinApp      CPSMDoc::m_show_old_query_dlg  0,         
	//	           -    
	//  ,      -    ,       CPSMDoc::m_show_old_query_dlg  0xFFFF,  
	//      -    

	if(m_api == 0) return;
	int opt_val = m_api->m_options_mgr.GetIntOptionValueBN(APL_NO_T("PSS\\\\show_old_query_dlg"),0);
	if(opt_val == 0)
	{
		//   ,       
		m_is_old_dlg = (m_show_old_query_dlg == 1);
	}
	else
	{
		//      ,   (  0    ..)     .      0xFFFF  
		m_is_old_dlg = (m_show_old_query_dlg != 0xFFFF);
	}

}

CaplInstance* CaplQueryManager::PrepareQuery(CaplInstance *query,
				/*CaplDataBuf *dbuf,*/CString name,bool only_lng,
				bool can_make_table,bool can_save,bool mode_slave,
				CString mode_quiery,long type_find_object,CString text_query,bool *is_new_window)
{
	if(m_data==0)return 0;
	
	bool spek_key = ((GetKeyState(VK_LSHIFT) & 0xff00)!=0);
	
	if(m_is_old_dlg && !spek_key  || (!m_is_old_dlg && spek_key))
	{
		return PrepareQueryOld(query,name,only_lng,
				can_make_table,can_save,mode_slave,
				mode_quiery,type_find_object,text_query);
	}
	return PrepareQueryNew(query,name,only_lng,
		can_make_table,can_save,mode_slave,
		mode_quiery,type_find_object,text_query,is_new_window);
}

CaplInstance* CaplQueryManager::PrepareQueryNew(CaplInstance *query,
				/*CaplDataBuf *dbuf,*/CString name,bool only_lng,
				bool can_make_table,bool can_save,bool mode_slave,
				CString mode_quiery,long type_find_object,CString text_query,bool *is_new_window)
{
	if(m_data==0)return 0;
	CString str,str2;
	//CString text_query;
	int res_i;
	bool res_b;
	int is_ro_edit=1;
	bool is_old_edit;

	CFindQueryDlgEx dlg_std;
	dlg_std.m_is_new_window = is_new_window;

	CFindQueryNiiao dlg_niiao;
	int temp_indx=0,indx=-1;
	CaplDataBuf dbuf_internal;
	CaplDataBuf *dbuf=0;
	long code=0;
	long size=0;
	BYTE *b_buf=0;
	bool flag_create=false;
	bool read_only=true,changed=false;
	bool StateSaveQuery=false,IsMakeTableResult=false;
	if(mode_slave){
		can_make_table=false;
		can_save=false;
	}
	if(mode_quiery==_T(""))mode_quiery=_T("Query");
	if(query==0){
		flag_create=true;
		query=m_data->CreateInstance(e_apl_query,true);
		if(query==0){
			AfxMessageBox( APL_T("  : ")+str,MB_OK|MB_ICONERROR);
			return 0;
		}
		m_data->PutAttr(query,a_apl_query_description, APL_T(" "));
		m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
		m_data->PutAttr(query,a_apl_query_name,name);
		m_data->PutAttr(query,a_apl_query_text_query,text_query);
		m_data->PutAttr(query,a_apl_query_make_table,false);
		m_data->PutAttr(query,a_apl_query_mode,mode_quiery);
		m_data->PutAttr(query,a_apl_query_temp_data_index,0);
		IsMakeTableResult=false;
		is_old_edit=false;
	}else{
		//     
		if(!query->GetTemporary()){
			StateSaveQuery=true;
			LoadQueryInfo(query);
		}else{
		}
		if(query->GetAccessmode()>aplRO){
			MessageBox(NULL, S::NoAccessRight(),  APL_T("  "), MB_OK|MB_ICONERROR);
			return 0;
		}
		UpdateTypeQuery(query);
		m_data->GetAttr(query,a_apl_query_mode,mode_quiery);
		m_data->GetAttr(query,a_apl_query_is_text_query,is_old_edit);
		m_data->GetAttr(query,a_apl_query_make_table,IsMakeTableResult);
		only_lng=only_lng || is_old_edit;
	}

	if(mode_quiery==_T("Query")){
		dlg_std.m_can_save=can_save;
		dlg_std.m_mode_slave=mode_slave;
		dlg_std.m_api=m_api;
		dlg_std.m_can_make_table=can_make_table;
		dlg_std.m_StringNameQuery=name;
		dlg_std.m_vis_mode=type_find_object;
		dlg_std.m_instance=query;
		dlg_std.m_IsMakeTableResult=IsMakeTableResult;
	}else if(mode_quiery==_T("Query_niiao")){
		dlg_niiao.m_mode_slave=mode_slave;
		dlg_niiao.m_can_save=can_save;
		dlg_niiao.m_api=m_api;
		dlg_niiao.m_can_make_table=can_make_table;
		dlg_niiao.m_StringNameQuery=name;
		//dlg_niiao.m_mode=type_find_object;
		dlg_niiao.m_instance=query;
		dlg_niiao.m_IsMakeTableResult=IsMakeTableResult;
	}

	
	do{
		if(only_lng){
			m_data->GetAttr(query,a_apl_query_text_query,text_query);
			is_ro_edit=is_old_edit?0:1;
			if(query->GetAccessmode()>aplRW){
				is_ro_edit=2;
			}
			m_data->GetAttr(query,a_apl_query_name,str);
			do{
				if(!m_data->NET_QueryEditParse(text_query,true,0,&is_ro_edit,&str,&StateSaveQuery,&IsMakeTableResult)){
					if(flag_create)m_data->DeleteInstance(query,false);
					return 0;
				}
				if(is_ro_edit==0 && !TestNameQuery(str,query)){
					continue;
				}
				break;
			}while(true);
			if(is_ro_edit==0 && query->GetAccessmode()<aplRO){
				only_lng=true;
				m_data->PutAttr(query,a_apl_query_name,str);
				m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
				m_data->PutAttr(query,a_apl_query_text_query,text_query);
				m_data->PutAttr(query,a_apl_query_description, APL_T("    "));
				m_data->PutAttr(query,a_apl_query_make_table,false);
				m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
				if(!is_old_edit && !query->GetTemporary()){
					// str -  
					m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
				}
			}
			if(StateSaveQuery){
				query->SetTemporary(false);
			}
			CaplDataBuf* dbuf_tmp;
			m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
			if(temp_indx!=0){
				//      ,      
				dbuf_tmp=(CaplDataBuf*)temp_indx;
				indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
				if(indx!=-1){
					m_data->m_query_temporary_data.Remove(indx);
				}
				m_data->PutAttr(query,a_apl_query_temp_data_index,(int)0);
			}
	
			if(StateSaveQuery && m_AutoSave){
				m_data->NET_SaveChanges();
			}
			return query;
		}else{
			m_data->GetAttr(query,a_apl_query_name,str);
			if(mode_quiery==_T("Query")){
				if(!query->GetTemporary() || dlg_std.m_StringNameQuery==_T("")){
					dlg_std.m_StringNameQuery=str;
				}
			}else if(mode_quiery==_T("Query_niiao")){
				if(!query->GetTemporary() || dlg_niiao.m_StringNameQuery==_T("")){
					dlg_niiao.m_StringNameQuery=str;
				}
			}
			if(query->GetTemporary()){
				m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
				dbuf=(CaplDataBuf*)temp_indx;
				indx=m_data->m_query_temporary_data.Find(dbuf);
				if(indx==-1){
					dbuf=0;
				}
			}else{
				dbuf=&dbuf_internal;
				if(mode_quiery==_T("Query")){
					dlg_std.m_can_save=false;
					dlg_std.m_StateSaveQuery=true;
					if(query->GetAccessmode()>aplRW){
						dlg_std.m_read_only=true;
					}
				}else if(mode_quiery==_T("Query_niiao")){
					dlg_niiao.m_can_save=false;
					dlg_niiao.m_StateSaveQuery=true;
					if(query->GetAccessmode()>aplRW){
						dlg_niiao.m_read_only=true;
					}
				}
				if(!flag_create && dbuf!=0){
					dbuf->Clear();
					res_b=m_data->NET_GetBlobSize(query,a_apl_query_dialog_data,size);
					if(res_b){
						b_buf=new BYTE[size];
						m_data->NET_LoadBlob2Memory(query,a_apl_query_dialog_data,b_buf,size);
						dbuf->Add(b_buf,size);
						delete [] b_buf;b_buf=0;
					}else{
						m_data->PutAttr(query,a_apl_query_dialog_data,_T(""));
					}
				}
			}
			if(dbuf==0){dbuf=&dbuf_internal;}
			if(mode_quiery==_T("Query")){
				dlg_std.SetDataBuf(*dbuf);
			}else if(mode_quiery==_T("Query_niiao")){
				dlg_niiao.SetDataBuf(*dbuf);
			}

			CaplSetResourceHandle setres(module_inst);
			
			res_i=IDCANCEL;
			if(mode_quiery==_T("Query"))
			{
				res_i=dlg_std.DoModal();
				str2= APL_T(": \'")+dlg_std.m_mode_text+_T("\'; "); //D    SFindObjectDef.name4user !!!!!
				if(dlg_std.m_descrtiption != _T(""))
				{
					str2+=dlg_std.m_descrtiption;
				}
				text_query=dlg_std.m_QL_query;
				name=dlg_std.m_StringNameQuery;
				read_only=dlg_std.m_read_only;
				changed=dlg_std.m_changed;
				StateSaveQuery=(dlg_std.m_StateSaveQuery==TRUE);
				IsMakeTableResult=(dlg_std.m_IsMakeTableResult==TRUE);
			}
			else if(mode_quiery==_T("Query_niiao"))
			{
				res_i=dlg_niiao.DoModal();
				str2= APL_T("  \'")+dlg_niiao.m_mode_text+_T("\' ");
				if(dlg_niiao.m_is_adjustment){
					str2+= APL_T(" ");
				}
				text_query=dlg_niiao.m_QL_query;
				name=dlg_niiao.m_StringNameQuery;
				read_only=dlg_niiao.m_read_only;
				changed=dlg_niiao.m_changed;
				StateSaveQuery=(dlg_niiao.m_StateSaveQuery==TRUE);
				IsMakeTableResult=(dlg_niiao.m_IsMakeTableResult==TRUE);
			}
			
			if(res_i==IDOK || res_i==ID_SHOW_STEPQL)
			{
				if(!read_only)
				{
					m_data->PutAttr(query,a_apl_query_description,str2);
					m_data->PutAttr(query,a_apl_query_name,name);
				}
				if(StateSaveQuery)
				{
					query->SetTemporary(false);
				}
				dbuf=&dbuf_internal;

				if(mode_quiery==_T("Query"))
				{
					dlg_std.GetDataBuf(*dbuf);
				}
				else if(mode_quiery==_T("Query_niiao"))
				{
					dlg_niiao.GetDataBuf(*dbuf);
				}

				CaplDataBuf* dbuf_tmp;
				m_data->GetAttr(query,a_apl_query_temp_data_index,temp_indx);
				if(temp_indx!=0)
				{
					//      
					dbuf_tmp=(CaplDataBuf*)temp_indx;
					indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
					if(indx!=-1)
					{
						m_data->m_query_temporary_data.Remove(indx);
					}
					m_data->PutAttr(query,a_apl_query_temp_data_index,(int)0);
				}
				if(query->GetTemporary())
				{
					if(!only_lng)
					{
						//    
						dbuf_tmp=new CaplDataBuf();
						dbuf_tmp->Add(dbuf->GetBuffer(),dbuf->m_Size);
						m_data->m_query_temporary_data.Add(dbuf_tmp);
						m_data->PutAttr(query,a_apl_query_temp_data_index,(int)dbuf_tmp);
					}
					else
					{
						//      .      
					}
				}

				if(!read_only && (changed || flag_create))
				{
					m_data->PutAttr(query,a_apl_query_text_query,text_query);
					if(StateSaveQuery)
					{
						m_data->GetAttr(query,a_apl_query_dialog_data,str);
						if(str!=_T(""))
						{
							res_b=m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
						}
						res_b=m_data->NET_SaveFileFromMemory(query,a_apl_query_dialog_data,
							(BYTE*)dbuf->GetBuffer(),dbuf->m_Size,code);
					}
				}
				if(StateSaveQuery && m_AutoSave)
				{
					m_data->NET_SaveChanges();
				}
			}
			if(res_i==IDOK)
			{
				res_b=m_data->NET_QueryEditParse(text_query,false,&str2);
				if(!read_only){
					if(res_b){
						bool flag_tmp=(IsMakeTableResult==1);
						m_data->PutAttr(query,a_apl_query_make_table,flag_tmp);
					}else{
						m_data->PutAttr(query,a_apl_query_make_table,false);
						str2+= APL_T(" ! !");
						m_data->PutAttr(query,a_apl_query_description,str2);
					}
				}
				
			}else if(res_i==ID_SHOW_STEPQL){
				if(query->GetAccessmode()>aplRW){
					is_ro_edit=2;
				}
				m_data->GetAttr(query,a_apl_query_name,str);
				do{
					res_b=m_data->NET_QueryEditParse(text_query,true,&str2,&is_ro_edit,&str,&StateSaveQuery,&IsMakeTableResult);
					if(!res_b){
						//   ""						
						break;
					}
					if(is_ro_edit==0 && !TestNameQuery(str,query)){
						continue;
					}
					m_data->PutAttr(query,a_apl_query_name,str);
					m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
					break;
				}while(true);

				if(is_ro_edit==0 && !read_only)
				{
					//    STEP_QL    ""
					only_lng=true;
					str2= APL_T("    ");
					m_data->PutAttr(query,a_apl_query_is_text_query,only_lng);
					m_data->PutAttr(query,a_apl_query_name,str);
					m_data->PutAttr(query,a_apl_query_text_query,text_query);
					m_data->PutAttr(query,a_apl_query_description,str2);
					m_data->PutAttr(query,a_apl_query_make_table,false);
					m_data->PutAttr(query,a_apl_query_make_table,IsMakeTableResult);
					dbuf->Clear();
					if(!is_old_edit && !query->GetTemporary()){
						// str -  
						m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
					}
				
				}else{
					if(!res_b){
						//   ""						
						continue;
					}
					//   ""
					
				}
				if(StateSaveQuery)
				{
					query->SetTemporary(false);
				}

			}else{
				if(flag_create)m_data->DeleteInstance(query,false);
				return 0;
			}
			
			if(!res_b){
				if(str==_T("")){str= APL_T("  :")+text_query;}
				AfxMessageBox( APL_T("  : ")+str,MB_OK|MB_ICONERROR);
				return query;
			}
			if(StateSaveQuery && m_AutoSave)
			{
				m_data->NET_SaveChanges();
			}
			return query;
		}
	}while(true);
	
	if(flag_create)m_data->DeleteInstance(query,false);
	return 0;
}

bool CaplQueryManager::UpdateTypeQuery(CaplInstance *query)
{
	CString str;
	bool flag=false;
	if(query==0)return false;
	m_data->GetAttr(query,a_apl_query_mode,str);
	if(str==_T("query")){str=_T("Query");flag=true;}
	else if(str==_T("find")){str=_T("Find");flag=true;}
	else if(str==_T("query_niiao")){str=_T("Query_niiao");flag=true;}
	else if(str==_T("combined_table")){str=_T("Combined_table");flag=true;}
	else return false;
	if(flag){
		m_data->PutAttr(query,a_apl_query_mode,str);
		if(m_AutoSave && !query->GetTemporary()) m_data->NET_SaveChanges();
	}
	return true;
}

CaplInstance* CaplQueryManager::CopyQuery(CaplInstance *old_query,bool force_temporary)
{
	CString text;
	bool bval;
	int ival;
	long lval;
	CaplInstance *inst;
	aplExtent ext;

	CaplDataBuf dbuf_internal;
	int temp_indx=0,indx=-1;
	long size;
	CaplDataBuf dbuf;
	CaplDataBuf *dbuf_tmp=0;

	LoadQueryInfo(old_query);
	if(!m_data->IsKindOf(old_query,e_apl_query)){
		return 0;
	}
	CaplInstance* new_query=m_data->CreateInstance(e_apl_query,old_query->GetTemporary() || force_temporary);
	if(new_query==0)return 0;
	//  
	m_data->GetAttr(old_query,a_apl_query_name,text);
	m_data->PutAttr(new_query,a_apl_query_name,text);
	m_data->GetAttr(old_query,a_apl_query_description,text);
	m_data->PutAttr(new_query,a_apl_query_description,text);
	m_data->GetAttr(old_query,a_apl_query_text_query,text);
	m_data->PutAttr(new_query,a_apl_query_text_query,text);
	UpdateTypeQuery(old_query);
	m_data->GetAttr(old_query,a_apl_query_mode,text);
	m_data->PutAttr(new_query,a_apl_query_mode,text);
	m_data->GetAttr(old_query,a_apl_query_execution_date,text);
	m_data->PutAttr(new_query,a_apl_query_execution_date,text);

	m_data->GetAttr(old_query,a_apl_query_is_text_query,bval);
	m_data->PutAttr(new_query,a_apl_query_is_text_query,bval);
	m_data->GetAttr(old_query,a_apl_query_make_table,bval);
	m_data->PutAttr(new_query,a_apl_query_make_table,bval);

	m_data->GetAttr(old_query,a_apl_query_execution_size,ival);
	m_data->PutAttr(new_query,a_apl_query_execution_size,ival);

	m_data->GetAttr(old_query,a_apl_query_combined_table,inst);
	m_data->PutAttr(new_query,a_apl_query_combined_table,inst);

	m_data->GetAttr(old_query,a_apl_query_content,ext);
	m_data->PutAttr(new_query,a_apl_query_content,ext);

	//  , 
	if(old_query->GetTemporary()){
		m_data->GetAttr(old_query,a_apl_query_temp_data_index,temp_indx);
		dbuf_tmp=(CaplDataBuf*)temp_indx;
		indx=m_data->m_query_temporary_data.Find(dbuf_tmp);
		if(indx!=-1){
			dbuf.Add(dbuf_tmp->GetBuffer(),dbuf_tmp->m_Size);
		}else{
			dbuf.Clear();
		}
	}else{
		m_data->PutAttr(new_query,a_apl_query_temp_data_index,(int)0);
		m_data->NET_GetBlobSize(old_query,a_apl_query_dialog_data,size);
		dbuf.SetSize(size);
		m_data->NET_LoadBlob2Memory(old_query,a_apl_query_dialog_data,(BYTE*)dbuf.GetBuffer(),size);
	}
	//   
	if(new_query->GetTemporary()){
		if(dbuf.m_Size!=0){
			dbuf_tmp=new CaplDataBuf();
			dbuf_tmp->Add(dbuf.GetBuffer(),dbuf.m_Size);
			m_data->m_query_temporary_data.Add(dbuf_tmp);
			temp_indx=(int)dbuf_tmp;
		}else{
			temp_indx=0;
		}
		m_data->PutAttr(new_query,a_apl_query_temp_data_index,temp_indx);
	}else{
		m_data->PutAttr(new_query,a_apl_query_temp_data_index,(int)0);
		m_data->NET_SaveFileFromMemory(new_query,a_apl_query_dialog_data,(BYTE*)dbuf.GetBuffer(),dbuf.m_Size,lval);
	}
	
	return new_query;
}

bool CaplQueryManager::SaveQuery(CaplInstance *query)
{
	CString str;
	bool res_b;
	long code;
	CaplDataBuf* dbuf=0;
	CaplAttr *temp_data,*save_data;
	CaplInstance* internal=0;
	CString err_header;
	int temp_indx=0,indx=-1;
	if(query==0)return false;
	if(query->GetType()==0)return false;
	if(!query->GetTemporary())return true;
	if(m_data->IsKindOf(query,e_apl_query))
	{
		err_header= APL_T(" ");
		temp_data=a_apl_query_temp_data_index;
		save_data=a_apl_query_dialog_data;
	}
	else if(m_data->IsKindOf(query,e_apl_ct))
	{
		err_header= APL_T("  ");
		temp_data=a_apl_ct_columns_data;
		m_data->GetAttr(query,a_apl_ct_query,internal);
		if(internal==0)
		{
			MessageBox(NULL,  APL_T("      !"),err_header , MB_OK|MB_ICONERROR);
			return false;
		}
	}
	m_data->GetAttr(query,temp_data,temp_indx);
	dbuf=(CaplDataBuf*)temp_indx;
	indx=m_data->m_query_temporary_data.Find(dbuf);
	if(indx==-1){
		//    ,    
		dbuf=0;
	}else{
		m_data->GetAttr(query,save_data,str);
		if(str!=_T("")){
			res_b=m_data->NET_DeleteBlob(query,save_data);
		}
		if(dbuf!=0){
			if(dbuf->m_Size>0){
				res_b=m_data->NET_SaveFileFromMemory(query,save_data,
					(BYTE*)dbuf->GetBuffer(),dbuf->m_Size,code);
			}
		}
		//     
		m_data->m_query_temporary_data.Remove(indx);
		m_data->PutAttr(query,temp_data,-1);
	}

	query->SetTemporary(false);
	if(internal!=0){
		SaveQuery(internal);
	}
	m_data->NET_SaveChanges();
	return true;
}

bool CaplQueryManager::TestNameQuery(CString name,CaplInstance *query,bool report) 
{
	CaplAttrValue tst_values[1];
	aplExtent ext;
	CString err_msg;
	bool flag=false;
	tst_values[0].value.Set(name);
	tst_values[0].attr=m_api->m_query_mgr.a_apl_query_name;
	if(m_data->NET_FindInstancesWithAttrValues(
		e_apl_query,1,&tst_values[0],ext,false)>0)
	{
		if(ext.Size>0 && query==0)return false;
		if(ext.Size>1 || ext[0]!=query){
			if(report)AfxMessageBox( APL_T("   !"),MB_ICONERROR);
			return false;
		}
	}
	return true;
}

bool CaplQueryManager::TestNameCombinedTable(CString name,CaplInstance *ct,bool report)
{
	CaplAttrValue tst_values[1];
	aplExtent ext;
	CString err_msg;
	bool flag=false;
	tst_values[0].value.Set(name);
	tst_values[0].attr=m_api->m_query_mgr.a_apl_ct_name;
	if(m_data->NET_FindInstancesWithAttrValues(
		e_apl_ct,1,&tst_values[0],ext,false)>0)
	{
		if(ext.Size>0 && ct==0)return false;
		if(ext.Size>1 || ext[0]!=ct){
			if(report)AfxMessageBox( APL_T("    !"),MB_ICONERROR);
			return false;
		}
	}
	return true;
}

bool CaplQueryManager::CheckRemoveLowLevelInstances(aplExtent &ckecked_ext)
{

	CString role_low_level;
	CaplInstance* curr_person;
	CaplInstance* checked_inst;
	bool can_low_level=false;
	bool supressed_low_level=false;
	CaplEntity *prev_low_ent=0;
	CaplEntity *prev_high_ent=0;
	int i;

	if(m_api==0) return false;
	can_low_level=m_api->m_appr_mgr.IsAdmin();

	if(!can_low_level)
	{
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\      "),role_low_level);
		if(role_low_level.IsEmpty()==FALSE)
		{
			curr_person=m_api->m_appr_mgr.GetCurrentPerson();
			if(curr_person==0){can_low_level=false;}
			else
			{
				can_low_level=m_api->m_appr_mgr.CheckPersonRole(curr_person,role_low_level);
			}
		}
	}
	if(!can_low_level)
	{
		//      
		for(i=ckecked_ext.GetSize()-1;i>=0;i--)
		{
			checked_inst=ckecked_ext[i];
			if(checked_inst==0)continue;
			//    -       
			if(prev_low_ent!=0 && checked_inst->GetType()==prev_low_ent)
			{
				supressed_low_level=true;
				ckecked_ext.Remove(i);
				continue;
			}
			if(prev_high_ent!=0 && checked_inst->GetType()==prev_high_ent)
			{
				continue;
			}
			if(m_ListTopLevelEntities.QFindByIn((long)checked_inst->GetType())==-1)
			{
				supressed_low_level=true;
				prev_low_ent=checked_inst->GetType();
				ckecked_ext.Remove(i);
				continue;
			}
		}
	}
	if(supressed_low_level)
	{
		AfxMessageBox( APL_T("        \r\n     "));
	}

	return true;
}

bool CaplQueryManager::ExecuteQuery(CaplInstance *query,aplExtent &out_ext)
{
	if(query==0)return false;
	if(m_data==0)return false;

	CString str;
	int size;
	out_ext.Clear();
	m_data->GetAttr(query,a_apl_query_text_query,str);
	if(!ExecuteQuery(str,out_ext)){
		return false;
	}
	if(query->GetAccessmode()<aplRO)
	{
		m_data->PutAttr(query,a_apl_query_content,out_ext);
		//  
		COleDateTime odt;
		m_data->NET_GetServerDateTime(odt);
		str=odt.Format(_T("%Y%m%d%H%M%S"));
		m_data->PutAttr(query,a_apl_query_execution_date,str);
		// 
		size=out_ext.Size;
		m_data->PutAttr(query,a_apl_query_execution_size,size);
		m_data->AppendNotComparedAggr(query,a_apl_query_content);
		if(m_AutoSave && !query->GetTemporary())m_data->NET_SaveChanges();
	}
	return true;
}

bool CaplQueryManager::ExecuteQuery(CString query,aplExtent &out_ext)
{
	if(m_data==0)	return false;
	
	out_ext.Clear();
	CString str;
	if(!m_data->NET_QueryEditParse(query,false,&str)){
		if(str==_T("")){str= APL_T("  :")+query;}
		AfxMessageBox( APL_T("  :\n ")+str,MB_OK|MB_ICONERROR);
		return false;
	}
	if(!m_data->NET_QueryExecute(out_ext)){
		/*
		str=_T("");
		if(m_data->GetLastError()!=APL_NET_OK){
			str=m_data->GetLastErrorDescription();
		}else if(m_data->GetLastAplError()!=APL_NET_OK){
			str=APL_NET_ERROR2char(m_data->GetLastAplError());
		}
		if(str!=_T("")){
			AfxMessageBox(APL_T("  :\n ")+str,MB_OK|MB_ICONERROR);
		}
		*/
		AfxMessageBox( APL_T("  "),MB_OK|MB_ICONERROR);
		return false;
	}
	//CheckRemoveLowLevelInstances(out_ext); -       PSM       
	return true;
}


bool CaplQueryManager::ExecuteFind(CaplInstance *query,aplExtent &out_ext)
{
	if(m_data==0)	return false;
	
	CString m_id_str,m_name_str,str;
	bool m_id_equ;
	bool m_id, m_name;
	CString m_mode;

	BOOL is_id;
	BOOL is_name;
	BOOL is_equal;

	if(!GetFindParams(query,m_mode,is_id,m_id_str,is_name,m_name_str,is_equal))
	{
		return false;
	}

	if(is_id==TRUE)m_id=true; else m_id=false;
	if(is_name==TRUE)m_name=true; else m_name=false;
	if(is_equal==TRUE)m_id_equ=true; else m_id_equ=false;



	CString buf;
	CString buf1;
	
	//  
	out_ext.Clear();

	// 
	CaplAttrValue tst_values[2];

	int i=0;
	int size=0;
	CaplEntity *ent=0;
	if(m_mode==_T("product")) ent=m_api->m_prd_mgr.e_prd;
	else if(m_mode==_T("document")) ent=m_api->m_doc_mgr.e_apl_doc;
	else if(m_mode==_T("bp")) ent=m_api->m_bp_mgr.e_bp;
	else if(m_mode==_T("lot")) ent=m_api->m_prd_inst_mgr.e_lot;
	else if(m_mode==_T("product_instance")) ent=m_api->m_prd_inst_mgr.e_prd_inst;
	else if(m_mode==_T("process")) ent=m_api->m_data.GetEntityBN(_T("apl_process"));
	else if(m_mode==_T("change")) ent=m_api->m_data.GetEntityBN(_T("apl_change"));
	if(m_id)
	{
		tst_values[i].value.Set((LPCTSTR)m_id_str);
		tst_values[i].attr=m_data->GetAttrDefinition(ent,_T("id"));
		i++;
	}
	if(m_name)
	{
		tst_values[i].value.Set((LPCTSTR)m_name_str);
		if((m_mode==_T("product"))||(m_mode==_T("document"))||(m_mode==_T("bp"))||(m_mode==_T("process")))
			tst_values[i].attr=m_data->GetAttrDefinition(ent,_T("name"));
		if(m_mode==_T("product_instance"))
			tst_values[i].attr=m_data->GetAttrDefinition(ent,_T("serial_number"));
		i++;
	}
	m_data->NET_FindInstancesWithAttrValues(ent,i,&tst_values[0],out_ext,!m_id_equ);

	if(query->GetAccessmode()<aplRO){
		m_data->PutAttr(query,a_apl_query_content,out_ext);
		COleDateTime odt;
		if(m_data->IsConnected()){
			m_data->NET_GetServerDateTime(odt);
		}else{
			odt=COleDateTime::GetCurrentTime();
		}
		str=odt.Format(_T("%Y%m%d%H%M%S"));
		m_data->PutAttr(query,a_apl_query_execution_date,str);
		// 
		size=out_ext.Size;
		m_data->PutAttr(query,a_apl_query_execution_size,size);
	}

	
	return true;
}

/*
bool CaplQueryManager::MakeTable(CaplInstance *query,bool is_hide_move_button,bool ignore_flag,aplExtent* ext_in)
{
	if(m_data==0)return false;
	if(query==0)return false;

	bool flag;
	aplExtent ext;
	m_data->GetAttr(query,a_apl_query_make_table,flag);
	m_data->GetAttr(query,a_apl_query_content,ext);
	
	int res=0;
	//	if(flag || is_hide_move_button){
	if(flag || ignore_flag){
		CaplSetResourceHandle setres(module_inst);
		CDlgListInstances dlg;
		dlg.m_content=&ext;
		dlg.m_api=m_api;
		dlg.m_is_hide_move_button=is_hide_move_button;
		res=dlg.DoModal();
		if(res==ID_MOVE2TREE)return true;
		return false;
	}
	return true;
}
*/
bool CaplQueryManager::GetFindResult(CaplInstance *query,aplExtent &out_ext,COleDateTime &time,bool only_temporary)
{
	if(m_data==0){
		return false;
	}
	out_ext.Clear();
	int i;
	CString str;
	CaplInstance* inst;
	aplExtent ext;
	
	CaplLoadData ld(m_data,DEF_SOURCE);
	if(query==0){
		if(m_data->IsConnected())
		{
			if(!only_temporary){
				ld.AddQuery(_T('e'),0,e_apl_query,0,1);
				ld.AddQuery(_T('e'),0,e_apl_ct,0,1);
				ld.LoadEx();
			}
		}	
		m_data->GetEntityExtent(e_apl_query,out_ext);
		//  ,       ( )
		for(i=0;i<out_ext.GetSize();i++){
			//    ,     ,   ?
			if(/*out_ext.GetAt(i)->GetId()<1000 || */(only_temporary && !(out_ext.GetAt(i)->GetTemporary()))){
				out_ext.Remove(i);
				i--;
				continue;
			}
			if(out_ext.GetAt(i)->GetAccessmode()>aplRO){
				//     -  
				out_ext.Remove(i);
				i--;
				continue;
			}
			m_data->GetAttr(out_ext.GetAt(i),a_apl_query_combined_table,inst);
			if(inst!=0){
				//   -       -      
				out_ext.Remove(i);
				i--;
			}
			m_data->GetAttr(out_ext.GetAt(i),a_apl_query_folder,inst);
			if(inst!=0){
				//   -       -      
				out_ext.Remove(i);
				i--;
			}
		}
		m_data->GetEntityExtent(e_apl_ct,ext);
		//   ( )
		for(i=0;i<ext.GetSize();i++){
			if(only_temporary && !(ext.GetAt(i)->GetTemporary())){
				ext.Remove(i);
				i--;
				continue;
			}
		}
		out_ext.Append(ext);
	}else{
		m_data->GetAttr(query,a_apl_query_content,out_ext);
		m_data->GetAttr(query,a_apl_query_execution_date,str);
		aplString2Date(str,time);
	}
	
	return true;
}

bool CaplQueryManager::GetName(CaplInstance *query,CString &name,CString &description)
{
	if(m_data==0)	return false;
	if(query==0)return false;

	if(m_data->IsKindOf(query,e_apl_ct)){
		m_data->GetAttr(query,a_apl_ct_name,name);
		m_data->GetAttr(query,a_apl_ct_description,description);
	}else if(m_data->IsKindOf(query,e_apl_query)){
		m_data->GetAttr(query,a_apl_query_name,name);
		m_data->GetAttr(query,a_apl_query_description,description);
	}
	return true;
}

bool CaplQueryManager::DeleteQuery(CaplInstance *query)
{
	if(m_data==0)	return false;
	if(query==0)return false;
	//   
	CaplInstance* internal;
	CString str;
	CaplDataBuf* dbuf;
	int temp_indx;
	CaplAttr *save_data,*temp_data;
	CString name;
	if(m_data->IsKindOf(query,e_apl_ct)){
		name= APL_T(" ");
		save_data=a_apl_ct_columns_data;
		temp_data=a_apl_ct_temp_data_index;
		m_data->GetAttr(query,a_apl_ct_query,internal);
		if(internal!=0)DeleteQuery(internal);
		
	}else if(m_data->IsKindOf(query,e_apl_query)){
		name= APL_T("");
		save_data=a_apl_query_dialog_data;
		temp_data=a_apl_query_temp_data_index;
	}

	CaplLoadData ld(m_data,DEF_SOURCE);
	ld.AddQuery(0,query);
	ld.LoadEx();
	if(query->GetAccessmode()>aplOWN)
	{
		MessageBox(NULL, S::NoAccessRight(),  APL_T(" ")+name, MB_OK|MB_ICONERROR);
		return false;
	}

	if(!query->GetTemporary()){
		m_data->GetAttr(query,save_data,str);
		if(str!=_T("")){
			m_data->NET_DeleteBlob(query,a_apl_query_dialog_data);
		}
	}else{
		m_data->GetAttr(query,temp_data,temp_indx);
		if(temp_indx!=0){
			//      
			dbuf=(CaplDataBuf*)temp_indx;
			temp_indx=m_data->m_query_temporary_data.Find(dbuf);
			if(temp_indx!=-1){
				m_data->m_query_temporary_data.Remove(temp_indx);
			}
		}
	}
	//   
	m_api->m_classifier_mgr.DeleteClassifierAssociation(query,0);
	
	m_data->DeleteInstance(query);
	return true;
}


/**    */
bool CaplQueryManager::FindIntoContent(CaplInstance *pdf)
{
	if(pdf==0){
		AfxMessageBox( APL_T(" pdf"));
		return false;
	}
	CFindInContent dlg;
	dlg.m_pdf=pdf;
	dlg.m_api=m_api;
	dlg.DoModal();
	return true;
}

/**      -       |  &    */
bool CaplQueryManager::MakeAttrConditionWithGroup(CString &str_par,CString &attr,CString &name4user,bool is_brackets,CString &attr_condition, const TCHAR* str_rel)
{
	CString cur_word = _T("");
	int pos = 0;
	bool last_logical = false;
	bool duble_logical = false;
	attr_condition = _T("(");
	int num_brackets = 0;
	CString str_mark;
	if(str_par.Find(_T('\''))==-1) str_mark=_T("'"); else str_mark=_T("\"");

	while(pos < str_par.GetLength())
	{
		if(str_par[pos] == _T('&'))
		{
			if(cur_word != _T(""))
			{
				attr_condition += attr + _T(" ") + CString(str_rel)+ _T(" ") + str_mark + cur_word + str_mark + _T(" ");
				cur_word = _T("");
			}
			attr_condition += _T(" AND ");
			if(last_logical)
			{
				duble_logical = true;
				break;
			}
			last_logical = true;
		}
		else if(str_par[pos] == _T('|'))
		{
			if(cur_word != _T(""))
			{
				attr_condition += attr + _T(" ") + str_rel+ _T(" ") + str_mark + cur_word + str_mark + _T(" ");
				cur_word = _T("");
			}
			attr_condition += _T(" OR ");
			if(last_logical)
			{
				duble_logical = true;
				break;
			}
			last_logical = true;
		}
		else
		{
			bool processed = false;
			if(is_brackets)
			{
				if(str_par[pos] == _T('('))
				{
					cur_word = _T("");
					attr_condition += _T('(');
					last_logical = false;
					num_brackets++;
					processed = true;
				}
				else if(str_par[pos] == _T(')'))
				{
					if(last_logical)
					{
						break;
					}
					if(cur_word != _T(""))
					{
						attr_condition += attr + _T(" ") + str_rel+ _T(" ") + str_mark + cur_word + str_mark + _T(" ");
						cur_word = _T("");
					}
					attr_condition += _T(')');
					last_logical = false;
					num_brackets--;
					processed = true;
				}
			}
			if(!processed)
			{
				cur_word += str_par[pos];
				last_logical = false;
			}
		}
		pos++;
	}
	if(cur_word != _T(""))
	{
		attr_condition += attr + _T(" ") + str_rel+ _T(" ") + str_mark + cur_word + str_mark + _T(" ");
		last_logical = false;
	}
	attr_condition += _T(")");
	if(duble_logical)
	{
		cur_word.Format(APL_T("   '%s'   %i    -    "),name4user,pos);
		AfxMessageBox(cur_word);
		return false;
	}
	if(last_logical)
	{
		cur_word.Format(APL_T("   '%s'   %i    -     "),name4user,pos);
		AfxMessageBox(cur_word);
		return false;
	}
	if(num_brackets > 0)
	{
		cur_word.Format(APL_T("   '%s'   ,  "),name4user);
		AfxMessageBox(cur_word);
		return false;
	}
	else if(num_brackets < 0)
	{
		cur_word.Format(APL_T("   '%s'   ,  "),name4user);
		AfxMessageBox(cur_word);
		return false;

	}
	return true;
}

bool aplShowFilterDlg(CaplAPI *api, LPCTSTR StringNameQuery, long vis_mode, CaplDataBuf &filter_query_buf, 
					  CString &out_extents, CString &out_fields, CString &out_descrtiption, CString &stepql_query)
{
	CString text_query;
	int is_ro_edit;
	DWORD result;
	CFindQueryDlg dlg_std;
	CFindQueryDlgEx dlg_std_ex;

	if(api==0) return false;

	dlg_std.m_can_save=false;
	dlg_std.m_api=api;
	dlg_std.m_mode_slave=true;
	dlg_std.m_can_make_table=false;
	dlg_std.m_StringNameQuery= StringNameQuery;
	dlg_std.m_vis_mode=vis_mode;
	dlg_std.m_instance=0;
	//	dlg_std.m_mode_slave=true;
	dlg_std_ex.m_can_save=false;
	dlg_std_ex.m_api=api;
	dlg_std_ex.m_mode_slave=true;
	dlg_std_ex.m_can_make_table=false;
	dlg_std_ex.m_StringNameQuery= StringNameQuery;
	dlg_std_ex.m_vis_mode=vis_mode;
	dlg_std_ex.m_instance=0;
	//	dlg_std.m_mode_slave=true;

	bool old_dlg;
	bool spek_key = ((GetKeyState(VK_LSHIFT) & 0xff00)!=0);

	old_dlg = api->m_query_mgr.m_is_old_dlg && !spek_key  || (!api->m_query_mgr.m_is_old_dlg && spek_key);

	if(old_dlg)
	{
		dlg_std.SetDataBuf(filter_query_buf);
	}
	else
	{
		dlg_std_ex.SetDataBuf(filter_query_buf);
	}
	do{
		if(stepql_query.IsEmpty())
		{
			if(old_dlg)
			{
				result=dlg_std.DoModal();
			}
			else
			{
				result=dlg_std_ex.DoModal();
			}
			is_ro_edit=1;
			if(result==ID_SHOW_STEPQL)
			{
				if(old_dlg)
				{
					text_query=_T("SELECT ")+dlg_std.m_fields + _T("\nFROM\n")+dlg_std.m_extents+_T("END_SELECT");
				}
				else
				{
					text_query=_T("SELECT ")+dlg_std_ex.m_fields + _T("\nFROM\n")+dlg_std_ex.m_extents+_T("END_SELECT");
				}
			}
		}
		else
		{
			result=ID_SHOW_STEPQL;
			is_ro_edit=0;
			text_query=stepql_query;
		}
		if(result==IDCANCEL)
		{
			return false;
		}
		else if(result==ID_SHOW_STEPQL)
		{
			CString titul = StringNameQuery;
			if(api->m_data.NET_QueryEditParse(text_query,true,0,&is_ro_edit,&titul) && is_ro_edit==0)
			{
				stepql_query=text_query;
				out_extents=_T("");
				out_fields=_T("");
				out_descrtiption=stepql_query;
				out_descrtiption.Replace(_T("\n"),_T("\r\n"));
				break;
			}
			else if(stepql_query.IsEmpty())
			{
				//        StepQL
				//      
				continue;
			}
			else
			{
				//  ,    ,       STepQL - 
				return false;
			}

		}
		else if(result==IDOK)
		{
			if(old_dlg)
			{
				dlg_std.GetDataBuf(filter_query_buf);
				out_extents=dlg_std.m_extents;
				out_fields=dlg_std.m_fields;
				out_descrtiption=dlg_std.m_descrtiption;
			}
			else
			{
				dlg_std_ex.GetDataBuf(filter_query_buf);
				out_extents=dlg_std_ex.m_extents;
				out_fields=dlg_std_ex.m_fields;
				out_descrtiption=dlg_std_ex.m_descrtiption;

			}
			break;
		}
	}while(true);
	return true;
}
