#if !defined(AFX_FINDQUERYDLG_H__572F8F65_AE26_4B51_8BDE_74505F8B1EA9__INCLUDED_)
#define AFX_FINDQUERYDLG_H__572F8F65_AE26_4B51_8BDE_74505F8B1EA9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// FindQueryDlg.h : header file
//
#include "resource.h"
#include <aplStepQL.h>
#include <apl_gui.h>
#include "apl_api.h"
#include "ResizableDialog.h"
#include "aplStepManager.h"

#define InserString2Control(control,value) 	pos_added=control.AddString(CaplQLQuery::LogOp2String(value));control.SetItemData(pos_added,value);


//////////////////////////////////////////////////////////////////////////////
//  ,          

//     ANSI !
#define STD_HEADER_FIND_QUERY_DLG_1_0	"FindQueryData v1.0\0"
#define STD_HEADER_FIND_QUERY_DLG_1_1	"FindQueryData v1.1\0"
#define STD_HEADER_FIND_QUERY_DLG_1_2	"FindQueryData v1.2\0"
#define STD_HEADER_FIND_QUERY_DLG_1_3	"FindQueryData v1.3\0"
#define STD_HEADER_FIND_QUERY_DLG_1_4	"FindQueryData v1.4\0"
#define STD_HEADER_FIND_QUERY_DLG_1_5	"FindQueryData v1.5\0"
#define STD_HEADER_FIND_QUERY_DLG_1_6	"FindQueryData v1.6\0"
#define STD_HEADER_FIND_QUERY_DLG_1_7	"FindQueryData v1.7\0"
#define STD_HEADER_FIND_QUERY_DLG_A_1_8	"FindQueryData v1.8\0"
#define STD_HEADER_FIND_QUERY_DLG_U_1_8 "FindQueryDatU v1.8\0"
#define STD_HEADER_FIND_QUERY_DLG_A_1_9	"FindQueryData v1.9\0"
#define STD_HEADER_FIND_QUERY_DLG_U_1_9 "FindQueryDatU v1.9\0"
#define STD_HEADER_FIND_QUERY_DLG_A		"FindQueryData v2.0\0"
#define STD_HEADER_FIND_QUERY_DLG_U		"FindQueryDatU v2.0\0"

#define TAB_ADJ_NAME_APPROVAL APL_T(" ")
#define TAB_ADJ_NAME_CHARACTER APL_T("")
#define TAB_ADJ_NAME_DOCUMENTS APL_T("")
#define TAB_ADJ_NAME_RESOURCES APL_T("")
#define TAB_ADJ_NAME_BLOBS APL_T(" ")
#define TAB_ADJ_NAME_CLASSIF APL_T("  ")


//////////////////////////////////////////////////////////////////////////////
enum COLUMNS_TAB_APPROVAL
{
	CT_APPR_IS_EXIST,
	CT_APPR_IS_APPR,
	CT_APPR_IS_DESCR,
	CT_APPR_IS_PERSON,
	CT_APPR_IS_ROLE,
	CT_APPR_IS_DATE,
	CT_APPR_IS_REVOC_DATE,
	CT_APPR_IS_IS_DIG_SIGN
};

enum COLUMNS_TAB_CHARACTERISTIC
{
	CT_CHAR_IS_EXIST,
	CT_CHAR_NAME,
	CT_CHAR_TYPE,
	CT_CHAR_RELATION,
	CT_CHAR_VALUE,
};

enum COLUMNS_TAB_DOC
{
	CT_DOC_IS_EXIST,
	CT_DOC_ID,
	CT_DOC_NAME,
	CT_DOC_KIND,
};

enum COLUMNS_TAB_RESOURCE
{
	CT_RES_IS_EXIST,
	CT_RES_ID_R,
	CT_RES_NAME_R,
	CT_RES_TYPE_R,
	CT_RES_ID_O,
	CT_RES_NAME_O,
	CT_RES_TYPE_O,
};

enum COLUMNS_TAB_BLOB
{
	CT_BLOB_IS_EXIST,
	CT_BLOB_CONTENT,
};

enum COLUMNS_TAB_CLASSIFIER
{
	CT_CLS_TYPE,
	CT_CLS_ID,
	CT_CLS_NAME,
	CT_CLS_LVL,
};

//
//////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////
// CFindQueryDlg dialog

class CFindQueryDlg : public CResizableDialog
{
	// Construction
public:

	CFindQueryDlg(CWnd* pParent = NULL);   // standard constructor
	~CFindQueryDlg();
	
	void DrawTabPage();
	void SetStateName(CString id,CString name,CString descr,CString type,CString code_ver,CString code_ver_1,CString code_ver_2,CString code_izd,CString source,CString ver);
	void SetTabPagesActive(TypeFindObject old_mode);
	void SetTabPagesEnable(BOOL mode);
	bool GenerateStepQL(bool show_message=true);
	bool SetDataBuf(CaplDataBuf &dbuf);
	bool GetDataBuf(CaplDataBuf &dbuf);
	void SetEditComboState();	
	bool TestNameQuery();
	
	void FillTabAdjust();
	void FillTabAdjustCharact();

	CaplAPI *m_api;
	CaplInstance *m_instance;
	
	//    "..."    -   ( SelectInstance)
	long m_vis_mode;
	//  true -    "   "
	bool m_can_make_table;
	//  true -   "   "
	bool m_can_save;
	//       
	TypeFindObject m_mode;
	
	CString m_mode_text;

	TypeAdj m_page_num;
	bool m_is_adjustment;
	bool m_read_only;
	bool m_changed;
	//  true -     ( ,     )
	bool m_mode_slave;
	bool m_single_mode;
	int m_cur_ext_num;
	//  
	CString m_QL_query;
	//       
	CString m_object_name;
	CString m_object_condition;
	//    c   (fields)
	CString m_extents;
	CString m_blob_query;
	CString m_fields;
	
	CString m_descrtiption;
	
	CString	m_StringSource;
	CString	m_StringType;
		

//	CaplQLQuery::CaplQLBranchSelect* m_bsel_res;
// Dialog Data
	//{{AFX_DATA(CFindQueryDlg)
	enum { IDD = IDD_FIND_QUERY };
	CButton	m_BtnType;
	CStatic	m_st_header;
	CEdit	m_edt_name_query;
	CComboBox	m_SelectFindType;
	CComboBox	m_CmbxStId;
	CComboBox	m_CmbxStName;
	CComboBox	m_CmbxStDescr;
	CComboBox	m_CmbxStType;
	CComboBox	m_CmbxStCodeVer;
	CComboBox	m_CmbxStCodeVer1;
	CComboBox	m_CmbxStCodeVer2;
	CComboBox	m_CmbxStCodeIzd;
	CComboBox	m_CmbxStSource;
	CComboBox	m_CmbxStVer;
	CEdit	m_EditId;
	CEdit	m_EditName;
	CEdit	m_EditDescr;
	CComboBox	m_EditType;
	CEdit	m_EditCodeVer;
	CEdit	m_EditCodeVer1;
	CEdit	m_EditCodeVer2;
	CEdit	m_EditCodeIzd;
	CComboBox	m_EditSource;
	CEdit	m_EditVer;
	CButton	m_ctrl_find_version;
	CButton	m_adj_edit;
	CButton	m_adj_del;
	CButton	m_adj_add;
	CListCtrl	m_ListAdjust;
	CTabCtrl	m_TabAdjust;
	int		m_int_source;
	int		m_int_type;
	CButton	m_Chk_StId;
	CButton	m_Chk_StName;
	CButton	m_Chk_StDescr;
	CButton	m_Chk_StType;
	CButton	m_Chk_StCodeVer;
	CButton	m_Chk_StCodeVer1;
	CButton	m_Chk_StCodeVer2;
	CButton	m_Chk_StCodeIzd;
	CButton	m_Chk_StSource;
	CButton	m_Chk_StVer;
	CButton	m_ChkSaveQuery;
	CaplButton	m_BtnFind;
	CaplButton	m_BtnCancel;
	CaplButton	m_BtnShowStepQl;
	CButton	m_CtrlMakeTableResult;
	BOOL	m_IsMakeTableResult;
	CString	m_StringNameQuery;
	BOOL	m_StateSaveQuery;
	int		m_StateFindType;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFindQueryDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	CBitmap m_name_bmp;
	CImageList imagelist_tab;
	CImageList imagelist_but;
	bool m_is_load_bmp;

	HICON m_adj_add_icon;
	HICON m_adj_del_icon;
	HICON m_adj_edit_icon;
	
	bool MakeObjectIdentify();
	//BOOL OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult ); :    CaplTranslateDialog
	
	bool MakeQueryChar();
	bool MakeQueryDoc ();
	bool MakeQueryAppr();
	bool MakeQueryRes ();
	bool MakeQueryBlob();

	bool SaveDataToBufBaseAttr(BYTE &count, BYTE type1, BYTE type2, CString &str_par);
	bool SaveDataToBufBaseString(CString str_par);
	bool SaveDataToBuf();
	bool Save2BufListQChar();
	bool LoadFromBufBaseString(CString &str_par);
	bool LoadDataFromBuf();
	bool LoadFromBufListQChar();
	CaplDataBuf *m_dbuf;
	
//	CString FillDateCompare(CaplQLQuery::aplQLLogRelation log_relation,int year,int month,int day);
	CString FillDateCompare(CString name_attr, CaplQLQuery::aplQLLogRelation log_relation,COleDateTime* dtt);
	void MakeExtAndField(CaplEntity *base_entity,CaplAttr *attr,CString conditions,bool is_exist);
	CString FillCharValue(ElValChar* el_ch,CaplEntity** base_entity);
	void SetHiglight();

	CaplQLQuery::aplQLLogRelation m_state_id;
	CaplQLQuery::aplQLLogRelation m_state_name;		
	CaplQLQuery::aplQLLogRelation m_state_descr;	
	CaplQLQuery::aplQLLogRelation m_state_type;		
	CaplQLQuery::aplQLLogRelation m_state_code_ver;		
	CaplQLQuery::aplQLLogRelation m_state_code_ver1;		
	CaplQLQuery::aplQLLogRelation m_state_code_ver2;		
	CaplQLQuery::aplQLLogRelation m_state_code_izd;		
	CaplQLQuery::aplQLLogRelation m_state_source;
	CaplQLQuery::aplQLLogRelation m_state_ver;
	
	// Generated message map functions
	//{{AFX_MSG(CFindQueryDlg)
	afx_msg void OnSelchangeTabAdjust(NMHDR* pNMHDR, LRESULT* pResult);
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeSelectFindType();
	afx_msg void OnAdjustAdd();
	afx_msg void OnAdjustDel();
	afx_msg void OnAdjustEdit();
	afx_msg void OnChkFindVersion();
	afx_msg void OnExecuteFind();
	afx_msg void OnRclickListAdjust(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkListAdjust(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnShowStepql();
	afx_msg void OnSelchangeComboState();
	afx_msg void OnChkSaveQuery();
	afx_msg void OnChangeEdit();
	afx_msg void OnChangeEditNameQuery();
	afx_msg void OnBtnType();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	aplExtent m_list_document_types;
	aplExtent m_list_action_types;
	aplExtent m_list_project_types;
	CaplTAggr<ElValChar*,ElValChar*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> m_list_char;
	CaplTAggr<ElValDoc*,ElValDoc*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> m_list_doc;
	CaplTAggr<ElValApproval*,ElValApproval*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> m_list_approval;
	CaplTAggr<ElValRes*,ElValRes*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> m_list_res;
	CaplTAggr<ElValBLOB*,ElValBLOB*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> m_list_blob;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FINDQUERYDLG_H__572F8F65_AE26_4B51_8BDE_74505F8B1EA9__INCLUDED_)
